/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.formplugin.analysereport.function.AnalyseReportFunctionPlugin;

public abstract class AbstractStepPlugin
extends AbstractFormPlugin
implements CommonMethod,
BeforeF7SelectListener,
EbMembPerm {
    private Function functionData;

    public void afterCreateNewData(EventObject e) {
        this.loadStepData();
    }

    public void afterBindData(EventObject e) {
        if (this.notEmpty(this.getCustomFormParam("isView"))) {
            this.lock4View();
        }
    }

    public abstract void lock4View();

    public abstract void loadStepData();

    protected abstract String getStepKey();

    public abstract FunctionStepData selectStepData();

    protected <T extends FunctionStepData> T getStepDataFromCache() {
        String stepKey = this.getStepKey();
        Function functionObj = this.getFunctionObj();
        return (T)functionObj.getStepData(stepKey);
    }

    protected Function getFunctionObj() {
        if (this.functionData == null) {
            AnalyseReportFunctionPlugin functionPagePlugin = this.getFunctionPagePlugin();
            this.functionData = functionPagePlugin.getOrCacheFunctionData(null);
        }
        return this.functionData;
    }

    private AnalyseReportFunctionPlugin getFunctionPagePlugin() {
        AnalyseReportFunctionPlugin functionPagePlugin = (AnalyseReportFunctionPlugin)CommonServiceHelper.getFormPlugin((IFormView)this.getView().getParentView(), AnalyseReportFunctionPlugin.class);
        if (functionPagePlugin == null) {
            throw new KDBizException("function page error");
        }
        return functionPagePlugin;
    }

    public Long getModelId() {
        Function functionObj = this.getFunctionObj();
        return functionObj.getModelId();
    }

    protected Long getBizModelId() {
        Function functionObj = this.getFunctionObj();
        return functionObj.getBusModelId();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    protected void addBaseFilter(List<QFilter> qFilters) {
        QFilter qModel = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qBizModel = new QFilter("bizmodel", "=", (Object)this.getBizModelId());
        qFilters.add(qModel);
        qFilters.add(qBizModel);
    }

    protected void addDimGroupFilter(List<QFilter> qFilters, int funcDimType) {
        this.addBaseFilter(qFilters);
        boolean needFuncDimFilter = funcDimType == 1 || funcDimType == 3;
        Set<String> refFunctionDimNums = this.getRefFunctionDimNums();
        StringBuilder sb = new StringBuilder();
        if (refFunctionDimNums != null && needFuncDimFilter) {
            IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
            Long bizModelId = this.getBizModelId();
            List dimensionList = iModelCacheHelper.getDimensionListByBusModel(bizModelId);
            dimensionList.forEach(dimension -> {
                if (refFunctionDimNums.contains(dimension.getNumber())) {
                    sb.append(dimension.getNumber()).append(',');
                }
            });
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        QFilter qFilter = new QFilter("reffunctiondimnums", "=", (Object)sb.toString());
        if (funcDimType == 3 && sb.length() > 0) {
            qFilter.or("reffunctiondimnums", "=", (Object)"");
        }
        qFilters.add(qFilter);
    }

    protected void addDimGroupFilter(List<QFilter> qFilters, boolean needFuncDimFilter) {
        this.addDimGroupFilter(qFilters, needFuncDimFilter ? 1 : 2);
    }

    protected Set<String> getRefFunctionDimNums() {
        MemberFilter stepData = (MemberFilter)this.getFunctionObj().getStepData(FunctionStepEnum.MEMBERFILTER);
        if (stepData != null) {
            return stepData.getMemberRanges().stream().map(MemberRange::getDimNum).collect(Collectors.toSet());
        }
        return null;
    }
}

