/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptFuncUtil;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.analysereport.constants.FunctionEnum;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.OrderFunction;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.guide.GuideData;
import kd.epm.eb.common.guide.GuideItem;
import kd.epm.eb.common.guide.GuideItemClickEvent;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.function.AbstractStepPlugin;
import kd.epm.eb.formplugin.guides.GuidesItemPluginHandler;

public class AnalyseReportFunctionPlugin
extends AbstractBasePlugin
implements GuidesItemPluginHandler {
    private static final String wizardapKey = "wizardap";
    private static final String functionTypeKey = "type";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "toolbarap1"});
        this.addGItemClickListener((AbstractFormPlugin)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initFunctionInfo();
    }

    private void init4Copy() {
        String newName;
        Long copyId = (Long)this.getCustomFormParam("copyId");
        if (this.isEmpty(copyId)) {
            return;
        }
        DynamicObject sourceObj = QueryServiceHelper.queryOne((String)VariableTypeEnum.Function.getMetadata(), (String)"number,name,type,model,bizmodel,allstepdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)copyId)});
        if (sourceObj == null) {
            return;
        }
        this.getModel().setValue("model", sourceObj.get("model"));
        this.getModel().setValue("bizmodel", sourceObj.get("bizmodel"));
        this.getModel().setValue(functionTypeKey, sourceObj.get(functionTypeKey));
        this.getModel().setValue("allstepdata_tag", sourceObj.get("allstepdata_tag"));
        QFilter qBizModel = new QFilter("bizmodel", "=", (Object)sourceObj.getLong("bizmodel"));
        String indexStr = ExecuteAnalyseUtil.getInstance().getCopyIndex(sourceObj.getString("number"), VariableTypeEnum.Function.getMetadata(), Long.valueOf(sourceObj.getLong("model")), qBizModel);
        String newNumber = sourceObj.getString("number") + indexStr;
        if (newNumber.length() > 40) {
            newNumber = newNumber.substring(0, 40);
        }
        if ((newName = sourceObj.getString("name") + indexStr).length() > 80) {
            newName = newName.substring(0, 80);
        }
        this.getModel().setValue("number", (Object)newNumber);
        this.getModel().setValue("name", (Object)newName);
        this.getModel().updateCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (functionTypeKey.equals(name)) {
            this.dealFunctionTypeChange();
        }
    }

    private void dealFunctionTypeChange() {
        String functionType = (String)this.getModel().getValue(functionTypeKey);
        FunctionEnum functionEnum = FunctionEnum.getFunctionEnumByFullName((String)functionType);
        if (functionEnum != null) {
            this.getModel().setValue("specification", (Object)functionEnum.getSpecification());
            this.updateStepGuides(functionEnum, functionEnum.getSteps()[0]);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initFunctionInfo();
    }

    private void initFunctionInfo() {
        FunctionStepEnum stepEnum;
        this.init4Copy();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FunctionEnum functionType = this.getCurrentFunctionType();
        Function function = Function.getInstance((FunctionEnum)functionType);
        String stepDataStr = (String)this.getValue("allstepdata_tag", null);
        if (status == OperationStatus.ADDNEW && this.isEmpty(stepDataStr)) {
            stepEnum = functionType.getSteps()[0];
            Long modelId = (Long)this.getCustomFormParam("model");
            Long busModelId = (Long)this.getCustomFormParam("bizmodel");
            this.getModel().setValue("bizmodel", (Object)busModelId);
            this.getModel().setValue("model", (Object)modelId);
            function.setModelId(modelId);
            function.setBusModelId(busModelId);
        } else {
            stepEnum = functionType.getSteps()[functionType.getSteps().length - 1];
            function.setStepData(stepDataStr);
        }
        this.getModel().setValue("specification", (Object)functionType.getSpecification());
        this.getOrCacheFunctionData(function);
        this.updateStepGuides(functionType, stepEnum);
        this.checkRefDimComb(function);
        this.getModel().setDataChanged(false);
    }

    private void checkRefDimComb(Function function) {
        List memberRanges;
        OrderFunction orderFunction;
        MemberFilter memberFilter;
        if (function instanceof OrderFunction && (memberFilter = (orderFunction = (OrderFunction)function).getMemberFilter()) != null && this.notEmpty(memberRanges = memberFilter.getMemberRanges())) {
            IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
            Set refDimNums = AnalyseRptFuncUtil.getDimNumsOnFuncDimGroup((Long)this.getBusModelId());
            HashSet<String> notExistDim = new HashSet<String>(16);
            for (MemberRange memberRange : memberRanges) {
                if (refDimNums.contains(memberRange.getDimNum())) continue;
                Dimension dimension = iModelCacheHelper.getDimension(memberRange.getDimNum());
                if (dimension == null) {
                    notExistDim.add(memberRange.getDimNum());
                    continue;
                }
                notExistDim.add(dimension.getName());
            }
            if (this.notEmpty(notExistDim)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728%1\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u51fd\u6570\u7684\u6307\u6807\u5bfc\u81f4\u5f53\u524d\u51fd\u6570\u5931\u6548\uff0c\u8bf7\u914d\u7f6e\u6307\u6807\u6216\u5220\u9664\u6b64\u51fd\u6570\u3002", (String)"AnalyseReportFunctionPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{notExistDim}));
            }
        }
    }

    private void openStepForm(StepPageInfo stepPageInfo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(stepPageInfo.stepEnum.getFormKey());
        formShowParameter.setCaption(stepPageInfo.stepEnum.getName());
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("stepcontainer");
        formShowParameter.setPageId(stepPageInfo.pageId);
        if (stepPageInfo.isView) {
            formShowParameter.setCustomParam("isView", (Object)"true");
        }
        this.getView().showForm(formShowParameter);
    }

    public Function getOrCacheFunctionData(Function functionData) {
        if (functionData == null) {
            FunctionEnum currentFunctionType = this.getCurrentFunctionType();
            functionData = Function.getInstance((FunctionEnum)currentFunctionType);
            String functionDataStr = (String)this.getValue("allstepdata_tag", null);
            if (this.notEmpty(functionDataStr)) {
                functionData.setStepData(functionDataStr);
            }
            functionData.setModelId(this.getModelId());
            functionData.setBusModelId(this.getBusModelId());
            functionData.setNumber((String)this.getValue("number", null));
        } else {
            this.getModel().getDataEntity(false).set("allstepdata_tag", (Object)functionData.getStepDataStr());
        }
        return functionData;
    }

    private StepPageInfo getOrCacheSettingStep(StepPageInfo stepPageInfo) {
        if (stepPageInfo == null) {
            String cacheStr = this.getPageCache().get("SettingStepInfo");
            stepPageInfo = (StepPageInfo)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        } else {
            this.getPageCache().put("SettingStepInfo", SerializationUtils.serializeToBase64((Object)stepPageInfo));
        }
        return stepPageInfo;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("close".equals(itemKey)) {
            this.getView().close();
        } else if ("nextstep".equals(itemKey)) {
            this.dealNextStep();
        } else if ("prestep".equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8fd4\u56de\u4e0a\u4e00\u6b65\u4f1a\u5220\u9664\u5f53\u524d\u6b65\u9aa4\u7684\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AnalyseReportFunctionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("preStep", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("preStep".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.dealPreStep();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.dealGuideItemClick(evt);
    }

    @Override
    public void onGuideItemClick(GuideItemClickEvent clickEvent) {
        int itemIndex = clickEvent.getItemIndex();
        int editIndex = clickEvent.getEditIndex();
        String itemKey = clickEvent.getItemKey();
        if (itemIndex > editIndex) {
            return;
        }
        StepPageInfo settingStep = this.getOrCacheSettingStep(null);
        if (settingStep.stepEnum.name().equals(itemKey)) {
            return;
        }
        this.dealViewStep(settingStep, itemKey, itemIndex != editIndex);
    }

    private void dealViewStep(StepPageInfo settingStep, String targetStep, boolean isView) {
        Function functionData = this.getOrCacheFunctionData(null);
        FunctionStepData functionStepData = this.selectCurrentStepData(settingStep);
        functionData.setStepData(functionStepData);
        this.getOrCacheFunctionData(functionData);
        FunctionStepEnum stepEnum = FunctionStepEnum.valueOf((String)targetStep);
        this.selectStep(stepEnum, isView);
    }

    private void dealPreStep() {
        Function functionData = this.getOrCacheFunctionData(null);
        StepPageInfo settingStep = this.getOrCacheSettingStep(null);
        functionData.removeStepData(settingStep.stepEnum.name());
        this.getOrCacheFunctionData(functionData);
        int preStepIndex = settingStep.stepEnum.getStepIndex() - 1;
        FunctionEnum currentFunctionType = functionData.getFunctionType();
        if (preStepIndex >= 0) {
            FunctionStepEnum targetStep = currentFunctionType.getSteps()[preStepIndex];
            this.selectStep(targetStep, false);
        }
    }

    private void dealNextStep() {
        StepPageInfo settingStep = this.getOrCacheSettingStep(null);
        Function functionData = this.getOrCacheFunctionData(null);
        FunctionStepData functionStepData = this.selectCurrentStepData(settingStep);
        CheckResult checkResult = new CheckResult();
        functionStepData.check(checkResult);
        if (checkResult.hasError()) {
            this.getView().showTipNotification(checkResult.getErrorInfo());
            return;
        }
        functionData.setStepData(functionStepData);
        this.getOrCacheFunctionData(functionData);
        int stepIndex = settingStep.stepEnum.getStepIndex();
        FunctionEnum currentFunctionType = this.getCurrentFunctionType();
        if (currentFunctionType.getSteps().length > stepIndex + 1) {
            FunctionStepEnum targetStep = currentFunctionType.getSteps()[stepIndex + 1];
            this.selectStep(targetStep, false);
        }
    }

    private FunctionStepData selectCurrentStepData(StepPageInfo stepPageInfo) {
        AbstractStepPlugin stepPagePlugin = this.getStepPagePlugin(stepPageInfo);
        FunctionStepData stepData = null;
        if (stepPagePlugin != null) {
            stepData = stepPagePlugin.selectStepData();
        }
        if (stepData == null) {
            throw new KDBizException("step page error");
        }
        return stepData;
    }

    private AbstractStepPlugin getStepPagePlugin(StepPageInfo settingStep) {
        String stepPageId = settingStep.pageId;
        IFormView stepView = this.getView().getView(stepPageId);
        AbstractStepPlugin stepPlugin = null;
        if (stepView != null) {
            FormViewPluginProxy curproxy = (FormViewPluginProxy)stepView.getService(FormViewPluginProxy.class);
            for (IFormPlugin plugin : curproxy.getPlugIns()) {
                if (!(plugin instanceof AbstractStepPlugin)) continue;
                stepPlugin = (AbstractStepPlugin)plugin;
                break;
            }
        }
        return stepPlugin;
    }

    private void updateStepGuides(FunctionEnum functionEnum, FunctionStepEnum nowStep) {
        GuideData guideData = new GuideData();
        ArrayList<GuideItem> stepsOptions = new ArrayList<GuideItem>(16);
        if (functionEnum != null) {
            FunctionStepEnum[] functionSteps = functionEnum.getSteps();
            int seq = 1;
            for (FunctionStepEnum stepEnum : functionSteps) {
                GuideItem guideItem = new GuideItem();
                guideItem.setKey(stepEnum.name());
                guideItem.setTitle(stepEnum.getName());
                stepsOptions.add(guideItem);
                if (stepEnum == nowStep) {
                    guideData.setEditIndex(seq);
                }
                ++seq;
            }
            guideData.setItemList(stepsOptions);
        }
        this.getOrCacheGuideData(guideData);
        this.selectStep(nowStep, false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String result;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && this.notEmpty(result = this.checkBeforeSave())) {
            args.setCancel(true);
            this.getView().showTipNotification(result);
        }
    }

    private String checkBeforeSave() {
        String errorInfo;
        GuideData guideData = this.getOrCacheGuideData(null);
        if (guideData.getEditIndex() != guideData.getItemList().size()) {
            errorInfo = ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b65\u672a\u8bbe\u7f6e\uff0c\u4e0d\u53ef\u4fdd\u5b58", (String)"AnalyseReportFunctionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            String number = (String)this.getValue("number", null);
            errorInfo = NumberCheckUtils.checkNumberRule((String)number);
            if (this.notEmpty(errorInfo)) {
                return errorInfo;
            }
            Long id = (Long)this.getValue("id", null);
            QFBuilder qb = new QFBuilder();
            qb.add("model", "=", (Object)this.getModelId());
            qb.add("bizmodel", "=", (Object)this.getBusModelId());
            qb.add("number", "=", (Object)number);
            if (NumberCheckUtils.checkNumberExist((String)VariableTypeEnum.Function.getMetadata(), (QFilter[])qb.toArray(), (Long)id)) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u548c\u4e1a\u52a1\u6a21\u578b\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\u3002", (String)"AnalyseReportFunctionPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getValue("name", null);
            if (this.isEmpty(name) || this.isEmpty(name.getLocaleValue())) {
                return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AnalyseReportFunctionPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            Function functionData = this.getOrCacheFunctionData(null);
            StepPageInfo settingStep = this.getOrCacheSettingStep(null);
            FunctionStepData functionStepData = this.selectCurrentStepData(settingStep);
            functionData.setStepData(functionStepData);
            CheckResult checkResult = new CheckResult();
            for (Map.Entry entry : functionData.getStepDataContainer().getStepData().entrySet()) {
                ((FunctionStepData)entry.getValue()).check(checkResult);
                if (!checkResult.hasError()) continue;
                if (!settingStep.stepEnum.name().equals(entry.getKey())) {
                    errorInfo = ResManager.loadResFormat((String)"\u6b65\u9aa4%1\u4e2d\uff1a\n%2", (String)"AnalyseReportFunctionPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{((FunctionStepData)entry.getValue()).getStepType().getStepIndex() + 1, checkResult.getErrorInfo()});
                    break;
                }
                errorInfo = checkResult.getErrorInfo();
                break;
            }
            if (this.isEmpty(errorInfo)) {
                this.upVal2Obj4Save(functionData);
            }
        }
        return errorInfo;
    }

    private void upVal2Obj4Save(Function functionData) {
        ShowLayout showLayout = (ShowLayout)functionData.getStepData(FunctionStepEnum.SHOWSETTING);
        String showfields = null;
        if (showLayout != null && showLayout.getFieldLayoutList().size() > 0) {
            showfields = AnalyseRptFuncUtil.buildShowField((ShowLayout)showLayout, (IModelCacheHelper)this.getIModelCacheHelper());
        }
        this.getModel().setValue("showfields", showfields);
        this.getModel().setValue("allstepdata_tag", (Object)functionData.getStepDataStr());
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void clientCallBack(ClientCallBackEvent e) {
    }

    public void selectStep(FunctionStepEnum stepEnum, boolean isView) {
        StepPageInfo stepPageInfo = new StepPageInfo();
        stepPageInfo.stepEnum = stepEnum;
        stepPageInfo.pageId = this.getView().getPageId() + System.nanoTime();
        stepPageInfo.isView = isView;
        int stepIndex = stepEnum.getStepIndex();
        FunctionEnum currentFunctionType = this.getCurrentFunctionType();
        boolean hidePreStep = stepIndex == 0;
        boolean hideNextStep = stepIndex == currentFunctionType.getSteps().length - 1;
        this.getOrCacheSettingStep(stepPageInfo);
        this.getView().setEnable(Boolean.valueOf(!hideNextStep && !stepPageInfo.isView), new String[]{"nextstep"});
        this.getView().setEnable(Boolean.valueOf(!hidePreStep && !stepPageInfo.isView), new String[]{"prestep"});
        if (isView) {
            this.setViewItem(stepEnum.name());
        } else {
            this.setEditItem(stepEnum.name());
        }
        this.openStepForm(stepPageInfo);
    }

    private FunctionEnum getCurrentFunctionType() {
        String type = (String)this.getValue(functionTypeKey, null);
        return FunctionEnum.getFunctionEnumByFullName((String)type);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    public Long getBusModelId() {
        return (Long)this.getValue("bizmodel", "id");
    }

    @Override
    public String getGuidePanelKey() {
        return "guildcontainer";
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        Control itemControl = this.getItemControl(e.getKey());
        if (itemControl != null) {
            e.setControl(itemControl);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)"true");
    }

    public static class StepPageInfo
    implements Serializable {
        private FunctionStepEnum stepEnum;
        private String pageId;
        private boolean isView;

        public FunctionStepEnum getStepEnum() {
            return this.stepEnum;
        }

        public void setStepEnum(FunctionStepEnum stepEnum) {
            this.stepEnum = stepEnum;
        }

        public String getPageId() {
            return this.pageId;
        }

        public void setPageId(String pageId) {
            this.pageId = pageId;
        }

        public boolean isView() {
            return this.isView;
        }

        public void setView(boolean view) {
            this.isView = view;
        }
    }
}

