/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.ConditionCompareType;
import kd.epm.eb.common.analysereport.pojo.condition.Condition;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.formplugin.analysereport.function.ConditionPluginHandler;

public class ConditionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CommonMethod {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"leftvalue", "rightvalue"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("rightvaluetype".equals(name)) {
            this.dealValueTypeChange(changeData);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("filterconditionentity".equals(entryName)) {
            int rowIndex = this.getModel().getEntryRowCount(entryName) - 1;
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"rightvalue"});
            this.getModel().setValue("rightnumvalue", null, rowIndex);
        }
    }

    private void dealValueTypeChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        boolean isFixVal = ConditionCompareType.FIXDATA.getValue().equals(newValue);
        this.getModel().setValue(isFixVal ? "rightvalue" : "rightnumvalue", null, rowIndex);
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{isFixVal ? "rightvalue" : "rightnumvalue"});
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{isFixVal ? "rightnumvalue" : "rightvalue"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        List<QFilter> qFilters = null;
        if ("leftvalue".equals(name)) {
            qFilters = this.getDimMembGroupFilters(true);
        } else if ("rightvalue".equals(name)) {
            qFilters = this.getDimMembGroupFilters(false);
        }
        if (qFilters != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
    }

    private List<QFilter> getDimMembGroupFilters(boolean isLeft) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        FormViewPluginProxy curproxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : curproxy.getPlugIns()) {
            if (!(plugin instanceof ConditionPluginHandler)) continue;
            ConditionPluginHandler conditionPlugin = (ConditionPluginHandler)plugin;
            if (isLeft) {
                conditionPlugin.addLeftValQFilters(qFilters);
                continue;
            }
            conditionPlugin.addRightValQFilters(qFilters);
        }
        qFilters.add(AnalyseReportUtil.getInstance().getMetricTypeQFilter());
        return qFilters;
    }

    public JudgeCondition selectValue() {
        JudgeCondition judgeCondition = new JudgeCondition();
        DynamicObjectCollection conditionRows = this.getModel().getEntryEntity("filterconditionentity");
        for (DynamicObject row : conditionRows) {
            Condition condition = new Condition();
            condition.setLeftB(this.notEmpty(row.getString("leftbracket")) ? 1 : 0);
            condition.setRightB(this.notEmpty(row.getString("rightbracket")) ? 1 : 0);
            condition.setLeftVal(Long.valueOf(row.getLong("leftvalue.id")));
            condition.setRightVal(Long.valueOf(row.getLong("rightvalue.id")));
            condition.setCompareSign(row.getString("comparesign"));
            condition.setRightValueType(row.getString("rightvaluetype"));
            condition.setRightNumVal((BigDecimal)row.get("rightnumvalue"));
            condition.setConnectSign(row.getString("connectsign"));
            judgeCondition.addCondition(condition);
        }
        return judgeCondition;
    }

    public void fillData2Page(JudgeCondition conditionData) {
        Container container = (Container)this.getControl("advconap");
        if (conditionData == null || conditionData.getConditionList().isEmpty()) {
            container.setCollapse(true);
        } else {
            this.getModel().batchCreateNewEntryRow("filterconditionentity", conditionData.getConditionList().size());
            DynamicObjectCollection conditionRows = this.getModel().getEntryEntity("filterconditionentity");
            int rowIndex = 0;
            for (Condition condition : conditionData.getConditionList()) {
                DynamicObject row = (DynamicObject)conditionRows.get(rowIndex);
                row.set("leftbracket", (Object)(condition.isHasLeftBracket() ? "(" : ""));
                row.set("rightbracket", (Object)(condition.isHasRightBracket() ? ")" : ""));
                row.set("comparesign", (Object)condition.getCompareSign());
                if (ConditionCompareType.FIXDATA.getValue().equals(condition.getRightValueType())) {
                    row.set("rightnumvalue", (Object)condition.getRightNumVal());
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"rightvalue"});
                } else {
                    row.set("rightnumvalue", null);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"rightnumvalue"});
                }
                row.set("rightvaluetype", (Object)condition.getRightValueType());
                row.set("connectsign", (Object)condition.getConnectSign());
                if (this.notEmpty(condition.getLeftVal())) {
                    row.set("leftvalue", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)condition.getLeftVal(), (String)"eb_dimcombinationentity"));
                }
                if (this.notEmpty(condition.getRightVal())) {
                    row.set("rightvalue", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)condition.getRightVal(), (String)"eb_dimcombinationentity"));
                }
                ++rowIndex;
            }
            container.setCollapse(false);
        }
    }
}

