/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptFuncUtil;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberInfo;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.analysereport.function.AbstractStepPlugin;
import kd.epm.eb.formplugin.analysereport.function.ConditionPluginHandler;

public class MemberFilterStepPlugin
extends AbstractStepPlugin
implements CellClickListener,
ConditionPluginHandler {
    private static final String membRangeEntityKey = "membrangeentity";
    private static final String filterConditionEntityKey = "filterconditionentity";
    private String defaultDimNum;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"memberrangeshow"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    protected Set<String> getRefFunctionDimNums() {
        DynamicObjectCollection membRangeRows = this.getModel().getEntryEntity(membRangeEntityKey);
        return membRangeRows.stream().map(row -> row.getString("dimension")).collect(Collectors.toSet());
    }

    @Override
    public void lock4View() {
        this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"dimension"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap", "addrangerow", "delrangerow"});
    }

    @Override
    public void loadStepData() {
        this.initDimList();
        MemberFilter stepData = (MemberFilter)this.getStepDataFromCache();
        IDataModel dataModel = this.getModel();
        if (stepData == null) {
            int newEntryRow = dataModel.createNewEntryRow(membRangeEntityKey);
            if (this.defaultDimNum != null) {
                dataModel.setValue("dimension", (Object)this.defaultDimNum, newEntryRow);
            }
        } else {
            List memberRanges = stepData.getMemberRanges();
            if (memberRanges != null) {
                dataModel.batchCreateNewEntryRow(membRangeEntityKey, memberRanges.size());
                DynamicObjectCollection rangRows = dataModel.getEntryEntity(membRangeEntityKey);
                StringBuilder sb = new StringBuilder();
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                for (int rowIndex = 0; rowIndex < memberRanges.size(); ++rowIndex) {
                    MemberRange memberRange = (MemberRange)memberRanges.get(rowIndex);
                    DynamicObject row = (DynamicObject)rangRows.get(rowIndex);
                    row.set("dimension", (Object)memberRange.getDimNum());
                    row.set("rangetype", (Object)memberRange.getRangeType());
                    row.set("memberrange", (Object)SerializationUtils.toJsonString((Object)memberRange.getMemberInfoList()));
                    row.set("view", (Object)memberRange.getViewId());
                    for (MemberInfo memberInfo : memberRange.getMemberInfoList()) {
                        RangeEnum rangeByVal = RangeEnum.getRangeByVal((int)Integer.parseInt(memberInfo.getRangeVal()));
                        Member member = modelCacheHelper.getMember(memberRange.getDimNum(), memberRange.getViewId(), memberInfo.getMembNum());
                        if (member == null) {
                            throw new KDBizException("member " + memberInfo.getMembNum() + " not exist");
                        }
                        if (rangeByVal == RangeEnum.ONLY) {
                            sb.append(member.getName()).append(',');
                            continue;
                        }
                        sb.append(member.getName()).append(ResManager.loadKDString((String)"\u7684", (String)"BgFixTemplateDimSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(rangeByVal.getName());
                        if (memberInfo.getChildLevel() > 0) {
                            sb.append(ResManager.loadResFormat((String)"(%1\u7ea7)", (String)"MemberFilterStepPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{memberInfo.getChildLevel()}));
                        }
                        sb.append(',');
                    }
                    if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    row.set("memberrangeshow", (Object)sb.toString());
                    sb.setLength(0);
                }
            }
            this.loadConditionData(stepData.getFilterCondition());
            if (stepData.getFilterCondition().getConditionList().size() > 0) {
                this.lockMembRaneEntry(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof NewEntry || source instanceof DeleteEntry) {
            int conditionRowCount;
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if ("newentry".equals(operateKey)) {
                String errorInfo = this.checkAddFilterCondition();
                if (this.notEmpty(errorInfo)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errorInfo);
                }
            } else if (("newentry1".equals(operateKey) || "deleteentry1".equals(operateKey)) && (conditionRowCount = this.getModel().getEntryRowCount(filterConditionEntityKey)) != 0) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u8fc7\u6ee4\u6761\u4ef6\uff0c\u518d\u7f16\u8f91\u6210\u5458\u8303\u56f4\u3002", (String)"MemberFilterStepPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String checkAddFilterCondition() {
        int filterRowCount = this.getModel().getEntryRowCount(filterConditionEntityKey);
        String result = null;
        if (filterRowCount == 0) {
            CheckResult checkResul = new CheckResult();
            MemberFilter memberFilter = this.selectMembRange();
            memberFilter.check(checkResul);
            if (checkResul.hasError()) {
                result = checkResul.getErrorInfo();
            }
        }
        return result;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        if (filterConditionEntityKey.equals(entryKey)) {
            this.lockMembRaneEntry(true);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryKey = e.getEntryProp().getName();
        if (filterConditionEntityKey.equals(entryKey)) {
            int rowCount = this.getModel().getEntryRowCount(filterConditionEntityKey);
            this.lockMembRaneEntry(rowCount != 0);
        }
    }

    private void lockMembRaneEntry(boolean lock) {
        this.getView().setEnable(Boolean.valueOf(!lock), -1, new String[]{"dimension"});
    }

    public void initDimList() {
        Function functionObj = this.getFunctionObj();
        Long busModelId = functionObj.getBusModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)functionObj.getModelId());
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(busModelId);
        ComboEdit combo = (ComboEdit)this.getControl("dimension");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        Set refDimNums = AnalyseRptFuncUtil.getDimNumsOnFuncDimGroup((Long)this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) || !refDimNums.contains(dimension.getNumber())) continue;
            if (this.defaultDimNum == null) {
                this.defaultDimNum = dimension.getNumber();
            }
            items.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        combo.setComboItems(items);
    }

    @Override
    protected String getStepKey() {
        return FunctionStepEnum.MEMBERFILTER.name();
    }

    @Override
    public FunctionStepData selectStepData() {
        MemberFilter memberFilter = this.selectMembRange();
        JudgeCondition condition = this.selectCondition();
        memberFilter.setFilterCondition(condition);
        return memberFilter;
    }

    private MemberFilter selectMembRange() {
        MemberFilter memberFilter = new MemberFilter();
        DynamicObjectCollection membRangeRows = this.getModel().getEntryEntity(membRangeEntityKey);
        if (!membRangeRows.isEmpty()) {
            List memberRanges = memberFilter.getMemberRanges();
            for (DynamicObject row : membRangeRows) {
                MemberRange memberRange = new MemberRange();
                String memberRangeVal = row.getString("memberrange");
                if (this.notEmpty(memberRangeVal)) {
                    List memberInfoList = SerializationUtils.fromJsonStringToList((String)memberRangeVal, MemberInfo.class);
                    memberRange.setMemberInfoList(memberInfoList);
                    memberRange.setViewId(Long.valueOf(row.getLong("view")));
                }
                memberRange.setRangeType(row.getInt("rangetype"));
                memberRange.setDimNum(row.getString("dimension"));
                memberRanges.add(memberRange);
            }
        }
        return memberFilter;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("memberrangeshow".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(membRangeEntityKey);
            this.openMemberRangeF7(entryGrid.getEntryState().getFocusRow());
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("memberrangeshow".equals(fieldKey)) {
            // empty if block
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void openMemberRangeF7(int rowIndex) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity(membRangeEntityKey, rowIndex);
        String dimensionNum = rowObj.getString("dimension");
        if (StringUtils.isEmpty((String)dimensionNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u7ef4\u5ea6\u3002", (String)"MemberFilterStepPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        Long busModelId = this.getBizModelId();
        Long viewId = rowObj.getLong("view");
        if (IDUtils.isNull((Long)viewId)) {
            viewId = BusinessModelServiceHelper.getInstance().getViewId(busModelId, dimensionNum, modelId);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectRangeMemb");
        ArrayList qFilters = new ArrayList(16);
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(closeCallBack);
        param.setqFilters(qFilters);
        param.setSign(dimensionNum);
        param.setEnableView(true);
        param.setBizModelId(busModelId);
        param.setQueryDecompose(true);
        param.setShowLevel(true);
        param.setUserRange(CollectionUtils.asList((Object[])new String[]{RangeEnum.ONLY.getIndStr(), RangeEnum.LEVEL_EXCLUDE.getIndStr(), RangeEnum.LEVEL.getIndStr(), RangeEnum.ALL_DETAIL.getIndStr(), RangeEnum.ALL_NOTDETAIL.getIndStr(), RangeEnum.PEERS_EXCLUDE.getIndStr(), RangeEnum.PEERS.getIndStr(), RangeEnum.ALL_EXCLUDE.getIndStr(), RangeEnum.ALL.getIndStr()}));
        String memberRange = rowObj.getString("memberrange");
        if (StringUtils.isNotEmpty((String)memberRange)) {
            List memberInfoList = SerializationUtils.fromJsonStringToList((String)memberRange, MemberInfo.class);
            ArrayList<MemberCondition> conditionList = new ArrayList<MemberCondition>(16);
            for (MemberInfo memberInfo : memberInfoList) {
                MemberCondition memberCondition = new MemberCondition();
                memberCondition.setNumber(memberInfo.getMembNum());
                memberCondition.setRange(memberInfo.getRangeVal());
                memberCondition.setRangeLevel(memberInfo.getChildLevel());
                conditionList.add(memberCondition);
            }
            param.setCon_list(conditionList);
        }
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimensionNum, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectRangeMemb".equals(actionId)) {
            this.dealSelectRangeMemb((DynamicObjectCollection)closedCallBackEvent.getReturnData());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("memberrangeshow".equals(name)) {
            this.dealMembRangeClear(changeData);
        } else if ("dimension".equals(name)) {
            this.dealDimensionChange(changeData);
        }
    }

    private void dealDimensionChange(ChangeData changeData) {
        String newDimNum = (String)changeData.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dimRows = dataEntity.getDynamicObjectCollection(membRangeEntityKey);
        int nowRowIndex = changeData.getRowIndex();
        boolean hasSame = false;
        int rowIndex = 0;
        if (StringUtils.isNotEmpty((String)newDimNum)) {
            for (DynamicObject row : dimRows) {
                String dimNum = row.getString("dimension");
                if (newDimNum.equals(dimNum) && rowIndex != nowRowIndex) {
                    hasSame = true;
                    break;
                }
                ++rowIndex;
            }
        }
        if (hasSame) {
            DynamicObject rowObj = (DynamicObject)dimRows.get(nowRowIndex);
            rowObj.set("dimension", changeData.getOldValue());
            this.getView().updateView("dimension", nowRowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e\u76f8\u540c\u7684\u7ef4\u5ea6\u3002", (String)"MemberFilterStepPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("memberrangeshow", null, nowRowIndex);
        }
    }

    private void dealMembRangeClear(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.isEmpty((String)((String)newValue))) {
            this.getModel().setValue("memberrange", null, rowIndex);
            this.getModel().setValue("view", null, rowIndex);
        }
    }

    private void dealSelectRangeMemb(DynamicObjectCollection backData) {
        if (backData != null) {
            ArrayList<MemberInfo> memberInfoList = new ArrayList<MemberInfo>(16);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject membRow : backData) {
                String numb = membRow.getString("number");
                String range = membRow.getString("scope");
                String name = membRow.getString("name");
                int childLevel = membRow.getInt("scopelevel");
                RangeEnum rangeByVal = RangeEnum.getRangeByVal((int)Integer.parseInt(range));
                MemberInfo memberInfo = new MemberInfo(numb, range);
                memberInfo.setChildLevel(childLevel);
                if (rangeByVal == RangeEnum.ONLY) {
                    sb.append(name).append(',');
                } else {
                    sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BgFixTemplateDimSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(rangeByVal.getName());
                    if (childLevel > 0) {
                        sb.append(ResManager.loadResFormat((String)"(%1\u7ea7)", (String)"MemberFilterStepPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{childLevel}));
                    }
                    sb.append(',');
                }
                memberInfoList.add(memberInfo);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(membRangeEntityKey);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            IDataModel dataModel = this.getModel();
            if (sb.length() == 0) {
                dataModel.setValue("memberrangeshow", null, focusRow);
            } else {
                sb.setLength(sb.length() - 1);
                dataModel.setValue("memberrangeshow", (Object)sb.toString(), focusRow);
                dataModel.setValue("memberrange", (Object)SerializationUtils.toJsonString(memberInfoList), focusRow);
                String dimNum = (String)dataModel.getValue("dimension", focusRow);
                String viewId = this.getPageCache().get(dimNum + "viewId");
                dataModel.setValue("view", (Object)IDUtils.toLong((Object)viewId), focusRow);
            }
        }
    }

    @Override
    public void addLeftValQFilters(List<QFilter> qFilters) {
        this.addDimGroupFilter(qFilters, true);
    }

    @Override
    public void addRightValQFilters(List<QFilter> qFilters) {
        this.addDimGroupFilter(qFilters, 3);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        EntryGrid entryGrid = (EntryGrid)this.getControl(membRangeEntityKey);
        int length = entryGrid.getEntryData().getDataEntitys().length;
        if (length > 9) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u8d85\u8fc710\u884c\u3002", (String)"MemberFilterStepPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }
}

