/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptFuncUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptTmpUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptVarExecUtil;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.common.DynamicCreate.CreateItemApHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.FieldSourceEnum;
import kd.epm.eb.common.analysereport.constants.FieldTypeEnum;
import kd.epm.eb.common.analysereport.constants.FunctionShowType;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.analysereport.pojo.functions.CheckResult;
import kd.epm.eb.common.analysereport.pojo.functions.Function;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionStrResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionTableResult;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FieldLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberFilter;
import kd.epm.eb.common.analysereport.pojo.functions.steps.MemberRange;
import kd.epm.eb.common.analysereport.pojo.functions.steps.ShowLayout;
import kd.epm.eb.common.analysereport.pojo.functions.steps.StepCheckResult;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.VarQuoteInfo;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.f7.DimMemberF7SelInfo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.analysereport.VarValSettingHandler;
import kd.epm.eb.formplugin.analysereport.function.AbstractStepPlugin;

public class ShowLayoutStepPlugin
extends AbstractStepPlugin
implements VarValSettingHandler,
AfterF7SelectListener {
    private static final int maxLocationIndex = 9;
    private static final String fieldSetEntryKey = "entryentity";
    private static final String field_fieldsource = "fieldsource";
    private static final String field_location = "location";
    private static final String field_showfieldval = "showfieldval";
    private static final String field_showfield = "showfield";
    private static final String field_fieldtype = "fieldtype";
    private static final String field_fieldtitle = "fieldtitle";
    private static final Set<String> baseDataKeys = Sets.newHashSet((Object[])new String[]{"account", "budgetperiod", "metric", "currency", "entity", "datatype", "version", "audittrail", "changetype", "internalcompany", "userdim1", "userdim2", "userdim3", "userdim4", "userdim5", "userdim6", "userdim7", "userdim8", "userdim9"});
    private boolean fireTitleChange = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{field_showfield, "varvaltext"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        baseDataKeys.forEach(key -> this.addF7SelectListener(this, new String[]{key}));
        this.addMemberF7AfterSelListener();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (field_showfield.equals(key)) {
            this.openFieldSelectForm();
        } else if ("varvaltext".equals(key)) {
            this.openVarValSelForm((IFormPlugin)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        this.addPageDimMembFilter(beforeF7SelectEvent);
    }

    private void addPageDimMembFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (baseDataKeys.contains(f7Key)) {
            this.switchDimNewF7(beforeF7SelectEvent, this.getBizModelId(), null, true, memberF7Parameter -> {
                Map<String, Long> memberViewIds = this.getOrCacheParamMemberViewIds(null);
                Long viewId = memberViewIds.get(f7Key);
                if (this.notEmpty(viewId)) {
                    memberF7Parameter.setViewId(viewId);
                }
                memberF7Parameter.setEnableView(true);
            });
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        Map<String, Pair<String, String>> refDimInfo = this.getOrCacheRefDimInfo(null);
        Pair<String, String> numAndName = refDimInfo.get(controlKey);
        if (numAndName != null) {
            return (String)numAndName.p1;
        }
        return super.getCurrentDimNumber(controlKey);
    }

    private void openFieldSelectForm() {
        String entityType;
        int index = this.getModel().getEntryCurrentRowIndex(fieldSetEntryKey);
        String fieldType = (String)this.getModel().getValue(field_fieldtype, index);
        if (FieldTypeEnum.DIMGROUP.getValue().equals(fieldType)) {
            entityType = "eb_dimcombinationentity";
        } else if (FieldTypeEnum.CONDITION.getValue().equals(fieldType)) {
            entityType = "eb_judgecondition";
        } else {
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityType, (boolean)true);
        List<QFilter> fieldFilter = this.getFieldFilter();
        listShowParameter.getListFilterParameter().getQFilters().addAll(fieldFilter);
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.add(IDUtils.toLong((Object)this.getModel().getValue(field_showfieldval)));
        listShowParameter.setSelectedRows(ids.toArray());
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldSelect"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<QFilter> getFieldFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        this.addDimGroupFilter(filters, true);
        return filters;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("fieldSelect".equals(actionId) && this.notEmpty(returnData)) {
            this.dealFieldBackShow((ListSelectedRowCollection)returnData);
        } else if ("VarValSel".equals(actionId) && this.notEmpty(returnData)) {
            this.fillBackVarVal((ListSelectedRowCollection)returnData);
        }
    }

    public void dealSingleMemberF7Back(DimMemberF7SelInfo selMember) {
        if (SysDimensionEnum.dimHasView((String)selMember.getDimNumber())) {
            Map<String, Long> memberViewIds = this.getOrCacheParamMemberViewIds(null);
            memberViewIds.put(selMember.getF7Key(), selMember.getViewId());
            this.getOrCacheParamMemberViewIds(memberViewIds);
        }
    }

    private void dealFieldBackShow(ListSelectedRowCollection rows) {
        if (rows.isEmpty()) {
            return;
        }
        ListSelectedRow selectedRow = rows.get(0);
        String name = selectedRow.getName();
        Object id = selectedRow.getPrimaryKeyValue();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(fieldSetEntryKey);
        Object oldId = this.getValue(field_showfieldval, null);
        if (String.valueOf(id).equals(oldId)) {
            this.fireTitleChange = true;
            this.getModel().setValue(field_showfield, (Object)name, rowIndex);
        } else {
            this.getModel().setValue(field_showfield, (Object)name, rowIndex);
            this.getModel().setValue(field_showfieldval, id, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("showway".equals(name)) {
            this.updateFillWayShow(false);
            this.updateFieldShow(false);
        } else if (field_showfield.equals(name)) {
            this.dealFieldShowChange(changeData);
        } else if (field_fieldtype.equals(name)) {
            this.dealFieldTypeChange(changeData);
        } else if (field_showfieldval.equals(name)) {
            this.updateFieldShow(true);
        } else if (field_fieldtitle.equals(name) || field_location.equals(name)) {
            this.updateFieldShow(false);
        }
        this.dealPropChange(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    private void dealFieldTypeChange(ChangeData changeData) {
        this.getModel().setValue(field_showfield, null, changeData.getRowIndex());
        String newVal = (String)changeData.getNewValue();
        this.getView().setEnable(Boolean.valueOf(!FieldTypeEnum.TEXT.getValue().equals(newVal)), changeData.getRowIndex(), new String[]{field_showfield});
    }

    public void dealFieldShowChange(ChangeData changeData) {
        Object newFieldShow = changeData.getNewValue();
        if (this.fireTitleChange) {
            this.getModel().setValue(field_fieldtitle, newFieldShow);
        } else {
            this.getModel().getEntryRowEntity(fieldSetEntryKey, changeData.getRowIndex()).set(field_fieldtitle, newFieldShow);
            this.getView().updateView(field_fieldtitle, changeData.getRowIndex());
        }
        if (this.isEmpty(newFieldShow)) {
            this.getModel().setValue(field_showfieldval, null, changeData.getRowIndex());
        }
    }

    @Override
    public void lock4View() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap2"});
    }

    private void updateFillWayShow(boolean isInit) {
        String showWay = (String)this.getValue("showway", null);
        boolean isShowTable = FunctionShowType.TABLE.getVal().equals(showWay);
        this.getView().setVisible(Boolean.valueOf(isShowTable), new String[]{"fillway"});
        this.getView().setVisible(Boolean.valueOf(!isShowTable), new String[]{"fillwaytext"});
        this.getView().setVisible(Boolean.valueOf(isShowTable), new String[]{"showtable"});
        this.getView().setVisible(Boolean.valueOf(!isShowTable), new String[]{"showstring"});
        this.getView().setVisible(Boolean.valueOf(isShowTable), new String[]{field_fieldtitle});
        if (!isInit) {
            this.batUpdateTitleCol(!isShowTable);
            if (isShowTable) {
                this.getModel().setValue("fillwaytext", null);
                this.getModel().deleteEntryData("showtable");
            } else {
                this.getModel().setValue("showstring", null);
                this.getModel().setValue("fillwaytext", (Object)"\u3001");
            }
        }
    }

    private void batUpdateTitleCol(boolean clean) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(fieldSetEntryKey);
        if (rows.size() > 0) {
            Count count = new Count();
            rows.forEach(row -> {
                if (clean) {
                    row.set(field_fieldtitle, null);
                } else {
                    row.set(field_fieldtitle, row.get(field_showfield));
                }
                this.getView().updateView(field_fieldtitle, count.getCount());
                count.addOne();
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("show".equals(itemKey)) {
            this.updateDataShow();
        }
    }

    private void updateDataShow() {
        int maxColSize;
        Function functionObj = this.getFunctionObj();
        StepCheckResult checkResult = new StepCheckResult();
        ShowLayout stepData = (ShowLayout)this.selectStepData();
        stepData.setShowAmount(Math.min(10, stepData.getShowAmount()));
        stepData.check((CheckResult)checkResult);
        List fieldLayoutList = stepData.getFieldLayoutList();
        int n = maxColSize = FunctionShowType.TABLE.getVal().equals(stepData.getShowWay()) ? 10 : 6;
        if (maxColSize < fieldLayoutList.size()) {
            fieldLayoutList = fieldLayoutList.subList(0, maxColSize);
            stepData.setFieldLayoutList(fieldLayoutList);
        }
        functionObj.setStepData((FunctionStepData)stepData);
        Map<String, Pair<String, String>> refDimInfo = this.getOrCacheRefDimInfo(null);
        HashMap<Object, MemberView> pageDimMembers = new HashMap<Object, MemberView>(refDimInfo.size());
        if (refDimInfo.size() > 0) {
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Map<String, Long> paramMemberViewIds = this.getOrCacheParamMemberViewIds(null);
            Map viewsByBusModel = modelCacheHelper.getViewsByBusModel(this.getBizModelId());
            for (Map.Entry<String, Pair<String, String>> entry : refDimInfo.entrySet()) {
                String key = entry.getKey();
                Pair<String, String> dimInfo = entry.getValue();
                String memberNum = (String)this.getValue(key, "number");
                if (this.isEmpty(memberNum)) {
                    checkResult.addErrorInfo(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u9875\u9762\u7ef4\u201c%1\u201d", (String)"ShowLayoutStepPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimInfo.p2}));
                    continue;
                }
                Long viewId = paramMemberViewIds.get(key);
                if (this.isEmpty(viewId) && SysDimensionEnum.dimHasView((String)((String)dimInfo.p1))) {
                    viewId = (Long)viewsByBusModel.get(dimInfo.p1);
                }
                pageDimMembers.put(dimInfo.p1, new MemberView(memberNum, viewId));
            }
        }
        if (checkResult.hasError()) {
            this.getView().showTipNotification(checkResult.getErrorInfo());
            return;
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("varentryentity");
        ArrayList<String> emptyRowIndex = new ArrayList<String>(entryRows.size());
        for (int index = 0; index < entryRows.size(); ++index) {
            if (!this.isEmpty(((DynamicObject)entryRows.get(index)).getLong("varvalid"))) continue;
            emptyRowIndex.add(String.valueOf(index + 1));
        }
        if (emptyRowIndex.size() > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u884c\u201c%1\u201d\u7684\u53d8\u91cf\u503c\u672a\u8bbe\u7f6e\u3002", (String)"AnalyseReportEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", emptyRowIndex)}));
            return;
        }
        Map memberVarValInfo = AnalyseReportUtil.getInstance().parseVarInfo(entryRows, this.getModelId());
        functionObj.setModelId(this.getModelId());
        FunctionResult functionResult = AnalyseRptVarExecUtil.executeFunction4Show((Function)functionObj, pageDimMembers, (Map)memberVarValInfo);
        if (functionResult instanceof FunctionTableResult) {
            List tableRows = ((FunctionTableResult)functionResult).getTableRows();
            this.updateEntryData(tableRows);
        } else if (functionResult instanceof FunctionStrResult) {
            this.getModel().setValue("showstring", (Object)((FunctionStrResult)functionResult).getShowStr());
        }
    }

    private void updateFieldShow(boolean checkRefDim, boolean isInit) {
        ShowLayout stepData = null;
        if (isInit) {
            stepData = (ShowLayout)this.getStepDataFromCache();
        }
        if (stepData == null) {
            stepData = (ShowLayout)this.selectStepData();
        }
        if (checkRefDim) {
            Function functionObj = this.getFunctionObj();
            functionObj.setStepData((FunctionStepData)stepData);
            boolean refDimChanged = this.updateParamF7(functionObj);
            boolean varEntryChanged = this.updateVarEntry(stepData, isInit);
            if (refDimChanged || varEntryChanged) {
                this.getModel().setValue("showstring", null);
                this.getModel().deleteEntryData("showtable");
            }
        }
        this.updateEntryCol(stepData);
    }

    private void updateFieldShow(boolean checkRefDim) {
        this.updateFieldShow(checkRefDim, false);
    }

    private void updateEntryCol(ShowLayout stepData) {
        boolean showTable = FunctionShowType.TABLE.getVal().equals(stepData.getShowWay());
        if (!showTable) {
            return;
        }
        int maxColSize = 10;
        List fieldLayoutList = stepData.getFieldLayoutList();
        if (maxColSize < fieldLayoutList.size()) {
            fieldLayoutList = fieldLayoutList.subList(0, maxColSize);
        }
        HashMap<Integer, List<FieldLayout>> sortedField = new HashMap<Integer, List<FieldLayout>>(fieldLayoutList.size());
        int maxLocation = 0;
        for (FieldLayout fieldLayout : fieldLayoutList) {
            if (maxLocation < fieldLayout.getLocation()) {
                maxLocation = fieldLayout.getLocation();
            }
            List fieldLayouts = sortedField.computeIfAbsent(fieldLayout.getLocation(), key -> new LinkedList());
            fieldLayouts.add(fieldLayout);
        }
        this.updateEntryCol(sortedField, maxLocation);
    }

    private void updateEntryCol(Map<Integer, List<FieldLayout>> sortedField, int maxColIndex) {
        EntryAp entryAp = CreateItemApHelper.createEntryAp((String)"showtable");
        entryAp.setOrderAndFilter(1);
        entryAp.setLock("new,edit,view");
        for (int index = 0; index <= maxColIndex; ++index) {
            List<FieldLayout> fieldLayouts = sortedField.get(index);
            String colName = fieldLayouts == null ? "" : fieldLayouts.stream().map(FieldLayout::getTitle).collect(Collectors.joining());
            EntryFieldAp entryFieldAp = ApplyTemplateUtils.createEntryFieldAp((String)("entrycol" + index), (String)colName);
            TextField textFiled = CreateItemApHelper.createTextFiled((String)("entrycolfield" + index));
            entryFieldAp.setField((Field)textFiled);
            entryAp.getItems().add(entryFieldAp);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map control = entryAp.createControl();
        clientViewProxy.preInvokeControlMethod(entryAp.getKey(), "createGridColumns", new Object[]{control});
    }

    private boolean updateVarEntry(ShowLayout showLayout, boolean isInit) {
        if (!isInit) {
            this.saveVarValInfo(showLayout);
        }
        boolean changed = this.initVarEntry(this.getModelId());
        Container container = (Container)this.getControl("varparampanel");
        if (this.getModel().getEntryRowCount("varentryentity") == 0) {
            container.setCollapse(true);
        } else {
            container.setCollapse(false);
        }
        return changed;
    }

    @Override
    public Map<Long, MemberView> getVarValUserRecord() {
        ShowLayout showLayout = (ShowLayout)this.getStepDataFromCache();
        Map memberVarValViewIdMap = showLayout.getMemberVarValViewIdMap();
        Map memberVarValMap = showLayout.getMemberVarValMap();
        HashMap<Long, MemberView> varValMap = new HashMap<Long, MemberView>(memberVarValMap.size());
        memberVarValMap.forEach((varId, varValId) -> varValMap.put((Long)varId, new MemberView(varValId, (Long)memberVarValViewIdMap.get(varId))));
        return varValMap;
    }

    private boolean updateParamF7(Function functionObj) {
        Set<String> refDimNums = this.getRefParamDimNums(functionObj);
        ArrayList hideKeys = new ArrayList(refDimNums.size());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashMap<String, Pair<String, String>> refDimNumMapKey = new HashMap<String, Pair<String, String>>(16);
        Count customDimCount = new Count(1);
        refDimNums.forEach(dimNum -> {
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension != null) {
                Pair dimNumAndName = new Pair(dimNum, (Object)dimension.getName());
                if (dimension.isPreset()) {
                    refDimNumMapKey.put(dimNum.toLowerCase(), dimNumAndName);
                } else {
                    refDimNumMapKey.put("userdim" + customDimCount.getCount(), dimNumAndName);
                    customDimCount.addOne();
                }
            }
        });
        Container container = (Container)this.getControl("dimparampanel");
        container.setCollapse(refDimNums.isEmpty());
        Map<String, Pair<String, String>> oldRefDimInfo = this.getOrCacheRefDimInfo(null);
        if (this.checkRefDimChanged(refDimNumMapKey, oldRefDimInfo)) {
            HashMap selMembers = new HashMap(oldRefDimInfo.size());
            IDataModel dataModel = this.getModel();
            oldRefDimInfo.forEach((key, dimInfo) -> {
                DynamicObject member = (DynamicObject)dataModel.getValue(key);
                if (member != null) {
                    selMembers.put(dimInfo.p1, member);
                }
            });
            baseDataKeys.forEach(key -> {
                Pair dimInfo = (Pair)refDimNumMapKey.get(key);
                if (dimInfo != null) {
                    BasedataEdit f7Ctrl = (BasedataEdit)this.getControl((String)key);
                    if (f7Ctrl != null) {
                        f7Ctrl.setCaption(new LocaleString((String)dimInfo.p2));
                    }
                    dataModel.setValue(key, selMembers.get(dimInfo.p1));
                } else {
                    hideKeys.add(key);
                    dataModel.setValue(key, null);
                }
            });
            if (refDimNumMapKey.size() > 0) {
                this.getView().setVisible(Boolean.valueOf(true), refDimNumMapKey.keySet().toArray(new String[0]));
            }
            if (hideKeys.size() > 0) {
                this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[0]));
            }
            this.getOrCacheRefDimInfo(refDimNumMapKey);
            return true;
        }
        return false;
    }

    private void fillBackPageDimMemberVal(Map<String, Pair<String, String>> refDimNumMapKey, ShowLayout showLayout) {
        if (showLayout != null) {
            Map pageDimMembers = showLayout.getPageDimMembers();
            HashMap<String, Long> viewIdMap = new HashMap<String, Long>(showLayout.getPageDimMemberViewIds());
            IDataModel dataModel = this.getModel();
            refDimNumMapKey.forEach((key, dimInfo) -> dataModel.setValue(key, pageDimMembers.get(dimInfo.p1)));
            this.getOrCacheParamMemberViewIds(viewIdMap);
        }
    }

    private boolean checkRefDimChanged(Map<String, Pair<String, String>> newRefDimInfo, Map<String, Pair<String, String>> oldRefDimInfo) {
        boolean result = false;
        if (oldRefDimInfo.size() != newRefDimInfo.size()) {
            return true;
        }
        for (Map.Entry<String, Pair<String, String>> entry : oldRefDimInfo.entrySet()) {
            Pair<String, String> numAndName = newRefDimInfo.get(entry.getKey());
            Pair<String, String> numAndName1 = entry.getValue();
            if (!(numAndName == null && numAndName1 != null || numAndName != null && numAndName1 == null) && (numAndName == null || StringUtils.equals((String)((String)numAndName.p1), (String)((String)numAndName1.p1)))) continue;
            result = true;
            break;
        }
        return result;
    }

    private Map<String, Pair<String, String>> getOrCacheRefDimInfo(Map<String, Pair<String, String>> refDimInfo) {
        if (refDimInfo == null) {
            String cacheStr = this.getPageCache().get("refDimInfo");
            refDimInfo = cacheStr == null ? new HashMap(16) : (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        } else {
            this.getPageCache().put("refDimInfo", SerializationUtils.serializeToBase64(refDimInfo));
        }
        return refDimInfo;
    }

    private Map<Long, Set<Long>> getDimVarInfo(Function functionObj) {
        VarQuoteInfo varQuoteInfo = new VarQuoteInfo();
        varQuoteInfo.setModelId(this.getModelId());
        functionObj.getStepDataContainer().getStepData().values().forEach(stepData -> stepData.selectQuote(varQuoteInfo));
        HashSet refConditionIds = new HashSet(varQuoteInfo.getRefConditionIds());
        Set refDimGroupIds = AnalyseRptTmpUtil.getInstance().getRefDimGroupIds(refConditionIds, 3);
        HashSet dimGroupIds = new HashSet(refDimGroupIds);
        if (varQuoteInfo.getRefDimGroupIds() != null) {
            dimGroupIds.addAll(varQuoteInfo.getRefDimGroupIds());
        }
        return AnalyseReportUtil.getInstance().getDimGroupVarInfos(dimGroupIds);
    }

    private Set<String> getRefParamDimNums(Function functionObj) {
        VarQuoteInfo varQuoteInfo = new VarQuoteInfo();
        varQuoteInfo.setModelId(this.getModelId());
        functionObj.getStepDataContainer().getStepData().values().forEach(stepData -> stepData.selectQuote(varQuoteInfo));
        RefDimColInfo refDimColInfo = new RefDimColInfo();
        AnalyseReportUtil.getInstance().selRefDimNumsOnCondition(refDimColInfo, varQuoteInfo.getRefConditionIds());
        AnalyseReportUtil.getInstance().selRefDimNumsOnDimGroup(refDimColInfo, varQuoteInfo.getRefDimGroupIds());
        return refDimColInfo.getRefParamDims();
    }

    private void updateEntryData(List<String[]> rowValues) {
        int colCount;
        ArrayList allRowVal = new ArrayList(rowValues.size());
        int n = colCount = rowValues.get(0) == null ? 0 : rowValues.get(0).length;
        if (rowValues.size() >= 2) {
            for (int index = 1; index < rowValues.size(); ++index) {
                int rowIndex = index - 1;
                ArrayList<Object> rowData = new ArrayList<Object>(16);
                rowData.add(rowIndex);
                rowData.add(rowIndex + 1);
                rowData.add(null);
                rowData.add(null);
                for (String val : rowValues.get(index)) {
                    rowData.add(val);
                }
                rowData.add(new HashMap(1));
                rowData.add(new HashMap(1));
                rowData.add(new HashMap(1));
                rowData.add(new HashMap(1));
                allRowVal.add(rowData);
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", allRowVal.size());
        data.put("rows", allRowVal);
        data.put("pagerows", 20);
        data.put("pageindex", 1);
        data.put("isSplitPage", false);
        data.put("phide", true);
        data.put("pagecount", 0);
        data.put("datacount", allRowVal.size());
        data.put("dataindex", this.getDataIndex(colCount));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty("showtable", "data", data);
    }

    public Map<String, Integer> getDataIndex(int maxColCount) {
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        dataIndex.put("seq", 1);
        dataIndex.put("id", 2);
        dataIndex.put("pid", 3);
        int i = 4;
        for (int index = 0; index <= maxColCount; ++index) {
            dataIndex.put("entrycol" + index, i);
            ++i;
        }
        dataIndex.put("l", i);
        dataIndex.put("s", i + 1);
        dataIndex.put("vi", i + 2);
        dataIndex.put("cprop", i + 3);
        return dataIndex;
    }

    @Override
    public void loadStepData() {
        ShowLayout showLayout = (ShowLayout)this.getStepDataFromCache();
        if (showLayout != null) {
            this.getModel().setValue("showcount", (Object)showLayout.getShowAmount());
            this.getModel().setValue("showway", (Object)showLayout.getShowWay());
            this.getModel().setValue("fillway", (Object)showLayout.getFillWay());
            List fieldLayoutList = showLayout.getFieldLayoutList();
            if (this.notEmpty(fieldLayoutList)) {
                this.getModel().batchCreateNewEntryRow(fieldSetEntryKey, fieldLayoutList.size());
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(fieldSetEntryKey);
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                int index = 0;
                for (FieldLayout fieldLayout : fieldLayoutList) {
                    DynamicObject row = (DynamicObject)entryEntity.get(index);
                    row.set(field_fieldsource, (Object)fieldLayout.getFieldSource());
                    row.set(field_fieldtype, (Object)fieldLayout.getFieldType());
                    row.set("pretext", (Object)fieldLayout.getPreText());
                    row.set("backtext", (Object)fieldLayout.getBackText());
                    row.set(field_location, (Object)fieldLayout.getLocation());
                    row.set(field_fieldtitle, (Object)fieldLayout.getTitle());
                    String showField = fieldLayout.getShowField();
                    if (this.notEmpty(showField)) {
                        row.set(field_showfieldval, (Object)showField);
                        String fieldName = AnalyseRptFuncUtil.getShowFieldName((String)fieldLayout.getFieldType(), (String)showField, (IModelCacheHelper)modelCacheHelper);
                        if (fieldName != null) {
                            row.set(field_showfield, (Object)fieldName);
                        }
                    }
                    row.set(field_fieldsource, (Object)fieldLayout.getFieldSource());
                    if (FieldSourceEnum.FUNCTIONBACK.getValue().equals(fieldLayout.getFieldType())) {
                        this.getView().setEnable(Boolean.valueOf(false), index, new String[]{field_fieldtype, field_showfield});
                    }
                    if (FieldTypeEnum.TEXT.getValue().equals(fieldLayout.getFieldType())) {
                        this.getView().setEnable(Boolean.valueOf(false), index, new String[]{field_showfield});
                    }
                    ++index;
                }
            }
        } else {
            Function functionObj = this.getFunctionObj();
            MemberFilter memberFilterStepData = (MemberFilter)functionObj.getStepData(FunctionStepEnum.MEMBERFILTER.name());
            if (memberFilterStepData != null) {
                List memberRanges = memberFilterStepData.getMemberRanges();
                DynamicObjectCollection entryRows = this.getModel().getEntryEntity(fieldSetEntryKey);
                entryRows.clear();
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                int seq = 0;
                for (MemberRange memberRange : memberRanges) {
                    Dimension dimension = modelCacheHelper.getDimension(memberRange.getDimNum());
                    if (dimension == null) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u5931\u8d25\u3002", (String)"ShowLayoutStepPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject row = entryRows.addNew();
                    row.set(field_fieldsource, (Object)FieldSourceEnum.FUNCTIONBACK.getValue());
                    row.set(field_location, (Object)seq);
                    row.set(field_showfieldval, (Object)dimension.getNumber());
                    row.set(field_showfield, (Object)dimension.getName());
                    row.set(field_fieldtype, (Object)FieldTypeEnum.DIMMENSION.getValue());
                    row.set(field_fieldtitle, (Object)dimension.getName());
                    this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{field_fieldtype, field_showfield});
                    ++seq;
                }
            }
        }
        this.updateFillWayShow(true);
        this.updateFieldShow(true, true);
        this.fillBackPageDimMemberVal(this.getOrCacheRefDimInfo(null), showLayout);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        this.checkDelFieldRow(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (fieldSetEntryKey.equals(e.getEntryProp().getName())) {
            for (RowDataEntity dataEntity : e.getRowDataEntities()) {
                DynamicObject rowObj = dataEntity.getDataEntity();
                int location = Math.min(dataEntity.getRowIndex(), 9);
                rowObj.set(field_location, (Object)location);
                this.getView().updateView(field_location, dataEntity.getRowIndex());
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (fieldSetEntryKey.equals(e.getEntryProp().getName())) {
            this.updateFieldShow(true);
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
    }

    private void checkDelFieldRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (fieldSetEntryKey.equals(entryName)) {
            int[] rowIndexs = e.getRowIndexs();
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity(fieldSetEntryKey);
            for (int index : rowIndexs) {
                DynamicObject row = (DynamicObject)entryRows.get(index);
                if (!FieldSourceEnum.FUNCTIONBACK.getValue().equals(row.getString(field_fieldsource))) continue;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u51fd\u6570\u8fd4\u56de\u884c", (String)"ShowLayoutStepPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected String getStepKey() {
        return FunctionStepEnum.SHOWSETTING.name();
    }

    @Override
    public FunctionStepData selectStepData() {
        ShowLayout showLayout = new ShowLayout();
        showLayout.setShowAmount(((Integer)this.getValue("showcount", null)).intValue());
        showLayout.setShowWay((String)this.getValue("showway", null));
        showLayout.setFillWay((String)this.getValue("fillway", null));
        showLayout.setFillWayText((String)this.getValue("fillwaytext", null));
        DynamicObjectCollection fieldLayouts = this.getModel().getDataEntity(true).getDynamicObjectCollection(fieldSetEntryKey);
        for (DynamicObject row : fieldLayouts) {
            FieldLayout fieldLayout = new FieldLayout();
            fieldLayout.setFieldSource(row.getString(field_fieldsource));
            fieldLayout.setFieldType(row.getString(field_fieldtype));
            fieldLayout.setPreText(row.getString("pretext"));
            fieldLayout.setShowField(row.getString(field_showfieldval));
            fieldLayout.setBackText(row.getString("backtext"));
            fieldLayout.setLocation(row.getInt(field_location));
            fieldLayout.setTitle(row.getString(field_fieldtitle));
            showLayout.getFieldLayoutList().add(fieldLayout);
        }
        Map<String, Pair<String, String>> refDimInfo = this.getOrCacheRefDimInfo(null);
        Map pageDimMembers = showLayout.getPageDimMembers();
        Map pageDimMemberViewIds = showLayout.getPageDimMemberViewIds();
        pageDimMembers.clear();
        pageDimMemberViewIds.clear();
        refDimInfo.forEach((key, dimInfo) -> {
            Long memberId = (Long)this.getValue((String)key, "id");
            if (this.notEmpty(memberId)) {
                pageDimMembers.put(dimInfo.p1, memberId);
            }
        });
        pageDimMemberViewIds.putAll(this.getOrCacheParamMemberViewIds(null));
        this.saveVarValInfo(showLayout);
        return showLayout;
    }

    private void saveVarValInfo(ShowLayout showLayout) {
        if (showLayout == null) {
            return;
        }
        Map selValInfo = this.selValInfo();
        Map memberVarValMap = showLayout.getMemberVarValMap();
        Map memberVarValViewIdMap = showLayout.getMemberVarValViewIdMap();
        memberVarValMap.clear();
        memberVarValViewIdMap.clear();
        selValInfo.values().forEach(varInfoList -> varInfoList.forEach(varValInfo -> {
            if (varValInfo.getVarValId() != 0L) {
                memberVarValMap.put(varValInfo.getVarId(), varValInfo.getVarValId());
                memberVarValViewIdMap.put(varValInfo.getVarId(), varValInfo.getViewId());
            }
        }));
    }

    @Override
    public Map<Long, Set<Long>> getDimVarInfo() {
        return this.getDimVarInfo(this.getFunctionObj());
    }

    @Override
    public Long getBizModelId() {
        return super.getBizModelId();
    }

    public Map<String, Long> getOrCacheParamMemberViewIds(Map<String, Long> dimViewIdMap) {
        return (Map)this.getOrCacheObjWithDef(dimViewIdMap, null, "ParamMemberViewIds", false, HashMap.class, false);
    }

    public Set<String> getMemberF7KeySet() {
        return baseDataKeys;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        this.dealMemberF7CloseCallback(afterF7SelectEvent);
    }
}

