/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.function;

import java.util.EventObject;
import java.util.List;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.FunctionStepEnum;
import kd.epm.eb.common.analysereport.constants.SortWayEnum;
import kd.epm.eb.common.analysereport.pojo.condition.JudgeCondition;
import kd.epm.eb.common.analysereport.pojo.functions.steps.FunctionStepData;
import kd.epm.eb.common.analysereport.pojo.functions.steps.SortWay;
import kd.epm.eb.formplugin.analysereport.function.AbstractStepPlugin;
import kd.epm.eb.formplugin.analysereport.function.ConditionPluginHandler;

public class SortWayStepPlugin
extends AbstractStepPlugin
implements ConditionPluginHandler {
    @Override
    public void lock4View() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap", "advconap1"});
    }

    @Override
    public void loadStepData() {
        SortWay sortWay = (SortWay)this.getStepDataFromCache();
        if (sortWay != null) {
            String sortWayVal = sortWay.getSortWay();
            this.getModel().setValue("sortway", (Object)sortWayVal);
            Long sortAccord = sortWay.getSortAccord();
            if (this.notEmpty(sortAccord)) {
                this.getModel().setValue("sortaccording", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)sortAccord, (String)"eb_dimcombinationentity"));
            }
            this.loadConditionData(sortWay.getSortCondition());
            this.dealSortWayChange(sortWayVal);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if ("sortway".equals(fieldName)) {
            this.dealSortWayChange((String)e.getChangeSet()[0].getNewValue());
        }
    }

    private void dealSortWayChange(String sortWayVal) {
        SortWayEnum sortWayByVal = SortWayEnum.getSortWayByVal((String)sortWayVal);
        boolean showSortAccord = true;
        boolean showCondition = true;
        switch (sortWayByVal) {
            case NULL: {
                showSortAccord = false;
                showCondition = false;
                break;
            }
            case GROUPDOWN: 
            case GROUPUP: {
                showCondition = false;
            }
        }
        if (!showCondition) {
            this.getModel().deleteEntryData("filterconditionentity");
        }
        this.getView().setVisible(Boolean.valueOf(showCondition), new String[]{"advconap"});
        if (!showSortAccord) {
            this.getModel().setValue("sortaccording", null);
        }
        this.getView().setVisible(Boolean.valueOf(showSortAccord), new String[]{"sortaccording"});
    }

    @Override
    protected String getStepKey() {
        return FunctionStepEnum.SORTWAY.name();
    }

    @Override
    public FunctionStepData selectStepData() {
        SortWay sortWay = new SortWay();
        sortWay.setSortWay((String)this.getValue("sortway", null));
        sortWay.setSortAccord((Long)this.getValue("sortaccording", "id"));
        JudgeCondition judgeCondition = this.selectCondition();
        sortWay.setSortCondition(judgeCondition);
        return sortWay;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"sortaccording"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("sortaccording".equals(name)) {
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            this.addDimGroupFilter((List<QFilter>)customQFilters, true);
            customQFilters.add(AnalyseReportUtil.getInstance().getMetricTypeQFilter());
        }
    }

    @Override
    public void addLeftValQFilters(List<QFilter> qFilters) {
        this.addDimGroupFilter(qFilters, false);
    }

    @Override
    public void addRightValQFilters(List<QFilter> qFilters) {
        this.addDimGroupFilter(qFilters, false);
    }
}

