/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.analysereport.constants.DimGroupTypeEnum;
import kd.epm.eb.common.analysereport.constants.FilterEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class AnalyseRptCommonService {
    private static final Set<String> copyIngoreKeys = new HashSet<String>(Arrays.asList("id", "number", "name", "creater", "modifier", "createdate", "modifydate"));

    public static boolean numberFormatCheck(String number, IFormView formView) {
        if (!CheckStringsUtil.checkNumber((String)number)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u5141\u8bb8\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u5c0f\u6570\u70b9\uff0c\u4e14\u4e0d\u5141\u8bb8\u5b58\u5728\u8fde\u7eed\u7684\u4e24\u4e2a\u5c0f\u6570\u70b9\u4ee5\u53ca\u4ee5\u5c0f\u6570\u70b9\u5f00\u5934\u548c\u7ed3\u5c3e\u3002", (String)"AnalyseRptCommonService_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean nameFormatCheck(String name, IFormView formView) {
        if (StringUtils.isEmpty((String)name) || name.trim().length() == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AnalyseRptCommonService_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean numberOnlyCheck(String number, long modelid, String metaDataKey, IFormView formView) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)metaDataKey, (QFilter[])qf.toArrays())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AnalyseRptCommonService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean numberOnlyCheck(String number, long modelid, long bizmodelid, String metaDataKey, IFormView formView, long currentId) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("bizmodel", "=", (Object)bizmodelid);
        qf.add("number", "=", (Object)number);
        if (currentId != 0L) {
            qf.add("id", "!=", (Object)currentId);
        }
        if (QueryServiceHelper.exists((String)metaDataKey, (QFilter[])qf.toArrays())) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AnalyseRptCommonService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean numberOnlyCheck(String number, long modelid, long bizmodelid, String metaDataKey, IFormView formView) {
        return AnalyseRptCommonService.numberOnlyCheck(number, modelid, bizmodelid, metaDataKey, formView, 0L);
    }

    public static void checkAndBuildDefVariable(long modelid, long bizmodelid) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("bizmodel", "=", (Object)bizmodelid);
        if (!QueryServiceHelper.exists((String)"eb_reportvariabletype", (QFilter[])qf.toArray())) {
            AnalyseRptCommonService.buildAnalyseReportVariableType(modelid, bizmodelid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildAnalyseReportVariableType(long modelid, long bizmodelid) {
        ArrayList<DynamicObject> parameters = new ArrayList<DynamicObject>(20);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelid);
        List dimensionList = orCreate.getDimensionListByBusModel(Long.valueOf(bizmodelid));
        for (Dimension dimension : dimensionList) {
            parameters.add(AnalyseRptCommonService.createParameter(modelid, bizmodelid, dimension));
        }
        DynamicObject[] res = new DynamicObject[]{AnalyseRptCommonService.createVariableType(modelid, bizmodelid, VariableTypeEnum.Parameter)};
        try (TXHandle tx = TX.requiresNew((String)"saveVariableType");){
            try {
                SaveServiceHelper.save((DynamicObject[])res);
                SaveServiceHelper.save((DynamicObject[])parameters.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
            }
            finally {
                ModelCacheContext.remove();
            }
        }
    }

    public static void fillEntryEntityRow(DynamicObject object, IDataModel iDataModel, int roeIndex, String typeNumber, VariableTypeEnum variableType) {
        iDataModel.setValue("id", (Object)object.getString("id"), roeIndex);
        iDataModel.setValue("number", object.get("number"), roeIndex);
        iDataModel.setValue("name", object.get("name"), roeIndex);
        iDataModel.setValue("modifier", object.get("modifier"), roeIndex);
        iDataModel.setValue("modifydate", object.get("modifydate"), roeIndex);
        iDataModel.setValue("creater", object.get("creater"), roeIndex);
        iDataModel.setValue("createdate", object.get("createdate"), roeIndex);
        iDataModel.setValue("description", object.get("description"), roeIndex);
        if (typeNumber != null) {
            iDataModel.setValue("type", (Object)typeNumber, roeIndex);
        }
        if (VariableTypeEnum.Function == variableType) {
            iDataModel.setValue("showfields", (Object)object.getString("showfields"), roeIndex);
            iDataModel.setValue("functiontype", (Object)object.getString("type"), roeIndex);
        } else if (VariableTypeEnum.Combination == variableType) {
            iDataModel.setValue("formula", (Object)object.getString("formula_show"), roeIndex);
            String dimGroupType = object.getString("dimgrouptype");
            dimGroupType = StringUtils.isNotEmpty((String)dimGroupType) ? DimGroupTypeEnum.getDimGroupEnumByIndex((String)dimGroupType).getName() : DimGroupTypeEnum.NUMBER.getName();
            iDataModel.setValue("functiontype", (Object)dimGroupType, roeIndex);
        } else if (VariableTypeEnum.RptSection == variableType) {
            iDataModel.setValue("ebtemplate", (Object)object.getString("template.name"), roeIndex);
        }
    }

    public static void buildAnalyseRptListTree(TreeNode root, Map<Object, DynamicObject> map, String prefix) {
        Map<String, List<DynamicObject>> collect = map.values().stream().collect(Collectors.groupingBy(c -> c.getString(prefix + "bizmodel.id")));
        TreeNode bizModelNode = null;
        for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
            for (DynamicObject ob : entry.getValue()) {
                if (bizModelNode == null) {
                    bizModelNode = new TreeNode(root.getId(), entry.getKey(), ob.getString(prefix + "bizmodel.name"));
                    bizModelNode.setLongNumber("bizmodel");
                    root.addChild(bizModelNode);
                }
                if (bizModelNode.getTreeNode(ob.getString(prefix + "id"), 20) != null) continue;
                bizModelNode.addChild(new TreeNode(entry.getKey(), ob.getString(prefix + "id"), ob.getString(prefix + "name")));
            }
            bizModelNode = null;
        }
    }

    public static void updateUserAndRptRelation(Set<Long> userids, Long reportId, Long modelid) {
        Map<Long, Long> shareUsers = AnalyseRptCommonService.queryUseridsByReportid(reportId, modelid);
        Set deleteIds = shareUsers.entrySet().stream().filter(s -> !userids.contains(s.getValue())).map(s -> (Long)s.getKey()).collect(Collectors.toSet());
        Set addUserIds = userids.stream().filter(u -> !shareUsers.values().contains(u)).collect(Collectors.toSet());
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(addUserIds.size());
        for (Long userid : addUserIds) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_analyserpt_user");
            object.set("user", (Object)userid);
            object.set("report", (Object)reportId);
            object.set("model", (Object)modelid);
            object.set("isread", (Object)Character.valueOf('0'));
            objects.add(object);
        }
        if (deleteIds.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_analyserpt_user", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
        }
        if (objects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        }
    }

    private static Map<Long, Long> queryUseridsByReportid(Long reportId, Long modelid) {
        QFBuilder qf = new QFBuilder("report", "=", (Object)reportId);
        qf.add("model", "=", (Object)modelid);
        Map maps = BusinessDataServiceHelper.loadFromCache((String)"eb_analyserpt_user", (String)"id,user.id", (QFilter[])qf.toArrays());
        Map<Long, Long> collect = maps.entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((DynamicObject)e.getValue()).getLong("user.id")));
        return collect;
    }

    private static DynamicObject createVariableType(long modelid, long bizmodelid, VariableTypeEnum value) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportvariabletype");
        object.set("id", (Object)DBServiceHelper.genGlobalLongId());
        object.set("number", (Object)value.getNumber());
        object.set("name", (Object)value.getName());
        object.set("varmetadatakey", (Object)value.getMetadata());
        object.set("model", (Object)modelid);
        object.set("bizmodel", (Object)bizmodelid);
        long userId = UserUtils.getUserId();
        object.set("creater", (Object)userId);
        object.set("modifier", (Object)userId);
        Date now = TimeServiceHelper.now();
        object.set("createdate", (Object)now);
        object.set("modifydate", (Object)now);
        return object;
    }

    private static DynamicObject createParameter(long modelid, long bizmodelid, Dimension dimension) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionparameter");
        object.set("id", (Object)DBServiceHelper.genGlobalLongId());
        object.set("number", (Object)dimension.getNumber());
        object.set("name", (Object)dimension.getName());
        object.set("model", (Object)modelid);
        object.set("bizmodel", (Object)bizmodelid);
        object.set("dimension", (Object)dimension.getId());
        long userId = UserUtils.getUserId();
        object.set("creater", (Object)userId);
        object.set("modifier", (Object)userId);
        Date now = TimeServiceHelper.now();
        object.set("createdate", (Object)now);
        object.set("modifydate", (Object)now);
        return object;
    }

    public static DynamicObject[] getFileObj(List<String> fileids) {
        String selectFields = "ffileid";
        QFilter qf = new QFilter("finterid", "in", fileids);
        QFilter qf1 = new QFilter("fBillType", "=", (Object)"eb_analysereporttemplate");
        return BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFields, (QFilter[])new QFilter[]{qf, qf1});
    }

    public static Set<Long> getTempIdFromTree(TreeNode node, Set<Long> tempids) {
        List children;
        if (tempids == null) {
            tempids = new HashSet<Long>(16);
        }
        if ((children = node.getChildren()) != null) {
            for (TreeNode child : children) {
                String longNumber = child.getLongNumber();
                if (StringUtils.isNotEmpty((String)longNumber) && "bizmodel".equals(longNumber)) {
                    AnalyseRptCommonService.getTempIdFromTree(child, tempids);
                    continue;
                }
                tempids.add(Long.parseLong(child.getId()));
            }
        }
        return tempids;
    }

    public static Set<Long> queryReadReportIds(Long modelid, String filterStatus) {
        if (modelid == 0L) {
            return new HashSet<Long>();
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        if (filterStatus == null) {
            filterStatus = FilterEnum.unRead.getIndex();
        }
        if (filterStatus.equals(FilterEnum.read.getIndex())) {
            qf.add("isread", "=", (Object)Character.valueOf('1'));
        } else if (filterStatus.equals(FilterEnum.unRead.getIndex())) {
            qf.add("isread", "=", (Object)Character.valueOf('0'));
        }
        qf.add("user", "=", (Object)UserUtils.getUserId());
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"eb_analyserpt_user", (String)"id,report.id", (QFilter[])qf.toArrays());
        return datas.values().stream().map(d -> d.getLong("report.id")).collect(Collectors.toSet());
    }

    public static String getReportCount(boolean isRead, Long modelid) {
        String sql = "select count(*) as c from t_eb_analysereport_user where fuserid = ? and fisread = ? and fmodelid = ?";
        Object[] params = new Object[]{UserUtils.getUserId(), Character.valueOf(isRead ? (char)'1' : '0'), modelid};
        DataSet rows = DB.queryDataSet((String)"getReportCount", (DBRoute)DBRoute.of((String)"EPM"), (String)sql, (Object[])params);
        if (rows == null || rows.isEmpty()) {
            return "0";
        }
        return rows.next().getLong("c") + "";
    }

    public static void updateReportRead(Long pkid) {
        QFBuilder qf = new QFBuilder("report", "=", (Object)pkid);
        qf.add("user", "=", (Object)UserUtils.getUserId());
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_analyserpt_user", (String)"isread", (QFilter[])qf.toArrays());
        if (load != null && !load.getBoolean("isread")) {
            load.set("isread", (Object)Character.valueOf('1'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{load});
        }
    }

    public static void copyAdd(IFormView View2, IDataModel model) {
        Object copyId = View2.getFormShowParameter().getCustomParam("copyId");
        if (copyId == null || 0L == (Long)copyId) {
            return;
        }
        DynamicObject ob = BusinessDataServiceHelper.loadSingle((Object)copyId, (DynamicObjectType)model.getDataEntityType());
        if (ob == null) {
            return;
        }
        DynamicObjectUtils.copy((DynamicObject)ob, (DynamicObject)model.getDataEntity(), copyIngoreKeys);
    }

    public static boolean tempIsEnable(Long tempId) {
        DynamicObject status = BusinessDataServiceHelper.loadSingle((Object)tempId, (String)"eb_analysereporttemplate", (String)"status");
        if (status == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"AnalyseRptCommonService_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return status.getBoolean("status");
    }
}

