/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.service;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.utils.IDUtils;

public class AnalyseRptTemplateService {
    private static NumberFormat decimalFormat = DecimalFormat.getInstance();

    public static List<Map<String, String>> queryAllVariables(long modelId, long bizmodelId, boolean filterRefFunction) {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
        boolean filterBizModel = IDUtils.isNotEmptyLong((Long)bizmodelId);
        String selectProperties = filterBizModel ? "id,number,name" : "id,number,name,bizmodel.number";
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        if (filterBizModel) {
            qModel.and("bizmodel", "=", (Object)bizmodelId);
        }
        QFilter qRefFunction = new QFilter("reffunctiondimnums", "=", (Object)"");
        for (VariableTypeEnum value : VariableTypeEnum.values()) {
            QFilter[] qFilterArray;
            boolean qRefFunctionType = filterRefFunction && (value == VariableTypeEnum.Combination || value == VariableTypeEnum.Condition);
            String string = value.getMetadata();
            if (qRefFunctionType) {
                QFilter[] qFilterArray2 = new QFilter[2];
                qFilterArray2[0] = qModel;
                qFilterArray = qFilterArray2;
                qFilterArray2[1] = qRefFunction;
            } else {
                QFilter[] qFilterArray3 = new QFilter[1];
                qFilterArray = qFilterArray3;
                qFilterArray3[0] = qModel;
            }
            Map objectMap = BusinessDataServiceHelper.loadFromCache((String)string, (String)selectProperties, (QFilter[])qFilterArray);
            for (DynamicObject object : objectMap.values()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("id", object.getString("id"));
                map.put("number", object.getString("number"));
                map.put("name", object.getString("name"));
                map.put("type", value.getNumber());
                if (!filterBizModel) {
                    map.put("bizmodel", object.getString("bizmodel.number"));
                }
                lists.add(map);
            }
        }
        return lists;
    }

    public static Set<Long> queryShareUserIdsFromTemp(Long tempid) {
        HashSet<Long> userids = new HashSet<Long>(16);
        String sql = "select fbasedataid from t_eb_rpttemplate_user where fid = ?";
        DataSet rows = DB.queryDataSet((String)"getShareUserIdsFromRpt", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{tempid});
        if (rows != null && !rows.isEmpty()) {
            while (rows.hasNext()) {
                userids.add(rows.next().getLong("fbasedataid"));
            }
        }
        return userids;
    }

    public static AnalyseReportTemplate getTempData(Long pkid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_analysereporttemplate");
        if (object == null) {
            return null;
        }
        AnalyseReportTemplate template = new AnalyseReportTemplate();
        template.setId(Long.valueOf(object.getLong("id")));
        template.setNumber(object.getString("number"));
        template.setName(object.getString("name"));
        template.setDescription(object.getString("description"));
        template.setModelid(Long.valueOf(object.getLong("model.id")));
        template.setEnable(object.getBoolean("status"));
        template.setBizModelid(Long.valueOf(object.getLong("bizmodel.id")));
        return template;
    }

    public static Map<String, Object> getReportData(Long pkid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_analysereport");
        if (object == null) {
            return null;
        }
        HashMap<String, Object> returns = new HashMap<String, Object>(16);
        returns.put("id", object.getString("id"));
        returns.put("rptnumber", object.getString("number"));
        returns.put("rptname", object.getLocaleString("name"));
        returns.put("json", object.getString("dimsjson"));
        returns.put("tempid", object.getString("rpttemp.id"));
        returns.put("status", object.getString("status"));
        return returns;
    }
}

