/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.webOffice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseDimShowForDimBaseCtrl;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptGenUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.analysereport.AnalyseWebOfficeVarEntity;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.analysereport.pojo.MemberView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.f7.DimMemberF7SelInfo;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;
import kd.epm.eb.formplugin.analysereport.webOffice.AnalyseTmpWebOfficeBase;
import kd.epm.eb.spread.utils.AttachmentHelper;
import org.jetbrains.annotations.NotNull;

public class AnalyseRptGenWebOfficePlugin
extends AnalyseTmpWebOfficeBase
implements BeforeF7SelectListener {
    private static final String CACHE_ATTACH_POPUP = "attachPopupCache";
    private static final Log log = LogFactory.getLog(AnalyseRptGenWebOfficePlugin.class);
    private AnalyseRptEntity templateEntity;
    private Collection<AnalyseWebOfficeVarEntity> varSelInfo;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, AnalyseDimShowForDimBaseCtrl.ALL_DIM_KEYS.toArray(new String[0]));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.getTemplateData().getRptTemp().isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AnalyseRptGenWebOfficePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDimCtrlVisible();
        this.loadDimValues();
        this.loadShareUsers();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.openWebOfficeFile();
        this.setReadOnly();
        this.setTempUnenable();
    }

    @Override
    protected Long getOpenFileId() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (rptTemp == null) {
            return null;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (((Boolean)customParams.get("isnew")).booleanValue()) {
            return rptTemp.getRptTemp().getId();
        }
        return rptTemp.getFileId();
    }

    @Override
    protected String getCaption() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (rptTemp == null) {
            return null;
        }
        Map rptName = (Map)JSONUtils.parse((String)rptTemp.getRptName(), HashMap.class);
        String name = (String)rptName.get(Lang.get().toString());
        if (name == null) {
            name = (String)rptName.get("GLang");
        }
        return name;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_gen": {
                this.getPageCache().put("oprationtype", "genrpt");
                this.replaceVar();
                break;
            }
            case "btn_save": {
                this.getPageCache().remove("oprationtype");
                this.prepareSave();
                break;
            }
            case "btn_note": {
                this.showMsgForm();
                break;
            }
            case "btn_refresh": {
                this.loadDimValues();
                break;
            }
            case "btn_push": {
                this.publish();
                break;
            }
            case "btn_attache": {
                this.attachePopup(key);
                break;
            }
            case "btn_baseinfo": {
                this.setBaseInfo(key);
                break;
            }
        }
    }

    private void showMsgForm() {
        Set collect;
        DynamicObject rpt = QueryServiceHelper.queryOne((String)"eb_analysereport", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getTemplateData().getFileId())});
        if (rpt == null || !rpt.getBoolean("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53d1\u5e03\u62a5\u544a\u3002", (String)"AnalyseRptGenWebOfficePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object shareusers = this.getModel().getValue("shareusers");
        String executorid = "";
        if (shareusers != null && (collect = ((DynamicObjectCollection)shareusers).stream().map(m -> m.getString("fbasedataid.id")).collect(Collectors.toSet())).size() > 0) {
            executorid = kd.bos.login.actions.SerializationUtils.serializeToBase64(collect);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("executorid", (Object)executorid);
        formShowParameter.setCustomParam("showaddnew", (Object)"1");
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_taskmessageremin");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void replaceVar() {
        if (!new AnalyseDimShowForDimBaseCtrl().checkDimHasValue(this.getModel(), (AbstractFormPlugin)this)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u503c\u7684\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u62a5\u544a\u3002", (String)"AnalyseRptGenWebOfficePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("replaceVar");
    }

    private void loadDimValues() {
        String dimJson = this.getJson();
        if (StringUtils.isEmpty((CharSequence)dimJson)) {
            return;
        }
        Map dimValues = (Map)kd.bos.login.actions.SerializationUtils.fromJsonString((String)dimJson, Map.class);
        new AnalyseDimShowForDimBaseCtrl().loadDimValues((AbstractFormPlugin)this, this.getModel(), dimValues);
    }

    private String getJson() {
        String dimJson = this.getPageCache().get("json");
        if (dimJson == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams.get("json") == null) {
                return null;
            }
            dimJson = customParams.get("json").toString();
        }
        return dimJson;
    }

    private void prepareSave() {
        if (!new AnalyseDimShowForDimBaseCtrl().checkDimHasValue(this.getModel(), (AbstractFormPlugin)this)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u8bbe\u7f6e\u503c\u7684\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"AnalyseRptGenWebOfficePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        AnalyseRptEntity rptTemp = this.getTemplateData();
        this.save(rptTemp);
    }

    @Override
    protected void doOther(AnalyseRptEntity rptTemp) {
        super.doOther(rptTemp);
        if (!rptTemp.isSaved()) {
            rptTemp.setSaved(true);
            this.templateEntity = rptTemp;
            this.getPageCache().put("rptWebOfficeCache", kd.bos.login.actions.SerializationUtils.serializeToBase64((Object)rptTemp));
        }
    }

    @Override
    protected String getFileName(AnalyseRptEntity rptTemp) {
        Map rptName = (Map)JSONUtils.parse((String)rptTemp.getRptName(), HashMap.class);
        String name = (String)rptName.get(Lang.get().toString());
        if (name == null) {
            name = (String)rptName.get("GLang");
        }
        return StringUtils.join((Object[])new String[]{rptTemp.getRptNumber(), "(", name, ")", "_RPT", ".docx"});
    }

    @Override
    protected List<Collection<DynamicObject>> getSaveData(WebOfficeBookmarkEvent webOfficeEvent, AnalyseRptEntity rptTemp) {
        if (!Objects.equals("saveRpt", webOfficeEvent.getId())) {
            return null;
        }
        ArrayList<Collection<DynamicObject>> needSaveRpts = new ArrayList<Collection<DynamicObject>>(16);
        String dimJson = this.getDimJson();
        this.getPageCache().put("json", dimJson);
        needSaveRpts.add(AnalyseRptGenUtil.getInstance().getSaveDataTmpBase(rptTemp, dimJson));
        return needSaveRpts;
    }

    private String getDimJson() {
        return new AnalyseDimShowForDimBaseCtrl().getDimJson((AbstractFormPlugin)this, this.getModel());
    }

    private Map<String, String> getDimJsonInfo() {
        String varValues = this.getDimJson();
        if (varValues == null) {
            return null;
        }
        return (Map)kd.bos.login.actions.SerializationUtils.fromJsonString((String)varValues, Map.class);
    }

    private void setDimCtrlVisible() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (rptTemp == null) {
            return;
        }
        Set showDims = AnalyseRptGenUtil.getInstance().getVarDims(rptTemp, (AbstractFormPlugin)this);
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        splitContainer.hidePanel(SplitDirection.left, showDims.isEmpty());
        this.getPageCache().put("modelid", rptTemp.getRptTemp().getModelid().toString());
        this.getPageCache().put("showdim", kd.bos.login.actions.SerializationUtils.toJsonString((Object)showDims));
        new AnalyseDimShowForDimBaseCtrl().setDimCtrlVisible((AbstractFormPlugin)this);
    }

    private Set<String> getShowDimsFromJson(String dimJson) {
        if (StringUtils.isEmpty((CharSequence)dimJson)) {
            return null;
        }
        Map dimValues = (Map)kd.bos.login.actions.SerializationUtils.fromJsonString((String)dimJson, Map.class);
        return dimValues.keySet();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("shareusers".equals(evt.getProperty().getName())) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_push"));
        } else {
            String dimNumber = this.getCurrentDimNumber(evt.getProperty().getName());
            if (dimNumber == null) {
                this.getView().showTipNotification(String.format("map dimension failed:%s", evt.getProperty().getName()));
                return;
            }
            AnalyseRptEntity rptTemp = this.getTemplateData();
            Long modelId = rptTemp.getModelId();
            MemberF7Parameter memberF7Parameter = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            memberF7Parameter.setBusModelId(rptTemp.getRptTemp().getBizModelid());
            if (DimensionViewServiceHelper.hasView((String)dimNumber)) {
                memberF7Parameter.setEnableView(true);
                Long viewId = this.getDimViewId(dimNumber);
                if (this.notEmpty(viewId)) {
                    memberF7Parameter.setViewId(viewId);
                }
            }
            if ("Metric".equals(dimNumber) || "Currency".equals(dimNumber) || "Version".equals(dimNumber) || "DataType".equals(dimNumber) || "ChangeType".equals(dimNumber)) {
                memberF7Parameter.setOnlySelLeaf(true);
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                memberF7Parameter.setCanSelectRoot(false);
            } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                memberF7Parameter.setCanSelectBudgetPeriodRoot(false);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)memberF7Parameter);
        }
    }

    private Long getDimViewId(String dimKey) {
        return new AnalyseDimShowForDimBaseCtrl().getDimViewId((AbstractFormPlugin)this, dimKey);
    }

    private void cacheDimViewId(String dimKey, Long viewId) {
        new AnalyseDimShowForDimBaseCtrl().cacheDimViewId((AbstractFormPlugin)this, dimKey, viewId);
    }

    public String getCurrentDimNumber(String controlKey) {
        return new AnalyseDimShowForDimBaseCtrl().getCurrentDimNumber((AbstractFormPlugin)this, controlKey);
    }

    private void publish() {
        if (!QueryServiceHelper.exists((String)"eb_analysereport", (Object)this.getTemplateData().getFileId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u62a5\u544a\u3002", (String)"AnalyseRptGenWebOfficePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MulBasedataEdit shareusers = (MulBasedataEdit)this.getControl("shareusers");
        shareusers.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        shareusers.click();
    }

    private void attachePopup(String key) {
        AnalyseRptEntity templateData = this.getTemplateData();
        HashMap<String, String> openParameter = new HashMap<String, String>(4);
        openParameter.put("formId", "eb_attachpopup");
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("fileid", (Object)String.valueOf(templateData.getFileId()));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this.isReadOnly()) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9644\u4ef6\u67e5\u770b", (String)"AnalyseRptGenWebOfficePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(formShowParameter);
    }

    private void loadShareUsers() {
        if (this.getTemplateData() == null) {
            return;
        }
        Set<Long> userids = AnalyseRptTemplateService.queryShareUserIdsFromTemp(this.getTemplateData().getRptTemp().getId());
        this.getModel().setValue("shareusers", (Object)userids.toArray());
    }

    @Override
    protected void SaveRptAttachFile(Long reportId) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String cache = this.getPageCache().get(CACHE_ATTACH_POPUP);
                if (cache != null) {
                    QFilter fInterID = new QFilter("fInterID", "=", (Object)reportId.toString());
                    fInterID.and("fBillType", "=", (Object)"eb_analysereport");
                    AttachmentHelper.deleteAttachmentData((QFilter)fInterID);
                    List datas = (List)SerializationUtils.deSerializeFromBase64((String)cache);
                    AttachmentHelper.saveAttachmentData((List)datas, (Long)reportId, (String)"eb_analysereport");
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("SaveRptAttachFileError:" + reportId, (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("btn_push".equals(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            this.publishRpt(rows);
        } else if ("btn_baseinfo".equals(actionId)) {
            Map data = (Map)returnData;
            AnalyseRptEntity templateData = this.getTemplateData();
            templateData.setRptName(data.get("rptname").toString());
            templateData.setRptNumber((String)data.get("rptnumber"));
            templateData.setMemberVarInfo(AnalyseReportUtil.getInstance().getVarValInfoFromParam(data));
            this.getPageCache().put("rptWebOfficeCache", kd.bos.login.actions.SerializationUtils.serializeToBase64((Object)templateData));
        }
    }

    private Map<String, String> getUserDimNumKeyMapping() {
        return new AnalyseDimShowForDimBaseCtrl().getUserDimNumKeyMapping((AbstractFormPlugin)this);
    }

    private void publishRpt(ListSelectedRowCollection rows) {
        Set collect = rows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toSet());
        this.getModel().setValue("shareusers", (Object)collect.toArray());
        AnalyseRptEntity templateData = this.getTemplateData();
        try (TXHandle tx = TX.required();){
            try {
                AnalyseRptCommonService.updateUserAndRptRelation(new HashSet<Long>(collect), templateData.getFileId(), templateData.getRptTemp().getModelid());
                DynamicObject ob = BusinessDataServiceHelper.loadSingle((String)"eb_analysereport", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateData.getFileId())});
                if (ob == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u672a\u627e\u5230\u62a5\u544a\u3002", (String)"AnalyseRptGenWebOfficePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                ob.set("status", (Object)Character.valueOf('1'));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ob});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalyseRptGenWebOfficePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private AnalyseRptEntity getTemplateData() {
        if (this.templateEntity == null) {
            String cache = this.getPageCache().get("rptWebOfficeCache");
            if (cache == null) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams == null || customParams.size() == 0) {
                    throw new KDBizException("not find report information.");
                }
                AnalyseReportTemplate reportData = AnalyseRptTemplateService.getTempData(Long.parseLong(customParams.get("tempid").toString()));
                AnalyseRptEntity obj = new AnalyseRptEntity();
                obj.setRptTemp(reportData);
                obj.setRptNumber(customParams.get("rptnumber").toString());
                obj.setRptName(customParams.get("rptname").toString());
                obj.setModelId(reportData.getModelid());
                obj.setMemberVarInfo(AnalyseReportUtil.getInstance().getAndDelVarValInfoFromCache(customParams));
                if (((Boolean)customParams.get("isnew")).booleanValue()) {
                    obj.setFileId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
                } else {
                    obj.setSaved(true);
                    obj.setFileId(Long.valueOf(customParams.get("id").toString()));
                }
                this.getPageCache().put("rptWebOfficeCache", kd.bos.login.actions.SerializationUtils.serializeToBase64((Object)obj));
                this.templateEntity = obj;
            } else {
                this.templateEntity = (AnalyseRptEntity)kd.bos.login.actions.SerializationUtils.deSerializeFromBase64((String)cache);
            }
        }
        return this.templateEntity;
    }

    private void setReadOnly() {
        if (this.isReadOnly()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_gen", "btn_save", "btn_push", "btn_note"});
            SplitContainer splitcontainerap = (SplitContainer)this.getControl("splitcontainerap");
            splitcontainerap.hidePanel(SplitDirection.left, true);
        }
    }

    @Override
    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
        if (Objects.equals("replaceVar", e.getId())) {
            this.replaceVar(e);
        } else if (Objects.equals("saveRpt", e.getId())) {
            super.onGetAllBookmarks(e);
        }
    }

    private void replaceVar(WebOfficeBookmarkEvent e) {
        List<String> bookmarks = this.removeBookMark(e);
        Collection<AnalyseWebOfficeVarEntity> varInfos = this.getVarSelInfosFromCache();
        HashSet<String> bookmarkSet = new HashSet<String>(bookmarks);
        boolean hasRptSection = false;
        Iterator<AnalyseWebOfficeVarEntity> iterator = varInfos.iterator();
        while (iterator.hasNext()) {
            AnalyseWebOfficeVarEntity varEntity = iterator.next();
            if (bookmarkSet.contains(varEntity.getVarKey())) {
                if (!VariableTypeEnum.RptSection.getNumber().equals(varEntity.getVarType())) continue;
                hasRptSection = true;
                continue;
            }
            iterator.remove();
        }
        if (hasRptSection) {
            this.prepareParam4RptSection(bookmarkSet);
        } else {
            this.replaceRptVar(null, bookmarkSet, varInfos);
        }
    }

    private void prepareParam4RptSection(Set<String> bookmarks) {
        this.getOrCacheObj(bookmarks, null, "newBookmarkKeys", true, Set.class, false);
        this.markSave4RptSection(false);
        this.saveWordFile(this.getTemplateData());
    }

    private void replaceRptVar(String wordFileId, Set<String> bookmarks, Collection<AnalyseWebOfficeVarEntity> varInfos) {
        ArrayList errInfo = new ArrayList(16);
        AnalyseRptEntity templateData = this.getTemplateData();
        Map<String, String> paramDimValues = this.getDimJsonInfo();
        if (paramDimValues == null) {
            paramDimValues = new HashMap<String, String>(16);
        }
        HashMap _paramDimValues = new HashMap(paramDimValues.size());
        Map dimMemberVarValInfo = AnalyseReportUtil.getInstance().parseVarInfo(templateData);
        paramDimValues.forEach((dimNum, memberNumber) -> {
            Long viewId = this.getDimViewId((String)dimNum);
            _paramDimValues.put(dimNum, new MemberView(memberNumber, viewId));
        });
        Map refVarInfo = AnalyseReportUtil.getInstance().getTempRefVarInfos(templateData.getRptTemp().getId());
        AnalyseRptGenUtil rptGenUtil = AnalyseRptGenUtil.getInstance();
        String errorInfo = rptGenUtil.checkMemberVarValInfo(templateData.getModelId(), dimMemberVarValInfo, refVarInfo);
        if (errorInfo != null) {
            this.getView().showTipNotification(errorInfo);
            return;
        }
        rptGenUtil.replaceVar(wordFileId, errInfo, bookmarks, templateData, varInfos, _paramDimValues, dimMemberVarValInfo, this.getWebOffice());
        if (errInfo.size() > 0) {
            CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)this.getView(), errInfo, (String)ResManager.loadKDString((String)"\u53d8\u91cf\u8d4b\u503c\u60c5\u51b5", (String)"AnalyseRptGenWebOfficePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u8d4b\u503c\u4e3a\u7a7a\u7684\u53d8\u91cf\uff1a", (String)"AnalyseRptGenWebOfficePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.prepareSave();
    }

    private boolean markSave4RptSection(boolean remove) {
        boolean removeSuss = false;
        if (remove && !this.isEmpty(this.getPageCache().get("Save4RptSection"))) {
            this.getPageCache().remove("Save4RptSection");
            removeSuss = true;
        } else if (!remove) {
            this.getPageCache().put("Save4RptSection", "true");
        }
        return removeSuss;
    }

    @NotNull
    private List<String> removeBookMark(WebOfficeBookmarkEvent e) {
        HashSet removes = new HashSet(16);
        List bookmarks = e.getBookmarks();
        AnalyseRptEntity templateData = this.getTemplateData();
        Long templateid = templateData.getRptTemp().getId();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_analysevarsel", (String)"vartype,rpttemp,varkey", (QFilter[])new QFilter[]{new QFilter("rpttemp", "=", (Object)templateid)});
        query.forEach(obj -> removes.add(obj.getString("varkey")));
        ArrayList<String> result = new ArrayList<String>(bookmarks.size());
        bookmarks.forEach(mark -> {
            if (removes.contains(mark = mark.replace("table", ""))) {
                result.add((String)mark);
            }
        });
        return result;
    }

    @Override
    public void getBookMark() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("saveRpt");
    }

    private void setBaseInfo(String key) {
        AnalyseRptEntity templateData = this.getTemplateData();
        AnalyseReportUtil.getInstance().openBaseForm(templateData.getRptTemp().getId(), this.isReadOnly(), templateData, this.getView(), new CloseCallBack((IFormPlugin)this, key));
    }

    private void setTempUnenable() {
        if (!this.getTemplateData().getRptTemp().isEnable()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_gen", "btn_push", "btn_save"});
        }
    }

    private boolean isReadOnly() {
        return "1".equals(this.getView().getFormShowParameter().getCustomParam("isReadOnly"));
    }

    @Override
    protected void selectQuoteInfo(List<MemberQuoteDao> quoteDaoList, Long modelId, Long sourceId, Collection<DynamicObject> objects, String objType) {
        if ("eb_analysereport".equals(objType)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            for (DynamicObject obj : objects) {
                String dimsjson = obj.getString("dimsjson");
                if (!StringUtils.isNotEmpty((CharSequence)dimsjson)) continue;
                Map dimsMap = (Map)kd.bos.login.actions.SerializationUtils.fromJsonString((String)dimsjson, Map.class);
                dimsMap.forEach((dimNum, membInfo) -> {
                    String membNum;
                    String[] strs = membInfo.split("!");
                    Long viewId = strs.length == 3 ? Long.valueOf(strs[2]) : null;
                    Member member = modelCacheHelper.getMember(dimNum, viewId, membNum = strs[0]);
                    if (member != null) {
                        quoteDaoList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), member.getDimension().getId(), member.getId(), MemberQuoteResourceEnum.ANALYREPORT, sourceId));
                    }
                });
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (rptTemp != null) {
            AdminModelUtil.checkAdminModeBeforeItemClick(evt, rptTemp.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
        }
    }

    private Collection<AnalyseWebOfficeVarEntity> getVarSelInfosFromCache() {
        if (this.varSelInfo == null) {
            String varKeyStr = this.getPageCache().get("varSelInfos");
            this.varSelInfo = varKeyStr != null ? (Collection<Object>)kd.bos.login.actions.SerializationUtils.deSerializeFromBase64((String)varKeyStr) : new ArrayList<AnalyseWebOfficeVarEntity>(16);
        }
        return this.varSelInfo;
    }

    @Override
    public void afterUpload(UploadEvent evt) {
        if (this.markSave4RptSection(true)) {
            Object[] urls = evt.getUrls();
            if (null == urls || urls.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u6863\u3002", (String)"AnalyseTmpWebOfficeBase_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map urlData = (Map)urls[0];
            String fileId = urlData.get("url").toString();
            Set bookmarkKeys = (Set)this.getOrCacheObjWithDef(null, null, "newBookmarkKeys", true, HashSet.class, false);
            this.replaceRptVar(fileId, bookmarkKeys, this.getVarSelInfosFromCache());
        } else {
            super.afterUpload(evt);
        }
    }

    public Set<String> getMemberF7KeySet() {
        return AnalyseDimShowForDimBaseCtrl.ALL_DIM_KEYS;
    }

    public void dealSingleMemberF7Back(DimMemberF7SelInfo selMember) {
        if (SysDimensionEnum.dimHasView((String)selMember.getDimNumber())) {
            this.cacheDimViewId(selMember.getDimNumber(), selMember.getViewId());
        }
    }
}

