/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.webOffice;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analysereport.webOffice.AnalyseTmpCopyBase;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class AnalyseTmpCopy
extends AnalyseTmpCopyBase {
    @Override
    protected void getCloneObjOtherFields(DynamicObject cloneobj) {
        cloneobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        cloneobj.set("creater", (Object)UserUtils.getUserId());
        cloneobj.set("modifier", (Object)UserUtils.getUserId());
        cloneobj.set("createdate", (Object)TimeServiceHelper.now());
        cloneobj.set("modifydate", (Object)TimeServiceHelper.now());
        cloneobj.set("shareusers", null);
        cloneobj.set("status", (Object)1);
    }

    @Override
    protected List<Collection<DynamicObject>> getOtherSaveData(Set<DynamicObject> dynamics, Map<String, String> valuesMap) {
        ArrayList<Collection<DynamicObject>> returns = new ArrayList<Collection<DynamicObject>>(16);
        if (dynamics == null || dynamics.size() == 0) {
            return returns;
        }
        Set<Long> sourceIds = this.getSourceID(dynamics);
        if (sourceIds == null || sourceIds.size() == 0) {
            return returns;
        }
        List<Map<String, String>> sourceDatas = this.getSourceDatas(sourceIds);
        Collection<DynamicObject> copyDatas = this.getCopyDatas(sourceDatas, valuesMap);
        if (copyDatas == null) {
            return returns;
        }
        returns.add(copyDatas);
        return returns;
    }

    @Override
    protected boolean beforeSave(DynamicObject sourceObj, DynamicObject cloneobj) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"eb_analysereporttemplate", (Object)sourceObj.getLong("id"), (String)"attachmentpanelap");
        return this.attachmentCopy(Long.valueOf(cloneobj.get("id").toString()), attachments);
    }

    private boolean attachmentCopy(Long fileid, List<Map<String, Object>> attachments) {
        this.saveToTemp(attachments);
        return this.saveToUrl(fileid, attachments);
    }

    private boolean saveToUrl(Long fileid, List<Map<String, Object>> attachments) {
        if (attachments == null || attachments.size() == 0) {
            return true;
        }
        try {
            AttachmentHelper.saveAttachmentData(new ArrayList<Map<String, Object>>(Collections.singletonList(attachments.get(0))), (Long)fileid, (String)"eb_analysereporttemplate");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private String getRealPath(Map<String, Object> attachment) {
        String url = attachment.get("url").toString();
        String[] urlArr = url.split("path=|&");
        if (urlArr.length < 2) {
            return null;
        }
        return urlArr[1];
    }

    private void saveToTemp(List<Map<String, Object>> attachments) {
        if (attachments.size() != 0) {
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (Map<String, Object> attachment : attachments) {
                String realPath = this.getRealPath(attachment);
                if (realPath == null || realPath.contains("tempfile")) continue;
                InputStream fileInputStream = null;
                try {
                    fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(URLDecoder.decode(realPath, "utf-8"));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                String tempUrl = tempFileCache.saveAsUrl(attachment.get("name").toString(), fileInputStream, 7200);
                attachment.put("url", tempUrl);
            }
        }
    }

    private Collection<DynamicObject> getCopyDatas(List<Map<String, String>> sourceDatas, Map<String, String> valuesMap) {
        if (sourceDatas == null || sourceDatas.size() == 0) {
            return null;
        }
        if (valuesMap == null || valuesMap.size() == 0) {
            return null;
        }
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(sourceDatas.size());
        for (Map<String, String> data : sourceDatas) {
            DynamicObject cloneobj = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysevarsel");
            String newid = valuesMap.get(data.get("rpttemp"));
            if (newid == null) continue;
            cloneobj.set("rpttemp", (Object)newid);
            cloneobj.set("vartype", (Object)data.get("type"));
            cloneobj.set("var", (Object)(data.get("id") == null ? 0L : Long.parseLong(data.get("id"))));
            cloneobj.set("varkey", (Object)data.get("varkey"));
            returns.add(cloneobj);
        }
        return returns;
    }

    private List<Map<String, String>> getSourceDatas(Set<Long> sourceIds) {
        if (sourceIds == null || sourceIds.size() == 0) {
            return null;
        }
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
        String selectFields = "var.id,vartype,varkey,rpttemp.id";
        QFilter qf = new QFilter("rpttemp", "in", sourceIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_analysevarsel", (String)selectFields, (QFilter[])qf.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("rpttemp", row.getString("rpttemp.id"));
                map.put("id", row.getString("var.id"));
                map.put("type", row.getString("vartype"));
                map.put("varkey", row.getString("varkey"));
                lists.add(map);
            }
        }
        return lists;
    }

    private Set<Long> getSourceID(Set<DynamicObject> dynamics) {
        if (dynamics == null || dynamics.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(16);
        for (DynamicObject dy : dynamics) {
            returns.add(dy.getLong("id"));
        }
        return returns;
    }

    @Override
    protected void quoteAfterSave(Set<DynamicObject> dynamics, Map<String, String> valuesMap, Map<String, String> paras) {
        Set<Long> sourceIDs = this.getSourceID(dynamics);
        if (sourceIDs == null) {
            return;
        }
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        Long modelId = Long.valueOf(paras.get("model"));
        Map quoteInfos = MemberQuote.get().queryQuoteWithResourceId(sourceIDs);
        for (Long sourceID : sourceIDs) {
            Map quoteInfoMap;
            Map quoteDetails = (Map)quoteInfos.get(sourceID);
            if (quoteDetails == null || (quoteInfoMap = (Map)quoteDetails.get(0L)) == null || quoteInfoMap.size() == 0) continue;
            String targetId = valuesMap.get(sourceID.toString());
            for (Map.Entry entry : quoteInfoMap.entrySet()) {
                String type = (String)entry.getKey();
                Set memberIds = (Set)entry.getValue();
                MemberTypeEnum memberType = MemberTypeEnum.getEnum((int)Integer.parseInt(type));
                if (memberType == null) continue;
                for (Long memberId : memberIds) {
                    quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), memberId, memberType, MemberQuoteResourceEnum.RPTTEMPLATE, Long.valueOf(Long.parseLong(targetId))));
                }
            }
        }
        if (quotes.size() != 0) {
            MemberQuote.get().save(quotes);
        }
    }
}

