/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.webOffice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AnalyseTmpCopyBase {
    private static final int MAX_NUMBER_COUNT = 46;
    private static final String KEY_FORMID = "formId";
    protected static final String KEY_MODEL = "model";

    public void copyData(BillList list, Map<String, String> paras) {
        if (list.getSelectedRows() == null || list.getSelectedRows().size() == 0) {
            return;
        }
        HashSet<String> numberset = new HashSet<String>(16);
        HashSet<String> nameset = new HashSet<String>(16);
        QFilter modelqfilter = new QFilter(KEY_MODEL, "=", (Object)Long.valueOf(paras.get(KEY_MODEL)));
        try (DataSet alldata = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)paras.get(KEY_FORMID), (String)"name, number", (QFilter[])new QFilter[]{modelqfilter}, null);){
            while (alldata.hasNext()) {
                Row row = alldata.next();
                numberset.add(row.getString("number"));
                nameset.add(row.getString("name"));
            }
        }
        Map dynas = list.getModel().loadReferenceDataBatch((DynamicObjectType)list.getEntityType(), list.getSelectedRows().getPrimaryKeyValues());
        HashSet<DynamicObject> dynamicObjects = new HashSet<DynamicObject>(dynas.values());
        if (dynas != null) {
            this.copyData(dynamicObjects, nameset, numberset, paras);
        }
    }

    private void copyData(Set<DynamicObject> dynamics, Set<String> nameset, Set<String> numberset, Map<String, String> paras) {
        if (dynamics == null || dynamics.size() == 0) {
            return;
        }
        ArrayList<String> numberlist = new ArrayList<String>(dynamics.size());
        ArrayList<DynamicObject> tosaveebobjs = new ArrayList<DynamicObject>(dynamics.size());
        HashMap<String, String> valuesMap = new HashMap<String, String>(16);
        for (DynamicObject dynamic : dynamics) {
            DynamicObject cloneobj = (DynamicObject)OrmUtils.clone((IDataEntityBase)dynamic, (boolean)true, (boolean)true);
            String temp_name = cloneobj.getString("name");
            String name = temp_name.length() > 46 ? temp_name.substring(0, 45) + "copy" : temp_name + "copy";
            cloneobj.set("name", (Object)this.getCopyName(name, nameset, 1));
            nameset.add(cloneobj.getString("name"));
            String temp_number = cloneobj.getString("number");
            String number = temp_number.length() > 46 ? temp_number.substring(0, 45) + "copy" : temp_number + "copy";
            cloneobj.set("number", (Object)this.getCopyName(number, numberset, 1));
            numberset.add(cloneobj.getString("number"));
            numberlist.add(cloneobj.getString("number"));
            this.getCloneObjOtherFields(cloneobj);
            if (!this.beforeSave(dynamic, cloneobj)) continue;
            valuesMap.put(dynamic.getString("id"), cloneobj.getString("id"));
            tosaveebobjs.add(cloneobj);
        }
        this.queryNumberRepeat(numberlist.toArray(new String[0]), paras);
        List<Collection<DynamicObject>> saveDys = this.getOtherSaveData(dynamics, valuesMap);
        if (saveDys == null) {
            return;
        }
        paras.put("cloneObjNumbers", tosaveebobjs.stream().map(obj -> obj.getString("number")).collect(Collectors.toList()).toString());
        saveDys.add(tosaveebobjs);
        this.saveData(saveDys, dynamics, valuesMap, paras);
    }

    private void queryNumberRepeat(String[] numbers, Map<String, String> paras) {
        QFilter qmodel = new QFilter(KEY_MODEL, "=", (Object)Long.valueOf(paras.get(KEY_MODEL)));
        QFilter qfnumber = new QFilter("number", "in", (Object)numbers);
        DynamicObjectCollection numberCol = QueryServiceHelper.query((String)paras.get(KEY_FORMID), (String)"number", (QFilter[])new QFilter[]{qmodel, qfnumber});
        if (numberCol != null && numberCol.size() > 0) {
            ArrayList<String> tip = new ArrayList<String>(16);
            for (DynamicObject num : numberCol) {
                tip.add(num.getString("number"));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u4fee\u6539\u7f16\u7801\uff0c\u907f\u514d\u590d\u5236\u65f6\u4ea7\u751f\u91cd\u590d\u7f16\u7801\uff1a%1\u3002", (String)"AnalyseTmpCopyBase_0", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", tip)}));
        }
    }

    private String getCopyName(String name, Set<String> nameset, int i) {
        if (nameset.contains(name)) {
            if (name.length() > 46) {
                name = name.substring(0, 39);
                name = name + "copy" + i;
            } else {
                char ss = name.charAt(name.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    name = name.substring(0, name.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    name = name + i;
                }
            }
            return this.getCopyName(name, nameset, i + 1);
        }
        return name;
    }

    private void saveData(List<Collection<DynamicObject>> saveDys, Set<DynamicObject> dynamics, Map<String, String> valuesMap, Map<String, String> params) {
        try (TXHandle tx = TX.required();){
            try {
                if (saveDys.size() > 0) {
                    for (Collection<DynamicObject> saveDy : saveDys) {
                        SaveServiceHelper.save((DynamicObject[])saveDy.toArray(new DynamicObject[0]));
                    }
                }
                this.quoteAfterSave(dynamics, valuesMap, params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    protected void quoteAfterSave(Set<DynamicObject> dynamics, Map<String, String> map, Map<String, String> valuesMap) {
    }

    protected List<Collection<DynamicObject>> getOtherSaveData(Set<DynamicObject> dynamics, Map<String, String> valuesMap) {
        return new ArrayList<Collection<DynamicObject>>(16);
    }

    protected void getCloneObjOtherFields(DynamicObject cloneobj) {
    }

    protected boolean beforeSave(DynamicObject sourceObj, DynamicObject cloneobj) {
        return true;
    }
}

