/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.webOffice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.analyzeReport.context.FunctionExecContext;
import kd.epm.eb.business.analyzeReport.execute.IFunctionExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptTmpUtil;
import kd.epm.eb.business.analyzeReport.service.AnalyseRptVarExecUtil;
import kd.epm.eb.common.analysereport.constants.AnalyseReportTemplate;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.analysereport.pojo.VarParams;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionResult;
import kd.epm.eb.common.analysereport.pojo.functions.FunctionTableResult;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptTemplateService;
import kd.epm.eb.formplugin.analysereport.webOffice.AnalyseTmpWebOfficeBase;

public class AnalyseTmpSetWebOfficePlugin
extends AnalyseTmpWebOfficeBase {
    private static final Log log = LogFactory.getLog(AnalyseTmpSetWebOfficePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid varSelEntry = (EntryGrid)this.getControl("varselentity");
        varSelEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid varSetEntry = (EntryGrid)this.getControl("varsetentity");
        varSetEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.prepareSave();
                break;
            }
            case "btn_refresh": 
            case "btn_baseinfo": {
                this.refreshVar();
                break;
            }
        }
    }

    @Override
    protected Long getOpenFileId() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (((Boolean)this.getView().getFormShowParameter().getCustomParam("isnew")).booleanValue()) {
            return null;
        }
        return rptTemp.getFileId();
    }

    @Override
    protected String getCaption() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        if (rptTemp == null) {
            return null;
        }
        return rptTemp.getRptTemp().getName();
    }

    private void prepareSave() {
        AnalyseRptEntity rptTemp = this.getTemplateData();
        this.save(rptTemp);
    }

    private void refreshVarSelFromDB(AnalyseRptEntity rptTemp) {
        HashMap varIdKeys = new HashMap(16);
        this.doLog(" refreshVarSelFromDB");
        Map varTypeMap = AnalyseRptTmpUtil.getInstance().queryVarSel(rptTemp.getRptTemp().getModelid(), rptTemp.getRptTemp().getId(), varIdKeys);
        this.setEntryValueSel(AnalyseRptTmpUtil.getInstance().getVarSels(varTypeMap, varIdKeys));
    }

    @Override
    protected String getFileName(AnalyseRptEntity rptTemp) {
        return StringUtils.join((Object[])new String[]{rptTemp.getRptTemp().getNumber(), "(", rptTemp.getRptTemp().getName(), ")", ".docx"});
    }

    @Override
    protected void DeleteData(AnalyseRptEntity rptTemp) {
        QFilter deltmpQfilter = new QFilter("rpttemp.id", "=", (Object)rptTemp.getRptTemp().getId());
        DeleteServiceHelper.delete((String)"eb_analysevarsel", (QFilter[])new QFilter[]{deltmpQfilter});
    }

    @Override
    protected List<Collection<DynamicObject>> getSaveData(WebOfficeBookmarkEvent webOfficeEvent, AnalyseRptEntity rptTemp) {
        ArrayList<Collection<DynamicObject>> needSaveRpts = new ArrayList<Collection<DynamicObject>>(16);
        Collection<DynamicObject> saveDataVarSel = this.getSaveDataVarSel(webOfficeEvent, rptTemp.getRptTemp().getId());
        if (saveDataVarSel != null) {
            needSaveRpts.add(saveDataVarSel);
        }
        needSaveRpts.add(AnalyseRptTmpUtil.getInstance().getSaveDataTmpBase(rptTemp, this.getModel()));
        this.doLog(" getSaveData.needSaveRpts.size:" + needSaveRpts.size());
        return needSaveRpts;
    }

    private Collection<DynamicObject> getVarSelFromWebOffice(WebOfficeBookmarkEvent webOfficeEvent) {
        Set bookMarks = AnalyseRptTmpUtil.getInstance().getBookMarkVar(webOfficeEvent.getBookmarks());
        if (bookMarks == null || bookMarks.size() == 0) {
            this.doLog(" getSaveData.bookMarks.size: null or 0;");
        } else {
            this.doLog(StringUtils.join((Object[])new Serializable[]{" getSaveData.bookMarks.size:", Integer.valueOf(bookMarks.size()), "; ", bookMarks.toString()}));
        }
        DynamicObjectCollection varSelEntity = this.getModel().getEntryEntity("varselentity");
        return AnalyseRptTmpUtil.getInstance().getVarSelFromWebOffice(varSelEntity, bookMarks);
    }

    private Collection<DynamicObject> getSaveDataVarSel(WebOfficeBookmarkEvent webOfficeEvent, Long rtpTempId) {
        Collection<DynamicObject> varSelEntityByWebOffice = this.getVarSelFromWebOffice(webOfficeEvent);
        Collection needSaveRpts = AnalyseRptTmpUtil.getInstance().getSaveDataVarSel(rtpTempId, varSelEntityByWebOffice);
        return needSaveRpts;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.openWebOfficeFile();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        switch (operateKey.toUpperCase(Locale.getDefault())) {
            case "SELFIELD": {
                this.selectField();
                break;
            }
            case "DELFIELD": {
                this.deleteField();
            }
        }
    }

    public void selectField() {
        IFormView formView = this.getView();
        WebOffice webOffice = this.getWebOffice();
        IDataModel model = formView.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("varsetentity");
        Long id = (Long)model.getValue("varid", rowIndex);
        String name = (String)model.getValue("varname", rowIndex);
        String number = (String)model.getValue("varnumber", rowIndex);
        String typenumber = (String)model.getValue("vartypenumber", rowIndex);
        String typeid = (String)model.getValue("vartype", rowIndex);
        String varselkey = "eb_" + System.currentTimeMillis();
        String varnamesel = "@" + name + "@";
        int row = model.insertEntryRow("varselentity", 0);
        model.setValue("varidsel", (Object)id, row);
        model.setValue("varnamesel", (Object)name, row);
        model.setValue("varnumbersel", (Object)number, row);
        model.setValue("vartypenumbersel", (Object)typenumber, row);
        model.setValue("vartypesel", (Object)typeid, row);
        model.setValue("varselkey", (Object)varselkey, row);
        if ("v_function".equals(typeid)) {
            this.addFunction(webOffice, varselkey, varnamesel, id);
        } else {
            webOffice.addMarks(new WebOfficeMark(varselkey, varnamesel));
        }
    }

    public void deleteField() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("varselentity");
        String bookMarkKey = (String)model.getValue("varselkey", rowIndex);
        webOffice.deleteMarks(Collections.singletonList(bookMarkKey));
        model.deleteEntryRow("varselentity", rowIndex);
    }

    private void addFunction(WebOffice webOffice, String varKey, String varName, Long id) {
        VarParams varParams = new VarParams();
        varParams.getFunctionIds().add(id);
        Map functionExecutorMap = AnalyseRptVarExecUtil.parseFunction((VarParams)varParams, (boolean)false);
        IFunctionExecutor executor = (IFunctionExecutor)functionExecutorMap.get(id);
        if (executor != null) {
            FunctionResult functionResult = executor.executeNoData(new FunctionExecContext());
            if (functionResult instanceof FunctionTableResult) {
                String[] tableHead = ((FunctionTableResult)functionResult).getTableHead();
                String[] emptyRow = new String[]{varName};
                webOffice.addTable(varKey, (String[][])new String[][]{tableHead, emptyRow});
            } else {
                webOffice.addMarks(new WebOfficeMark(varKey, varName));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (StringUtils.equals((CharSequence)"varselentity", (CharSequence)entryKey)) {
            this.locationField();
        }
    }

    private AnalyseRptEntity getTemplateData() {
        String cache = this.getPageCache().get("rptWebOfficeCache");
        if (cache == null) {
            AnalyseRptEntity rptTemp = new AnalyseRptEntity();
            rptTemp.setRptTemp(this.getData());
            rptTemp.setFileId(rptTemp.getRptTemp().getId() == null ? Long.valueOf(GlobalIdUtil.genGlobalLongId()) : rptTemp.getRptTemp().getId());
            this.getPageCache().put("rptWebOfficeCache", SerializationUtils.serializeToBase64((Object)rptTemp));
            return rptTemp;
        }
        return (AnalyseRptEntity)SerializationUtils.deSerializeFromBase64((String)cache);
    }

    @Override
    protected void setEntryData() {
        AnalyseRptEntity info = this.getTemplateData();
        if (info == null) {
            return;
        }
        this.refreshVarSelFromDB(info);
        this.setEntryValueSet(info, AnalyseRptTemplateService.queryAllVariables(info.getRptTemp().getModelid(), info.getRptTemp().getBizModelid(), true));
    }

    private void refreshVar() {
        AnalyseRptEntity info = this.getTemplateData();
        if (info == null) {
            return;
        }
        this.setEntryValueSet(info, AnalyseRptTemplateService.queryAllVariables(info.getRptTemp().getModelid(), info.getRptTemp().getBizModelid(), true));
        this.getMarkFromWebOffice();
    }

    private void setEntryValueSet(AnalyseRptEntity info, List<Map<String, String>> varLst) {
        if (varLst == null || varLst.size() == 0) {
            return;
        }
        TableValueSetter tableValueSetter = AnalyseRptTmpUtil.getInstance().setEntryValueSet(info, varLst);
        this.updateEntryView("varsetentity", tableValueSetter);
    }

    private void setEntryValueSel(List<Map<String, String>> varLst) {
        if (varLst == null) {
            varLst = new ArrayList<Map<String, String>>(16);
        }
        TableValueSetter tableValueSetter = AnalyseRptTmpUtil.getInstance().setEntryValueSel(varLst);
        this.updateEntryView("varselentity", tableValueSetter);
    }

    private void updateEntryView(String entityName, TableValueSetter tableValueSetter) {
        if (tableValueSetter == null) {
            return;
        }
        this.getModel().deleteEntryData(entityName);
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(entityName, tableValueSetter);
        this.getModel().endInit();
        this.getView().updateView(entityName);
    }

    protected AnalyseReportTemplate getData() {
        String cache = this.getPageCache().get("templateInfoCache");
        if (cache == null) {
            cache = (String)this.getView().getFormShowParameter().getCustomParam("data");
            this.getPageCache().put("templateInfoCache", cache);
        }
        return (AnalyseReportTemplate)SerializationUtils.fromJsonString((String)cache, AnalyseReportTemplate.class);
    }

    @Override
    public void getBookMark() {
        this.doLog(" begin tempSet getBookMark");
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("saveTmp");
    }

    @Override
    public void doOther(AnalyseRptEntity rptTemp) {
        this.refreshVarSelFromDB(rptTemp);
    }

    @Override
    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
        this.doLog(" begin tempSet onGetAllBookmarks");
        if (Objects.equals("refresh", e.getId())) {
            this.refreshVarSelFromWebOffice(e);
        }
        if (Objects.equals("saveTmp", e.getId())) {
            super.onGetAllBookmarks(e);
        }
    }

    private void getMarkFromWebOffice() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("refresh");
    }

    private void refreshVarSelFromWebOffice(WebOfficeBookmarkEvent e) {
        Collection<DynamicObject> varSelEntityByWebOffice = this.getVarSelFromWebOffice(e);
        HashMap varTypeMap = new HashMap(16);
        HashMap varIdKeys = new HashMap(16);
        if (varSelEntityByWebOffice != null) {
            for (DynamicObject varSelEntity : varSelEntityByWebOffice) {
                AnalyseRptTmpUtil.getInstance().putMap(Long.valueOf(varSelEntity.getLong("varidsel")), varSelEntity.getString("vartypesel"), varSelEntity.getString("varselkey"), varTypeMap, varIdKeys);
            }
        }
        this.setEntryValueSel(AnalyseRptTmpUtil.getInstance().getVarSels(varTypeMap, varIdKeys));
    }

    @Override
    protected void selectQuoteInfo(List<MemberQuoteDao> quoteDaoList, Long modelId, Long sourceId, Collection<DynamicObject> objects, String objType) {
        HashMap<String, Set> refObjIds = new HashMap<String, Set>(16);
        if ("eb_analysevarsel".equals(objType)) {
            for (DynamicObject dynamicObject : objects) {
                String refObjType = dynamicObject.getString("vartype");
                Long refId = dynamicObject.getLong("var");
                refObjIds.computeIfAbsent(refObjType, key -> new HashSet(16)).add(refId);
            }
        }
        for (Map.Entry entry : refObjIds.entrySet()) {
            MemberTypeEnum memberTypeEnum;
            VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)((String)entry.getKey()));
            if (variableTypeEnum == null || (memberTypeEnum = MemberTypeEnum.getEnumByFormKey((String)variableTypeEnum.getMetadata())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u544a\u53d8\u91cf\u7c7b\u578b\u5931\u8d25:%s", (String)"AnalyseTmpSetWebOfficePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{entry.getKey()}));
            }
            quoteDaoList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), (Collection)entry.getValue(), memberTypeEnum, MemberQuoteResourceEnum.RPTTEMPLATE, sourceId));
        }
    }

    @Override
    protected String getBaseDataFormKey() {
        return "eb_analysereporttemplate";
    }
}

