/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysereport.webOffice;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.business.analyzeReport.service.AnalyzeRptWebOfficeCommon;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.common.analysereport.pojo.AnalyseRptEntity;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysereport.service.AnalyseRptCommonService;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class AnalyseTmpWebOfficeBase
extends AbstractFormPlugin
implements WebOfficeDataListener,
UploadListener,
RowClickEventListener {
    protected static final String CACHE_OPRATIONTYPE = "oprationtype";
    private static final Log log = LogFactory.getLog(AnalyseTmpWebOfficeBase.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    protected void save(AnalyseRptEntity rptTemp) {
        this.saveRptFile(rptTemp);
    }

    protected void DeleteData(AnalyseRptEntity rptTemp) {
    }

    protected List<Collection<DynamicObject>> getSaveData(WebOfficeBookmarkEvent webOfficeEvent, AnalyseRptEntity rptTemp) {
        return null;
    }

    protected void setEntryData() {
    }

    protected String getFileName(AnalyseRptEntity rptTemp) {
        return null;
    }

    protected Long getOpenFileId() {
        return null;
    }

    protected String getCaption() {
        return null;
    }

    protected void getBookMark() {
    }

    protected void doOther(AnalyseRptEntity rptTemp) {
    }

    private void saveRptFile(AnalyseRptEntity rptTemp) {
        this.doLog(" begin saveRptFile");
        this.saveWordFile(rptTemp);
        this.doLog(" SaveRptAttachFile");
        this.SaveRptAttachFile(rptTemp.getFileId());
    }

    protected void saveWordFile(AnalyseRptEntity rptTemp) {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String userName = RequestContext.get().getUserName();
        webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        webOffice.save(this.getFileName(rptTemp), rptTemp.getFileId().toString());
    }

    protected void SaveRptAttachFile(Long reportId) {
    }

    private void saveData(WebOfficeBookmarkEvent webOfficeEvent, AnalyseRptEntity rptTemp) {
        this.doLog(" begin getSaveData");
        List<Collection<DynamicObject>> saveDys = this.getSaveData(webOfficeEvent, rptTemp);
        Long sourceId = StringUtils.isNotEmpty((CharSequence)rptTemp.getRptNumber()) ? rptTemp.getFileId() : rptTemp.getRptTemp().getId();
        List<MemberQuoteDao> quoteDaoList = this.selectQuoteInfo(saveDys, sourceId, rptTemp.getRptTemp().getModelid(), rptTemp.getRptTemp().getBizModelid());
        try (TXHandle tx = TX.required();){
            try {
                if (saveDys.size() > 0 && !saveDys.get(0).isEmpty()) {
                    this.doLog(" begin DeleteData");
                    this.DeleteData(rptTemp);
                    this.doLog(" begin SaveServiceHelper.save");
                    for (Collection<DynamicObject> saveDy : saveDys) {
                        SaveServiceHelper.save((DynamicObject[])saveDy.toArray(new DynamicObject[0]));
                    }
                    QuoteSave.get().save(quoteDaoList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private List<MemberQuoteDao> selectQuoteInfo(List<Collection<DynamicObject>> saveDys, Long sourceId, Long modelId, Long bizModelId) {
        ArrayList<MemberQuoteDao> quoteDaoList = new ArrayList<MemberQuoteDao>(16);
        for (Collection<DynamicObject> objects : saveDys) {
            if (objects.isEmpty()) continue;
            DynamicObject firstObj = objects.iterator().next();
            String objType = firstObj.getDataEntityType().getName();
            this.selectQuoteInfo(quoteDaoList, modelId, sourceId, objects, objType);
        }
        if (quoteDaoList.isEmpty()) {
            MemberQuoteResourceEnum quoteResourceEnum = "eb_analysereport".equals(this.getBaseDataFormKey()) ? MemberQuoteResourceEnum.ANALYREPORT : MemberQuoteResourceEnum.RPTTEMPLATE;
            quoteDaoList.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), bizModelId, MemberTypeEnum.BUSINESS_MODEL, quoteResourceEnum, sourceId));
        }
        return quoteDaoList;
    }

    protected String getBaseDataFormKey() {
        return "eb_analysereport";
    }

    protected void selectQuoteInfo(List<MemberQuoteDao> quoteDaoList, Long modelId, Long sourceId, Collection<DynamicObject> objects, String objType) {
    }

    protected void doLog(String info) {
        AnalyzeRptWebOfficeCommon.doLog((String)info, (Log)log);
    }

    protected void openWebOfficeFile() {
        this.doLog(" begin openWebOfficeFile");
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        this.doLog(" setEntryData");
        this.setEntryData();
        this.doLog(" getOpenFileId");
        Long openFileId = this.getOpenFileId();
        if (StringUtils.isBlank((Object)openFileId)) {
            this.doLog(" webOffice.openNew");
            webOffice.openNew(WebOfficeFileType.word);
        } else {
            this.doLog(" webOffice.edit");
            String fielurl = this.getFileUrl(openFileId);
            if (StringUtils.isEmpty((CharSequence)fielurl)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6a21\u677f\u6587\u4ef6\uff0c\u53ef\u80fd\u672a\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalyseTmpWebOfficeBase_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.doLog(" open fielurl" + fielurl);
            try {
                String docUrl = UrlService.getAttachmentFullUrl((String)URLEncoder.encode(fielurl, "utf-8"));
                this.doLog(" open docUrl" + docUrl);
                webOffice.open(docUrl);
            }
            catch (Exception ex) {
                this.doLog(ex.getMessage() + ex.getStackTrace());
                throw new KDBizException(ResManager.loadResFormat((String)"\u6253\u5f00\u6587\u4ef6\u5931\u8d25\uff1a%1\u3002", (String)"AnalyseTmpWebOfficeBase_0", (String)"epm-eb-formplugin", (Object[])new Object[]{ex.getMessage() + Arrays.toString(ex.getStackTrace())}));
            }
        }
        webOffice.setTitlebar(false);
        webOffice.setCaption(this.getCaption());
        webOffice.setMenubar(false);
    }

    private String getFileUrl(Long fileid) {
        DynamicObject[] bd_attachments = AnalyseRptCommonService.getFileObj(Collections.singletonList(fileid.toString()));
        if (bd_attachments != null && bd_attachments.length > 0 && bd_attachments[0] != null) {
            return bd_attachments[0].getString("ffileid");
        }
        return "";
    }

    public void afterUpload(UploadEvent evt) {
        this.doLog(" begin afterUpload");
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u6863\u3002", (String)"AnalyseTmpWebOfficeBase_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map urlData = (Map)urls[0];
        if (Objects.equals("webofficeap", evt.getCallbackKey())) {
            String fileId = urlData.get("id").toString();
            try {
                QFilter fInterID = new QFilter("fInterID", "=", (Object)fileId);
                fInterID.and("fBillType", "=", (Object)"eb_analysereporttemplate");
                this.doLog(" AttachmentHelper.deleteAttachmentData.");
                AttachmentHelper.deleteAttachmentData((QFilter)fInterID);
                this.doLog(" AttachmentHelper.saveAttachmentData.");
                AttachmentHelper.saveAttachmentData(Collections.singletonList(urlData), (Long)Long.valueOf(fileId), (String)"eb_analysereporttemplate");
                this.doLog(" afterUpload_begin getBookMark");
                this.getBookMark();
            }
            catch (Exception ex) {
                this.doLog(ex.getMessage() + ex.getStackTrace());
                throw new KDBizException(ResManager.loadResFormat((String)"\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff0c%1\u3002", (String)"AnalyseTmpWebOfficeBase_3", (String)"epm-eb-formplugin", (Object[])new Object[]{ex.getMessage() + Arrays.toString(ex.getStackTrace())}));
            }
        }
    }

    private boolean isGenRptOpration() {
        String opration = this.getPageCache().get(CACHE_OPRATIONTYPE);
        return !StringUtils.isEmpty((CharSequence)opration);
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent var1) {
        MultiLangEnumBridge opNameBridge;
        String objNumber;
        String baseFormKey;
        String opName;
        this.doLog(" AnalyseTmpWebOfficeBase_onGetAllBookmarks");
        AnalyseRptEntity rptTemp = (AnalyseRptEntity)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("rptWebOfficeCache"));
        this.saveData(var1, rptTemp);
        this.doOther(rptTemp);
        if (this.isGenRptOpration()) {
            opName = ResManager.loadKDString((String)"\u62a5\u544a\u751f\u6210", (String)"AnalyseTmpWebOfficeBase_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            baseFormKey = "eb_analysereport";
            objNumber = rptTemp.getRptNumber();
            opNameBridge = new MultiLangEnumBridge("\u62a5\u544a\u751f\u6210", "AnalyseTmpWebOfficeBase_4", "epm-eb-formplugin");
        } else {
            opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AnalyseTmpWebOfficeBase_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            baseFormKey = "eb_analysereporttemplate";
            objNumber = rptTemp.getRptTemp().getNumber();
            opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "AnalyseTmpWebOfficeBase_6", "epm-eb-formplugin");
        }
        this.addObjOpLog(baseFormKey, opName, opNameBridge, objNumber);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"AnalyseTmpWebOfficeBase_2", (String)"epm-eb-formplugin", (Object[])new Object[]{opName}));
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent var1) {
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent var1) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent var1) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent var1) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent var1) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent var1) {
    }

    protected WebOffice getWebOffice() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        return webOffice;
    }

    public void locationField() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("varselentity");
        if (rowIndex == -1) {
            return;
        }
        String bookMarkKey = (String)model.getValue("varselkey", rowIndex);
        this.getWebOffice().locateMark(bookMarkKey);
    }

    @Override
    public String getBizAppId() {
        String appId = super.getBizAppId();
        if (this.isEmpty(appId)) {
            String formKey = this.getView().getFormShowParameter().getFormId();
            if ("eb_analyserptgen".equals(formKey)) {
                return ApplicationTypeEnum.BGM.getAppnum();
            }
            return ApplicationTypeEnum.BGMD.getAppnum();
        }
        return super.getBizAppId();
    }
}

