/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasBizIndicatorConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String MAIN_DIM = "maindim";
    private static final String MAIN_DIMMEMBER = "maindimmember";
    private static final String SUB_DIM = "subdim";
    private static final String SUB_DIMMEMBER = "subdimmember";
    private static final String CLOSE_CALLBACK_MAIN_DIMMEMBER = "closeCallbackMainDimmember";
    private static final String CLOSE_CALLBACK_SUB_DIMMEMBER = "closeCallbacksubDimmember";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        JSONObject bizModelJson = customItem.getC().getJSONObject("bizModel");
        if (bizModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            BizModel bizModel = (BizModel)bizModelJson.toJavaObject(BizModel.class);
            Long modelId = IDUtils.toLong((Object)bizModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)bizModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            JSONObject dimensionViews = bizModel.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            this.getPageCache().put("dimension_view", dimensionViews.toJSONString());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            this.clearBizDim();
            this.initBizDim();
            this.initMainData(canvasId, bizModel, dataSetId, modelCache);
            if (bizModel.getBizConfig().size() == 2) {
                this.initSubData(canvasId, bizModel, dataSetId, modelCache);
            } else {
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.subBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            }
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                this.initBizDim();
                this.getModel().setValue(MAIN_DIM, (Object)SysDimensionEnum.Account.getNumber());
                this.getModel().setValue(SUB_DIM, (Object)SysDimensionEnum.Account.getNumber());
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.mainBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.subBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.mainBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.subBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            }
        }
    }

    private void initMainData(String canvasId, BizModel bizModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        BizValue mainConfig = (BizValue)bizModel.getBizConfig().get(0);
        JSONObject mainViews = mainConfig.getDimensionViews();
        if (mainViews == null) {
            mainViews = new JSONObject();
        }
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        AnalysisCanvasUserSelHelper.initSingleMembers(this.getView(), modelCache, dimensionList, mainViews, mainConfig.getDim(), mainConfig.getNum(), ignoreDimNumbers, MAIN_DIM, MAIN_DIMMEMBER, AnalysisCanvasEnum.mainBiz);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, mainConfig.getDims(), mainViews, AnalysisCanvasEnum.mainBiz, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.mainBiz, ignoreDimNumbers);
    }

    private void initSubData(String canvasId, BizModel bizModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        BizValue subConfig = (BizValue)bizModel.getBizConfig().get(1);
        JSONObject subViews = subConfig.getDimensionViews();
        if (subViews == null) {
            subViews = new JSONObject();
        }
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        AnalysisCanvasUserSelHelper.initSingleMembers(this.getView(), modelCache, dimensionList, subViews, subConfig.getDim(), subConfig.getNum(), ignoreDimNumbers, SUB_DIM, SUB_DIMMEMBER, AnalysisCanvasEnum.subBiz);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, subConfig.getDims(), subViews, AnalysisCanvasEnum.subBiz, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.subBiz, ignoreDimNumbers);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", MAIN_DIMMEMBER, SUB_DIMMEMBER, "dimmember", "dimselect", "dimmember1", "dimselect1"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view_main", this.getView());
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view_sub", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                this.clearBizDim();
                this.initBizDim();
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.mainBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.subBiz, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                this.getModel().setValue(MAIN_DIM, null);
                this.getModel().setValue(SUB_DIM, null);
                this.getModel().setValue(MAIN_DIM, (Object)SysDimensionEnum.Account.getNumber());
                this.getModel().setValue(SUB_DIM, (Object)SysDimensionEnum.Account.getNumber());
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (SUB_DIMMEMBER.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove(SUB_DIMMEMBER);
            }
        } else if (MAIN_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            this.clearMainDim();
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.mainBiz, Collections.singletonList(newVal));
            String subMember = this.getModel().getValue(SUB_DIMMEMBER).toString();
            if (StringUtils.isBlank((CharSequence)subMember)) {
                this.getModel().setValue(SUB_DIM, (Object)newVal);
            }
        } else if (SUB_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getModel().setValue(SUB_DIMMEMBER, null);
                this.getPageCache().remove(SUB_DIMMEMBER);
            }
            this.clearSubDim();
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.subBiz, Collections.singletonList(newVal));
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        } else if ("dimmember1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = this.getCurrSubEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select_1");
            }
        } else if ("dimselect1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect1" + this.getCurrSubEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember1"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember1"});
            }
        } else if ("dimmemberismulti1".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect1"});
                this.getModel().setValue("dimselect1", null, rowIndex);
                this.getModel().setValue("dimmember1", null, rowIndex);
                String currEntryDim = this.getCurrSubEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select_1");
                this.getPageCache().remove("dimselect1" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect1"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildBizModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (MAIN_DIMMEMBER.equals(ctrlKey)) {
            String dimNumber = (String)this.getModel().getValue(MAIN_DIM);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            this.openDimSelect(dimNumber, CLOSE_CALLBACK_MAIN_DIMMEMBER, true, "dimension_view_main");
        } else if (SUB_DIMMEMBER.equals(ctrlKey)) {
            String dimNumber = (String)this.getModel().getValue(SUB_DIM);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u526f\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasBizIndicatorConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.openDimSelect(dimNumber, CLOSE_CALLBACK_SUB_DIMMEMBER, true, "dimension_view_sub");
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "bizMemberCloseCallback", !isMulti, "dimension_view_main");
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId, "dropdownConfigCloseCallback");
        } else if ("dimmember1".equals(ctrlKey)) {
            String dimNumber = this.getCurrSubEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = this.getCurrSubEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "bizMemberCloseCallback1", !isMulti, "dimension_view_sub");
        } else if ("dimselect1".equals(ctrlKey)) {
            String dimNumber = this.getCurrSubEntryDim(null, this.getView());
            boolean isMulti = this.getCurrSubEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect1" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId, "dropdownConfigCloseCallback1");
        }
    }

    private void openDropdownConfig(String dimNumber, String relateId, String closeBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeBack));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CLOSE_CALLBACK_MAIN_DIMMEMBER.equals(actionId) || CLOSE_CALLBACK_SUB_DIMMEMBER.equals(actionId) || "bizMemberCloseCallback".equals(actionId) || "bizMemberCloseCallback1".equals(actionId)) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.mainBiz);
        }
        if ("dropdownConfigCloseCallback1".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.subBiz);
        }
    }

    private void initBizDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit mainComboEdit = (ComboEdit)this.getControl(MAIN_DIM);
        ComboEdit subComboEdit = (ComboEdit)this.getControl(SUB_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        mainComboEdit.setComboItems(data);
        subComboEdit.setComboItems(data);
    }

    private void clearBizDim() {
        ComboEdit mainComboEdit = (ComboEdit)this.getControl(MAIN_DIM);
        ComboEdit subComboEdit = (ComboEdit)this.getControl(SUB_DIM);
        mainComboEdit.setComboItems(null);
        subComboEdit.setComboItems(null);
        this.clearMainDim();
        this.clearSubDim();
    }

    private void clearMainDim() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue(MAIN_DIMMEMBER, null);
        this.getPageCache().remove("maindimmember_select");
    }

    private void clearSubDim() {
        this.getModel().deleteEntryData("entryentity1");
        this.getModel().setValue(SUB_DIMMEMBER, null);
        this.getPageCache().remove("subdimmember_select_1");
    }

    private BizModel buildBizModel() {
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        BizModel bizModel = new BizModel();
        ArrayList<BizValue> configs = new ArrayList<BizValue>(2);
        JSONObject dimensionViewsMain = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_main", this.getView());
        JSONObject dimensionViewsSub = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_sub", this.getView());
        JSONObject dimensionViewsAll = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        String mainTabName = ResManager.loadKDString((String)"\u4e3b\u6307\u6807\u7ef4\u5ea6\u53d6\u503c", (String)"AnalysisCanvasBizIndicatorConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String subTabName = ResManager.loadKDString((String)"\u526f\u6307\u6807\u7ef4\u5ea6\u53d6\u503c", (String)"AnalysisCanvasBizIndicatorConfigPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ModelHelper.checkViewIdExisted((String)mainTabName, (JSONObject)dimensionViewsMain);
        ModelHelper.checkViewIdExisted((String)subTabName, (JSONObject)dimensionViewsSub);
        BizValue mainConfig = this.buildMainConfig(datasetId, canvasId, dimensionViewsMain);
        BizValue subConfig = this.buildSubConfig(datasetId, canvasId, dimensionViewsSub);
        if (subConfig != null) {
            mainConfig.getDims().stream().filter(p -> p.getS() == false).forEach(leftDim -> subConfig.getDims().stream().filter(p -> p.getS() == false).forEach(rightDim -> {
                if (leftDim.getDim().equals(rightDim.getDim())) {
                    if (StringUtils.isNotBlank((CharSequence)leftDim.getRelSelectId())) {
                        rightDim.setRelSelectId(leftDim.getRelSelectId());
                        dimensionViewsSub.fluentPut(leftDim.getDim(), dimensionViewsMain.get((Object)leftDim.getDim()));
                        dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsMain.get((Object)leftDim.getDim()));
                    } else if (StringUtils.isNotBlank((CharSequence)rightDim.getRelSelectId())) {
                        leftDim.setRelSelectId(rightDim.getRelSelectId());
                        dimensionViewsMain.fluentPut(rightDim.getDim(), dimensionViewsSub.get((Object)rightDim.getDim()));
                        dimensionViewsAll.fluentPut(rightDim.getDim(), dimensionViewsSub.get((Object)rightDim.getDim()));
                    } else {
                        dimensionViewsSub.fluentPut(leftDim.getDim(), dimensionViewsMain.get((Object)leftDim.getDim()));
                        dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsMain.get((Object)leftDim.getDim()));
                    }
                }
            }));
            configs.add(mainConfig);
            configs.add(subConfig);
        } else {
            configs.add(mainConfig);
            mainConfig.getDims().stream().filter(p -> p.getS() == false).forEach(leftDim -> dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsMain.get((Object)leftDim.getDim())));
        }
        bizModel.setDimensionViews(dimensionViewsAll);
        bizModel.setBizConfig(configs);
        bizModel.setModel(String.valueOf(this.getModelId()));
        bizModel.setDataset(datasetId);
        bizModel.setAdd(Boolean.valueOf(false));
        bizModel.setEdit(Boolean.valueOf(false));
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return bizModel;
    }

    private BizValue buildMainConfig(String datasetId, String canvasId, JSONObject dimensionViews) {
        Object mainDim = this.getModel().getValue(MAIN_DIM);
        if (mainDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasBizIndicatorConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object mainMember = this.getModel().getValue(MAIN_DIMMEMBER);
        if (StringUtils.isBlank((CharSequence)String.valueOf(mainMember))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u6307\u6807\u6210\u5458\u3002", (String)"AnalysisCanvasBizIndicatorConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.mainBiz);
        String mainItemStr = this.getPageCache().get("maindimmember_select");
        List mainItemList = JSON.parseArray((String)mainItemStr, TextEditSelectItem.class);
        BizValue mainConfig = new BizValue();
        mainConfig.setDim(mainDim.toString());
        mainConfig.setNum(((TextEditSelectItem)mainItemList.get(0)).getNumber());
        mainConfig.setValue((Object)0.0);
        mainConfig.setDims(dimModels);
        mainConfig.setDimensionViews(dimensionViews);
        AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)datasetId), mainConfig.getDim(), IDUtils.toLong((Object)dimensionViews.getString(mainConfig.getDim())), mainConfig.getNum());
        return mainConfig;
    }

    private BizValue buildSubConfig(String datasetId, String canvasId, JSONObject dimensionViews) {
        String subDim = (String)this.getModel().getValue(SUB_DIM);
        if (StringUtils.isBlank((CharSequence)subDim)) {
            return null;
        }
        Object subMember = this.getModel().getValue(SUB_DIMMEMBER);
        if (StringUtils.isBlank((CharSequence)String.valueOf(subMember))) {
            return null;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.subBiz);
        String subItemStr = this.getPageCache().get("subdimmember_select_1");
        List subItemList = JSON.parseArray((String)subItemStr, TextEditSelectItem.class);
        BizValue subConfig = new BizValue();
        subConfig.setDim(subDim);
        subConfig.setNum(((TextEditSelectItem)subItemList.get(0)).getNumber());
        subConfig.setDims(dimModels);
        subConfig.setDimensionViews(dimensionViews);
        AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)datasetId), subConfig.getDim(), IDUtils.toLong((Object)dimensionViews.getString(subConfig.getDim())), subConfig.getNum());
        return subConfig;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect, String viewKey) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, viewKey, this.getView());
        String selectKey = CLOSE_CALLBACK_MAIN_DIMMEMBER.equals(callback) ? MAIN_DIMMEMBER : (CLOSE_CALLBACK_SUB_DIMMEMBER.equals(callback) ? SUB_DIMMEMBER : dimNumber);
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if ("bizMemberCloseCallback1".equals(callback) || CLOSE_CALLBACK_SUB_DIMMEMBER.equals(callback)) {
            selectItemStr = this.getPageCache().get(selectKey + "_select_1");
        }
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        String dimNumber;
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        String viewKey = CLOSE_CALLBACK_MAIN_DIMMEMBER.equals(actionId) || "bizMemberCloseCallback".equals(actionId) ? "dimension_view_main" : "dimension_view_sub";
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, viewKey, this.getView());
        if (CLOSE_CALLBACK_MAIN_DIMMEMBER.equals(actionId)) {
            this.getPageCache().put("maindimmember_select", JSON.toJSONString(list));
            this.getModel().setValue(MAIN_DIMMEMBER, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
        }
        if (CLOSE_CALLBACK_SUB_DIMMEMBER.equals(actionId) && list.size() > 0) {
            this.getPageCache().put("subdimmember_select_1", JSON.toJSONString(list));
            this.getModel().setValue(SUB_DIMMEMBER, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
        }
        if ("bizMemberCloseCallback".equals(actionId)) {
            dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
        if ("bizMemberCloseCallback1".equals(actionId)) {
            dimNumber = this.getCurrSubEntryDim(null, this.getView());
            this.getModel().setValue("dimmember1", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), this.getCurrSubEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select_1", JSON.toJSONString(list));
        }
    }

    private String getCurrSubEntryDim(Integer rowIndex, IFormView formView) {
        if (rowIndex == null) {
            rowIndex = this.getCurrSubEntryRow(formView);
        }
        DynamicObject row = formView.getModel().getEntryRowEntity("entryentity1", rowIndex.intValue());
        return row.getString("dimnumber1");
    }

    private Boolean getCurrSubEntryIsMulti(IFormView formView) {
        DynamicObject row = formView.getModel().getEntryRowEntity("entryentity1", this.getCurrSubEntryRow(formView));
        return row.getBoolean("dimmemberismulti1");
    }

    private int getCurrSubEntryRow(IFormView formView) {
        return formView.getModel().getEntryCurrentRowIndex("entryentity1");
    }
}

