/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasBoxListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getPageCache().put("canvasId", (String)formShowParameter.getCustomParam("canvasId"));
        this.getPageCache().put("usedBoxId", (String)formShowParameter.getCustomParam("usedBoxId"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection allRow = billList.getCurrentListAllRowCollection();
        for (int i = 0; i < allRow.size(); ++i) {
            ListSelectedRow row = allRow.get(i);
            Long usedBoxId = IDUtils.toLong((Object)this.getPageCache().get("usedBoxId"));
            if (!row.getPrimaryKeyValue().equals(usedBoxId)) continue;
            billList.selectRows(i, true);
            break;
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    private QFilter getListQFilter() {
        long canvasId = IDUtils.toLong((Object)this.getPageCache().get("canvasId"));
        return new QFilter("canvasid", "=", (Object)canvasId);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_new": {
                this.openEditPage(null);
                break;
            }
            case "btn_del": {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"AnalysisCanvasBoxListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long id = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue());
                AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(id);
                if (AnalysisCanvasConstants.BoxType.BASE.getValue().equals(canvasBox.getType())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u51c6\u6c99\u76d8\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AnalysisCanvasBoxListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6570\u636e\uff1f", (String)"AnalysisCanvasBoxListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8981\u4fee\u6539\u7684\u6570\u636e\u3002", (String)"AnalysisCanvasBoxListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long pkId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
                this.openEditPage(pkId.toString());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"AnalysisCanvasBoxListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long pkId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
            this.returnDesignPage(pkId.toString());
        } else if ("btn_cancel".equals(ctrlKey)) {
            this.getView().close();
        }
    }

    private void refreshListData() {
        QFilter qFilter = this.getListQFilter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setFilter(qFilter);
        billList.setOrderBy("bseq asc");
        billList.setClearSelection(true);
        billList.refresh();
        billList.selectRows(0, true);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.delData();
        }
    }

    private void openEditPage(String id) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_box");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sandboxAddCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        String canvasId = this.getPageCache().get("canvasId");
        if (StringUtils.isNotEmpty((String)id)) {
            if (StringUtils.isEmpty((String)canvasId)) {
                AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(IDUtils.toLong((Object)id));
                canvasId = String.valueOf(canvasBox.getCanvasId());
            }
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("canvasId", (Object)canvasId);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u6c99\u76d8\u4fee\u6539", (String)"AnalysisCanvasBoxListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("canvasId", (Object)canvasId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u6c99\u76d8\u65b0\u589e", (String)"AnalysisCanvasBoxListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void returnDesignPage(String id) {
        this.getView().returnDataToParent((Object)id);
        this.getView().close();
    }

    private void delData() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        AnalysisCanvasBoxService.getInstance().delete(ids);
        PredictRecordService.getInstance().deleteCanvasRecord(IDUtils.toLong((Object)this.getPageCache().get("canvasId")).longValue(), ids);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "AnalysisCanvasBoxListPlugin_8", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8ID\uff1a%1$s\u5220\u9664\u6210\u529f\u3002", "AnalysisCanvasBoxListPlugin_6", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "delete", opName, opDesc, new String[]{ids.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisCanvasBoxListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshListData();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("sandboxAddCloseCallback".equals(actionId)) {
            this.refreshListData();
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getListQFilter());
        e.setOrderBy("bseq asc");
    }
}

