/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;

public class AnalysisCanvasBoxPlugin
extends AbstractBasePlugin {
    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("name");
        String langStr = RequestContext.get().getLang().toString();
        if (StringUtils.isEmpty((String)ormLocaleValue.get((Object)langStr)) && ormLocaleValue != null && !ormLocaleValue.isEmpty()) {
            ormLocaleValue.setItem(langStr, ormLocaleValue.toString());
        }
        this.getModel().setValue("name", (Object)ormLocaleValue);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String canvasId = (String)formShowParameter.getCustomParam("canvasId");
        OperationStatus status = formShowParameter.getStatus();
        if ("save".equals(opType)) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name == null || name.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6c99\u76d8\u540d\u79f0\u3002", (String)"AnalysisCanvasBoxPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (status == OperationStatus.ADDNEW) {
                IDataModel dataModel = this.getModel();
                dataModel.setValue("canvasid", (Object)canvasId);
                dataModel.setValue("type", (Object)AnalysisCanvasConstants.BoxType.SANDBOX.getValue());
                dataModel.setValue("status", (Object)AnalysisCanvasConstants.BoxStatus.UNACTIVATED.getValue());
                int seq = AnalysisCanvasBoxService.getInstance().getSeq(IDUtils.toLong((Object)canvasId).longValue());
                dataModel.setValue("bseq", (Object)seq);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        boolean success = args.getOperationResult().isSuccess();
        if (success) {
            MultiLangEnumBridge opDesc;
            MultiLangEnumBridge opName;
            String opKey;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            OperationStatus status = formShowParameter.getStatus();
            String canvasId = (String)formShowParameter.getCustomParam("canvasId");
            Long boxId = (Long)args.getOperationResult().getSuccessPkIds().get(0);
            AnalysisCanvasBox box = AnalysisCanvasBoxService.getInstance().load(boxId);
            if (AnalysisCanvasConstants.BoxType.SANDBOX.getValue().equals(box.getType())) {
                AnalysisCubeService.getInstance().syncForSaveBox(IDUtils.toLong((Object)canvasId).longValue(), boxId.longValue());
            }
            if (status == OperationStatus.ADDNEW) {
                opKey = "addnew";
                opName = new MultiLangEnumBridge("\u65b0\u589e", "AnalysisCanvasBoxPlugin_1", "epm-eb-formplugin");
                opDesc = new MultiLangEnumBridge("\u6c99\u76d8%1$s\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisCanvasBoxPlugin_3", "epm-eb-formplugin");
            } else {
                opKey = "edit";
                opName = new MultiLangEnumBridge("\u4fee\u6539", "AnalysisCanvasBoxPlugin_2", "epm-eb-formplugin");
                opDesc = new MultiLangEnumBridge("\u6c99\u76d8ID\u201c%1$s\u201d\u4fee\u6539\u5df2\u4fdd\u5b58\u3002", "AnalysisCanvasBoxPlugin_4", "epm-eb-formplugin");
            }
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), opKey, opName, opDesc, new String[]{String.valueOf(boxId)});
            this.getView().close();
        }
    }
}

