/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCateService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class AnalysisCanvasCateEditPlugin
extends AbstractBasePlugin {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (null != parent) {
            this.getModel().setValue("parentname", (Object)parent.getString("name"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            String parent = (String)this.getView().getFormShowParameter().getCustomParam("parent");
            DynamicObject dy = AnalysisCanvasCateService.getInstance().load(IDUtils.toLong((Object)parent));
            this.getModel().setValue("parent", (Object)dy.getLong("id"));
            this.getModel().setValue("parentname", (Object)dy.getString("name"));
            int seq = AnalysisCanvasCateService.getInstance().getCurNodeSequence(IDUtils.toLong((Object)parent));
            this.getModel().setValue("sequence", (Object)seq);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            String number = (String)this.getModel().getValue("number");
            if (!CheckStringsUtil.checkNumber4((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AnalysisCanvasCateEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (AnalysisCanvasCateService.getInstance().checkNumberExisted(IDUtils.toLong((Object)this.getModel().getValue("id")), number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AnalysisCanvasCateEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"AnalysisCanvasCateEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (AnalysisCanvasCateService.getInstance().checkNameExisted(IDUtils.toLong((Object)this.getModel().getValue("id")), name.getLocaleValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalysisCanvasCateEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "AnalysisCanvasCateEditPlugin_7", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6211\u7684\u6536\u85cf\u5206\u7c7bID\uff1a%1$s\u5df2\u4fdd\u5b58\u3002", "AnalysisCanvasCateEditPlugin_8", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "save", opName, opDesc, new String[]{ids.toString()});
            this.getView().returnDataToParent((Object)ids);
        }
    }
}

