/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCompareService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasCompareConfigPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final String SANDBOX = "sandbox";
    private static final String BASE_SANDBOX_ID = "baseSandboxId";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        if ("compareAll".equals(this.getView().getFormShowParameter().getCustomParam("compareType"))) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.addSetFilterListener(evt -> evt.getQFilters().add(new QFilter("canvas", "=", (Object)this.getCanvasId())));
            billList.setOrderBy("id");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List canvasBoxList = AnalysisCanvasBoxService.getInstance().loadByCanvas(this.getCanvasId());
        ComboEdit comboEdit = (ComboEdit)this.getControl(SANDBOX);
        ArrayList data = new ArrayList();
        canvasBoxList.forEach(box -> data.add(new ComboItem(new LocaleString(box.getName()), box.getId().toString())));
        comboEdit.setComboItems(data);
        Optional<Long> baseBox = canvasBoxList.stream().filter(box -> "1".equals(box.getType())).map(AnalysisCanvasBox::getId).findFirst();
        if (baseBox.isPresent()) {
            String baseBoxId = String.valueOf(baseBox.get());
            this.getPageCache().put(BASE_SANDBOX_ID, baseBoxId);
            this.getModel().setValue(SANDBOX, (Object)baseBoxId);
        }
        if ("compareAll".equals(this.getView().getFormShowParameter().getCustomParam("compareType"))) {
            this.refreshBillList();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (SANDBOX.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String old = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || !newVal.contains(this.getPageCache().get(BASE_SANDBOX_ID))) {
                this.getModel().setValue(SANDBOX, (Object)old);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u51c6\u6c99\u76d8\u5fc5\u586b\uff0c\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"AnalysisCanvasCompareConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            if (this.checkIsSelectData()) {
                return;
            }
            this.openCompareExport();
        }
    }

    private boolean checkIsSelectData() {
        ListSelectedRowCollection selectedRows;
        if (this.getModel().getValue(SANDBOX) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c99\u76d8\u8303\u56f4\u3002", (String)"AnalysisCanvasCompareConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        List sandboxIds = Stream.of(this.getModel().getValue(SANDBOX).toString().split(",")).filter(StringUtils::isNotEmpty).map(IDUtils::toLong).collect(Collectors.toList());
        if (sandboxIds.size() > 5) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u8d85\u8fc75\u4e2a\u6c99\u76d8\u8303\u56f4\u3002", (String)"AnalysisCanvasCompareConfigPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if ("compareAll".equals(this.getView().getFormShowParameter().getCustomParam("compareType")) && (selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows()).size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AnalysisCanvasCompareConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setClearSelection(true);
        billList.setFilter(new QFilter("canvas", "=", (Object)this.getCanvasId()));
        billList.setOrderBy("id");
        billList.refresh();
    }

    private void openCompareExport() {
        CompareTable compareTable;
        List sandboxIds = Stream.of(this.getModel().getValue(SANDBOX).toString().split(",")).filter(StringUtils::isNotEmpty).map(IDUtils::toLong).collect(Collectors.toList());
        try {
            if ("compareAll".equals(this.getView().getFormShowParameter().getCustomParam("compareType"))) {
                Long compareId = IDUtils.toLong((Object)((BillList)this.getControl("billlistap")).getFocusRowPkId());
                compareTable = AnalysisCanvasCompareService.getInstance().getCompareDataByAll(compareId, this.getCanvasId(), sandboxIds, this.getView());
            } else {
                CustomItem item = (CustomItem)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("customItem")), CustomItem.class);
                List allItem = JSON.parseArray((String)((String)this.getView().getFormShowParameter().getCustomParam("customItems")), CustomItem.class);
                compareTable = AnalysisCanvasCompareService.getInstance().getCompareDataByItem(item, allItem, sandboxIds, this.getView());
                String canvasName = AnalysisCanvasService.getInstance().queryName(this.getCanvasId());
                String itemName = StringUtils.isNotEmpty((CharSequence)item.getTitle()) ? item.getTitle() : item.getName();
                String title = ResManager.loadResFormat((String)"%1-%2\u5bfc\u51fa", (String)"AnalysisCanvasCompareConfigPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{canvasName, itemName});
                compareTable.setTitle(title);
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        FormShowParameter fsp = new FormShowParameter();
        IFormView parentView = this.getView().getParentView();
        fsp.setFormId("eb_analysiscanvas_export");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("compareTable", (Object)JSON.toJSONString((Object)compareTable));
        parentView.showForm(fsp);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private Long getCanvasId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("canvasId");
    }
}

