/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.epm.eb.business.analysiscanvas.model.CompareData;
import kd.epm.eb.business.analysiscanvas.model.CompareHead;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasEntryHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasCompareDataPlugin
extends AbstractBasePlugin
implements SubPage,
ClickListener {
    private static final Log log = LogFactory.getLog(AnalysisCanvasCompareDataPlugin.class);

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"varentity", "reportentity", "dataentity"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getView().addCustomControls(new String[]{"varentity", "reportentity", "dataentity"});
        this.addClickListeners(new String[]{"varvector", "reportvector", "datavector"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CompareTable compareTable = this.getCompareTable();
        this.initEntry(compareTable);
        this.showOrVisible(compareTable);
        this.buildEntry("varentity", compareTable.getValueData(), compareTable.getValueUnit());
        this.buildEntry("reportentity", compareTable.getReportData(), compareTable.getReportUnit());
        this.buildEntry("dataentity", compareTable.getDataData(), compareTable.getDataUnit());
    }

    public void click(EventObject evt) {
        String ctrlKey;
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrlKey = ctrl.getKey()) {
            case "varvector": {
                Boolean varBoolean = Boolean.valueOf(this.getPageCache().get("varvector"));
                Vector varControl = (Vector)this.getControl("varvector");
                varControl.setFontClass(varBoolean != false ? "kdfont kdfont-bottom" : "kdfont kdfont-right");
                this.getView().setVisible(varBoolean, new String[]{"varpanel"});
                this.getPageCache().put("varvector", String.valueOf(varBoolean == false));
                break;
            }
            case "reportvector": {
                Boolean reportBoolean = Boolean.valueOf(this.getPageCache().get("reportvector"));
                Vector reportControl = (Vector)this.getControl("reportvector");
                reportControl.setFontClass(reportBoolean != false ? "kdfont kdfont-bottom" : "kdfont kdfont-right");
                this.getView().setVisible(reportBoolean, new String[]{"reportpanel"});
                this.getPageCache().put("reportvector", String.valueOf(reportBoolean == false));
                break;
            }
            case "datavector": {
                Boolean dataBoolean = Boolean.valueOf(this.getPageCache().get("datavector"));
                Vector dataControl = (Vector)this.getControl("datavector");
                dataControl.setFontClass(dataBoolean != false ? "kdfont kdfont-bottom" : "kdfont kdfont-right");
                this.getView().setVisible(dataBoolean, new String[]{"datapanel"});
                this.getPageCache().put("datavector", String.valueOf(dataBoolean == false));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        CompareTable compareTable = this.getCompareTable();
        if ("valunit".equals(key)) {
            compareTable.setValueUnit(CompareTable.AnalysisCanvasUnit.getEnumByValue((int)Integer.parseInt(newValue)));
            this.buildEntry("varentity", compareTable.getValueData(), compareTable.getValueUnit());
        }
        if ("reportunit".equals(key)) {
            compareTable.setReportUnit(CompareTable.AnalysisCanvasUnit.getEnumByValue((int)Integer.parseInt(newValue)));
            this.buildEntry("reportentity", compareTable.getReportData(), compareTable.getReportUnit());
        }
        if ("dataunit".equals(key)) {
            compareTable.setDataUnit(CompareTable.AnalysisCanvasUnit.getEnumByValue((int)Integer.parseInt(newValue)));
            this.buildEntry("dataentity", compareTable.getDataData(), compareTable.getDataUnit());
        }
        this.getPageCache().put("compareTable", JSON.toJSONString((Object)compareTable));
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        CompareTable compareTable;
        String ctrlKey = e.getKey();
        EntryGrid entryGrid = (EntryGrid)e.getControl();
        if (entryGrid == null) {
            return;
        }
        if ("varentity".equals(ctrlKey)) {
            entryGrid.getItems().clear();
            compareTable = this.getCompareTable();
            compareTable.getValueHead().forEach(p -> {
                TextEdit colEdit = AnalysisCanvasEntryHelper.createEntryTextCtl(p.getFieldKey().toLowerCase(), ctrlKey, entryGrid.getModel(), this.getView());
                entryGrid.getItems().add(colEdit);
            });
        }
        if ("reportentity".equals(ctrlKey)) {
            entryGrid.getItems().clear();
            compareTable = this.getCompareTable();
            compareTable.getReportHead().forEach(p -> {
                TextEdit colEdit = AnalysisCanvasEntryHelper.createEntryTextCtl(p.getFieldKey().toLowerCase(), ctrlKey, entryGrid.getModel(), this.getView());
                entryGrid.getItems().add(colEdit);
            });
        }
        if ("dataentity".equals(ctrlKey)) {
            entryGrid.getItems().clear();
            compareTable = this.getCompareTable();
            compareTable.getDataHead().forEach(p -> {
                if (CollectionUtils.isNotEmpty((Collection)p.getChild())) {
                    p.getChild().forEach(c -> {
                        TextEdit colEdit = AnalysisCanvasEntryHelper.createEntryTextCtl(c.getFieldKey().toLowerCase(), ctrlKey, entryGrid.getModel(), this.getView());
                        entryGrid.getItems().add(colEdit);
                    });
                }
                TextEdit colEdit = AnalysisCanvasEntryHelper.createEntryTextCtl(p.getFieldKey().toLowerCase(), ctrlKey, entryGrid.getModel(), this.getView());
                entryGrid.getItems().add(colEdit);
            });
        }
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        CompareTable compareTable = this.getCompareTable();
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        EntryType varEntryType = (EntryType)mainEntityType.getAllEntities().get("varentity");
        varEntryType.createPropIndexs();
        varEntryType.setDbIgnore(true);
        compareTable.getValueHead().forEach(e -> AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)varEntryType, e.getFieldKey().toLowerCase()));
        EntryType reportEntryType = (EntryType)mainEntityType.getAllEntities().get("reportentity");
        reportEntryType.createPropIndexs();
        reportEntryType.setDbIgnore(true);
        compareTable.getReportHead().forEach(e -> AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)reportEntryType, e.getFieldKey().toLowerCase()));
        EntryType dataEntryType = (EntryType)mainEntityType.getAllEntities().get("dataentity");
        dataEntryType.createPropIndexs();
        dataEntryType.setDbIgnore(true);
        compareTable.getDataHead().forEach(e -> {
            if (CollectionUtils.isNotEmpty((Collection)e.getChild())) {
                e.getChild().forEach(c -> AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)dataEntryType, c.getFieldKey().toLowerCase()));
            }
            AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)dataEntryType, e.getFieldKey().toLowerCase());
        });
    }

    private void initEntry(CompareTable compareTable) {
        CompareHead head;
        int i;
        EntryAp varEntryAp = AnalysisCanvasEntryHelper.createEntry("varentity");
        EntryAp reportEntryAp = AnalysisCanvasEntryHelper.createEntry("reportentity");
        EntryAp dataEntryAp = AnalysisCanvasEntryHelper.createEntry("dataentity");
        for (i = 0; i < compareTable.getValueHead().size(); ++i) {
            head = (CompareHead)compareTable.getValueHead().get(i);
            AnalysisCanvasEntryHelper.createEntryTextFieldAp(varEntryAp, head.getFieldKey().toLowerCase(), head.getName(), i == 0 ? "left" : "right");
        }
        AnalysisCanvasEntryHelper.updateEntry(varEntryAp, this.getView());
        for (i = 0; i < compareTable.getReportHead().size(); ++i) {
            head = (CompareHead)compareTable.getReportHead().get(i);
            AnalysisCanvasEntryHelper.createEntryTextFieldAp(reportEntryAp, head.getFieldKey().toLowerCase(), head.getName(), i == 0 ? "left" : "right");
        }
        AnalysisCanvasEntryHelper.updateEntry(reportEntryAp, this.getView());
        for (i = 0; i < compareTable.getDataHead().size(); ++i) {
            head = (CompareHead)compareTable.getDataHead().get(i);
            if (CollectionUtils.isEmpty((Collection)head.getChild())) {
                AnalysisCanvasEntryHelper.createEntryTextFieldAp(dataEntryAp, head.getFieldKey().toLowerCase(), head.getName(), i == 0 ? "left" : "right");
                continue;
            }
            AnalysisCanvasEntryHelper.createEntryFieldGroupAp(dataEntryAp, head.getFieldKey().toLowerCase(), head.getName(), head.getChild(), i == 0 ? "left" : "right");
        }
        AnalysisCanvasEntryHelper.updateEntry(dataEntryAp, this.getView());
    }

    private void buildEntry(String entryEntity, List<List<CompareData>> data, CompareTable.AnalysisCanvasUnit unit) {
        if (data.size() <= 0) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        IDataModel dataModel = this.getControl(entryEntity).getModel();
        ArrayList styleList = new ArrayList(16);
        dataModel.deleteEntryData(entryEntity);
        dataModel.batchCreateNewEntryRow(entryEntity, data.size());
        AtomicInteger row = new AtomicInteger(0);
        data.forEach(p -> {
            int i = row.getAndIncrement();
            p.forEach(e -> {
                dataModel.setValue(e.getFieldKey().toLowerCase(), AnalysisCanvasPluginHelper.formatData(e.getValue(), unit, true), i);
                CellStyle style = new CellStyle();
                style.setFieldKey(e.getFieldKey().toLowerCase());
                style.setRow(i);
                style.setForeColor(e.getColor());
                styleList.add(style);
            });
        });
        this.getView().updateView(entryEntity);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntity);
        entryGrid.setCellStyle(styleList);
        log.info("refresh complete cost:{}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private CompareTable getCompareTable() {
        String compare = this.getPageCache().get("compareTable");
        if (StringUtils.isEmpty((CharSequence)compare)) {
            compare = (String)this.getView().getFormShowParameter().getCustomParam("compareTable");
            this.getPageCache().put("compareTable", compare);
        }
        return (CompareTable)JSONObject.parseObject((String)compare, CompareTable.class);
    }

    private void showOrVisible(CompareTable compareTable) {
        if (CollectionUtils.isEmpty((Collection)compareTable.getValueData())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexvarpanel", "varpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexvarpanel", "varpanel"});
        }
        if (CollectionUtils.isEmpty((Collection)compareTable.getReportData())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexreportpanel", "reportpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexreportpanel", "reportpanel"});
        }
        if (CollectionUtils.isEmpty((Collection)compareTable.getDataData())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdatapanel", "datapanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdatapanel", "datapanel"});
        }
    }
}

