/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCompareService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.business.analysiscanvas.model.DataModel;
import kd.epm.eb.business.analysiscanvas.model.DimensionDto;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasPluginConstants;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPanelHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AnalysisCanvasCompareEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener,
MainPage {
    public void afterCreateNewData(EventObject e) {
    }

    public void afterLoadData(EventObject e) {
        String data = (String)this.getModel().getValue("data", 0);
        DataModel dataModel = (DataModel)JSONObject.parseObject((String)data, DataModel.class);
        DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
        this.getPageCache().put("data_model", data);
        this.getPageCache().put("dataset", dataset.getString("id"));
        this.getPageCache().put("dimension_view", dataModel.getDimensionViews().toJSONString());
        this.initDimPool();
    }

    public void afterBindData(EventObject e) {
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
        String propName = e.getProperty().getName();
        DimensionItem dimItem = this.findItemByKey(propName);
        if (AnalysisCanvasPluginConstants.isCustomItem(propName) && dimItem != null) {
            Long modelId = this.getModelId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
            Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
            String dimNumber = dimItem.getNumber();
            Long viewId = this.getViewId(modelId, dataSetId, dimNumber);
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(bizModelId);
            f7Param.setDatasetId(dataSetId);
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                f7Param.addCustomFilter(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
            f7Param.setEnableView(true);
            f7Param.setViewId(viewId);
            f7Param.setReturnAllData(true);
            f7Param.setCutTree(false);
            if ("click".equals(e.getSourceMethod())) {
                MemberModel memDto;
                Member member;
                String selectItemStr = this.getPageCache().get(propName);
                if (StringUtils.isNotEmpty((String)selectItemStr) && (member = modelCache.getMember(dimNumber, viewId, (memDto = (MemberModel)JSON.parseObject((String)selectItemStr, MemberModel.class)).getNum())) != null) {
                    f7Param.setSelectId(member.getId());
                }
                f7Param.setModelId(modelId);
                NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
                e.setCancel(true);
            } else {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                e.addCustomQFilter(qFilter);
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
            }
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        DimensionItem dimItem = this.findItemByKey(controlKey);
        return dimItem.getNumber();
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)modelId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("model");
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            this.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove("all_dim");
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newVal;
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null && !newVal.getString("id").equals(this.getPageCache().get("model"))) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                QFilter qFilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
                qFilter.and(new QFilter("number", "=", (Object)"default"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])qFilter.toArray());
                this.getModel().setValue("dataset", dynamicObject == null ? null : Long.valueOf(dynamicObject.getLong("id")));
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        }
        if ("dataset".equals(key)) {
            newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null && !newVal.getString("id").equals(this.getPageCache().get("dataset"))) {
                String datasetId = newVal.getString("id");
                this.getPageCache().put("dataset", datasetId);
                this.clearDimPool();
                this.initDimPool();
            } else {
                this.getModel().setValue("dataset", (Object)String.valueOf(this.getDataSetId()));
            }
        }
        if (AnalysisCanvasPluginConstants.isCustomItem(key)) {
            Object newVal2;
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null) {
                return;
            }
            if (AnalysisCanvasPluginConstants.isCustomItemHideField(dimItem.getPanel())) {
                newVal2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (newVal2 == null) {
                    this.getPageCache().remove(dimItem.getFieldKey());
                } else {
                    MemberModel memDto = new MemberModel();
                    memDto.setNum(newVal2.getString("number"));
                    memDto.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                    this.getPageCache().put(key, JSON.toJSONString((Object)memDto));
                }
            } else if ((AnalysisCanvasPluginConstants.isCustomItemRowField(dimItem.getPanel()) || AnalysisCanvasPluginConstants.isCustomItemColField(dimItem.getPanel())) && StringUtils.isEmpty((String)(newVal2 = (String)e.getChangeSet()[0].getNewValue()))) {
                this.getPageCache().remove(dimItem.getFieldKey() + "_select");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_preview": {
                this.initChildIframe();
                break;
            }
            case "btn_save_as": {
                this.saveAs();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        DimensionItem dimItem = this.findItemByKey(key);
        if (AnalysisCanvasPluginConstants.isCustomItem(key) && dimItem != null) {
            String dimNumber = dimItem.getNumber();
            Long modelId = this.getModelId();
            Long dataSetId = this.getDataSetId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
            }
            Long viewId = this.getViewId(modelId, dataSetId, dimNumber);
            RangeF7Param param = new RangeF7Param();
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            param.setqFilters(qFilters);
            param.setSign(key);
            param.setEnableView(true);
            param.setNeedPermCheck(true);
            param.setBizModelId(modelCache.getBusModelByDataSet(dataSetId));
            param.setDatasetId(dataSetId);
            String selectItemStr = this.getPageCache().get(key + "_select");
            if (StringUtils.isNotEmpty((String)selectItemStr)) {
                List selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
                List conList = selectItemList.stream().map(s -> {
                    MemberCondition memberCondition = new MemberCondition();
                    memberCondition.setNumber(s.getNumber());
                    memberCondition.setRange(s.getScope());
                    return memberCondition;
                }).collect(Collectors.toList());
                param.setCon_list(conList);
            }
            this.getPageCache().remove(key);
            CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"AnalysisCanvasCompareEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            if (IDUtils.isNotEmptyLong((Long)id).booleanValue() && AnalysisCanvasCompareService.getInstance().checkName(id, this.getCanvasId(), name.getLocaleValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalysisCanvasCompareEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (model == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalysisCanvasCompareEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
            if (dataset == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AnalysisCanvasCompareEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<DimensionItem> allDimension = this.getAllDimension();
            List row = allDimension.stream().filter(d -> "rowpool".equals(d.getPanel())).collect(Collectors.toList());
            List col = allDimension.stream().filter(d -> "colpool".equals(d.getPanel())).collect(Collectors.toList());
            if (row.size() != 1 || col.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u548c\u5217\u7ef4\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasCompareEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DataModel dataModel = this.buildDataModelFromPage(allDimension);
            for (DimensionDto hideField : dataModel.getHideFields()) {
                if (!CollectionUtils.isEmpty((Collection)hideField.getMembers())) continue;
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u9690\u85cf\u7ef4\u5ea6\uff1a%1\u7684\u6210\u5458\u3002", (String)"AnalysisCanvasCompareEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{hideField.getDim()}));
                args.setCancel(true);
                return;
            }
            for (DimensionDto rowField : dataModel.getRowFields()) {
                if (!CollectionUtils.isEmpty((Collection)rowField.getMembers())) continue;
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u884c\u7ef4\uff1a%1\u7684\u8303\u56f4\u3002", (String)"AnalysisCanvasCompareEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{rowField.getDim()}));
                args.setCancel(true);
                return;
            }
            for (DimensionDto colField : dataModel.getColFields()) {
                if (!CollectionUtils.isEmpty((Collection)colField.getMembers())) continue;
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u5217\u7ef4\uff1a%1\u7684\u8303\u56f4\u3002", (String)"AnalysisCanvasCompareEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{colField.getDim()}));
                args.setCancel(true);
                return;
            }
            String number = (String)this.getModel().getValue("number");
            if (StringUtils.isEmpty((String)number)) {
                number = "Analysis_" + System.currentTimeMillis();
                this.getModel().setValue("number", (Object)number);
            }
            this.getModel().setValue("canvas", (Object)this.getCanvasId());
            this.getModel().setValue("data", (Object)JSONObject.toJSONString((Object)dataModel), 0);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "AnalysisCanvasCompareEditPlugin_12", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6bd4\u8f83\u65b9\u6848ID\uff1a%1$s\u5df2\u4fdd\u5b58\u3002", "AnalysisCanvasCompareEditPlugin_13", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "save", opName, opDesc, new String[]{ids.toString()});
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (AnalysisCanvasPluginConstants.isCustomItem(actionId)) {
            ListSelectedRowCollection members;
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            if (closedCallBackEvent.getReturnData() instanceof DynamicObjectCollection) {
                DynamicObjectCollection rows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                if (rows != null) {
                    StringBuilder sb = new StringBuilder();
                    ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
                    String dimNumber = "";
                    for (DynamicObject row : rows) {
                        TextEditSelectItem item = new TextEditSelectItem();
                        item.setId(row.getString("memberid"));
                        item.setScope(row.getString("scope"));
                        item.setNumber(row.getString("number"));
                        item.setName(row.getString("name"));
                        item.setPid(row.getString("pid"));
                        this.buildMultiSelectF7ReturnValue(sb, row.getString("name"), row.getInt("scope"));
                        dimNumber = row.getString("dimNum");
                        list.add(item);
                    }
                    Long viewId = IDUtils.toLong((Object)this.getPageCache().get(actionId + "viewId"));
                    this.updateDimensionView(dimNumber, viewId);
                    this.getModel().setValue(actionId, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
                    this.getPageCache().put(actionId + "_select", JSON.toJSONString(list));
                }
            } else if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection && (members = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).size() == 1) {
                for (ListSelectedRow member : members) {
                    String dimNumber = String.valueOf(member.getDataMap().get("dimNumber"));
                    Long viewId = IDUtils.toLong(member.getDataMap().get("viewid"));
                    this.updateDimensionView(dimNumber, viewId);
                    this.getModel().setValue(actionId, member.getPrimaryKeyValue());
                }
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (AnalysisCanvasPluginConstants.isCustomItemConfigField(ctrlKey)) {
            TextEdit edit = AnalysisCanvasPanelHelper.createTextCtl(ctrlKey, this.getModel(), this.getView());
            e.setControl((Control)edit);
        } else if (AnalysisCanvasPluginConstants.isCustomItem(ctrlKey)) {
            DimensionItem dimItem = this.findItemByKey(ctrlKey);
            if (dimItem == null) {
                return;
            }
            if (AnalysisCanvasPluginConstants.isCustomItemHideField(dimItem.getPanel())) {
                BasedataEdit edit = AnalysisCanvasPanelHelper.createBaseDataCtl(ctrlKey, this.getModel(), this.getView());
                edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                e.setControl((Control)edit);
            } else {
                TextEdit edit = AnalysisCanvasPanelHelper.createTextCtl(ctrlKey, this.getModel(), this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        if ("drop".equals(name)) {
            boolean changeFlag;
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (AnalysisCanvasPluginConstants.isCustomItem(source) && (changeFlag = this.interChange(target, source))) {
                this.refreshDimPool();
                this.setDraggable();
                this.getModel().setDataChanged(true);
            }
        }
    }

    public boolean triggerPropChange() {
        return true;
    }

    public String getBizCtrlRangeKey() {
        return "bizmodel";
    }

    public String getBizModelKey() {
        return "dataset";
    }

    private void clearDimPool() {
        FlexPanelAp hidePanel = AnalysisCanvasPanelHelper.createFlexPanel("hidepool");
        hidePanel.getItems().clear();
        AnalysisCanvasPanelHelper.updateControlMetadata(this.getView(), "hidepool", hidePanel.createControl());
        FlexPanelAp textPanel = AnalysisCanvasPanelHelper.createFlexPanel("rowpool");
        textPanel.getItems().clear();
        AnalysisCanvasPanelHelper.updateControlMetadata(this.getView(), "rowpool", textPanel.createControl());
        FlexPanelAp valuePanel = AnalysisCanvasPanelHelper.createFlexPanel("colpool");
        valuePanel.getItems().clear();
        AnalysisCanvasPanelHelper.updateControlMetadata(this.getView(), "colpool", valuePanel.createControl());
        this.getPageCache().remove("data_model");
    }

    private void initDimPool() {
        this.getPageCache().remove("all_dim");
        this.refreshDimPool();
        this.registerDynamicProps(null);
        this.setDraggable();
        this.setDefaultValue();
    }

    private void refreshDimPool() {
        this.initDimPanel("hidepool");
        this.initDimPanel("rowpool");
        this.initDimPanel("colpool");
    }

    private void initDimPanel(String panel) {
        FlexPanelAp flexPanelAp = AnalysisCanvasPanelHelper.createFlexPanel(panel);
        List<DimensionItem> allDims = this.getAllDimension();
        List<DimensionItem> panelDims = allDims.stream().filter(d -> panel.equals(d.getPanel())).collect(Collectors.toList());
        this.addDimItems(flexPanelAp, panelDims);
        AnalysisCanvasPanelHelper.updateControlMetadata(this.getView(), panel, flexPanelAp.createControl());
    }

    private List<DimensionItem> getAllDimension() {
        String allDim = this.getPageCache().get("all_dim");
        if (StringUtils.isEmpty((String)allDim)) {
            return this.loadAllDim();
        }
        return JSON.parseArray((String)this.getPageCache().get("all_dim"), DimensionItem.class);
    }

    private List<DimensionItem> loadAllDim() {
        Long dataSetId = this.getDataSetId();
        if (IDUtils.isEmptyLong((Long)dataSetId).booleanValue()) {
            return Collections.emptyList();
        }
        DataModel dataModel = null;
        String dataModelJson = this.getPageCache().get("data_model");
        if (StringUtils.isNotEmpty((String)dataModelJson)) {
            dataModel = (DataModel)JSON.parseObject((String)dataModelJson, DataModel.class);
        }
        List dimensionList = this.getIModelCacheHelper().getDimensionList(dataSetId);
        ArrayList<DimensionItem> itemList = new ArrayList<DimensionItem>(dimensionList.size());
        for (Dimension d : dimensionList) {
            List colFields;
            Optional<DimensionDto> rowOptional;
            List rowFields;
            Optional<DimensionDto> optional;
            String dimNumber = d.getNumber();
            String panel = dataModel != null ? ((optional = (rowFields = dataModel.getRowFields()).stream().filter(dto -> dto.getDim().equals(dimNumber)).findFirst()).isPresent() ? "rowpool" : ((rowOptional = (colFields = dataModel.getColFields()).stream().filter(dto -> dto.getDim().equals(dimNumber)).findFirst()).isPresent() ? "colpool" : "hidepool")) : (AnalysisCanvasPluginConstants.DEFAULT_ROW_FIELDS.contains(dimNumber) ? "rowpool" : (AnalysisCanvasPluginConstants.DEFAULT_COL_FIELDS.contains(dimNumber) ? "colpool" : "hidepool"));
            DimensionItem dimensionItem = new DimensionItem(d.getId(), d.getName(), d.getNumber(), d.getMemberModel(), d.getSeq(), panel);
            itemList.add(dimensionItem);
        }
        this.getPageCache().put("all_dim", JSON.toJSONString(itemList));
        return itemList;
    }

    private void updateDimensionView(String dimNumber, Long viewId) {
        String dimViewStr = this.getPageCache().get("dimension_view");
        JSONObject dimensionViews = StringUtils.isNotEmpty((String)dimViewStr) ? JSON.parseObject((String)dimViewStr) : new JSONObject();
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            dimensionViews.put(dimNumber, (Object)viewId);
        }
        this.getPageCache().put("dimension_view", JSON.toJSONString((Object)dimensionViews));
    }

    private Long getViewId(Long modelId, Long datasetId, String dimNumber) {
        JSONObject dimView;
        String dimViewStr = this.getPageCache().get("dimension_view");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long viewId = StringUtils.isNotEmpty((String)dimViewStr) ? ((dimView = JSON.parseObject((String)dimViewStr)).getLong(dimNumber) == null ? AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber) : dimView.getLong(dimNumber)) : AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber);
        return viewId;
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        String allDim = this.getPageCache().get("all_dim");
        if (StringUtils.isEmpty((String)allDim)) {
            return;
        }
        List dimItems = JSON.parseArray((String)this.getPageCache().get("all_dim"), DimensionItem.class);
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        for (DimensionItem item : dimItems) {
            String fieldKey = item.getFieldKey();
            if (AnalysisCanvasPluginConstants.isCustomItemHideField(item.getPanel())) {
                String baseDataEntity = item.getMemberModel();
                AnalysisCanvasPanelHelper.registerComplexProp((EntityType)mainEntityType, fieldKey, baseDataEntity);
                continue;
            }
            AnalysisCanvasPanelHelper.registerSimplePropWithId((EntityType)mainEntityType, fieldKey);
        }
    }

    private void setDraggable() {
        this.getControl("hidepool").setDroppable(true);
        this.getControl("rowpool").setDroppable(true);
        this.getControl("colpool").setDroppable(true);
        List<DimensionItem> allDimension = this.getAllDimension();
        allDimension.forEach(d -> {
            this.getControl(d.getFieldKey()).setDraggable(true);
            this.getControl(d.getFieldKey()).setDroppable(true);
        });
    }

    private DimensionItem findItemByKey(String key) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getFieldKey().equals(key)).findFirst();
        return optional.orElse(null);
    }

    private void addDimItems(FlexPanelAp flexPanelAp, List<DimensionItem> list) {
        String panelKey = flexPanelAp.getKey();
        for (DimensionItem item : list) {
            String fieldKey = item.getFieldKey();
            if ("hidepool".equals(panelKey)) {
                AnalysisCanvasPanelHelper.createBaseDataFieldAp(flexPanelAp, fieldKey, item.getName(), item.getMemberModel());
                continue;
            }
            AnalysisCanvasPanelHelper.createTextFieldAp(flexPanelAp, fieldKey, item.getName(), false, true);
        }
    }

    private void setDefaultValue() {
        String fData = this.getPageCache().get("data_model");
        if (StringUtils.isNotEmpty((String)fData)) {
            DataModel dataModel = (DataModel)JSON.parseObject((String)fData, DataModel.class);
            this.initData(dataModel);
        } else {
            this.setDefaultData();
        }
    }

    private void initData(@NotNull DataModel dataModel) {
        Long modelId = this.getModelId();
        Long dataSetId = this.getDataSetId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<DimensionItem> allDimension = this.getAllDimension();
        for (DimensionItem d : allDimension) {
            List textFields;
            Optional<DimensionDto> optional;
            String fieldKey = d.getFieldKey();
            String dimNumber = d.getNumber();
            Long viewId = this.getViewId(modelId, dataSetId, dimNumber);
            if (AnalysisCanvasPluginConstants.isCustomItemHideField(d.getPanel())) {
                List hideFields = dataModel.getHideFields();
                optional = hideFields.stream().filter(dto -> dto.getDim().equals(dimNumber)).findFirst();
                Member member = null;
                if (optional.isPresent()) {
                    DimensionDto dimDto = optional.get();
                    if (CollectionUtils.isNotEmpty((Collection)dimDto.getMembers())) {
                        String memberNumber = ((MemberModel)dimDto.getMembers().get(0)).getNum();
                        member = modelCache.getMember(dimNumber, viewId, memberNumber);
                    }
                } else {
                    member = modelCache.getRootMember(dimNumber, viewId);
                }
                if (member != null) {
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(member.getNumber());
                    memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                    this.getPageCache().put(fieldKey, JSON.toJSONString((Object)memberModel));
                    this.getModel().setValue(fieldKey, (Object)member.getId());
                    this.getView().updateView(fieldKey);
                }
            }
            if (!AnalysisCanvasPluginConstants.isCustomItemRowField(d.getPanel()) && !AnalysisCanvasPluginConstants.isCustomItemColField(d.getPanel()) || !(optional = (textFields = AnalysisCanvasPluginConstants.isCustomItemRowField(d.getPanel()) ? dataModel.getRowFields() : dataModel.getColFields()).stream().filter(dto -> dto.getDim().equals(dimNumber)).findFirst()).isPresent()) continue;
            DimensionDto dimDto = optional.get();
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)dimDto.getMembers())) {
                dimDto.getMembers().forEach(mem -> {
                    Member member = modelCache.getMember(dimNumber, viewId, mem.getNum());
                    if (member == null) {
                        return;
                    }
                    this.buildMultiSelectF7ReturnValue(sb, member.getName(), mem.getScope());
                });
                List selectItemList = dimDto.getMembers().stream().map(mem -> {
                    TextEditSelectItem item = new TextEditSelectItem();
                    item.setNumber(mem.getNum());
                    item.setScope(mem.getScope().toString());
                    return item;
                }).collect(Collectors.toList());
                this.getPageCache().put(fieldKey + "_select", JSON.toJSONString(selectItemList));
            }
            this.getModel().setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getView().updateView(fieldKey);
        }
    }

    private void setDefaultData() {
        List<DimensionItem> allDimension = this.getAllDimension();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long datasetId = this.getDataSetId();
        this.getPageCache().remove("dimension_view");
        for (DimensionItem d : allDimension) {
            String fieldKey = d.getFieldKey();
            String dimNumber = d.getNumber();
            Long viewId = AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber);
            if (AnalysisCanvasPluginConstants.isCustomItemHideField(d.getPanel())) {
                List memberSort;
                HashMap<String, String> defaultMember = new HashMap<String, String>(16);
                defaultMember.put(SysDimensionEnum.Version.getNumber(), "VNone");
                defaultMember.put(SysDimensionEnum.Metric.getNumber(), "Money");
                defaultMember.put(SysDimensionEnum.Currency.getNumber(), "CNY");
                defaultMember.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                defaultMember.put(SysDimensionEnum.ChangeType.getNumber(), "CurrentPeriod");
                defaultMember.put(SysDimensionEnum.DataType.getNumber(), "Budget");
                defaultMember.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                Member member = null;
                if (defaultMember.containsKey(dimNumber)) {
                    String memberNumber = (String)defaultMember.get(dimNumber);
                    member = modelCache.getMember(dimNumber, viewId, memberNumber);
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) && CollectionUtils.isNotEmpty((Collection)(memberSort = modelCache.getMemberSort(SysDimensionEnum.Entity.getNumber(), viewId, "Entity", RangeEnum.DIRECTSUB_EXCLUDE.getIndex())))) {
                    member = memberSort.stream().filter(e -> !e.isLeaf()).findFirst().orElseGet(() -> (Member)memberSort.get(0));
                    this.updateDimensionView(SysDimensionEnum.Entity.getNumber(), viewId);
                }
                if (AnalysisCanvasPluginConstants.isUserDefineDimension(dimNumber)) {
                    member = modelCache.getRootMember(dimNumber, viewId);
                    this.updateDimensionView(dimNumber, viewId);
                }
                if (member != null) {
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(member.getNumber());
                    memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                    this.getPageCache().put(fieldKey, JSON.toJSONString((Object)memberModel));
                    this.getModel().setValue(fieldKey, (Object)member.getId());
                } else {
                    this.getPageCache().remove(fieldKey);
                    this.getModel().setValue(fieldKey, null);
                }
            } else {
                this.getPageCache().remove(fieldKey + "_select");
                this.getModel().setValue(fieldKey, null);
            }
            this.getView().updateView(fieldKey);
        }
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"AnalysisCanvasCompareEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source) {
        List<DimensionItem> dimItems = this.getAllDimension();
        DimensionItem sourceDimItem = dimItems.stream().filter(d -> d.getFieldKey().equals(source)).findFirst().orElse(null);
        if (sourceDimItem == null) {
            return false;
        }
        if (SysDimensionEnum.Metric.getNumber().equals(sourceDimItem.getNumber()) && "hidepool".equals(sourceDimItem.getPanel())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u5141\u8bb8\u79fb\u52a8\u81f3\u884c\u7ef4\u3001\u5217\u7ef4\u3002", (String)"AnalysisCanvasCateEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String sourcePanel = sourceDimItem.getPanel();
        if (StringUtils.isEmpty((String)sourcePanel) || StringUtils.isEmpty((String)target) || sourcePanel.equals(target)) {
            return false;
        }
        if ("rowpool".equals(target) || "colpool".equals(target) || "hidepool".equals(target)) {
            List items = dimItems.stream().filter(e -> target.equals(e.getPanel())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(items) && ("rowpool".equals(target) || "colpool".equals(target))) {
                DimensionItem dimensionItem = (DimensionItem)items.get(0);
                this.getModel().setValue(dimensionItem.getFieldKey(), null);
                this.getView().updateView(dimensionItem.getFieldKey());
                dimensionItem.setPanel(sourcePanel);
            }
            sourceDimItem.setPanel(target);
        } else {
            DimensionItem targetItem = dimItems.stream().filter(d -> d.getFieldKey().equals(target)).findFirst().orElse(null);
            if (targetItem == null || sourcePanel.equals(targetItem.getPanel())) {
                return false;
            }
            String targetPanel = targetItem.getPanel();
            sourceDimItem.setPanel(targetPanel);
            if ("rowpool".equals(targetPanel) || "colpool".equals(targetPanel)) {
                this.getModel().setValue(targetItem.getFieldKey(), null);
                this.getView().updateView(targetItem.getFieldKey());
                targetItem.setPanel(sourcePanel);
            }
        }
        this.getModel().setValue(source, null);
        this.getView().updateView(source);
        this.updateAllDimCache(dimItems);
        return true;
    }

    private DataModel buildDataModelFromPage(List<DimensionItem> allDims) {
        String dimViewStr = this.getPageCache().get("dimension_view");
        JSONObject dimensionViews = StringUtils.isNotEmpty((String)dimViewStr) ? JSON.parseObject((String)dimViewStr) : new JSONObject();
        List hideDims = allDims.stream().filter(d -> "hidepool".equals(d.getPanel())).map(d -> {
            DimensionDto dto = new DimensionDto();
            dto.setDim(d.getNumber());
            String memDtoJson = this.getPageCache().get(d.getFieldKey());
            if (StringUtils.isNotEmpty((String)memDtoJson)) {
                MemberModel memberModel = (MemberModel)JSON.parseObject((String)memDtoJson, MemberModel.class);
                dto.setMembers(Collections.singletonList(memberModel));
            }
            return dto;
        }).collect(Collectors.toList());
        List rowDims = allDims.stream().filter(d -> "rowpool".equals(d.getPanel())).map(d -> {
            DimensionDto dto = new DimensionDto();
            dto.setDim(d.getNumber());
            String fieldKey = d.getFieldKey();
            List memberModels = Collections.emptyList();
            String selectStr = this.getPageCache().get(fieldKey + "_select");
            if (StringUtils.isNotEmpty((String)selectStr)) {
                List selectItems = JSON.parseArray((String)selectStr, TextEditSelectItem.class);
                memberModels = selectItems.stream().map(item -> {
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(item.getNumber());
                    memberModel.setScope(Integer.valueOf(Integer.parseInt(item.getScope())));
                    return memberModel;
                }).collect(Collectors.toList());
            }
            dto.setMembers(memberModels);
            return dto;
        }).collect(Collectors.toList());
        List colDims = allDims.stream().filter(d -> "colpool".equals(d.getPanel())).map(d -> {
            DimensionDto dto = new DimensionDto();
            dto.setDim(d.getNumber());
            String fieldKey = d.getFieldKey();
            List memberModels = Collections.emptyList();
            String selectStr = this.getPageCache().get(fieldKey + "_select");
            if (StringUtils.isNotEmpty((String)selectStr)) {
                List selectItems = JSON.parseArray((String)selectStr, TextEditSelectItem.class);
                memberModels = selectItems.stream().map(item -> {
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(item.getNumber());
                    memberModel.setScope(Integer.valueOf(Integer.parseInt(item.getScope())));
                    return memberModel;
                }).collect(Collectors.toList());
            }
            dto.setMembers(memberModels);
            return dto;
        }).collect(Collectors.toList());
        DataModel dataModel = new DataModel();
        dataModel.setModel(this.getModelId());
        dataModel.setDataset(this.getDataSetId());
        dataModel.setHideFields(hideDims);
        dataModel.setRowFields(rowDims);
        dataModel.setColFields(colDims);
        dataModel.setDimensionViews(dimensionViews);
        return dataModel;
    }

    private void updateAllDimCache(List<DimensionItem> list) {
        this.getPageCache().put("all_dim", JSON.toJSONString(list));
    }

    private void saveAs() {
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6c99\u76d8\u6a21\u62df\u6bd4\u8f83\u65b9\u6848\u3002", (String)"AnalysisCanvasCateEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long copyId = AnalysisCanvasCompareService.getInstance().copy(id);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_cmp");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "compareCloseCallback"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setPkId((Object)copyId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("id", (Object)copyId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a\u6c99\u76d8\u6a21\u62df\u6bd4\u8f83\u65b9\u6848", (String)"AnalysisCanvasCateEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("canvasId", (Object)this.getCanvasId());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53e6\u5b58\u4e3a", "AnalysisCanvasCompareEditPlugin_10", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6bd4\u8f83\u65b9\u6848ID\uff1a%1$s\u5df2\u53e6\u5b58\u3002", "AnalysisCanvasCompareEditPlugin_11", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "save", opName, opDesc, new String[]{String.valueOf(copyId)});
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initChildIframe() {
        CompareTable compareTable;
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6c99\u76d8\u6a21\u62df\u6bd4\u8f83\u65b9\u6848\u3002", (String)"AnalysisCanvasCateEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        try {
            compareTable = AnalysisCanvasCompareService.getInstance().getCompareDataByAll(id, this.getCanvasId(), this.getSandBoxId(), this.getView());
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = this.getView().getPageId() + "eb_analysiscanvas_cmp" + System.currentTimeMillis();
        showParameter.setPageId(pageId);
        showParameter.setFormId("eb_analysiscanvas_data");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("previewpanel");
        showParameter.setCustomParam("compareTable", (Object)JSON.toJSONString((Object)compareTable));
        this.getView().showForm(showParameter);
    }

    private List<Long> getSandBoxId() {
        List ids = AnalysisCanvasBoxService.getInstance().loadCompareCanvas(this.getCanvasId());
        return ids.stream().map(IDUtils::toLong).collect(Collectors.toList());
    }

    private Long getCanvasId() {
        Long canvasId = (Long)this.getView().getFormShowParameter().getCustomParam("canvasId");
        if (IDUtils.isEmptyLong((Long)canvasId).booleanValue()) {
            canvasId = ((DynamicObject)this.getModel().getValue("canvas")).getLong("id");
        }
        return canvasId;
    }

    private Long getDataSetId() {
        return IDUtils.toLong((Object)this.getPageCache().get("dataset"));
    }
}

