/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.epm.eb.business.analysiscanvas.model.CompareData;
import kd.epm.eb.business.analysiscanvas.model.CompareHead;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasExcelHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Row;

public class AnalysisCanvasCompareExportPlugin
extends AbstractListPlugin
implements ClickListener,
MainPage {
    private static final String EXPORT_PAGE_ID = "exportPageId";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_export"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initChildIframe();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_export".equals(ctrlKey)) {
            this.export();
        }
    }

    private void initChildIframe() {
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = this.getView().getPageId() + "eb_analysiscanvas_cmp" + System.currentTimeMillis();
        this.getPageCache().put(EXPORT_PAGE_ID, pageId);
        showParameter.setPageId(pageId);
        showParameter.setFormId("eb_analysiscanvas_data");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("previewpanel");
        showParameter.setCustomParam("compareTable", this.getView().getFormShowParameter().getCustomParam("compareTable"));
        this.getView().showForm(showParameter);
    }

    private CompareTable getCompareTable() {
        String pageId = this.getPageCache().get(EXPORT_PAGE_ID);
        IFormView childView = this.getView().getView(pageId);
        return (CompareTable)JSONObject.parseObject((String)childView.getPageCache().get("compareTable"), CompareTable.class);
    }

    private void export() {
        CompareTable compareTable = this.getCompareTable();
        AnalysisCanvasExcelHelper excel = AnalysisCanvasExcelHelper.getInstance();
        excel.createSheet(ResManager.loadKDString((String)"\u6c99\u76d8\u6bd4\u8f83", (String)"AnalysisCanvasCompareExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        int sandboxSize = this.getSandboxSize(compareTable);
        int colDimSize = this.getColDimSize(compareTable);
        if (CollectionUtils.isNotEmpty((Collection)compareTable.getValueData())) {
            String valueTitle = ResManager.loadKDString((String)"\u6ed1\u8f68\u4ef7\u503c\u6811\u53d8\u91cf", (String)"AnalysisCanvasCompareExportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.dealHead(excel, sandboxSize, colDimSize, compareTable.getValueHead(), compareTable.getValueUnit(), valueTitle);
            this.dealData(excel, colDimSize, compareTable.getValueData(), compareTable.getValueUnit());
        }
        if (CollectionUtils.isNotEmpty((Collection)compareTable.getReportData())) {
            String reportTitle = ResManager.loadKDString((String)"\u62a5\u8868\u8868\u683c\u53d8\u91cf", (String)"AnalysisCanvasCompareExportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.dealHead(excel, sandboxSize, colDimSize, compareTable.getReportHead(), compareTable.getReportUnit(), reportTitle);
            this.dealData(excel, colDimSize, compareTable.getReportData(), compareTable.getReportUnit());
        }
        if (CollectionUtils.isNotEmpty((Collection)compareTable.getDataHead()) && compareTable.getDataHead().size() > 1 && CollectionUtils.isNotEmpty((Collection)((CompareHead)compareTable.getDataHead().get(1)).getChild())) {
            this.dealDataHead(excel, compareTable, sandboxSize, colDimSize);
            this.dealDataData(excel, compareTable);
        } else {
            String dataTitle = ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u8f83", (String)"AnalysisCanvasCompareExportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.dealHead(excel, sandboxSize, colDimSize, compareTable.getDataHead(), compareTable.getDataUnit(), dataTitle);
            this.dealData(excel, colDimSize, compareTable.getDataData(), compareTable.getDataUnit());
        }
        excel.initMergeRegion();
        try {
            excel.downloadExcel(compareTable.getTitle(), this.getView());
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u62a5\u9519\u3002", (String)"AnalysisCanvasCompareExportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void dealHead(AnalysisCanvasExcelHelper excel, int sandboxSize, int colDimSize, List<CompareHead> headList, CompareTable.AnalysisCanvasUnit unit, String title) {
        this.dealTitle(excel, title, unit, sandboxSize, colDimSize);
        Row row = excel.createRow();
        int rowNum = row.getRowNum();
        for (int i = 0; i < headList.size(); ++i) {
            CompareHead head = headList.get(i);
            if (i == 0) {
                excel.setCellValue(row, i, excel.getRowStyle(), head.getName());
                continue;
            }
            excel.setCellValue(row, (i - 1) * colDimSize + 1, excel.getColStyle(), head.getName());
            excel.mergeRegion(rowNum, rowNum, (i - 1) * colDimSize + 1, i * colDimSize);
        }
    }

    private void dealData(AnalysisCanvasExcelHelper excel, int colDimSize, List<List<CompareData>> dataList, CompareTable.AnalysisCanvasUnit unit) {
        for (List<CompareData> data : dataList) {
            Row row = excel.createRow();
            int rowNum = row.getRowNum();
            for (int j = 0; j < data.size(); ++j) {
                CompareData compareData = data.get(j);
                if (j == 0) {
                    excel.setCellValue(row, j, excel.getRowStyle(), compareData.getValue());
                    continue;
                }
                excel.setCellValue(row, (j - 1) * colDimSize + 1, excel.getColorStyle(compareData.getColor()), AnalysisCanvasPluginHelper.formatData(compareData.getValue(), unit));
                excel.mergeRegion(rowNum, rowNum, (j - 1) * colDimSize + 1, j * colDimSize);
            }
        }
    }

    private void dealDataHead(AnalysisCanvasExcelHelper excel, CompareTable compareTable, int sandboxSize, int colDimSize) {
        String title = ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u8f83", (String)"AnalysisCanvasCompareExportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.dealTitle(excel, title, compareTable.getDataUnit(), sandboxSize, colDimSize);
        Row row = excel.createRow();
        int rowNum = row.getRowNum();
        ArrayList dimNames = new ArrayList(16);
        for (int i = 0; i < compareTable.getDataHead().size(); ++i) {
            CompareHead head = (CompareHead)compareTable.getDataHead().get(i);
            if (i == 0) {
                excel.setCellValue(row, i, excel.getRowStyle(), head.getName());
                excel.mergeRegion(rowNum, rowNum + 1, 0, 0);
                continue;
            }
            excel.setCellValue(row, (i - 1) * colDimSize + 1, excel.getColStyle(), head.getName());
            excel.mergeRegion(rowNum, rowNum, (i - 1) * colDimSize + 1, i * colDimSize);
            dimNames.addAll(head.getChild().stream().map(CompareHead::getName).collect(Collectors.toList()));
        }
        Row rowDim = excel.createRow();
        for (int i = 0; i < dimNames.size(); ++i) {
            excel.setCellValue(rowDim, i + 1, excel.getRowStyle(), dimNames.get(i));
        }
    }

    private void dealDataData(AnalysisCanvasExcelHelper excel, CompareTable compareTable) {
        for (int i = 0; i < compareTable.getDataData().size(); ++i) {
            Row row = excel.createRow();
            for (int j = 0; j < ((List)compareTable.getDataData().get(i)).size(); ++j) {
                CompareData compareData = (CompareData)((List)compareTable.getDataData().get(i)).get(j);
                if (j == 0) {
                    excel.setCellValue(row, j, excel.getRowStyle(), compareData.getValue());
                    continue;
                }
                excel.setCellValue(row, j, excel.getColorStyle(compareData.getColor()), AnalysisCanvasPluginHelper.formatData(compareData.getValue(), compareTable.getDataUnit()));
            }
        }
    }

    private void dealTitle(AnalysisCanvasExcelHelper excel, String title, CompareTable.AnalysisCanvasUnit unit, int sandboxSize, int colDimSize) {
        int curCol = 0;
        Row row = excel.createRow();
        excel.setCellValue(row, curCol, excel.getTitleStyle(), title);
        int rowNum = row.getRowNum();
        int lastCol = curCol + Math.max((sandboxSize - 1) * colDimSize, 0);
        excel.mergeRegion(rowNum, rowNum, curCol, lastCol);
        int initUnitCol = lastCol + 1;
        String unitName = ResManager.loadResFormat((String)"\u5355\u4f4d\uff1a%1", (String)"AnalysisCanvasCompareExportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{unit.getName()});
        excel.setCellValue(row, initUnitCol, excel.getUnitStyle(), unitName);
        excel.mergeRegion(rowNum, rowNum, initUnitCol, initUnitCol + colDimSize - 1);
    }

    private int getColDimSize(CompareTable compareTable) {
        List dataHead = compareTable.getDataHead();
        if (CollectionUtils.isNotEmpty((Collection)dataHead) && dataHead.size() > 1 && CollectionUtils.isNotEmpty((Collection)((CompareHead)dataHead.get(1)).getChild())) {
            return ((CompareHead)dataHead.get(1)).getChild().size();
        }
        return 1;
    }

    private int getSandboxSize(CompareTable compareTable) {
        List dataHead = compareTable.getDataHead();
        if (CollectionUtils.isNotEmpty((Collection)dataHead) && dataHead.size() > 1) {
            return dataHead.size() - 1;
        }
        return 0;
    }
}

