/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCompareService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class AnalysisCanvasCompareListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_CLOSE_CALLBACK = "entityCloseCallback";
    private static final String DELETE_COMPARE_CONFIRM = "deleteCompareConfirm";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(this.getQFilter()));
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        Object pkId = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        this.openComparePage(IDUtils.toLong((Object)pkId));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long canvasId = (Long)this.getView().getFormShowParameter().getCustomParam("canvasId");
        this.getPageCache().put("canvasId", canvasId.toString());
        this.refreshBillList();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        switch (key) {
            case "btn_new": {
                this.openComparePage(null);
                break;
            }
            case "btn_modify": {
                this.checkIsSelectOneDataModify(selectedRows);
                this.openComparePage(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
            case "btn_copy": {
                this.checkIsSelectOneData(selectedRows);
                this.copyData(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
            case "btn_del": {
                this.checkIsSelectData(selectedRows);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6570\u636e\uff1f", (String)"AnalysisCanvasCompareListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_COMPARE_CONFIRM, (IFormPlugin)this));
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ENTITY_CLOSE_CALLBACK.equals(key)) {
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals(DELETE_COMPARE_CONFIRM) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            AnalysisCanvasCompareService.getInstance().delete(ids);
            this.refreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "OperationLogUtil_1201", "epm-eb-common");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6c99\u76d8\u6bd4\u8f83\u65b9\u6848ID\uff1a%1$s\u5df2\u5220\u9664\u3002", "AnalysisCanvasCompareListPlugin_3", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)"eb_analysiscanvas_cmp", null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{ids.toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisCanvasCompareListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setClearSelection(true);
        billList.setFilter(this.getQFilter());
        billList.setOrderBy("id");
        billList.refresh();
    }

    private QFilter getQFilter() {
        return new QFilter("canvas", "=", (Object)this.getCanvasId());
    }

    private void openComparePage(Long pkId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_cmp");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "compareCloseCallback"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        if (IDUtils.isNotEmptyLong((Long)pkId).booleanValue()) {
            showParameter.setPkId((Object)pkId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)pkId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u6c99\u76d8\u6a21\u62df\u6bd4\u8f83\u65b9\u6848", (String)"AnalysisCanvasCompareListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6c99\u76d8\u6a21\u62df\u6bd4\u8f83\u65b9\u6848", (String)"AnalysisCanvasCompareListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("canvasId", (Object)this.getCanvasId());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void copyData(Long id) {
        AnalysisCanvasCompareService.getInstance().copy(id);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u5236", "AnalysisCanvasCompareListPlugin_9", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6bd4\u8f83\u65b9\u6848ID\uff1a%1$s\u5df2\u590d\u5236\u3002", "AnalysisCanvasCompareListPlugin_10", "epm-eb-formplugin");
        this.writeLogWithEntityNumber("eb_analysiscanvas_cmp", null, "copy", opName, opDesc, new String[]{Convert.toStr((Object)id)});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalysisCanvasCompareListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
    }

    private void checkIsSelectOneDataModify(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u4fee\u6539\u7684\u65b9\u6848\u3002", (String)"AnalysisCanvasCompareListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectOneData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u590d\u5236\u7684\u65b9\u6848\u3002", (String)"AnalysisCanvasCompareListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectData(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (ids.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"AnalysisCanvasCompareListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getCanvasId() {
        Long canvasId = IDUtils.toLong((Object)this.getPageCache().get("canvasId"));
        if (IDUtils.isEmptyLong((Long)canvasId).booleanValue()) {
            canvasId = (Long)this.getView().getFormShowParameter().getCustomParam("canvasId");
        }
        return canvasId;
    }
}

