/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCommentService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.AnalysisService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasComment;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.item.ItemService;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PageConfig;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.SplitConfig;
import kd.epm.eb.business.analysiscanvas.model.SplitModel;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysiscanvas.CustomItemEvent;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasPluginConstants;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasRememberHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.analysiscanvas.report.IReportHelper;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasDesignPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener,
MainPage {
    private static final Log log = LogFactory.getLog(AnalysisCanvasDesignPlugin.class);

    public void afterCreateNewData(EventObject e) {
        AnalysisCanvas canvas;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long canvasId = (Long)formShowParameter.getCustomParam("id");
        String canvasNum = (String)formShowParameter.getCustomParam("number");
        if (StringUtils.isNotEmpty((String)canvasNum) && (canvas = AnalysisCanvasService.getInstance().loadByNum(canvasNum)) != null) {
            canvasId = canvas.getId();
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        this.getPageCache().put("canvasId", canvasId.toString());
        Long id = IDUtils.toLong((Object)canvasId);
        EpmThreadPools.CommPools.execute(() -> {
            AnalysisCanvasUserSelHelper.cacheUserSel(this.getView(), id);
            AnalysisCanvasShareService.getInstance().updateLookStatus(id);
        });
        try {
            this.loadData();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Object)e);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    private void loadData() {
        boolean designMode;
        long canvasId = this.getCanvasId();
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(Long.valueOf(canvasId));
        String canvasStatus = canvas.getStatus();
        this.getPageCache().put("canvasStatus", canvasStatus);
        List itemList = JSON.parseArray((String)canvas.getItem(), CustomItem.class);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            ModelHelper.resetItems((List)itemList);
            Map<String, String> nameMaps = itemList.stream().filter(e -> StringUtils.isNotEmpty((String)e.getTitle()) || StringUtils.isNotEmpty((String)e.getName())).collect(Collectors.toMap(CustomItem::getId, e -> StringUtils.isNotEmpty((String)e.getTitle()) ? e.getTitle() : e.getName()));
            this.getPageCache().put("itemNameMapping", JSON.toJSONString(nameMaps));
        }
        PageConfig pageConfig = (PageConfig)JSON.parseObject((String)canvas.getPage(), PageConfig.class);
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().loadActivated(Long.valueOf(canvasId));
        this.getPageCache().put("usedBoxId", String.valueOf(canvasBox.getId()));
        if (ModelHelper.isBaseBox((AnalysisCanvasBox)canvasBox)) {
            this.getPageCache().put("calcType", AnalysisCanvasConstants.CalcType.BASE.name());
        } else {
            this.getPageCache().put("calcType", AnalysisCanvasConstants.CalcType.SAND.name());
        }
        this.getModel().setValue("btn_sandbox", (Object)canvasBox.getId());
        if (AnalysisCanvasConstants.Status.RELEASE.getValue().equals(canvasStatus)) {
            designMode = false;
            this.getPageCache().put("designMode", Boolean.FALSE.toString());
        } else if (StringUtils.isEmpty((String)this.getPageCache().get("designMode"))) {
            designMode = true;
            this.getPageCache().put("designMode", Boolean.TRUE.toString());
        } else {
            designMode = Boolean.parseBoolean(this.getPageCache().get("designMode"));
        }
        AnalysisService.getInstance().getItemDataFromBox(itemList, canvasBox, this.getView());
        IReportHelper.build(itemList, this.getView());
        AnalysisService.getInstance().calc(canvasBox.getId().longValue(), itemList, null, AnalysisCanvasConstants.OptType.INIT, this.getView());
        CustomItemEvent.getInstance().sendDataInitEvent(this.getView(), itemList, pageConfig, designMode, canvasStatus, canvasBox.getType());
        this.setShowBtn(canvasBox);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl("btn_sandbox");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        this.addClickListeners(new String[]{"btn_add_comment", "btn_del_comment", "btn_refresh_comment"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addAfterBindDataListener(e1 -> {
            BillList billList1 = (BillList)e1.getSource();
            Map nameMaps = (Map)JSON.parseObject((String)this.getPageCache().get("itemNameMapping"), Map.class);
            int dataCount = billList1.getListModel().getDataCount();
            Map modelMap = billList1.getListModel().getData(0, dataCount);
            int dataIndex = (Integer)((Map)modelMap.get("dataindex")).get("itemid");
            List rows = (List)modelMap.get("rows");
            for (int i = 0; i < rows.size() && nameMaps != null; ++i) {
                String itemId = String.valueOf(((Object[])((List)rows.get(i)).get(dataIndex))[1]);
                billList1.setCellFieldValue("itemname", i, nameMaps.get(itemId));
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("click".equals(evt.getSourceMethod())) {
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.setFormId("eb_analysiscanvas_boxlist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectBoxCloseCallback"));
            fsp.setCustomParam("usedBoxId", (Object)this.getPageCache().get("usedBoxId"));
            fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
            fsp.setShowTitle(true);
            this.getView().showForm((FormShowParameter)fsp);
        }
        if ("getLookUpList".equals(evt.getSourceMethod())) {
            evt.addCustomQFilter(new QFilter("canvasid", "=", (Object)this.getCanvasId()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newVal;
        String key = e.getProperty().getName();
        if ("btn_sandbox".equals(key) && (newVal = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String sandboxId = newVal.getString("id");
            AnalysisCanvasBoxService.getInstance().updateActivatedBox(IDUtils.toLong((Object)sandboxId), Long.valueOf(this.getCanvasId()));
            this.loadData();
            this.closePredictView();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (!"btn_close".equals(key) && AnalysisCanvasConstants.Status.SAVE.getValue().equals(this.getPageCache().get("canvasStatus")) && this.refreshLockInfo()) {
            return;
        }
        switch (key) {
            case "btn_save": {
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_SAVE);
                break;
            }
            case "btn_preview": {
                this.getView().showLoading(new LocaleString(""));
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_PREVIEW);
                break;
            }
            case "btn_close_preview": {
                this.doClosePreviewEvent();
                break;
            }
            case "btn_publish": {
                this.getView().showLoading(new LocaleString(""));
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_PUBLISH);
                break;
            }
            case "btn_calc": {
                this.getPageCache().put("calcType", AnalysisCanvasConstants.CalcType.SAND.name());
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AnalysisCanvasDesignPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CALC);
                break;
            }
            case "btn_calc_base": {
                this.getPageCache().put("calcType", AnalysisCanvasConstants.CalcType.BASE.name());
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AnalysisCanvasDesignPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CALC);
                break;
            }
            case "btn_cover": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8986\u76d6\u8fc7\u7a0b\u9700\u8981\u6267\u884c\u89c4\u5219\u8ba1\u7b97\uff0c\u53ef\u80fd\u8017\u65f6\u8f83\u957f\uff0c\u786e\u5b9a\u7528\u6a21\u62df\u6570\u636e\u8986\u76d6\u57fa\u51c6\u6570\u636e\uff1f", (String)"AnalysisCanvasDesignPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmCover", (IFormPlugin)this));
                break;
            }
            case "btn_comment": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                String commentShow = this.getPageCache().get("commentShow");
                boolean showFlag = Boolean.parseBoolean(commentShow);
                if (!showFlag) {
                    this.refreshCommentList();
                }
                SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
                splitContainer.hidePanel(SplitDirection.right, showFlag);
                splitContainer.setCollapse("splitpanelap1", showFlag);
                this.getPageCache().put("commentShow", String.valueOf(!showFlag));
                break;
            }
            case "btn_compare": {
                this.openCompareConfig("compareAll", null, null);
                break;
            }
            case "btn_config": 
            case "btn_config1": {
                this.openCanvasComparePage();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        switch (key) {
            case "btn_add_comment": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                Object comment = this.getModel().getValue("field_comment");
                if (comment == null || StringUtils.isEmpty((String)comment.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6279\u6ce8\uff01", (String)"AnalysisCanvasDesignPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                AnalysisCanvasCommentService.getInstance().save(Long.valueOf(this.getCanvasId()), Long.valueOf(this.getUsedBoxId()), comment.toString(), Long.valueOf(0L));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6dfb\u52a0\u6279\u6ce8", "AnalysisCanvasDesignPlugin_27", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_10", "epm-eb-formplugin");
                AnalysisLogService.getInstance().writeOperateLog(this.getView(), "add", opName, opDesc, null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("field_comment", (Object)"");
                this.refreshCommentList();
                break;
            }
            case "btn_del_comment": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(ids)) {
                    return;
                }
                AnalysisCanvasComment comment = AnalysisCanvasCommentService.getInstance().load((Long)ids.get(0));
                if (RequestContext.get().getCurrUserId() != IDUtils.toLong((Object)comment.getCreatorId()).longValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u81ea\u5df1\u7684\u6279\u6ce8\u3002", (String)"AnalysisCanvasDesignPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkIfRevoke(comment.getCreateDate())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc75\u5206\u949f\uff0c\u4e0d\u80fd\u518d\u64a4\u9500\u8be5\u6279\u6ce8\u3002", (String)"AnalysisCanvasDesignPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u64a4\u9500\u8be5\u6761\u6279\u6ce8\uff1f", (String)"AnalysisCanvasDesignPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDelComment", (IFormPlugin)this));
                break;
            }
            case "btn_refresh_comment": {
                this.refreshCommentList();
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put("tabap", tabKey);
        this.getView().setVisible(Boolean.valueOf("tab_sandbox".equals(tabKey)), new String[]{"commpanel", "flexpanelap6"});
        this.refreshCommentList();
    }

    private boolean checkIfRevoke(String createDate) {
        Date dateStart;
        try {
            dateStart = DateTimeUtils.parseDate((String)createDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Date dateEnd = DateTimeUtils.addMinute((Date)dateStart, (long)5L);
        return dateEnd.getTime() < new Date().getTime();
    }

    private boolean checkAnalysisCanvasStatus() {
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(Long.valueOf(this.getCanvasId()));
        return AnalysisCanvasConstants.Status.SAVE.getValue().equals(canvas.getStatus());
    }

    private void refreshCommentList() {
        QFilter filter = new QFilter("canvasid", "=", (Object)this.getCanvasId());
        filter.and("sandboxid", "=", (Object)this.getUsedBoxId());
        if ("tab_item".equals(this.getPageCache().get("tabap"))) {
            filter.and("itemid", "!=", (Object)0L);
        } else {
            filter.and("itemid", "=", (Object)0L);
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(filter, "id desc"));
        billList.refresh();
    }

    private void setShowBtn(AnalysisCanvasBox canvasBox) {
        if (AnalysisCanvasConstants.Status.SAVE.getValue().equals(this.getPageCache().get("canvasStatus"))) {
            this.setSaveShowBtn();
        } else {
            this.setReleaseShowBtn();
        }
        this.setCalcShowBtn(canvasBox);
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        splitContainer.hidePanel(SplitDirection.right, true);
        this.getPageCache().remove("commentShow");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"showbizrulepanel"});
    }

    private void closePredictView() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"predictpanel"});
        this.getPageCache().put("predictShow", String.valueOf(false));
        IFormView predictView = this.getView().getView(this.getPredictPageId());
        if (predictView != null) {
            predictView.close();
            this.getView().sendFormAction(predictView);
        }
    }

    private void setSaveShowBtn() {
        boolean designMode = Boolean.parseBoolean(this.getPageCache().get("designMode"));
        if (designMode) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_save", "btn_preview", "btn_publish", "btn_close", "btn_config1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_close_preview", "btn_sandbox", "btn_compare"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_preview", "btn_publish", "btn_close", "btn_config1"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_close_preview", "btn_sandbox", "btn_compare"});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_comment", "btn_cover"});
    }

    private void setReleaseShowBtn() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_preview", "btn_close_preview", "btn_publish", "btn_config1"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_sandbox", "btn_close", "btn_comment", "btn_cover", "btn_compare"});
    }

    private void setCalcShowBtn(AnalysisCanvasBox canvasBox) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_calc", "btn_calc_base"});
        boolean designMode = Boolean.parseBoolean(this.getPageCache().get("designMode"));
        if (designMode) {
            return;
        }
        if (canvasBox != null) {
            if (ModelHelper.isBaseBox((AnalysisCanvasBox)canvasBox)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_calc_base"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_calc", "btn_cover"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_calc_base"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_calc"});
            }
        }
    }

    private long getCanvasId() {
        return IDUtils.toLong((Object)this.getPageCache().get("canvasId"));
    }

    private long getUsedBoxId() {
        return IDUtils.toLong((Object)this.getPageCache().get("usedBoxId"));
    }

    private void publish() {
        Long id = this.getCanvasId();
        AnalysisCanvasService.getInstance().updateStatus(AnalysisCanvasConstants.Status.RELEASE, Collections.singletonList(id));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d1\u5e03", "AnalysisCanvasDesignPlugin_2", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53d1\u5e03\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_1", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "publish", opName, opDesc, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmCover".equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                this.doCoverData();
            }
        } else if ("confirmDelComment".equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                this.doDelComment();
            }
        } else if ("confirmQuit".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().close();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "sliderConfigCloseCallback": {
                this.closeCompConfig(e, "slider");
                break;
            }
            case "chartConfigCloseCallback": {
                this.closeCompConfig(e, "chart");
                break;
            }
            case "bizConfigCloseCallback": {
                this.closeCompConfig(e, "bizindicator");
                break;
            }
            case "tabConfigCloseCallback": {
                this.closeCompConfig(e, "table");
                break;
            }
            case "tableConfigCloseCallback": {
                this.closeCompConfig(e, "table2");
                break;
            }
            case "reportConfigCloseCallback": {
                this.closeCompConfig(e, "report");
                break;
            }
            case "dupontConfigCloseCallback": {
                this.closeCompConfig(e, "dupontnode");
                break;
            }
            case "selectimgCloseCallback": {
                this.closeCallbackSelectImg(e);
                break;
            }
            case "selectBackgroundImgCloseCallback": {
                this.closeCallbackSetBackgroundImg(e);
                break;
            }
            case "dropdownConfigCloseCallback": {
                this.closeCallbackDropdownConfig(e);
                break;
            }
            case "relateConfigCloseCallback": {
                this.closeCallbackRelateConfig(e);
                break;
            }
            case "selectBoxCloseCallback": {
                this.closeCallbackSelectSandbox(e);
                break;
            }
            case "gaugeSplitCloseCallback": {
                this.closeCallbackSplitConfig(e);
                break;
            }
            case "configCompareCloseCallback": {
                this.openCompareExport(e);
                break;
            }
            case "predictDataCloseCallback": {
                this.closePredictData(e);
            }
        }
    }

    private void closeCallbackSelectImg(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData == null) {
            CustomItem item = (CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class);
            if (((Boolean)item.getC().get((Object)"add")).booleanValue()) {
                CustomItemEvent.getInstance().sendDataRemoveEvent(this.getView(), Collections.singletonList(item));
            }
            return;
        }
        String event = returnData.get("event").toString();
        if ("ok".equals(event)) {
            CustomItem customItem = (CustomItem)returnData.get("data");
            CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), Collections.singletonList(customItem));
        }
    }

    private void closeCallbackSetBackgroundImg(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData == null) {
            return;
        }
        String event = returnData.get("event").toString();
        if ("ok".equals(event)) {
            PageConfig pageConfig = (PageConfig)returnData.get("data");
            CustomItemEvent.getInstance().sendPageConfigEvent(this.getView(), pageConfig);
        }
    }

    private void closeCallbackDropdownConfig(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        CustomItem item = (CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class);
        Boolean isAdd = AnalysisCanvasControlHelper.isAdd(item);
        if (returnData == null) {
            if (isAdd.booleanValue()) {
                CustomItemEvent.getInstance().sendDataRemoveEvent(this.getView(), Collections.singletonList(item));
            }
        } else {
            String event = returnData.get("event").toString();
            if ("ok".equals(event)) {
                List CustomItems = (List)returnData.get("data");
                CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), CustomItems);
            } else if (isAdd.booleanValue()) {
                CustomItemEvent.getInstance().sendDataRemoveEvent(this.getView(), Collections.singletonList(item));
            }
        }
    }

    private void closeCallbackRelateConfig(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        CustomItem item = (CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class);
        if (returnData != null) {
            String relateIds = returnData.get("ids") == null ? "" : returnData.get("ids").toString();
            BaseModel model = ModelHelper.getModel((CustomItem)item);
            if (model != null) {
                List relateIdList = Arrays.stream(relateIds.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                model.setRelationId(relateIdList);
                ModelHelper.updateModel((CustomItem)item, (BaseModel)model);
            }
            CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), Collections.singletonList(item));
        }
    }

    private void closeCompConfig(ClosedCallBackEvent e, String type) {
        Map returnData = (Map)e.getReturnData();
        CustomItem item = (CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class);
        Boolean isAdd = AnalysisCanvasControlHelper.isAdd(item);
        if (returnData == null) {
            if (isAdd.booleanValue()) {
                CustomItemEvent.getInstance().sendDataRemoveEvent(this.getView(), Collections.singletonList(item));
            }
        } else {
            try {
                String event = returnData.get("event").toString();
                if ("ok".equals(event)) {
                    AnalysisCanvasBoxDataService.getInstance().deleteItemData(item.getId(), Long.valueOf(this.getCanvasId()));
                    List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(this.getPageCache().get("canvasId"));
                    ArrayList<CustomItem> returnItems = new ArrayList<CustomItem>(16);
                    BaseModel oldModel = null;
                    BaseModel newModel = null;
                    switch (type) {
                        case "slider": {
                            oldModel = ModelHelper.getModel((CustomItem)item, VarModel.class);
                            item.getC().put("varModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, VarModel.class);
                            break;
                        }
                        case "chart": {
                            oldModel = ModelHelper.getModel((CustomItem)item, ChartModel.class);
                            item.getC().put("chartModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, ChartModel.class);
                            break;
                        }
                        case "bizindicator": {
                            oldModel = ModelHelper.getModel((CustomItem)item, BizModel.class);
                            item.getC().put("bizModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, BizModel.class);
                            break;
                        }
                        case "table": {
                            oldModel = ModelHelper.getModel((CustomItem)item, TabModel.class);
                            item.getC().put("tabModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, TabModel.class);
                            break;
                        }
                        case "table2": {
                            oldModel = ModelHelper.getModel((CustomItem)item, TableModel.class);
                            item.getC().put("tableModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, TableModel.class);
                            break;
                        }
                        case "report": {
                            oldModel = ModelHelper.getModel((CustomItem)item, ReportModel.class);
                            ReportModel data = (ReportModel)returnData.get("data");
                            item.getC().put("reportModel", (Object)data);
                            newModel = ModelHelper.getModel((CustomItem)item, ReportModel.class);
                            break;
                        }
                        case "dupontnode": {
                            oldModel = ModelHelper.getModel((CustomItem)item, DupontModel.class);
                            item.getC().put("dupontModel", returnData.get("data"));
                            newModel = ModelHelper.getModel((CustomItem)item, DupontModel.class);
                        }
                    }
                    log.info("After CompConfig item:{}", (Object)JSON.toJSONString((Object)item));
                    List<CustomItem> itemSelector = isAdd != false ? AnalysisCanvasControlHelper.getNewItemSelector(newModel, item, selectItems) : AnalysisCanvasControlHelper.getModifyItemSelector(oldModel, newModel, item, selectItems);
                    if (CollectionUtils.isNotEmpty(itemSelector)) {
                        ModelHelper.buildOption(itemSelector, (IFormView)this.getView());
                        returnItems.addAll(itemSelector);
                    }
                    if (newModel != null && !"report".equals(type)) {
                        AnalysisCanvasUserSelHelper.saveUserSel(this.getView(), newModel, this.getCanvasId());
                    }
                    ArrayList<CustomItem> itemList = new ArrayList<CustomItem>(itemSelector.size() + 1);
                    itemList.addAll(returnItems);
                    itemList.add(item);
                    if ("report".equals(type)) {
                        IReportHelper.build(itemList, this.getView());
                    }
                    AnalysisService.getInstance().calc(this.getUsedBoxId(), itemList, null, AnalysisCanvasConstants.OptType.INIT, this.getView());
                    if (!isAdd.booleanValue()) {
                        AnalysisCanvasBoxDataService.getInstance().clearOtherBoxItemData(Long.valueOf(this.getCanvasId()), Long.valueOf(this.getUsedBoxId()), item.getId());
                    }
                    CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), itemList);
                } else if (isAdd.booleanValue()) {
                    CustomItemEvent.getInstance().sendDataRemoveEvent(this.getView(), Collections.singletonList(item));
                }
            }
            catch (KDBizException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                this.getView().showErrorNotification(ex.getMessage());
                CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
            }
        }
    }

    private void closeCallbackSelectSandbox(ClosedCallBackEvent e) {
        Long id = e.getReturnData() instanceof ListSelectedRowCollection ? IDUtils.toLong((Object)((ListSelectedRowCollection)e.getReturnData()).getPrimaryKeyValues()[0]) : IDUtils.toLong((Object)e.getReturnData());
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            this.getModel().setValue("btn_sandbox", (Object)id);
        }
    }

    private void closeCallbackSplitConfig(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        CustomItem item = (CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class);
        if (returnData != null && "ok".equals(returnData.get("event").toString())) {
            SplitModel splitModel = (SplitModel)returnData.get("data");
            List splitConfigs = ModelHelper.getSplitConfigs((CustomItem)item);
            int index = Integer.parseInt(this.getPageCache().get("index"));
            SplitConfig splitConfig = (SplitConfig)splitConfigs.get(index);
            splitConfig.setSplitModel(splitModel);
            ModelHelper.putSplitConfigs((CustomItem)item, (List)splitConfigs);
            List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(this.getPageCache().get("canvasId"));
            selectItems.add(item);
            AnalysisService.getInstance().calc(this.getUsedBoxId(), selectItems, null, AnalysisCanvasConstants.OptType.INIT, this.getView());
            AnalysisCanvasBoxDataService.getInstance().clearOtherBoxItemData(Long.valueOf(this.getCanvasId()), Long.valueOf(this.getUsedBoxId()), item.getId());
        }
        CustomItemEvent.getInstance().sendDataSplitEvent(this.getView(), item);
    }

    private void closePredictData(ClosedCallBackEvent e) {
        if (((Boolean)e.getReturnData()).booleanValue()) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AnalysisCanvasDesignPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CALC);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = AnalysisCanvasUtils.unCompressData((String)e.getEventArgs());
        if (AnalysisCanvasConstants.Status.SAVE.getValue().equals(this.getPageCache().get("canvasStatus")) && this.refreshLockInfo()) {
            if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_GET_ITEM_ID.getName())) {
                this.getItemId(eventArgs, true);
            }
            return;
        }
        log.info("customEvent eventName:{}, arg:{}", (Object)eventName, (Object)eventArgs);
        if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_SAVE.getName())) {
            this.doSaveEvent(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_PREVIEW.getName())) {
            this.doPreviewEvent(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_PUBLISH.getName())) {
            this.doPublishEvent(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_CALC.getName())) {
            this.doCalcEvent(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_BOX_COMPARE.getName())) {
            this.doBoxCompareEvent(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_VAR_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openSliderConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_CHART_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openChartConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_BIZ_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openBizConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_TAB_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openTableConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_TABLE2_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openTable2ConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_REPORT_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openReportConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_DUPONT_CONFIG.getName())) {
            String item = this.cacheSelectItems(eventArgs);
            this.openDupontConfigPage(item);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_SELECT_IMG.getName())) {
            this.getPageCache().put("customItem", eventArgs);
            this.openImg(e);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_SET_BACKGROUND_IMG.getName())) {
            this.openBackgroundImg(e);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_GET_ITEM_ID.getName())) {
            this.getItemId(eventArgs, false);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_COMP_CONFIG.getName())) {
            this.openCompConfig(e);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_RELATE_CONFIG.getName())) {
            this.openRelateConfig(e);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_VIEW_COMPUTE_PROCESS.getName())) {
            this.viewComputeProcess(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_PREDICT_DATA.getName())) {
            this.predictData(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_CELL_CLICK.getName())) {
            this.cellClick(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_SPLIT_CONFIG.getName())) {
            this.cacheSelectItems(eventArgs);
            this.openSplitConfig(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_OPEN_NOTE.getName())) {
            this.openNote(eventArgs);
        } else if (eventName.equals(AnalysisCanvasPluginConstants.Event.EVENT_TABLE_EXPAND.getName())) {
            this.doTableExpand(eventArgs);
        }
    }

    private String cacheSelectItems(String eventArgs) {
        JSONObject jsonObj = JSON.parseObject((String)eventArgs);
        String item = String.valueOf(jsonObj.get((Object)"item"));
        String items = String.valueOf(jsonObj.get((Object)"items"));
        this.getPageCache().put("customItem", item);
        this.getPageCache().put("customItems", items);
        List customItems = JSONObject.parseArray((String)items, CustomItem.class);
        if (customItems != null) {
            List selectItemList = ModelHelper.getItems((String)"select", (List)customItems);
            AnalysisCanvasRememberHelper.saveSelectItems(this.getPageCache().get("canvasId"), selectItemList);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCoverData() {
        try {
            long canvasId = this.getCanvasId();
            AnalysisService.getInstance().coverData(canvasId, this.getUsedBoxId(), this.getView());
            this.loadData();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8986\u76d6\u57fa\u51c6\u6570\u636e", "AnalysisCanvasDesignPlugin_24", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfid\uff1a%1$s\u8986\u76d6\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_25", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "over", opName, opDesc, new String[]{String.valueOf(canvasId)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8986\u76d6\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelComment() {
        try {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            AnalysisCanvasCommentService.getInstance().delete((Long)ids.get(0));
            this.refreshCommentList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6279\u6ce8\u64a4\u9500", "AnalysisCanvasDesignPlugin_26", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u64a4\u9500\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_12", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "cacel_coment", opName, opDesc, null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveEvent(String eventArgs) {
        try {
            long canvasId = this.getCanvasId();
            AnalysisCanvasService.getInstance().updateCanvas(Long.valueOf(canvasId), eventArgs);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "AnalysisCanvasDesignPlugin_23", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u5df2\u6210\u529f\u4fdd\u5b58\u3002", "AnalysisCanvasDesignPlugin_30", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "save", opName, opDesc, new String[]{String.valueOf(canvasId)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void doPreviewEvent(String eventArgs) {
        try {
            AnalysisCanvasService.getInstance().updateCanvas(Long.valueOf(this.getCanvasId()), eventArgs);
            this.getPageCache().put("designMode", Boolean.FALSE.toString());
            this.loadData();
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void doClosePreviewEvent() {
        try {
            this.getView().showLoading(new LocaleString(""));
            this.getPageCache().put("designMode", Boolean.TRUE.toString());
            this.loadData();
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void doPublishEvent(String eventArgs) {
        try {
            AnalysisCanvasService.getInstance().updateCanvas(Long.valueOf(this.getCanvasId()), eventArgs);
            this.publish();
            this.loadData();
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCalcEvent(String eventArgs) {
        try {
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            List itemList = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
            String type = jsonObj.getString("type");
            AnalysisCanvasConstants.OptType optType = AnalysisCanvasConstants.OptType.find((String)type);
            String param = jsonObj.getString("param");
            this.beforeCalc(itemList, optType, param);
            long usedBoxId = this.getUsedBoxId();
            AnalysisService.getInstance().calc(usedBoxId, itemList, null, optType, this.getView());
            CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), itemList);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6a21\u62df\u6d4b\u7b97", "AnalysisCanvasDesignPlugin_28", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8ID\u201c%1$s\u201d\u6a21\u62df\u6d4b\u7b97\u5df2\u5b8c\u6210\u3002", "AnalysisCanvasDesignPlugin_29", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "calc", opName, opDesc, new String[]{String.valueOf(usedBoxId)});
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void beforeCalc(List<CustomItem> itemList, AnalysisCanvasConstants.OptType optType, String param) {
        if (optType == AnalysisCanvasConstants.OptType.CALC || optType == AnalysisCanvasConstants.OptType.SELECTOR_CHANGE || optType == AnalysisCanvasConstants.OptType.REL_QUERY) {
            IReportHelper.build(itemList, this.getView());
        } else if (optType == AnalysisCanvasConstants.OptType.VIRTUAL) {
            this.getPageCache().put("viewArea", param);
        }
        this.getPageCache().put("calcParam", param);
    }

    private void doBoxCompareEvent(String eventArgs) {
        JSONObject jsonObj = JSON.parseObject((String)eventArgs);
        CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
        List allItems = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
        this.openCompareConfig("compareItem", evtItem, allItems);
    }

    private void openSliderConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_varconf");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sliderConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openChartConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_parent");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chartConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openBizConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_biz");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openTableConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_table");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tabConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openTable2ConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_table2");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tableConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openReportConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_report");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reportConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openDupontConfigPage(String customItem) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_dupont");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dupontConfigCloseCallback"));
        fsp.setCustomParam("customItem", (Object)customItem);
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        fsp.setCustomParam("usedBoxId", (Object)String.valueOf(this.getUsedBoxId()));
        this.getView().showForm(fsp);
    }

    private void openImg(CustomEventArgs e) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_manage");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectimgCloseCallback"));
        fsp.setCustomParam("customItem", (Object)AnalysisCanvasUtils.unCompressData((String)e.getEventArgs()));
        fsp.setCustomParam("type", (Object)"customItem");
        this.getView().showForm(fsp);
    }

    private void openBackgroundImg(CustomEventArgs e) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_manage");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectBackgroundImgCloseCallback"));
        fsp.setCustomParam("pageConfig", (Object)AnalysisCanvasUtils.unCompressData((String)e.getEventArgs()));
        fsp.setCustomParam("type", (Object)"pageConfig");
        this.getView().showForm(fsp);
    }

    private void openCompConfig(CustomEventArgs e) {
        JSONObject jsonObj = JSON.parseObject((String)AnalysisCanvasUtils.unCompressData((String)e.getEventArgs()));
        CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
        BaseModel baseModel = ModelHelper.getModel((CustomItem)evtItem);
        if (baseModel != null && !AnalysisCanvasRememberHelper.checkDatasetExisted(baseModel.getDataset())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u8be5\u7ec4\u4ef6\u3002", (String)"AnalysisCanvasDesignPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List allItems = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
        List selectItemList = ModelHelper.getItems((String)"select", (List)allItems);
        AnalysisCanvasRememberHelper.saveSelectItems(this.getPageCache().get("canvasId"), selectItemList);
        String json = JSON.toJSONString((Object)evtItem);
        this.getPageCache().put("customItem", json);
        switch (evtItem.getType()) {
            case "slider": {
                this.openSliderConfigPage(json);
                break;
            }
            case "chart": {
                this.openChartConfigPage(json);
                break;
            }
            case "bizindicator": {
                this.openBizConfigPage(json);
                break;
            }
            case "table": {
                this.openTableConfigPage(json);
                break;
            }
            case "table2": {
                this.openTable2ConfigPage(json);
                break;
            }
            case "report": {
                this.openReportConfigPage(json);
                break;
            }
            case "dupontnode": {
                this.openDupontConfigPage(json);
            }
        }
    }

    private void openRelateConfig(CustomEventArgs e) {
        JSONObject jsonObj = JSON.parseObject((String)AnalysisCanvasUtils.unCompressData((String)e.getEventArgs()));
        this.getPageCache().put("customItem", jsonObj.getString("item"));
        this.openRelateConfig(AnalysisCanvasUtils.unCompressData((String)e.getEventArgs()));
    }

    private void getItemId(String eventArgs, boolean isDLock) {
        String itemId = isDLock ? "0" : String.valueOf(ID.genLongId());
        JSONObject data = new JSONObject(2);
        data.fluentPut("type", (Object)eventArgs);
        data.fluentPut("itemId", (Object)itemId);
        CustomItemEvent.getInstance().sendEventWithData(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_GET_ITEM_ID, data);
    }

    private void openRelateConfig(String evtArgs) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_relate");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "relateConfigCloseCallback"));
        fsp.setCustomParam("evtArgs", (Object)evtArgs);
        this.getView().showForm(fsp);
    }

    private void openSplitConfig(String evtArgs) {
        JSONObject jsonObj = JSON.parseObject((String)evtArgs);
        String item = String.valueOf(jsonObj.get((Object)"item"));
        int index = Integer.parseInt(jsonObj.get((Object)"index").toString());
        this.getPageCache().put("customItem", item);
        this.getPageCache().put("index", Integer.toString(index));
        CustomItem customItem = (CustomItem)JSON.parseObject((String)item, CustomItem.class);
        List splitConfigs = ModelHelper.getSplitConfigs((CustomItem)customItem);
        SplitConfig splitConfig = (SplitConfig)splitConfigs.get(index);
        ChartModel model = (ChartModel)ModelHelper.getModel((CustomItem)customItem, ChartModel.class);
        if (splitConfig.getSplitModel() == null || splitConfig.getSplitModel().getModel() == null) {
            splitConfig.setSplitModel(AnalysisCanvasPluginHelper.convertToSplitModel(model, String.valueOf(this.getCanvasId())));
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_split");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gaugeSplitCloseCallback"));
        fsp.setCustomParam("splitModel", (Object)JSON.toJSONString((Object)splitConfig.getSplitModel()));
        fsp.setCustomParam("chartType", (Object)model.getType());
        fsp.setCustomParam("canvasId", (Object)String.valueOf(this.getCanvasId()));
        if (!"gauge".equals(model.getType())) {
            fsp.setCaption(ResManager.loadKDString((String)"\u53c2\u8003\u7ebf\u914d\u7f6e", (String)"AnalysisCanvasDesignPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(fsp);
    }

    private void openNote(String evtArgs) {
        if (this.checkAnalysisCanvasStatus()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
            return;
        }
        JSONObject jsonObj = JSON.parseObject((String)evtArgs);
        String item = String.valueOf(jsonObj.get((Object)"item"));
        CustomItem customItem = (CustomItem)JSON.parseObject((String)item, CustomItem.class);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u6279\u6ce8", (String)"AnalysisCanvasDesignPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fsp.setFormId("eb_analysiscanvas_note");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openNoteCallBack"));
        fsp.setCustomParam("customItem", (Object)JSONObject.toJSONString((Object)customItem));
        fsp.setCustomParam("canvasId", (Object)this.getCanvasId());
        fsp.setCustomParam("usedBoxId", (Object)this.getUsedBoxId());
        this.getView().showForm(fsp);
    }

    private void openCanvasComparePage() {
        Long canvasId = this.getCanvasId();
        String pageId = this.getView().getPageId() + canvasId + "actionCompareList";
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId(pageId);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId("eb_analysiscanvas_cmp");
        lsp.setCustomParam("canvasId", (Object)canvasId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openCompareConfig(String type, CustomItem item, List<CustomItem> filterItems) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(item == null ? "eb_analysiscanvas_config" : "eb_analysiscanvas_comp");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("canvasId", (Object)this.getCanvasId());
        fsp.setCustomParam("compareType", (Object)type);
        if ("compareItem".equals(type)) {
            fsp.setCustomParam("customItem", (Object)JSON.toJSONString((Object)item));
            fsp.setCustomParam("customItems", (Object)JSON.toJSONString(filterItems));
        }
        this.getView().showForm(fsp);
    }

    private void openCompareExport(ClosedCallBackEvent e) {
        String returnData = (String)e.getReturnData();
        if (StringUtils.isNotEmpty((String)returnData)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("eb_analysiscanvas_export");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("compareTable", (Object)returnData);
            this.getView().showForm(fsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewComputeProcess(String eventArgs) {
        try {
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
            List allItems = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
            List filterItemList = ModelHelper.getItems((String)"select", (List)allItems);
            AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(Long.valueOf(this.getUsedBoxId()));
            ItemService itemService = ItemService.getInstance((String)evtItem.getType());
            DimInfoDto dimInfo = itemService.getDimInfo(canvasBox, evtItem, filterItemList, jsonObj.getJSONObject("param"), this.getView());
            if (dimInfo == null) {
                return;
            }
            Map viewMap = dimInfo.getViewMap();
            AnalysisCanvasUtils.checkPermRead((long)dimInfo.getModelId(), (long)dimInfo.getDatasetId(), (Map)dimInfo.getMemberInfo(), (Map)viewMap);
            RuleDto ruleDto = AnalysisCanvasUtils.getCellRule((long)dimInfo.getModelId(), (long)dimInfo.getDatasetId(), (Map)viewMap, (Map)dimInfo.getMemberInfo());
            if (ruleDto == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u89c4\u5219\u3002", (String)"AnalysisCanvasListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("allDimNum", (Object)dimInfo.getMemberInfo());
            formShowParameter.setCustomParam("modelId", (Object)dimInfo.getModelId());
            formShowParameter.setCustomParam("templateId", (Object)dimInfo.getTemplateId());
            formShowParameter.setCustomParam("dataSetId", (Object)dimInfo.getDatasetId());
            formShowParameter.setCustomParam("analysisCanvasId", (Object)canvasBox.getCanvasId());
            formShowParameter.setCustomParam("analysisBoxId", (Object)canvasBox.getId());
            formShowParameter.setCustomParam("dimViewMap", (Object)SerializationUtils.toJsonString((Object)viewMap));
            ReportOrTaskPojo reportOrTaskPojo = new ReportOrTaskPojo();
            reportOrTaskPojo.setReportProcessIdLong(Long.valueOf(0L));
            reportOrTaskPojo.setTitleString(ResManager.loadKDString((String)"\u6c99\u76d8\u6a21\u62df", (String)"AnalysisCanvasListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            reportOrTaskPojo.setTypeString(ProcessTypeEnum.REPORT.name());
            formShowParameter.setCustomParam(ReportOrTaskPojo.class.getName(), (Object)JsonUtils.getJsonString((Object)reportOrTaskPojo));
            formShowParameter.setFormId("eb_bizruleshowforreport");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("showbizrulepanel");
            this.getView().showForm(formShowParameter);
            this.showRulePanel(true);
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void showRulePanel(boolean hidden) {
        this.getView().setVisible(Boolean.valueOf(!hidden), new String[]{"showbizrulepanel"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void predictData(String eventArgs) {
        try {
            if (Boolean.parseBoolean(this.getPageCache().get("predictShow"))) {
                return;
            }
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
            List allItems = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
            List filterItemList = ModelHelper.getItems((String)"select", (List)allItems);
            AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(Long.valueOf(this.getUsedBoxId()));
            ItemService itemService = ItemService.getInstance((String)evtItem.getType());
            DimInfoDto dimInfo = itemService.getDimInfo(canvasBox, evtItem, filterItemList, jsonObj.getJSONObject("param"), this.getView());
            if (dimInfo == null) {
                return;
            }
            List<Map> memberInfoList = dimInfo.getMemberInfoList().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(memberInfoList)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7ef4\u5ea6\u7ec4\u5408\u7684\u5355\u5143\u683c\u8fdb\u884c\u9884\u6d4b\u3002", (String)"AnalysisCanvasListPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map viewMap = dimInfo.getViewMap();
            memberInfoList.forEach(memInfo -> AnalysisCanvasUtils.checkPermRead((long)dimInfo.getModelId(), (long)dimInfo.getDatasetId(), (Map)memInfo, (Map)viewMap));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("allDimNum", (Object)JSON.toJSONString(memberInfoList));
            showParameter.setCustomParam("rowDim", (Object)JSON.toJSONString((Object)dimInfo.getRowDimSet()));
            showParameter.setCustomParam("modelId", (Object)dimInfo.getModelId());
            showParameter.setCustomParam("dataSetId", (Object)dimInfo.getDatasetId());
            showParameter.setCustomParam("canvasId", (Object)canvasBox.getCanvasId());
            showParameter.setCustomParam("sandboxId", (Object)canvasBox.getId());
            showParameter.setCustomParam("dimViewMap", (Object)SerializationUtils.toJsonString((Object)viewMap));
            showParameter.setCustomParam("dataunit", (Object)dimInfo.getDataUnit());
            showParameter.setCustomParam("unitSetting", (Object)dimInfo.getUnitSetting());
            showParameter.setCustomParam("writable", (Object)String.valueOf(!ModelHelper.isBaseBox((AnalysisCanvasBox)canvasBox)));
            String pageId = this.getPredictPageId();
            this.cachePageId(this.getPageCache(), "eb_predict_sidebar", pageId);
            showParameter.setFormId("eb_predict_sidebar");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setPageId(pageId);
            showParameter.getOpenStyle().setTargetKey("predictpanel");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "predictDataCloseCallback"));
            showParameter.setShowTitle(false);
            showParameter.setShowClose(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"predictpanel"});
            this.getPageCache().put("predictShow", String.valueOf(true));
            this.getView().showForm(showParameter);
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private String getPredictPageId() {
        return this.getView().getPageId() + this.getCanvasId() + "eb_predict_sidebar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cellClick(String eventArgs) {
        if (!Boolean.parseBoolean(this.getPageCache().get("predictShow"))) {
            return;
        }
        try {
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
            List allItems = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
            List filterItemList = ModelHelper.getItems((String)"select", (List)allItems);
            AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(Long.valueOf(this.getUsedBoxId()));
            ItemService itemService = ItemService.getInstance((String)evtItem.getType());
            DimInfoDto dimInfo = itemService.getDimInfo(canvasBox, evtItem, filterItemList, jsonObj.getJSONObject("param"), this.getView());
            if (dimInfo == null || CollectionUtils.isEmpty((Collection)dimInfo.getMemberInfoList()) || dimInfo.getMemberInfoList().stream().allMatch(Objects::isNull)) {
                return;
            }
            this.sendChildMsg("cellClick", dimInfo);
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableExpand(String eventArgs) {
        try {
            JSONObject jsonObj = JSON.parseObject((String)eventArgs);
            CustomItem evtItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
            List itemList = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
            itemList.add(evtItem);
            this.getPageCache().put("calcParam", jsonObj.getString("param"));
            long usedBoxId = this.getUsedBoxId();
            AnalysisService.getInstance().calc(usedBoxId, itemList, null, AnalysisCanvasConstants.OptType.EXPAND, this.getView());
            Optional<CustomItem> optional = itemList.stream().filter(item -> item.getId().equals(evtItem.getId())).findFirst();
            if (optional.isPresent()) {
                CustomItem tableItem = optional.get();
                CustomItemEvent.getInstance().sendDataUpdateEvent(this.getView(), Collections.singletonList(tableItem));
            }
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private boolean refreshLockInfo() {
        String userId = String.valueOf(UserUtils.getUserId());
        String canvasId = this.getPageCache().get("canvasId");
        String userInfo = AnalysisCanvasControlHelper.getUserInfo();
        String fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + canvasId), String.class);
        if (StringUtils.isEmpty((String)fromCacheUserInfo)) {
            CacheServiceHelper.put((String)("analysisCanvas:lock:" + canvasId), (Object)userInfo, (int)1800);
            return false;
        }
        JSONObject getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
        if (userId.equals(getUserInfo.get((Object)"userId"))) {
            CacheServiceHelper.put((String)("analysisCanvas:lock:" + canvasId), (Object)userInfo, (int)1800);
            return false;
        }
        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u6b63\u5728\u7f16\u8f91\u4e2d\u3002", (String)"AnalysisCanvasListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{getUserInfo.get((Object)"userName")}));
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String canvasId = this.getPageCache().get("canvasId");
        CacheServiceHelper.remove((String)("analysisCanvas:lock:" + canvasId));
        AnalysisCanvasRememberHelper.removeSelectItems(canvasId);
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void sendChildMsg(String operation, Object ... param) {
        CommandParam cmd = new CommandParam("eb_analysiscanvas_design", "eb_predict_sidebar", operation, param);
        this.sendMsg(this.getView(), cmd);
    }

    public void dealMsg(CommandParam command) {
        if ("refreshData".equals(command.getOperation())) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AnalysisCanvasDesignPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CALC);
        } else if ("switchFloating".equals(command.getOperation())) {
            String data = (String)command.getParam().get(0);
            Map param = (Map)command.getParam().get(1);
            ForecastHelper.switchFloating(data, param, this.getView(), (IFormPlugin)this);
        }
    }
}

