/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;

public class AnalysisCanvasDropdownConfigPlugin
extends AbstractBasePlugin
implements ClickListener {
    private static final String ASSEMBLY = "assembly";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.initOption(params);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
    }

    private void initOption(Map<String, Object> params) {
        String modelId = String.valueOf(params.get("model"));
        String dataset = String.valueOf(params.get("dataset"));
        String canvasId = String.valueOf(params.get("canvasId"));
        String dimNumber = String.valueOf(params.get("dimNumber"));
        String name = String.valueOf(params.get("name"));
        this.getModel().setValue("name", (Object)name);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
        List<CustomItem> items = AnalysisCanvasPluginHelper.filterSameDimSelector(canvasId, modelId, dataset, dimNumber);
        ComboEdit comboEdit = (ComboEdit)this.getControl(ASSEMBLY);
        ArrayList data = new ArrayList();
        items.forEach(Item -> data.add(new ComboItem(new LocaleString(Item.getName()), Item.getId())));
        comboEdit.setComboItems(data);
        this.getModel().setValue(ASSEMBLY, params.get("relateId"));
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_ok": {
                this.returnData();
                break;
            }
            case "btn_cancel": {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("event", "cancel");
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
                break;
            }
        }
    }

    private void returnData() {
        String id;
        String string = id = this.getModel().getValue(ASSEMBLY) == null ? null : String.valueOf(this.getModel().getValue(ASSEMBLY));
        if (StringUtils.isEmpty(id)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u83dc\u5355\u3002", (String)"AnalysisCanvasDropdownConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("event", "ok");
        returnMap.put("id", id);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }
}

