/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasDupontConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String INDICATOR_DIM = "indicatordim";
    private static final String INDEX_DIMMEMBER = "indexdimmember";
    private static final String CLOSE_CALLBACK_INDEX_DIMMEMBER = "closeCallbackIndexDimmember";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        JSONObject dupontModelJson = customItem.getC().getJSONObject("dupontModel");
        if (dupontModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            DupontModel dupontModel = (DupontModel)dupontModelJson.toJavaObject(DupontModel.class);
            Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)dupontModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            this.clearDupontDim();
            this.initDupontDim();
            this.initDupontData(canvasId, dupontModel, dataSetId, modelCache);
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                this.initDupontDim();
                this.getModel().setValue(INDICATOR_DIM, (Object)SysDimensionEnum.Account.getNumber());
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.dupont, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.dupont, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            }
        }
    }

    private void initDupontData(String canvasId, DupontModel dupontModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        BizValue dupontConfig = (BizValue)dupontModel.getDupontConfig().get(0);
        JSONObject dimensionViews = dupontConfig.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        AnalysisCanvasUserSelHelper.initSingleMembers(this.getView(), modelCache, dimensionList, dimensionViews, dupontConfig.getDim(), dupontConfig.getNum(), ignoreDimNumbers, INDICATOR_DIM, INDEX_DIMMEMBER, AnalysisCanvasEnum.dupont);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, dupontConfig.getDims(), dimensionViews, AnalysisCanvasEnum.dupont, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.dupont, ignoreDimNumbers);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", INDEX_DIMMEMBER, "dimmember", "dimselect"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.dupont, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                this.clearDupontDim();
                this.initDupontDim();
                this.getModel().setValue(INDICATOR_DIM, null);
                this.getModel().setValue(INDICATOR_DIM, (Object)SysDimensionEnum.Account.getNumber());
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (INDICATOR_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            this.clearDupontDim();
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.dupont, Collections.singletonList(newVal));
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildDupontModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (INDEX_DIMMEMBER.equals(ctrlKey)) {
            Object bizDim = this.getModel().getValue(INDICATOR_DIM);
            if (bizDim == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasDupontConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = bizDim.toString();
            this.openDimSelect(dimNumber, CLOSE_CALLBACK_INDEX_DIMMEMBER, true);
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "varMemberCloseCallback", !isMulti);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId);
        }
    }

    private void openDropdownConfig(String dimNumber, String relateId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dropdownConfigCloseCallback"));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CLOSE_CALLBACK_INDEX_DIMMEMBER.equals(actionId) || actionId.startsWith("varMemberCloseCallback")) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.dupont);
        }
    }

    private void initDupontDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit comboEdit = (ComboEdit)this.getControl(INDICATOR_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        comboEdit.setComboItems(data);
    }

    private void clearDupontDim() {
        this.getModel().setValue(INDEX_DIMMEMBER, null);
        this.getPageCache().remove("indexdimmember_select");
    }

    private DupontModel buildDupontModel() {
        Object indicatorDim = this.getModel().getValue(INDICATOR_DIM);
        if (indicatorDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasDupontConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object indexDimMember = this.getModel().getValue(INDEX_DIMMEMBER);
        if (StringUtils.isBlank((CharSequence)String.valueOf(indexDimMember))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u6210\u5458\u3002", (String)"AnalysisCanvasDupontConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.dupont);
        String indexDim = this.getPageCache().get("indexdimmember_select");
        List indexItemList = JSON.parseArray((String)indexDim, TextEditSelectItem.class);
        BizValue indexValue = new BizValue();
        indexValue.setNum(((TextEditSelectItem)indexItemList.get(0)).getNumber());
        indexValue.setValue((Object)"0.00");
        indexValue.setDim(indicatorDim.toString());
        indexValue.setDims(dimModels);
        indexValue.setDimensionViews(dimensionViews);
        List<BizValue> dupontConfig = Collections.singletonList(indexValue);
        AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)datasetId), indexValue.getDim(), IDUtils.toLong((Object)dimensionViews.getString(indexValue.getDim())), indexValue.getNum());
        DupontModel dupontModel = new DupontModel();
        dupontModel.setDupontConfig(dupontConfig);
        dupontModel.setModel(String.valueOf(this.getModelId()));
        dupontModel.setDataset(datasetId);
        dupontModel.setAdd(Boolean.valueOf(false));
        dupontModel.setEdit(Boolean.valueOf(false));
        dupontModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return dupontModel;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectKey = CLOSE_CALLBACK_INDEX_DIMMEMBER.equals(callback) ? INDEX_DIMMEMBER : dimNumber;
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if (CLOSE_CALLBACK_INDEX_DIMMEMBER.equals(actionId)) {
            this.getPageCache().put("indexdimmember_select", JSON.toJSONString(list));
            this.getModel().setValue(INDEX_DIMMEMBER, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
        } else {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }
}

