/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasEditPlugin
extends AbstractBasePlugin {
    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String langStr = RequestContext.get().getLang().toString();
        OrmLocaleValue nameOrmValue = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringUtils.isEmpty((String)nameOrmValue.get((Object)langStr)) && nameOrmValue != null && !nameOrmValue.isEmpty()) {
            nameOrmValue.setItem(langStr, nameOrmValue.toString());
        }
        this.getModel().setValue("name", (Object)nameOrmValue);
        OrmLocaleValue discriptionOrmValue = (OrmLocaleValue)this.getModel().getValue("description");
        if (StringUtils.isEmpty((String)discriptionOrmValue.get((Object)langStr)) && discriptionOrmValue != null && !discriptionOrmValue.isEmpty()) {
            discriptionOrmValue.setItem(langStr, discriptionOrmValue.toString());
        }
        this.getModel().setValue("description", (Object)discriptionOrmValue);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if ("save".equals(opType)) {
            IDataModel dataModel = this.getModel();
            dataModel.setValue("modifier", (Object)this.getUserId());
            String number = (String)dataModel.getValue("number");
            OrmLocaleValue name = (OrmLocaleValue)dataModel.getValue("name");
            if (StringUtils.isEmpty((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AnalysisCanvasEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (!CheckStringsUtil.checkNumber4((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AnalysisCanvasEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (name == null || name.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AnalysisCanvasEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (AnalysisCanvasService.getInstance().numberIsExists(id, number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AnalysisCanvasEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            String type = (String)dataModel.getValue("type");
            if (StringUtils.isEmpty((String)type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u753b\u5e03\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"AnalysisCanvasEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
        }
        if ("close".equals(opType)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long canvasId;
        List successPkIds;
        super.afterDoOperation(args);
        Boolean isAdd = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAdd");
        boolean success = args.getOperationResult().isSuccess();
        if (success && isAdd.booleanValue() && CollectionUtils.isNotEmpty((Collection)(successPkIds = args.getOperationResult().getSuccessPkIds()))) {
            canvasId = IDUtils.toLong(successPkIds.get(0));
            AnalysisCanvasBox baseBox = new AnalysisCanvasBox();
            baseBox.setCanvasId(canvasId);
            baseBox.setName(ResManager.loadKDString((String)"\u57fa\u51c6\u6c99\u76d8", (String)"AnalysisCanvasEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            baseBox.setType(AnalysisCanvasConstants.BoxType.BASE.getValue());
            baseBox.setStatus(AnalysisCanvasConstants.BoxStatus.UNACTIVATED.getValue());
            baseBox.setSeq(Integer.valueOf(1));
            AnalysisCanvasBoxService.getInstance().save(Collections.singletonList(baseBox));
            AnalysisCanvasBox sandBox = new AnalysisCanvasBox();
            sandBox.setCanvasId(canvasId);
            sandBox.setName(ResManager.loadResFormat((String)"\u6a21\u62df\u6c99\u76d8%1", (String)"AnalysisCanvasEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{1}));
            sandBox.setType(AnalysisCanvasConstants.BoxType.SANDBOX.getValue());
            sandBox.setStatus(AnalysisCanvasConstants.BoxStatus.ACTIVATED.getValue());
            sandBox.setSeq(Integer.valueOf(2));
            AnalysisCanvasBoxService.getInstance().save(Collections.singletonList(sandBox));
            HashMap<String, Long> returnMap = new HashMap<String, Long>();
            returnMap.put("id", canvasId);
            this.getView().returnDataToParent(returnMap);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "AnalysisCanvasEditPlugin_8", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62df%1$s\u5df2\u6210\u529f\u4fdd\u5b58\u3002", "AnalysisCanvasEditPlugin_10", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "new_save", opName, opDesc, new String[]{String.valueOf(canvasId)});
        }
        if (success && !isAdd.booleanValue() && CollectionUtils.isNotEmpty((Collection)(successPkIds = args.getOperationResult().getSuccessPkIds()))) {
            canvasId = IDUtils.toLong(successPkIds.get(0));
            AnalysisCanvasCollectService.getInstance().deleteByCanvas(canvasId);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "AnalysisCanvasEditPlugin_9", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62df%1$s\u5df2\u6210\u529f\u4fdd\u5b58\u3002", "AnalysisCanvasEditPlugin_10", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "edit_save", opName, opDesc, new String[]{String.valueOf(canvasId)});
        }
    }
}

