/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class AnalysisCanvasImgEditPlugin
extends AbstractBasePlugin
implements ClickListener,
UploadListener {
    private static final List<String> IMAGE_SUFFIX = Arrays.asList(".png", ".jpg", ".gif");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String cateid = this.getView().getFormShowParameter().getCustomParams().get("cateid").toString();
        this.getModel().setValue("cateid", (Object)cateid);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            IDataModel dataModel = this.getModel();
            String imageUrl = (String)this.getModel().getValue("fileurl");
            String name = (String)dataModel.getValue("name");
            if (StringUtils.isEmpty((String)imageUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247\u3002", (String)"AnalysisCanvasImgEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (!this.matchSuffix(imageUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u9650\u5236\u4e3a5M\u4ee5\u5185\uff0c\u652f\u6301png\u3001jpg\u548cgif\u683c\u5f0f\u3002", (String)"AnalysisCanvasImgEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((String)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fe\u7247\u540d\u79f0\u3002", (String)"AnalysisCanvasImgEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
        }
        if ("close".equals(opType)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private boolean matchSuffix(String imageUrl) {
        String suffix = imageUrl.substring(imageUrl.lastIndexOf("."));
        return IMAGE_SUFFIX.contains(suffix);
    }
}

