/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.PageConfig;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;

public class AnalysisCanvasImgPlugin
extends AbstractFormPlugin
implements UploadListener,
ListboxClickListener,
RowClickEventListener,
ClickListener {
    private static final String ITEM_ID_CACHE = "itemIdCache";
    private static final String SHOW_ENTRYKEY = "showentry";

    public void initialize() {
        super.initialize();
        Listbox box = (Listbox)this.getView().getControl("listbox");
        box.addListboxClickListener((ListboxClickListener)this);
        AbstractGrid showGrid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        showGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.selectCatalogue();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_add", "btn_edit", "btn_del", "img_edit", "img_del", "btn_upload"});
        Listbox box = (Listbox)this.getView().getControl("listbox");
        box.addListboxClickListener((ListboxClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String itemId = this.getPageCache().get(ITEM_ID_CACHE);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        Long id = IDUtils.toLong((Object)this.getModel().getValue("id", rowIndex));
        switch (key) {
            case "btn_image": {
                break;
            }
            case "btn_add": {
                this.openEditPage("");
                break;
            }
            case "btn_edit": {
                if (StringUtils.isBlank((CharSequence)itemId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u5206\u5f55\u3002", (String)"AnalysisCanvasImgPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.openEditPage(itemId);
                break;
            }
            case "btn_del": {
                if (StringUtils.isBlank((CharSequence)itemId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5206\u5f55\u3002", (String)"AnalysisCanvasImgPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (this.getImageIds(IDUtils.toLong((Object)itemId)).size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u76ee\u5f55\u4e0b\u5b58\u5728\u56fe\u7247\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AnalysisCanvasImgPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u76ee\u5f55\uff1f", (String)"AnalysisCanvasImgPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
                break;
            }
            case "img_edit": {
                if (IDUtils.isNull((Long)id)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u56fe\u7247\u3002", (String)"AnalysisCanvasImgPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.openEditImg(id);
                break;
            }
            case "img_del": {
                if (IDUtils.isNull((Long)id)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u56fe\u7247\u3002", (String)"AnalysisCanvasImgPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_analysiscanvas_quote", (String)"id, canvasid", (QFilter[])new QFilter[]{new QFilter("imageid", "=", (Object)id)});
                if (dynamicObject != null) {
                    AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(Long.valueOf(dynamicObject.getLong("canvasid")));
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5206\u6790\u753b\u5e03\u201c%1\u201d\u5df2\u5f15\u7528\u8be5\u56fe\u7247\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AnalysisCanvasImgPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{canvas.getName()}));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u56fe\u7247\uff1f", (String)"AnalysisCanvasImgPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDelImg", (IFormPlugin)this));
                break;
            }
            case "btn_upload": {
                this.openEditImg(null);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.delPage(IDUtils.toLong((Object)this.getPageCache().get(ITEM_ID_CACHE)));
        }
        if ("confirmDelImg".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
            int rowIndex = grid.getEntryState().getFocusRow();
            Long id = IDUtils.toLong((Object)this.getModel().getValue("id", rowIndex));
            this.delImg(id);
        }
    }

    private void delImg(Long id) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_analysiscanvas_img", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                this.showPictureGrid(this.getPageCache().get(ITEM_ID_CACHE));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void delPage(Long id) {
        List<Object> ids = this.getImageIds(id);
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_analysiscanvas_img_cat", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                DeleteServiceHelper.delete((String)"eb_analysiscanvas_img", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                this.getPageCache().remove(ITEM_ID_CACHE);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            finally {
                this.selectCatalogue();
            }
        }
    }

    private List<Object> getImageIds(Long id) {
        return QueryServiceHelper.queryPrimaryKeys((String)"eb_analysiscanvas_img", (QFilter[])new QFilter[]{new QFilter("cateid", "=", (Object)id)}, null, (int)1000);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        switch (key = evt.getItemKey()) {
            case "btn_ok": {
                if (rowIndex < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u56fe\u7247\u3002", (String)"AnalysisCanvasImgPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String newValue = (String)this.getModel().getValue("url0", rowIndex);
                String type = this.getView().getFormShowParameter().getCustomParams().get("type").toString();
                if ("customItem".equals(type)) {
                    this.returnData(newValue);
                    break;
                }
                if (!"pageConfig".equals(type)) break;
                this.returnPage(newValue);
                break;
            }
        }
    }

    private void returnData(String value) {
        String custom = this.getView().getFormShowParameter().getCustomParams().get("customItem").toString();
        CustomItem customItem = (CustomItem)JSON.parseObject((String)custom, CustomItem.class);
        String imgUrl = UrlService.getImageFullUrl((String)value);
        customItem.getC().put("value", (Object)imgUrl);
        customItem.getC().put("add", (Object)false);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("event", "ok");
        returnMap.put("data", (String)customItem);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private void returnPage(String value) {
        String page = this.getView().getFormShowParameter().getCustomParams().get("pageConfig").toString();
        PageConfig PageConfig2 = (PageConfig)JSON.parseObject((String)page, PageConfig.class);
        String imgUrl = UrlService.getImageFullUrl((String)value);
        PageConfig2.setUrl(imgUrl);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("event", "ok");
        returnMap.put("data", (String)PageConfig2);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private void openEditPage(String id) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_img_cat");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u76ee\u5f55\u4fee\u6539", (String)"AnalysisCanvasImgPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u76ee\u5f55\u65b0\u589e", (String)"AnalysisCanvasImgPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openEditImg(Long id) {
        String itemId = this.getPageCache().get(ITEM_ID_CACHE);
        if (StringUtils.isBlank((CharSequence)itemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u5206\u7ec4\uff0c\u518d\u8fdb\u884c\u56fe\u7247\u4e0a\u4f20\u3002", (String)"AnalysisCanvasImgPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_img");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "updateCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("cateid", (Object)IDUtils.toLong((Object)itemId));
            showParameter.setCaption(ResManager.loadKDString((String)"\u56fe\u7247\u4fee\u6539", (String)"AnalysisCanvasImgPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("cateid", (Object)IDUtils.toLong((Object)itemId));
            showParameter.setCaption(ResManager.loadKDString((String)"\u56fe\u7247\u4e0a\u4f20", (String)"AnalysisCanvasImgPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addCloseCallback".equals(actionId)) {
            this.selectCatalogue();
        }
        if ("updateCloseCallback".equals(actionId)) {
            this.showPictureGrid(this.getPageCache().get(ITEM_ID_CACHE));
        }
    }

    public void upload(UploadEvent event) {
        String url = (String)event.getUrls()[0];
        String name = (String)event.getNames()[0];
        ArrayList<Object[]> insertHeadDatas = new ArrayList<Object[]>(16);
        Object[] row = new Object[5];
        Long id = GlobalIdUtil.genGlobalLongId();
        Long itemId = IDUtils.toLong((Object)this.getPageCache().get(ITEM_ID_CACHE));
        row[0] = id;
        row[1] = itemId;
        row[2] = name;
        row[3] = url;
        row[4] = RequestContext.get().getCurrUserId();
        insertHeadDatas.add(row);
        this.saveImageUrl(insertHeadDatas);
    }

    public void saveImageUrl(List<Object[]> insertHeadDatas) {
        String insertSql = "insert into t_eb_analysiscanvas_img(fid,fcateid,fname,ffileurl,fcreaterid) values(?,?,?,?,?)";
        DB.executeBatch((DBRoute)new DBRoute("epm"), (String)insertSql, insertHeadDatas);
        ImageList imageList = (ImageList)this.getView().getControl("btn_image");
        imageList.getModel().beginInit();
        String itemId = this.getPageCache().get(ITEM_ID_CACHE);
        this.openEditPage(itemId);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(ITEM_ID_CACHE, itemId);
        this.showPictureGrid(itemId);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SHOW_ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        Object url = this.getModel().getValue("url0", rowIndex);
        if (StringUtils.isNotBlank((Object)url)) {
            String[] urls = new String[]{(String)url};
            this.getView().showPictureView(urls, 1);
        }
    }

    private List<ListboxItem> getCategoryNodes() {
        QFilter filter = new QFilter("id", "is not null", (Object)"");
        DynamicObject[] category = BusinessDataServiceHelper.load((String)"eb_analysiscanvas_img_cat", (String)"id,name", (QFilter[])filter.toArray(), (String)"id");
        if (category.length == 0) {
            this.getPageCache().remove(ITEM_ID_CACHE);
        }
        ArrayList<ListboxItem> nodes = new ArrayList<ListboxItem>(category.length);
        for (DynamicObject row : category) {
            Object id = row.get("id");
            ListboxItem node = new ListboxItem();
            node.setId(id.toString());
            node.setContent(row.getString("name"));
            nodes.add(node);
        }
        return nodes;
    }

    private void selectCatalogue() {
        List<ListboxItem> ListBoxItems = this.getCategoryNodes();
        Listbox box = (Listbox)this.getView().getControl("listbox");
        box.addItems(ListBoxItems);
        if (ListBoxItems.size() <= 0) {
            this.getModel().deleteEntryData(SHOW_ENTRYKEY);
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(ITEM_ID_CACHE))) {
            ListboxItem firstItem = ListBoxItems.get(0);
            String id = firstItem.getId();
            this.getPageCache().put(ITEM_ID_CACHE, id);
            box.activeItem(id);
            this.showPictureGrid(id);
        }
    }

    private void showPictureGrid(String categoryId) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(SHOW_ENTRYKEY);
        model.getDataEntity(true);
        model.endInit();
        QFilter pathFilter = new QFilter("cateid", "=", (Object)Long.parseLong(categoryId));
        QFilter[] filters = new QFilter[]{pathFilter};
        String orderBy = "id";
        Map pics = BusinessDataServiceHelper.loadFromCache((String)"eb_analysiscanvas_img", (String)"id, name, fileurl", (QFilter[])filters, (String)orderBy);
        if (pics.size() > 0) {
            int i = 0;
            model.beginInit();
            model.batchCreateNewEntryRow(SHOW_ENTRYKEY, pics.size());
            for (DynamicObject obj : pics.values()) {
                model.setValue("id", obj.get("id"), i);
                String name = obj.getString("name");
                model.setValue("name", (Object)name, i);
                String url0 = obj.getString("fileurl");
                model.setValue("url0", (Object)url0, i);
                ++i;
            }
            model.endInit();
        }
        this.getView().updateView(SHOW_ENTRYKEY);
    }
}

