/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCateService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasShare;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasType;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AnalysisCanvasListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
FilterContainerInitListener,
TabSelectListener {
    private static final String TREE_NAME = "treeviewap";
    private static final String EXPAND_ALL = "expand_all";
    private static final String SHRINK_ALL = "shrink_all";
    private static final String EXPAND_CURRENT = "expand_current";
    private static final String SHRINK_CURRENT = "shrink_current";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PUBLISH = "publish";
    private static final String STAGING = "staging";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String DESCRIPTION = "description";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_DATE = "modifydate";
    private static final String ENJOY = "enjoy";
    private static final String SELF = "self";
    private static final String B_VIEW = "b_view";
    private static final String B_DELETE = "b_delete";
    private static final String B_ENJOY = "b_enjoy";
    private static final String B_PUBLISH = "b_publish";
    private static final String B_STAGING = "b_staging";
    private static final String BTN_LIST = "btn_list";
    private static final String BTN_CARD = "btn_card";
    private static final String CURR_NODE = "currNode";
    private static final int MAX_LEVEL = 5;
    private static final String TAB = "tabap";
    private static final String TAB_ALL = "tab_all";
    private static final String TAB_COLLECT = "tab_collect";
    private static final String TREE_TOOLBAR = "tree_toolbar";
    private static final String CATE_ADD = "cate_add";
    private static final String CATE_MODIFY = "cate_modify";
    private static final String CATE_DELETE = "cate_delete";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId("eb_analysiscanvas");
            fc.addFilterContainerInitListener((FilterContainerInitListener)this);
            fc.addBeforeF7SelectListener(arg_0 -> ((AnalysisCanvasListPlugin)this).filterContainerBeforeF7Select(arg_0));
            fc.addSearchClickListener(this::filterContainerSearchClick);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        QFilter defaultFilter;
        super.afterCreateNewData(e);
        this.switchListOrCard(Boolean.FALSE);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TREE_TOOLBAR});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_uncollect"});
        List filterSchemes = FilterServiceHelper.getSchemeList((String)"eb_analysiscanvas");
        Optional<FilterScheme> optional = filterSchemes.stream().filter(FilterScheme::isDefault).findFirst();
        if (optional.isPresent() && (defaultFilter = FilterServiceHelper.getQFilterByFilterScheme((FilterScheme)optional.get(), (String)"eb_analysiscanvas", null)) != null) {
            this.getPageCache().put("qFilters", SerializationUtils.serializeToBase64((Object)Lists.newArrayList((Object[])new QFilter[]{defaultFilter})));
        }
        this.initTree();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{B_VIEW, B_DELETE, B_ENJOY, B_PUBLISH, B_STAGING, EXPAND_ALL, SHRINK_ALL, EXPAND_CURRENT, SHRINK_CURRENT, "searchbefore", "searchnext", BTN_LIST, BTN_CARD, CATE_ADD, CATE_MODIFY, CATE_DELETE});
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREE_NAME)));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(evt -> evt.getQFilters().add(this.getQFilter()));
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        List<Long> canvasIds = this.getCanvasIds();
        switch (key) {
            case "btn_new": {
                this.openEditPage(null);
                break;
            }
            case "btn_copy": {
                this.checkIsSelectOneData(canvasIds);
                this.copyData();
                break;
            }
            case "btn_del": {
                this.checkIsSelectData(canvasIds);
                this.checkCanvasDel("btn_del", canvasIds);
                break;
            }
            case "btn_modify": {
                this.checkIsSelectOneData(canvasIds);
                this.openEditPage(this.getFocusId().toString());
                break;
            }
            case "btn_refresh": {
                this.refreshData();
                break;
            }
            case "btn_pub_cancel": {
                this.checkIsSelectData(canvasIds);
                this.checkCanvasPublish(AnalysisCanvasConstants.Status.SAVE, canvasIds);
                this.publish(AnalysisCanvasConstants.Status.SAVE, canvasIds);
                break;
            }
            case "btn_publish": {
                this.checkIsSelectData(canvasIds);
                this.checkCanvasPublish(AnalysisCanvasConstants.Status.RELEASE, canvasIds);
                this.publish(AnalysisCanvasConstants.Status.RELEASE, canvasIds);
                break;
            }
            case "btn_enjoy": {
                this.checkIsSelectData(canvasIds);
                this.openEnjoyUserPage("btn_enjoy");
                break;
            }
            case "btn_share": {
                this.openEnjoyRecordPage();
                break;
            }
            case "btn_collect": {
                this.checkIsSelectData(canvasIds);
                this.openAddCollectPage();
                break;
            }
            case "btn_uncollect": {
                this.checkIsSelectData(canvasIds);
                this.checkCanvasUnCollect();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "b_view": {
                this.openDesignPage(this.getFocusId());
                break;
            }
            case "b_delete": {
                this.checkCanvasDel(B_DELETE, Collections.singletonList(this.getFocusId()));
                break;
            }
            case "b_enjoy": {
                this.openEnjoyUserPage(B_ENJOY);
                break;
            }
            case "b_publish": {
                this.checkCanvasPublish(AnalysisCanvasConstants.Status.RELEASE, Collections.singletonList(this.getFocusId()));
                this.publish(AnalysisCanvasConstants.Status.RELEASE, Collections.singletonList(this.getFocusId()));
                break;
            }
            case "b_staging": {
                this.checkCanvasPublish(AnalysisCanvasConstants.Status.SAVE, Collections.singletonList(this.getFocusId()));
                this.publish(AnalysisCanvasConstants.Status.SAVE, Collections.singletonList(this.getFocusId()));
                break;
            }
            case "btn_list": {
                this.switchListOrCard(Boolean.TRUE);
                this.refreshData();
                break;
            }
            case "btn_card": {
                this.switchListOrCard(Boolean.FALSE);
                this.refreshData();
                break;
            }
            case "cate_add": {
                this.openCatePage(true);
                break;
            }
            case "cate_modify": {
                this.openCatePage(false);
                break;
            }
            case "cate_delete": {
                this.checkCateDelete();
                break;
            }
            case "expand_all": {
                this.expendNode(true, true);
                break;
            }
            case "shrink_all": {
                this.expendNode(true, false);
                break;
            }
            case "expand_current": {
                this.expendNode(false, true);
                break;
            }
            case "shrink_current": {
                this.expendNode(false, false);
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_NAME, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_NAME, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (TAB_ALL.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_collect"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TREE_TOOLBAR, "btn_uncollect"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TREE_TOOLBAR, "btn_uncollect"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_collect"});
        }
        Search search = (Search)this.getControl("searchap");
        search.setSearchKey("");
        this.getPageCache().put(TREE_TOOLBAR, tabKey);
        this.initTree();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (("btn_del".equals(key) || B_DELETE.equals(key)) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.delData(key);
        }
        if ("btn_uncollect".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.unCollectData();
            this.refreshData();
        }
        if (CATE_DELETE.equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteCate();
            this.initTree();
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        Object pkId = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        this.openDesignPage(IDUtils.toLong((Object)pkId));
    }

    private void filterContainerSearchClick(SearchClickEvent args) {
        FilterParameter filterParameter = args.getFilterParameter();
        List qFilters = filterParameter.getQFilters();
        List fastQFilters = args.getFastQFilters();
        if (CollectionUtils.isNotEmpty((Collection)fastQFilters)) {
            List<List<QFilter>> qFilterList = this.translateFastFilter(fastQFilters);
            if (CollectionUtils.isNotEmpty(qFilterList)) {
                this.getPageCache().put("fastFilters", SerializationUtils.serializeToBase64(qFilterList));
            } else {
                this.getPageCache().put("fastFilters", "");
            }
        } else {
            this.getPageCache().put("fastFilters", "");
        }
        if (CollectionUtils.isNotEmpty((Collection)qFilters)) {
            this.getPageCache().put("qFilters", SerializationUtils.serializeToBase64((Object)qFilters));
        } else {
            this.getPageCache().put("qFilters", "");
        }
        this.refreshData();
    }

    private List<List<QFilter>> translateFastFilter(List<QFilter> fastQFilters) {
        ArrayList<List<QFilter>> qFilters = new ArrayList<List<QFilter>>(10);
        for (QFilter fastQFilter : fastQFilters) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            String valueStr = (String)fastQFilter.getValue();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)valueStr)) {
                QFilter qFilter;
                String property = valueStr.substring(0, valueStr.indexOf("#"));
                String value = valueStr.substring(valueStr.indexOf("#") + 1);
                if (property.contains(",")) {
                    String[] propertySplit;
                    for (String s : propertySplit = property.split(",")) {
                        if (value.contains("\b")) {
                            String[] strings;
                            for (String string : strings = value.split("\b")) {
                                QFilter qFilter2 = new QFilter(s, "like", (Object)string);
                                filters.add(qFilter2);
                            }
                            continue;
                        }
                        qFilter = new QFilter(s, "like", (Object)value);
                        filters.add(qFilter);
                    }
                } else if (value.contains("\b")) {
                    String[] strings;
                    for (String string : strings = value.split("\b")) {
                        qFilter = new QFilter(property, "like", (Object)string);
                        filters.add(qFilter);
                    }
                } else {
                    QFilter qFilter3 = new QFilter(property, "like", (Object)value);
                    filters.add(qFilter3);
                }
            }
            qFilters.add(filters);
        }
        return qFilters;
    }

    private QFilter getDealProcessFilter() {
        QFilter qFilter = null;
        String qFilterStr = this.getPageCache().get("qFilters");
        if (StringUtils.isNotEmpty((String)qFilterStr)) {
            List qFilters = (List)SerializationUtils.deSerializeFromBase64((String)qFilterStr);
            for (QFilter filter : qFilters) {
                if (qFilter == null) {
                    qFilter = filter;
                    continue;
                }
                qFilter.and(filter);
            }
        }
        QFilter fastQFilter = null;
        String fastFilterStr = this.getPageCache().get("fastFilters");
        if (StringUtils.isNotEmpty((String)fastFilterStr)) {
            List fastFilters = (List)SerializationUtils.deSerializeFromBase64((String)fastFilterStr);
            for (List fastFilter : fastFilters) {
                QFilter qFilter1 = null;
                for (QFilter filter : fastFilter) {
                    String cp = filter.getCP();
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"like", (CharSequence)cp)) {
                        filter.__setValue((Object)("%" + this.escape(filter.getValue() + "") + "%"));
                    }
                    if (qFilter1 == null) {
                        qFilter1 = filter;
                        continue;
                    }
                    qFilter1.or(filter);
                }
                if (fastQFilter == null) {
                    fastQFilter = qFilter1;
                    continue;
                }
                fastQFilter.and(qFilter1);
            }
        }
        if (qFilter != null) {
            if (fastQFilter != null) {
                qFilter.and(fastQFilter);
            }
        } else if (fastQFilter != null) {
            qFilter = fastQFilter;
        }
        return qFilter;
    }

    private String escape(String content) {
        if (content != null && !content.trim().isEmpty()) {
            content = content.replaceAll("\\\\", "\\\\\\\\");
            content = content.replaceAll("_", "\\\\_");
            content = content.replaceAll("%", "\\\\%");
            content = content.replaceAll("'", "\\\\'");
        }
        return content;
    }

    private void openEditPage(String id) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        if (StringUtils.isNotEmpty((String)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("isAdd", (Object)false);
            showParameter.setCustomParam(ID, (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u6c99\u76d8\u6a21\u62df\u753b\u5e03", (String)"AnalysisCanvasListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("isAdd", (Object)true);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6c99\u76d8\u6a21\u62df\u753b\u5e03", (String)"AnalysisCanvasListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openEnjoyRecordPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_analysiscanvas_record");
        parameter.setCaption(ResManager.loadKDString((String)"\u6c99\u76d8\u6a21\u62df\u5206\u4eab\u5217\u8868", (String)"AnalysisCanvasListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDesignPage(Long id) {
        AnalysisCanvas canvas;
        block6: {
            canvas = AnalysisCanvasService.getInstance().load(id);
            String status = canvas.getStatus();
            if (AnalysisCanvasConstants.Status.SAVE.getValue().equals(status)) {
                String userId = String.valueOf(UserUtils.getUserId());
                String userInfo = AnalysisCanvasControlHelper.getUserInfo();
                String fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + id), String.class);
                JSONObject getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
                if (getUserInfo != null && !getUserInfo.get((Object)"userId").equals(userId)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\uff1a[%1]\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"AnalysisCanvasListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{getUserInfo.get((Object)"userName")}));
                    return;
                }
                DLock dLock = DLock.createReentrant((String)("analysisCanvas:dLock:" + id));
                dLock.fastMode();
                boolean b = dLock.tryLock();
                try {
                    if (b) {
                        CacheServiceHelper.put((String)("analysisCanvas:lock:" + id), (Object)userInfo, (int)1800);
                        break block6;
                    }
                    fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + id), String.class);
                    getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\uff1a[%1]\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"AnalysisCanvasListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{getUserInfo.get((Object)"userName")}));
                    return;
                }
                finally {
                    dLock.unlock();
                }
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        IFormView mainView = this.getView().getMainView();
        showParameter.setPageId("eb_analysiscanvas_design_" + (mainView == null ? "" : mainView.getPageId()) + "_" + id);
        showParameter.setFormId("eb_analysiscanvas_design");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openDesignCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u6c99\u76d8\u6a21\u62df-%1", (String)"AnalysisCanvasListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{canvas.getName()}));
        showParameter.setCustomParam(ID, (Object)id);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void openEnjoyUserPage(String key) {
        List<Long> canvasIds = "btn_enjoy".equals(key) ? this.getCanvasIds() : Collections.singletonList(this.getFocusId());
        List canvasList = AnalysisCanvasService.getInstance().load(canvasIds);
        if (canvasList.stream().allMatch(c -> AnalysisCanvasConstants.ShareType.SHARE.getValue().equals(c.getShare()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u753b\u5e03\u65e0\u9700\u5206\u4eab\u5373\u53ef\u67e5\u770b\u3002", (String)"AnalysisCanvasListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter(ID, "!=", (Object)this.getUserId()));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void openCatePage(boolean isAddNew) {
        String nodeId = ((TreeView)this.getControl(TREE_NAME)).getTreeState().getFocusNodeId();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_analysiscanvas_cate");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addCateCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        if (!isAddNew) {
            if (this.isRootCatalog(nodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AnalysisCanvasListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            showParameter.setPkId((Object)nodeId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u6c99\u76d8\u5206\u7c7b", (String)"AnalysisCanvasListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            if (this.isFiveLevel(nodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6c99\u76d8\u5206\u7c7b\u4ec5\u5141\u8bb8\u65b0\u589e\u81f3\u7b2c5\u7ea7\u3002", (String)"AnalysisCanvasListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("parent", (Object)nodeId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6c99\u76d8\u5206\u7c7b", (String)"AnalysisCanvasListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openAddCollectPage() {
        List<Long> ids = this.getCanvasIds();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_analysiscanvas_move");
        showParameter.setCustomParam(ID, ids);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addCollectCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void checkCanvasPublish(AnalysisCanvasConstants.Status status, List<Long> canvasIds) {
        DynamicObjectCollection dynamicObjects = AnalysisCanvasService.getInstance().queryCanvasCreator(canvasIds);
        dynamicObjects.forEach(creator -> {
            if (creator == null) {
                return;
            }
            if (status == AnalysisCanvasConstants.Status.SAVE) {
                return;
            }
            long id = creator.getLong(ID);
            String fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + id), String.class);
            JSONObject getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
            if (getUserInfo != null) {
                String name = creator.getString(NAME);
                String opDesc = ResManager.loadResFormat((String)"\u7528\u6237\u201c%2\u201d\u6b63\u5728\u7f16\u8f91\u6c99\u76d8\u201c%1\u201d\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"AnalysisCanvasListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{String.valueOf(name), getUserInfo.get((Object)"userName")});
                throw new KDBizException(opDesc);
            }
        });
    }

    private void checkCanvasDel(String key, List<Long> canvasIds) {
        DynamicObjectCollection status = AnalysisCanvasService.getInstance().queryCanvasStatus(canvasIds);
        status.forEach(d -> {
            if (AnalysisCanvasConstants.Status.RELEASE.getValue().equals(d.getString("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u5206\u6790\u753b\u5e03\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AnalysisCanvasListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6570\u636e\uff1f", (String)"AnalysisCanvasListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
    }

    private void checkCanvasUnCollect() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u6536\u85cf\u6570\u636e\uff1f", (String)"AnalysisCanvasListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_uncollect", (IFormPlugin)this));
    }

    private void checkCateDelete() {
        String nodeId = ((TreeView)this.getControl(TREE_NAME)).getTreeState().getFocusNodeId();
        if (this.isRootCatalog(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExamineListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (AnalysisCanvasCateService.getInstance().isDefault(IDUtils.toLong((Object)nodeId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AnalysisCanvasListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6c99\u76d8\u5c06\u88ab\u79fb\u52a8\u5230\u4e0a\u7ea7\u5206\u7c7b\u4e0b\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AnalysisCanvasListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CATE_DELETE, (IFormPlugin)this));
    }

    private void delData(String key) {
        List<Long> ids = key.equals("btn_del") ? this.getCanvasIds() : Collections.singletonList(this.getFocusId());
        AnalysisCanvasService.getInstance().delete(ids);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "AnalysisCanvasListPlugin_19", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u5220\u9664\u6210\u529f\u3002", "AnalysisCanvasListPlugin_7", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "delete", opName, opDesc, new String[]{ids.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisCanvasListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.initTree();
    }

    private void copyData() {
        Long id = this.getFocusId();
        AnalysisCanvasService.getInstance().copy(id);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u5236", "AnalysisCanvasListPlugin_10", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u590d\u5236\u6210\u529f\u3002", "AnalysisCanvasListPlugin_9", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "copy", opName, opDesc, new String[]{id.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalysisCanvasListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.initTree();
    }

    private void publish(AnalysisCanvasConstants.Status status, List<Long> ids) {
        MultiLangEnumBridge opDesc;
        MultiLangEnumBridge opName;
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (status == AnalysisCanvasConstants.Status.RELEASE) {
            AnalysisCanvasService.getInstance().updateStatus(AnalysisCanvasConstants.Status.RELEASE, ids);
            opName = new MultiLangEnumBridge("\u53d1\u5e03", "AnalysisCanvasListPlugin_17", "epm-eb-formplugin");
            opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u5df2\u6210\u529f\u53d1\u5e03\u3002", "AnalysisCanvasListPlugin_14", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), PUBLISH, opName, opDesc, new String[]{ids.toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisCanvasListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (status == AnalysisCanvasConstants.Status.SAVE) {
            AnalysisCanvasService.getInstance().updateStatus(AnalysisCanvasConstants.Status.SAVE, ids);
            opName = new MultiLangEnumBridge("\u53d6\u6d88\u53d1\u5e03", "AnalysisCanvasListPlugin_18", "epm-eb-formplugin");
            opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfid\uff1a%1$s\u53d6\u6d88\u53d1\u5e03\u6210\u529f\u3002", "AnalysisCanvasListPlugin_11", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "cancel_publish", opName, opDesc, new String[]{ids.toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5df2\u53d6\u6d88\u3002", (String)"AnalysisCanvasListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshData();
    }

    private void unCollectData() {
        List<Long> canvasIds = this.getCanvasIds();
        String nodeId = ((TreeView)this.getControl(TREE_NAME)).getTreeState().getFocusNodeId();
        List<Long> childrenIds = this.getChildrenIds(nodeId);
        AnalysisCanvasCollectService.getInstance().delete(childrenIds, canvasIds);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u6536\u85cf", "AnalysisCanvasListPlugin_32", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u6536\u85cf\u5df2\u53d6\u6d88\u3002", "AnalysisCanvasListPlugin_33", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "uncollect", opName, opDesc, new String[]{canvasIds.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u5df2\u53d6\u6d88\u3002", (String)"AnalysisCanvasListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void deleteCate() {
        String nodeId = ((TreeView)this.getControl(TREE_NAME)).getTreeState().getFocusNodeId();
        List<Long> childrenIds = this.getChildrenIds(nodeId);
        AnalysisCanvasCateService.getInstance().delete(IDUtils.toLong((Object)nodeId), childrenIds);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u7c7b\u5220\u9664", "AnalysisCanvasListPlugin_36", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u5206\u7c7b\u5df2\u5220\u9664\u3002", "AnalysisCanvasListPlugin_37", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "deleteCate", opName, opDesc, new String[]{childrenIds.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisCanvasListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addCloseCallback".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (MapUtils.isEmpty((Map)returnData)) {
                this.initTree();
                return;
            }
            Long id = IDUtils.toLong(returnData.get(ID));
            if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
                this.initTree();
                this.openDesignPage(id);
            }
        }
        if ("btn_enjoy".equals(actionId) || B_ENJOY.equals(actionId)) {
            this.shareRecord(actionId, closedCallBackEvent);
        }
        if ("addCateCloseCallback".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            this.initTree();
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        this.getPageCache().put(CURR_NODE, nodeId.toString());
        this.refreshData();
    }

    private QFilter getQFilter() {
        String nodeId = this.getPageCache().get(CURR_NODE);
        AnalysisCanvasType type = AnalysisCanvasType.getEnumByValue(nodeId);
        QFilter qFilter = this.getDealProcessFilter();
        if (qFilter == null) {
            qFilter = new QFilter("1", "=", (Object)1);
        }
        if (!TAB_COLLECT.equals(this.getPageCache().get(TREE_TOOLBAR))) {
            QFilter qFilter1;
            List ids;
            if (type == AnalysisCanvasType.ALL) {
                ids = AnalysisCanvasShareService.getInstance().querySuccessShareIds();
                qFilter1 = new QFilter("creater", "=", (Object)RequestContext.get().getCurrUserId());
                qFilter1.or(new QFilter("share", "=", (Object)"1"));
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    qFilter1.or(ID, "in", (Object)ids);
                }
                qFilter.and(qFilter1);
            }
            if (type == AnalysisCanvasType.CREATE || type == AnalysisCanvasType.C_PRIVATE || type == AnalysisCanvasType.C_SHARE) {
                qFilter.and(new QFilter("creater", "=", (Object)RequestContext.get().getCurrUserId()));
                if (type == AnalysisCanvasType.C_PRIVATE || type == AnalysisCanvasType.C_SHARE) {
                    qFilter.and("share", "=", (Object)(type == AnalysisCanvasType.C_PRIVATE ? "0" : "1"));
                }
            }
            if (type == AnalysisCanvasType.PRIVATE || type == AnalysisCanvasType.P_PRIVATE || type == AnalysisCanvasType.P_SHARE) {
                ids = AnalysisCanvasShareService.getInstance().querySuccessShareIds();
                qFilter1 = new QFilter("share", "=", (Object)"1").and("creater", "!=", (Object)RequestContext.get().getCurrUserId());
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    qFilter1.or(ID, "in", (Object)ids);
                }
                qFilter.and(qFilter1);
                if (type == AnalysisCanvasType.P_PRIVATE || type == AnalysisCanvasType.P_SHARE) {
                    qFilter.and("share", "=", (Object)(type == AnalysisCanvasType.P_PRIVATE ? "0" : "1"));
                }
            }
        } else {
            List<Long> childrenIds = this.getChildrenIds(nodeId);
            List ids = AnalysisCanvasCollectService.getInstance().queryCanvasIdByCate(childrenIds);
            qFilter.and(ID, "in", (Object)ids);
        }
        return qFilter;
    }

    private void refreshData() {
        QFilter qFilter = this.getQFilter();
        if (this.getListStatus().booleanValue()) {
            this.refreshListData(qFilter);
        } else {
            DynamicObject[] data = AnalysisCanvasService.getInstance().queryAllData(qFilter);
            this.refreshEntryEntity(data);
        }
    }

    private void refreshEntryEntity(DynamicObject[] data) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (data == null || data.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, data.length);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        AtomicInteger row = new AtomicInteger(0);
        for (DynamicObject e : data) {
            int i = row.getAndIncrement();
            this.getModel().setValue(ID, (Object)e.getString(ID), i);
            this.getModel().setValue(NAME, (Object)e.getString(NAME), i);
            this.getModel().setValue(NUMBER, (Object)ResManager.loadResFormat((String)"\u7f16\u7801\uff1a%1", (String)"AnalysisCanvasListPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getString(NUMBER)}), i);
            this.getModel().setValue(MODEL, (Object)ResManager.loadResFormat((String)"\u4f53\u7cfb\uff1a%1", (String)"AnalysisCanvasListPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getString(MODEL)}), i);
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadResFormat((String)"\u63cf\u8ff0\uff1a%1", (String)"AnalysisCanvasListPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getString(DESCRIPTION) != null ? e.getString(DESCRIPTION) : ""}), i);
            this.getModel().setValue(MODIFIER, (Object)ResManager.loadResFormat((String)"\u4fee\u6539\u4eba\uff1a%1", (String)"AnalysisCanvasListPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getString("modifier.name")}), i);
            this.getModel().setValue(MODIFY_DATE, (Object)ResManager.loadResFormat((String)"\u4fee\u6539\u65f6\u95f4\uff1a%1", (String)"AnalysisCanvasListPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[]{DateTimeUtils.format((Date)e.getDate(MODIFY_DATE))}), i);
            if (AnalysisCanvasConstants.Status.RELEASE.getValue().equals(e.getString("status"))) {
                cardEntry.setChildVisible(false, i, new String[]{STAGING, B_PUBLISH});
            } else {
                cardEntry.setChildVisible(false, i, new String[]{PUBLISH, B_STAGING});
            }
            if ("0".equals(e.getString("share"))) {
                cardEntry.setChildVisible(false, i, new String[]{ENJOY});
                continue;
            }
            cardEntry.setChildVisible(false, i, new String[]{SELF});
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void refreshListData(QFilter qFilter) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setFilter(qFilter);
        billList.setClearSelection(true);
        billList.refresh();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.deleteAllNodes();
        TreeNode root = this.getTreeNode();
        treeView.addNode(root);
        TreeNode focusNode = root;
        String curNodeId = this.getPageCache().get(CURR_NODE);
        if (StringUtils.isNotEmpty((String)curNodeId) && (focusNode = root.getTreeNode(curNodeId, 5)) == null) {
            focusNode = root;
        }
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
        this.treeNodeClick(evt);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)root));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        this.expendNode(true, true);
        treeView.focusNode(focusNode);
    }

    private void expandCurrentNode(TreeNode treenode, boolean state) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(state);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode node : nodes) {
                this.expandCurrentNode(node, state);
            }
        }
    }

    private void expendNode(boolean isAll, boolean isExpand) {
        TreeView tree = (TreeView)this.getControl(TREE_NAME);
        TreeNode root = this.getLeftTree();
        TreeNode currentNode = isAll ? root : root.getTreeNode(tree.getTreeState().getFocusNodeId(), 5);
        this.expandCurrentNode(currentNode, isExpand);
        tree.updateNode(currentNode);
    }

    private TreeNode getLeftTree() {
        String cache = this.getPageCache().get("treeCacheName");
        if (cache == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u3002", (String)"AnalysisCanvasListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
    }

    private TreeNode getTreeNode() {
        if (TAB_COLLECT.equals(this.getPageCache().get(TREE_TOOLBAR))) {
            return AnalysisCanvasCateService.getInstance().getCateTree();
        }
        return this.getRootNode();
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode();
        AnalysisCanvasType all = AnalysisCanvasType.ALL;
        root.setId(all.getValue());
        root.setParentid("");
        root.setText(all.getName());
        root.setIsOpened(true);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        root.setChildren(children);
        this.addAnalysisCanvasTypes(children);
        return root;
    }

    private void addAnalysisCanvasTypes(List<TreeNode> children) {
        TreeNode createNode = new TreeNode();
        createNode.setId(AnalysisCanvasType.CREATE.getValue());
        createNode.setParentid(AnalysisCanvasType.ALL.getValue());
        createNode.setText(AnalysisCanvasType.CREATE.getName());
        createNode.setChildren(this.addCreateChild());
        createNode.setIsOpened(true);
        children.add(createNode);
        TreeNode privateNode = new TreeNode();
        privateNode.setId(AnalysisCanvasType.PRIVATE.getValue());
        privateNode.setParentid(AnalysisCanvasType.ALL.getValue());
        privateNode.setText(AnalysisCanvasType.PRIVATE.getName());
        privateNode.setChildren(this.addPrivateChild());
        privateNode.setIsOpened(true);
        children.add(privateNode);
    }

    private List<TreeNode> addCreateChild() {
        TreeNode privateNode = new TreeNode();
        privateNode.setId(AnalysisCanvasType.C_PRIVATE.getValue());
        privateNode.setParentid(AnalysisCanvasType.CREATE.getValue());
        privateNode.setText(AnalysisCanvasType.C_PRIVATE.getName());
        privateNode.setIsOpened(true);
        TreeNode shareNode = new TreeNode();
        shareNode.setId(AnalysisCanvasType.C_SHARE.getValue());
        shareNode.setParentid(AnalysisCanvasType.CREATE.getValue());
        shareNode.setText(AnalysisCanvasType.C_SHARE.getName());
        shareNode.setIsOpened(true);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(2);
        children.add(privateNode);
        children.add(shareNode);
        return children;
    }

    private List<TreeNode> addPrivateChild() {
        TreeNode privateNode = new TreeNode();
        privateNode.setId(AnalysisCanvasType.P_PRIVATE.getValue());
        privateNode.setParentid(AnalysisCanvasType.PRIVATE.getValue());
        privateNode.setText(AnalysisCanvasType.P_PRIVATE.getName());
        TreeNode shareNode = new TreeNode();
        shareNode.setId(AnalysisCanvasType.P_SHARE.getValue());
        shareNode.setParentid(AnalysisCanvasType.PRIVATE.getValue());
        shareNode.setText(AnalysisCanvasType.P_SHARE.getName());
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(2);
        children.add(privateNode);
        children.add(shareNode);
        return children;
    }

    private List<Long> getCanvasIds() {
        if (this.getListStatus().booleanValue()) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            return selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        int[] selectedRows = cardEntry.getEntryState().getSelectedRows();
        return Arrays.stream(selectedRows).mapToObj(i -> IDUtils.toLong((Object)this.getModel().getValue(ID, i))).collect(Collectors.toList());
    }

    private Long getFocusId() {
        if (this.getListStatus().booleanValue()) {
            return IDUtils.toLong((Object)((BillList)this.getControl("billlistap")).getFocusRowPkId());
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        return IDUtils.toLong((Object)this.getModel().getValue(ID, focusRow));
    }

    private void shareRecord(String key, ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ArrayList<Long> receivers = new ArrayList<Long>(returnData.size());
        for (ListSelectedRow selectedRow : returnData) {
            Long userId = (Long)selectedRow.getPrimaryKeyValue();
            receivers.add(userId);
        }
        List<Long> canvasIds = "btn_enjoy".equals(key) ? this.getCanvasIds() : Collections.singletonList(this.getFocusId());
        List canvasList = AnalysisCanvasService.getInstance().load(canvasIds);
        List shareCanvasList = canvasList.stream().filter(c -> AnalysisCanvasConstants.ShareType.SELF.getValue().equals(c.getShare())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shareCanvasList)) {
            return;
        }
        canvasIds = shareCanvasList.stream().map(AnalysisCanvas::getId).collect(Collectors.toList());
        DynamicObjectCollection queryReceiver = AnalysisCanvasShareService.getInstance().querySuccessReceiver(canvasIds);
        DynamicObjectCollection creators = AnalysisCanvasService.getInstance().queryCanvasCreator(canvasIds);
        ArrayList dataList = new ArrayList();
        Long userId = this.getUserId();
        canvasIds.forEach(id -> receivers.forEach(receiverId -> {
            String status = AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue();
            String reason = "";
            if (creators.stream().anyMatch(p -> id.equals(p.getLong(ID)) && receiverId.equals(p.getLong("creater")))) {
                status = AnalysisCanvasConstants.ShareStatus.FAIL.getValue();
                reason = ResManager.loadKDString((String)"\u521b\u5efa\u4eba\u5df2\u6709\u6c99\u76d8\u6743\u9650\uff0c\u65e0\u9700\u5206\u4eab\u3002", (String)"AnalysisCanvasListPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if (queryReceiver.stream().anyMatch(p -> id.equals(p.getLong("canvasid")) && receiverId.equals(p.getLong("receiver")))) {
                status = AnalysisCanvasConstants.ShareStatus.FAIL.getValue();
                reason = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u62e5\u6709\u6c99\u76d8\u6743\u9650\uff0c\u65e0\u9700\u5206\u4eab\u3002", (String)"AnalysisCanvasListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            AnalysisCanvasShare a = new AnalysisCanvasShare();
            a.setCanvasId(id);
            a.setSharers(userId);
            a.setReceiver(receiverId);
            a.setLook("0");
            a.setStatus(status);
            a.setReason(reason);
            dataList.add(a);
        }));
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        if (dataList.stream().allMatch(e -> AnalysisCanvasConstants.ShareStatus.FAIL.getValue().equals(e.getStatus()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u5b58\u5728\u5931\u8d25\uff0c\u5728\u5206\u4eab\u8bb0\u5f55\u67e5\u770b\u8be6\u60c5\u3002", (String)"AnalysisCanvasListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u6210\u529f\u3002", (String)"AnalysisCanvasListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        AnalysisCanvasShareService.getInstance().save(dataList);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u4eab", "AnalysisCanvasListPlugin_40", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u88ab\u7528\u6237\uff1a%2$s\u5206\u4eab\u7ed9%3$s\u3002", "AnalysisCanvasListPlugin_41", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "share", opName, opDesc, new String[]{canvasIds.toString(), userId.toString(), ((Object)receivers).toString()});
    }

    private Boolean getListStatus() {
        String listStatus = this.getPageCache().get("listStatus");
        return Boolean.parseBoolean(listStatus);
    }

    private void switchListOrCard(Boolean status) {
        VectorAp list = new VectorAp();
        VectorAp card = new VectorAp();
        list.setKey(BTN_LIST);
        card.setKey(BTN_CARD);
        list.setfontClass("kdfont kdfont-shitu_liebiao3");
        card.setfontClass("kdfont kdfont-shitu_kapian2");
        if (status.booleanValue()) {
            list.setForeColor("#76a4e9");
            card.setForeColor("#cccccc");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billlistap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
        } else {
            list.setForeColor("#cccccc");
            card.setForeColor("#76a4e9");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billlistap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTRY_ENTITY});
        }
        this.getPageCache().put("listStatus", status.toString());
        this.getView().updateControlMetadata(BTN_LIST, list.createControl());
        this.getView().updateControlMetadata(BTN_CARD, card.createControl());
    }

    private boolean isRootCatalog(String nodeId) {
        TreeNode leftTree = this.getLeftTree();
        TreeNode focusNode = leftTree.getTreeNode(nodeId, 5);
        return "".equals(focusNode.getParentid());
    }

    private boolean isFiveLevel(String nodeId) {
        TreeNode leftTree = this.getLeftTree();
        int nodeLevel = leftTree.getNodeLevel(nodeId, 0);
        return nodeLevel >= 5;
    }

    private List<Long> getChildrenIds(String pNodeId) {
        TreeNode root = this.getTreeNode();
        TreeNode current = root.getTreeNode(pNodeId, 5);
        ArrayList<Long> children = new ArrayList<Long>();
        children.add(IDUtils.toLong((Object)pNodeId));
        this.cycleNode(current, c -> children.add(IDUtils.toLong((Object)c.getId())));
        return children;
    }

    private void cycleNode(TreeNode pNode, Consumer<TreeNode> cs) {
        if (pNode.getChildren() == null) {
            return;
        }
        pNode.getChildren().forEach(c -> {
            cs.accept((TreeNode)c);
            this.cycleNode((TreeNode)c, cs);
        });
    }

    private void checkIsSelectData(List<Long> canvasIds) {
        if (CollectionUtils.isEmpty(canvasIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"AnalysisCanvasListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectOneData(List<Long> canvasIds) {
        if (canvasIds.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AnalysisCanvasListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

