/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCateService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class AnalysisCanvasMovePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TREE_NAME = "treeviewap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "close"});
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREE_NAME)));
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.deleteAllNodes();
        TreeNode root = AnalysisCanvasCateService.getInstance().getCateTree();
        treeView.addNode(root);
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)root.getParentid(), (Object)root.getId());
        this.treeNodeClick(evt);
        this.expandTreeNode(root);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)root));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        treeView.focusNode(root);
    }

    private void expandTreeNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (CollectionUtils.isNotEmpty((Collection)treenode.getChildren())) {
            treenode.getChildren().forEach(this::expandTreeNode);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btn_save".equals(key)) {
            this.addCollect();
        }
    }

    private void addCollect() {
        String newNodeId = ((TreeView)this.getControl(TREE_NAME)).getTreeState().getFocusNodeId();
        List canvasIds = (List)this.getView().getFormShowParameter().getCustomParam("id");
        AnalysisCanvasCollectService.getInstance().save(IDUtils.toLong((Object)newNodeId), canvasIds);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62df\u6536\u85cf", "AnalysisCanvasMovePlugin_0", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62dfID\uff1a%1$s\u5df2\u6536\u85cf\u3002", "AnalysisCanvasMovePlugin_1", "epm-eb-formplugin");
        AnalysisLogService.getInstance().writeOperateLog(this.getView(), "collect", opName, opDesc, new String[]{canvasIds.toString()});
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"AnalysisCanvasMovePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().returnDataToParent((Object)newNodeId);
        this.getView().close();
    }
}

