/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCommentService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasComment;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysiscanvas.CustomItemEvent;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasPluginConstants;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasNotePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillList();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_add_comment", "btn_del_comment", "btn_refresh_comment"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(evt -> evt.getQFilters().add(this.getQFilter()));
        billList.setOrderBy("id desc");
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        switch (key) {
            case "btn_add_comment": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                Object comment = this.getModel().getValue("field_comment");
                if (comment == null || StringUtils.isEmpty((String)comment.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6279\u6ce8\uff01", (String)"AnalysisCanvasDesignPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                AnalysisCanvasCommentService.getInstance().save(this.getCanvasId(), this.getUsedBoxId(), comment.toString(), IDUtils.toLong((Object)this.getItem().getId()));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6dfb\u52a0\u6279\u6ce8", "AnalysisCanvasDesignPlugin_27", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_10", "epm-eb-formplugin");
                AnalysisLogService.getInstance().writeOperateLog(this.getView(), "addComment", opName, opDesc, null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("field_comment", (Object)"");
                this.refreshBillList();
                break;
            }
            case "btn_del_comment": {
                if (this.checkAnalysisCanvasStatus()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u753b\u5e03\u5df2\u8c03\u6574\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"AnalysisCanvasDesignPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmQuit", (IFormPlugin)this));
                    return;
                }
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(ids)) {
                    return;
                }
                AnalysisCanvasComment comment = AnalysisCanvasCommentService.getInstance().load((Long)ids.get(0));
                if (RequestContext.get().getCurrUserId() != IDUtils.toLong((Object)comment.getCreatorId()).longValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u81ea\u5df1\u7684\u6279\u6ce8\u3002", (String)"AnalysisCanvasDesignPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkIfRevoke(comment.getCreateDate())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc75\u5206\u949f\uff0c\u4e0d\u80fd\u518d\u64a4\u9500\u8be5\u6279\u6ce8\u3002", (String)"AnalysisCanvasDesignPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u64a4\u9500\u8be5\u6761\u6279\u6ce8\uff1f", (String)"AnalysisCanvasDesignPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDelComment", (IFormPlugin)this));
                break;
            }
            case "btn_refresh_comment": {
                this.refreshBillList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDelComment".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doDelComment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelComment() {
        try {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            AnalysisCanvasCommentService.getInstance().delete((Long)ids.get(0));
            this.refreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6279\u6ce8\u64a4\u9500", "AnalysisCanvasDesignPlugin_26", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u64a4\u9500\u6210\u529f\u3002", "AnalysisCanvasDesignPlugin_12", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "delComment", opName, opDesc, null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"AnalysisCanvasDesignPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (AnalysisCanvasException ex) {
            this.getView().showTipNotification(ex.getMessage());
            CustomItemEvent.getInstance().sendEvent(this.getView(), AnalysisCanvasPluginConstants.Event.EVENT_CLEAR);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setFilter(this.getQFilter());
        billList.setOrderBy("id desc");
        billList.setClearSelection(true);
        billList.refresh();
    }

    private QFilter getQFilter() {
        QFilter qFilter = new QFilter("itemid", "=", (Object)IDUtils.toLong((Object)this.getItem().getId()));
        qFilter.and("sandboxid", "=", (Object)this.getUsedBoxId());
        return qFilter;
    }

    private CustomItem getItem() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("customItem");
        return (CustomItem)JSONObject.parseObject((String)customParam, CustomItem.class);
    }

    private Long getCanvasId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("canvasId");
    }

    private Long getUsedBoxId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("usedBoxId");
    }

    private boolean checkAnalysisCanvasStatus() {
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(this.getCanvasId());
        return AnalysisCanvasConstants.Status.SAVE.getValue().equals(canvas.getStatus());
    }

    private boolean checkIfRevoke(String createDate) {
        Date dateStart;
        try {
            dateStart = DateTimeUtils.parseDate((String)createDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Date dateEnd = DateTimeUtils.addMinute((Date)dateStart, (long)5L);
        return dateEnd.getTime() < new Date().getTime();
    }
}

