/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasRelateConfigPlugin
extends AbstractBasePlugin
implements ClickListener {
    private static final String TARGET_ITEM = "targetitem";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JSONObject jsonObj = JSON.parseObject((String)params.get("evtArgs").toString());
        CustomItem currItem = (CustomItem)jsonObj.getJSONObject("item").toJavaObject(CustomItem.class);
        List itemList = jsonObj.getJSONArray("items").toJavaList(CustomItem.class);
        this.initData(currItem, itemList);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    private void initData(CustomItem currItem, List<CustomItem> itemList) {
        List relationId;
        ArrayList dataList = new ArrayList();
        itemList.forEach(item -> {
            Long baseBusModel;
            if (item.getId().equals(currItem.getId())) {
                return;
            }
            if (!(item.getType().equals("chart") || item.getType().equals("bizindicator") || item.getType().equals("table") || item.getType().equals("dupontnode") || item.getType().equals("table2"))) {
                return;
            }
            BaseModel currModel = ModelHelper.getModel((CustomItem)currItem);
            BaseModel baseModel = ModelHelper.getModel((CustomItem)item);
            if (currModel == null || baseModel == null) {
                return;
            }
            if (!currModel.getModel().equals(baseModel.getModel())) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)currModel.getModel()));
            Long currBusModel = modelCache.getBusModelByDataSet(IDUtils.toLong((Object)currModel.getDataset()));
            if (!currBusModel.equals(baseBusModel = modelCache.getBusModelByDataSet(IDUtils.toLong((Object)baseModel.getDataset())))) {
                return;
            }
            dataList.add(new ComboItem(new LocaleString(item.getName()), item.getId()));
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl(TARGET_ITEM);
        comboEdit.setComboItems(dataList);
        BaseModel model = ModelHelper.getModel((CustomItem)currItem);
        if (model != null && CollectionUtils.isNotEmpty((Collection)(relationId = model.getRelationId()))) {
            relationId.removeIf(next -> itemList.stream().noneMatch(item -> item.getId().equals(next)));
            relationId.removeIf(next -> dataList.stream().noneMatch(item -> item.getValue().equals(next)));
            String selectedVal = String.join((CharSequence)",", relationId);
            this.getModel().setValue(TARGET_ITEM, (Object)selectedVal);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_ok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("ids", this.getModel().getValue(TARGET_ITEM));
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }
}

