/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasVarService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasVar;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.analysiscanvas.report.IReportHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.utils.ReportVar.TemplateDataVarType;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasReportConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String VARIABLE = "variable";
    private static final String SELECT_VARIABLE_CLOSE_CALLBACK = "selectVariableCloseCallBack";
    private static final String VARIABLE_ENTRY_ENTITY = "variableentryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        JSONObject reportModelJson = customItem.getC().getJSONObject("reportModel");
        if (reportModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            ReportModel reportModel = (ReportModel)reportModelJson.toJavaObject(ReportModel.class);
            Long modelId = IDUtils.toLong((Object)reportModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)reportModel.getDataset());
            Long tempId = IDUtils.toLong((Object)reportModel.getTempId());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            this.getPageCache().put("template", String.valueOf(tempId));
            this.getModel().setValue("template", (Object)tempId);
            this.initVariableEntryEntity(String.valueOf(tempId), true);
            JSONObject dimensionViews = reportModel.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dims = reportModel.getDims();
            List dimMembers = dims.stream().map(DimensionModel::getDim).collect(Collectors.toList());
            List dimensionList = modelCache.getDimensionList(dataSetId);
            List<String> ignoreDimNumbers = dimensionList.stream().map(BaseCache::getNumber).filter(number -> !dimMembers.contains(number)).collect(Collectors.toList());
            AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, dims, dimensionViews, AnalysisCanvasEnum.report, ignoreDimNumbers);
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.report, ignoreDimNumbers);
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.report, Collections.emptyList());
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", "btn_config", "dimmember", "dimselect", VARIABLE});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit template = (BasedataEdit)this.getControl("template");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
        if ("template".equals(e.getProperty().getName())) {
            String datasetId = this.getPageCache().get("dataset");
            if (StringUtils.isNotBlank((CharSequence)datasetId)) {
                e.addCustomQFilter(new QFilter("dataset", "=", (Object)IDUtils.toLong((Object)datasetId)));
                e.getFormShowParameter().setCustomParam("analysis.modelId", (Object)this.getModelId());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AnalysisCanvasDesignPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.report, Collections.emptyList());
                this.getModel().setValue("template", null);
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("template".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String templateId = newVal.getString("id");
                this.getPageCache().put("template", templateId);
                this.clearDimEntry();
                this.initVariableEntryEntity(templateId, false);
                this.initDimEntry(templateId);
            } else {
                this.getPageCache().put("template", null);
                this.clearDimEntry();
            }
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildReportModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "reportMemberCloseCallback", !isMulti);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId);
        } else if (VARIABLE.equals(ctrlKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(VARIABLE_ENTRY_ENTITY);
            DynamicObject row = this.getModel().getEntryRowEntity(VARIABLE_ENTRY_ENTITY, rowIndex);
            String dimNumber = row.getString("number");
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            this.showMemberSelect(dimNumber);
        }
    }

    private void clearDimEntry() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData(VARIABLE_ENTRY_ENTITY);
    }

    private void initDimEntry(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        Pair<ITemplateModel, String> pair = IReportHelper.getTemplateModel(templateId);
        if (pair == null || pair.getLeft() == null) {
            this.getModel().setValue("template", null);
            return;
        }
        ITemplateModel templateModel = (ITemplateModel)pair.getLeft();
        if (TemplateModelHelper.hasFloat((ITemplateModel)templateModel)) {
            this.getModel().setValue("template", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6d6e\u52a8\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AnalysisCanvasReportConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List pageMemEntry = templateModel.getPagemembentry();
        if (CollectionUtils.isEmpty((Collection)pageMemEntry)) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String canvasId = this.getPageCache().get("canvasId");
        String datasetId = this.getPageCache().get("dataset");
        List dimMembers = pageMemEntry.stream().map(entry -> entry.getDimension().getNumber()).collect(Collectors.toList());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)datasetId));
        List<String> ignoreDimNumbers = dimensionList.stream().map(BaseCache::getNumber).filter(number -> !dimMembers.contains(number)).collect(Collectors.toList());
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.report, ignoreDimNumbers);
    }

    private void initVariableEntryEntity(String templateId, boolean isLoadData) {
        this.getModel().deleteEntryData(VARIABLE_ENTRY_ENTITY);
        HashSet<Long> templateIds = new HashSet<Long>();
        templateIds.add(IDUtils.toLong((Object)templateId));
        Map tempDataVarTypeInfo = TemplateVarCommonUtil.getTempDataVarTypeInfo((Long)this.getModelId(), templateIds);
        TemplateDataVarType tempVarInfo = (TemplateDataVarType)tempDataVarTypeInfo.get(IDUtils.toLong((Object)templateId));
        if (tempVarInfo == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap"});
            return;
        }
        HashMap templateVarDim = new HashMap(16);
        TemplateVarCommonUtil.getVarDimFromTemplateData((String)tempVarInfo.getData(), templateVarDim, (boolean)false);
        if (templateVarDim.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap"});
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        QFilter qFilter = null;
        for (Map.Entry stringListEntry : templateVarDim.entrySet()) {
            String dimNumber = (String)stringListEntry.getKey();
            Dimension dimension = modelCache.getDimension(dimNumber);
            List variable = (List)stringListEntry.getValue();
            Set variables = variable.stream().filter(Objects::nonNull).map(v -> v.contains("@BaseY") || v.contains("@NextY") || v.contains("@LastY") ? "@BaseY" : v).collect(Collectors.toSet());
            if (qFilter == null) {
                qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("number", "in", variables).and("dimension", "=", (Object)dimension.getId());
                continue;
            }
            qFilter.or(new QFilter("model", "=", (Object)this.getModelId()).and("number", "in", variables).and("dimension", "=", (Object)dimension.getId()));
        }
        if (qFilter == null) {
            return;
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)"eb_periodvariable", (String)"name, number, grouptype, dimension", (QFilter[])new QFilter[]{qFilter});
        if (data.isEmpty()) {
            return;
        }
        List varList = isLoadData ? AnalysisCanvasVarService.getInstance().query(IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getId())) : Collections.emptyList();
        this.getModel().batchCreateNewEntryRow(VARIABLE_ENTRY_ENTITY, data.size());
        AtomicInteger row = new AtomicInteger(0);
        data.forEach(a -> {
            int i = row.getAndIncrement();
            Dimension dimension = modelCache.getDimension(Long.valueOf(a.getLong("dimension")));
            this.getModel().setValue("variablename", (Object)a.getString("name"), i);
            this.getModel().setValue("variablenumber", (Object)a.getString("number"), i);
            this.getModel().setValue("name", (Object)dimension.getName(), i);
            this.getModel().setValue("number", (Object)dimension.getNumber(), i);
            this.getModel().setValue("variabletype", (Object)a.getString("grouptype"), i);
            Optional<AnalysisCanvasVar> var = varList.stream().filter(v -> v.getDimension().equals(dimension.getNumber()) && v.getVariable().equals(a.getString("number"))).findFirst();
            var.ifPresent(analysisCanvasVar -> {
                this.getModel().setValue("variablejson", (Object)analysisCanvasVar.getVariableJson(), i);
                Map valueMap = (Map)SerializationUtils.fromJsonString((String)analysisCanvasVar.getVariableJson(), Map.class);
                String name = valueMap.get("name").toString();
                this.getModel().setValue(VARIABLE, (Object)name, i);
            });
        });
    }

    private void showMemberSelect(String dimNumber) {
        Map memberInfoMap;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(VARIABLE_ENTRY_ENTITY);
        DynamicObject row = this.getModel().getEntryRowEntity(VARIABLE_ENTRY_ENTITY, rowIndex);
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        String type = row.getString("variabletype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if ("2".equals(type)) {
            f7Param.setCanSelectRoot(false);
            filters.add(new QFilter("level", "<=", (Object)2));
        }
        String memberJson = (String)this.getModel().getValue("variablejson");
        Long viewId = 0L;
        if (StringUtils.isNotEmpty((CharSequence)memberJson) && (memberInfoMap = (Map)SerializationUtils.fromJsonString((String)memberJson, Map.class)) != null) {
            Long memberId = (Long)memberInfoMap.get("id");
            if (IDUtils.isNotNull((Long)memberId)) {
                f7Param.setSelectId(memberId);
            }
            viewId = IDUtils.toLong(memberInfoMap.get("view"));
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            filters.add(new QFilter("dataset", "=", (Object)dataSetId));
        }
        f7Param.setBusModelId(bizModelId);
        f7Param.setViewId(viewId);
        f7Param.setMultiSelect(true);
        f7Param.setEnableView(true);
        f7Param.addCustomCommFilter(filters);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, SELECT_VARIABLE_CLOSE_CALLBACK));
    }

    private void openDropdownConfig(String dimNumber, String relateId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dropdownConfigCloseCallback"));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    private ReportModel buildReportModel() {
        Object template = this.getModel().getValue("template");
        if (template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"AnalysisCanvasReportConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String templateId = ((DynamicObject)template).getString("id");
        DynamicObjectCollection varData = this.getModel().getEntryEntity(VARIABLE_ENTRY_ENTITY);
        if (varData.stream().anyMatch(v -> StringUtils.isEmpty((CharSequence)v.getString("variablejson")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bf9\u6240\u6709\u53d8\u91cf\u8fdb\u884c\u8d4b\u503c\u3002", (String)"AnalysisCanvasReportConfigPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        AnalysisCanvasVarService.getInstance().save(IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getId()), varData);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.report);
        ReportModel reportModel = new ReportModel();
        reportModel.setModel(String.valueOf(this.getModelId()));
        reportModel.setDataset(datasetId);
        reportModel.setDims(dimModels);
        reportModel.setTempId(templateId);
        reportModel.setAdd(Boolean.valueOf(false));
        reportModel.setEdit(Boolean.valueOf(false));
        reportModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return reportModel;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectItemStr = this.getPageCache().get(dimNumber + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("reportMemberCloseCallback".equals(actionId)) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.report);
        }
        if (SELECT_VARIABLE_CLOSE_CALLBACK.equals(actionId)) {
            this.setSelectVariable(evt);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
        this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
        this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
    }

    private void setSelectVariable(ClosedCallBackEvent evt) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(VARIABLE_ENTRY_ENTITY);
        DynamicObject row = this.getModel().getEntryRowEntity(VARIABLE_ENTRY_ENTITY, rowIndex);
        String dimNumber = row.getString("number");
        ListSelectedRowCollection memberInfo = (ListSelectedRowCollection)evt.getReturnData();
        if (memberInfo == null) {
            return;
        }
        for (ListSelectedRow memberDetails : memberInfo) {
            DynamicObject dim = this.getModel().getEntryRowEntity(VARIABLE_ENTRY_ENTITY, rowIndex);
            if (dim == null || !dimNumber.equals(dim.getString("number"))) break;
            String groupType = dim.getString("variabletype");
            if ("2".equals(groupType) && !"2".equals(memberDetails.getDataMap().get("level").toString())) continue;
            HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
            memberInfoMap.put("id", memberDetails.getPrimaryKeyValue());
            memberInfoMap.put("name", memberDetails.getName());
            memberInfoMap.put("number", memberDetails.getNumber());
            memberInfoMap.put("view", memberDetails.getDataMap().get("viewid"));
            this.getModel().setValue(VARIABLE, (Object)memberDetails.getName(), rowIndex);
            String memberJson = SerializationUtils.toJsonString(memberInfoMap);
            this.getModel().setValue("variablejson", (Object)memberJson, rowIndex);
            ++rowIndex;
        }
    }
}

