/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasType;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;

public class AnalysisCanvasShareListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TAB = "tab";
    private static final String TREE_NAME = "treeviewap";
    private static final String CURR_NODE = "currNode";
    private static final String RECEIVE = "receive";
    private static final String SHARE = "share";
    private static final String CONFIRM_CANCEL_SHARE = "confirm_cancel_share";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_cancelshare", "btn_del"});
        this.initTree();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(evt -> evt.getQFilters().add(this.getQFilter()));
        billList.setOrderBy("id");
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "btn_cancelshare": {
                this.cancelShare();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        this.getPageCache().put(CURR_NODE, nodeId.toString());
        this.getView().setVisible(Boolean.valueOf(!AnalysisCanvasType.RECEIVE.getValue().equals(nodeId)), new String[]{"btn_cancelshare"});
        this.refreshBillList();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult()) && CONFIRM_CANCEL_SHARE.equals(callBackId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
            AnalysisCanvasShareService.getInstance().delete(pkArray);
            this.refreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u4eab", "AnalysisCanvasShareListPlugin_4", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6c99\u76d8\u6a21\u62df\u5206\u4eab\u8bb0\u5f55ID\uff1a%1$s\u88ab\u7528\u6237%2$s\u53d6\u6d88\u5206\u4eab\u6210\u529f\u3002", "AnalysisCanvasShareListPlugin_5", "epm-eb-formplugin");
            AnalysisLogService.getInstance().writeOperateLog(this.getView(), "cacel_share", opName, opDesc, new String[]{Arrays.toString(pkArray), this.getUserId().toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u5df2\u53d6\u6d88\u3002", (String)"AnalysisCanvasShareListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        Object pkId = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        this.openDesignPage(AnalysisCanvasShareService.getInstance().queryCanvasId(IDUtils.toLong((Object)pkId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDesignPage(Long id) {
        AnalysisCanvas canvas;
        block6: {
            canvas = AnalysisCanvasService.getInstance().load(id);
            String status = canvas.getStatus();
            if (AnalysisCanvasConstants.Status.SAVE.getValue().equals(status)) {
                String userId = String.valueOf(UserUtils.getUserId());
                String userInfo = AnalysisCanvasControlHelper.getUserInfo();
                String fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + id), String.class);
                JSONObject getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
                if (getUserInfo != null && !getUserInfo.get((Object)"userId").equals(userId)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\uff1a[%1]\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"AnalysisCanvasListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{getUserInfo.get((Object)"userName")}));
                    return;
                }
                DLock dLock = DLock.createReentrant((String)("analysisCanvas:dLock:" + id));
                dLock.fastMode();
                boolean b = dLock.tryLock();
                try {
                    if (b) {
                        CacheServiceHelper.put((String)("analysisCanvas:lock:" + id), (Object)userInfo, (int)1800);
                        break block6;
                    }
                    fromCacheUserInfo = (String)CacheServiceHelper.get((String)("analysisCanvas:lock:" + id), String.class);
                    getUserInfo = JSONObject.parseObject((String)fromCacheUserInfo);
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\uff1a[%1]\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"AnalysisCanvasListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{getUserInfo.get((Object)"userName")}));
                    return;
                }
                finally {
                    dLock.unlock();
                }
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        IFormView mainView = this.getView().getMainView();
        showParameter.setPageId("eb_analysiscanvas_design_" + (mainView == null ? "" : mainView.getPageId()) + "_" + id);
        showParameter.setFormId("eb_analysiscanvas_design");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openDesignCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u6c99\u76d8\u6a21\u62df-%1", (String)"AnalysisCanvasListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{canvas.getName()}));
        showParameter.setCustomParam("id", (Object)id);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.deleteAllNodes();
        TreeNode root = this.getRootNode();
        treeView.addNode(root);
        String curNodeId = AnalysisCanvasType.RECEIVE.getValue();
        TreeNode focusNode = root.getTreeNode(curNodeId, 5);
        TreeNodeEvent evt = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
        this.treeNodeClick(evt);
        treeView.focusNode(focusNode);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setFilter(this.getQFilter());
        billList.setOrderBy("id");
        billList.setClearSelection(true);
        billList.refresh();
    }

    private QFilter getQFilter() {
        QFilter qFilter;
        String currentNode = this.getPageCache().get(CURR_NODE);
        if (RECEIVE.equals(currentNode)) {
            qFilter = new QFilter("receiver", "=", (Object)this.getUserId());
            qFilter.and("status", "=", (Object)AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue());
        } else {
            qFilter = new QFilter("sharers", "=", (Object)this.getUserId());
        }
        return qFilter;
    }

    private void cancelShare() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e\u3002", (String)"AnalysisCanvasShareListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u4eab\u540e\uff0c\u6b64\u6c99\u76d8\u5c06\u4e0d\u4f1a\u5728\u88ab\u5206\u4eab\u4eba\u7684\u201c\u6c99\u76d8\u5217\u8868\u201d\u548c\u201c\u63a5\u6536\u5206\u4eab\u201d\u4e2d\u663e\u793a\uff0c\u662f\u5426\u786e\u5b9a\u53d6\u6d88\u5206\u4eab\uff1f", (String)"AnalysisCanvasShareListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CANCEL_SHARE, (IFormPlugin)this));
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode();
        AnalysisCanvasType all = AnalysisCanvasType.ALL;
        root.setId(all.getValue());
        root.setParentid("");
        root.setText(all.getName());
        root.setDisabled(true);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        root.setChildren(children);
        this.addAnalysisCanvasTypes(children);
        return root;
    }

    private void addAnalysisCanvasTypes(List<TreeNode> children) {
        TreeNode createNode = new TreeNode();
        createNode.setId(AnalysisCanvasType.RECEIVE.getValue());
        createNode.setParentid(AnalysisCanvasType.ALL.getValue());
        createNode.setText(AnalysisCanvasType.RECEIVE.getName());
        children.add(createNode);
        TreeNode privateNode = new TreeNode();
        privateNode.setId(AnalysisCanvasType.SHARE.getValue());
        privateNode.setParentid(AnalysisCanvasType.ALL.getValue());
        privateNode.setText(AnalysisCanvasType.SHARE.getName());
        children.add(privateNode);
    }
}

