/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SplitModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasSplitConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String DIM = "dim";
    private static final String MEMBER = "member";
    private static final String CLOSE_CALLBACK_SPLIT_DIM_MEMBER = "closeCallbackSplitDimMember";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SplitModel splitModel = (SplitModel)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("splitModel")), SplitModel.class);
        String canvasId = (String)this.getView().getFormShowParameter().getCustomParam("canvasId");
        this.getPageCache().put("canvasId", canvasId);
        String chartType = (String)this.getView().getFormShowParameter().getCustomParam("chartType");
        if (!"gauge".equals(chartType)) {
            ComboEdit dim = (ComboEdit)this.getControl(DIM);
            dim.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53c2\u8003\u7ebf\u7ef4\u5ea6", (String)"AnalysisCanvasSplitConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            TextEdit member = (TextEdit)this.getControl(MEMBER);
            member.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53c2\u8003\u7ebf\u6210\u5458", (String)"AnalysisCanvasSplitConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
        this.setInitData(canvasId, splitModel);
    }

    private void setInitData(String canvasId, SplitModel splitModel) {
        Long modelId = IDUtils.toLong((Object)splitModel.getModel());
        Long dataSetId = IDUtils.toLong((Object)splitModel.getDataset());
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("dataset", String.valueOf(dataSetId));
        this.getModel().setValue("dataset", (Object)dataSetId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        this.clearSplitDim();
        this.initSpitDim();
        this.initSplitData(canvasId, splitModel, dataSetId, modelCache);
    }

    private void initSplitData(String canvasId, SplitModel splitModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        JSONObject dimensionViews = splitModel.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        if (splitModel.getDim() != null && splitModel.getMember() != null) {
            AnalysisCanvasUserSelHelper.initSingleMembers(this.getView(), modelCache, dimensionList, dimensionViews, splitModel.getDim(), splitModel.getMember().getNum(), ignoreDimNumbers, DIM, MEMBER, AnalysisCanvasEnum.split);
        }
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, splitModel.getDims(), dimensionViews, AnalysisCanvasEnum.split, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.split, ignoreDimNumbers);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", MEMBER, "dimmember", "dimselect"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.split, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                this.clearSplitDim();
                this.initSpitDim();
                this.getModel().setValue(DIM, null);
                this.getModel().setValue(DIM, (Object)SysDimensionEnum.Account.getNumber());
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            this.clearSplitDim();
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.split, Collections.singletonList(newVal));
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildSplitModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (MEMBER.equals(ctrlKey)) {
            Object bizDim = this.getModel().getValue(DIM);
            if (bizDim == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasDupontConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = bizDim.toString();
            this.openDimSelect(dimNumber, CLOSE_CALLBACK_SPLIT_DIM_MEMBER, true);
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            this.openDimSelect(dimNumber, "varMemberCloseCallback", true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CLOSE_CALLBACK_SPLIT_DIM_MEMBER.equals(actionId) || actionId.startsWith("varMemberCloseCallback")) {
            this.cacheSelectedDim(actionId, evt);
        }
    }

    private void initSpitDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit comboEdit = (ComboEdit)this.getControl(DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        comboEdit.setComboItems(data);
    }

    private void clearSplitDim() {
        this.getModel().setValue(MEMBER, null);
        this.getPageCache().remove("member_select");
    }

    private SplitModel buildSplitModel() {
        Object indicatorDim = this.getModel().getValue(DIM);
        if (indicatorDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasDupontConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object indexDimMember = this.getModel().getValue(MEMBER);
        if (StringUtils.isBlank((CharSequence)String.valueOf(indexDimMember))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u6210\u5458\u3002", (String)"AnalysisCanvasDupontConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.split);
        String indexDim = this.getPageCache().get("member_select");
        List indexItemList = JSON.parseArray((String)indexDim, TextEditSelectItem.class);
        MemberModel member = new MemberModel();
        member.setNum(((TextEditSelectItem)indexItemList.get(0)).getNumber());
        member.setScope(Integer.valueOf(Integer.parseInt(((TextEditSelectItem)indexItemList.get(0)).getScope())));
        SplitModel splitModel = new SplitModel();
        splitModel.setModel(this.getModelId().toString());
        splitModel.setDataset(datasetId);
        splitModel.setDimensionViews(dimensionViews);
        splitModel.setDim(indicatorDim.toString());
        splitModel.setMember(member);
        splitModel.setDims(dimModels);
        return splitModel;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectKey = CLOSE_CALLBACK_SPLIT_DIM_MEMBER.equals(callback) ? MEMBER : dimNumber;
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if (CLOSE_CALLBACK_SPLIT_DIM_MEMBER.equals(actionId)) {
            this.getPageCache().put("member_select", JSON.toJSONString(list));
            this.getModel().setValue(MEMBER, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
        } else {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }
}

