/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.business.analysiscanvas.model.VarRange;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasRememberHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasVarConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String VAR_DIM = "vardim";
    private static final String VAR_NUMBER = "varnumber";
    private static final String VAR_LABEL = "varlabel";
    private static final String VAR_NAME = "varname";
    private static final String VAR_START = "varstart";
    private static final String VAR_END = "varend";
    private static final String VAR_ENTRY = "varentryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        JSONObject varModelJson = customItem.getC().getJSONObject("varModel");
        if (varModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            VarModel varModel = (VarModel)varModelJson.toJavaObject(VarModel.class);
            Long modelId = IDUtils.toLong((Object)varModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)varModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            JSONObject dimensionViews = varModel.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            this.getPageCache().put("dimension_view", dimensionViews.toJSONString());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.clearVarDim();
            this.initVarDim();
            this.initVarData(canvasId, varModel, dataSetId, modelCache, dimensionViews);
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                this.initVarDim();
                this.getModel().setValue(VAR_DIM, (Object)SysDimensionEnum.Account.getNumber());
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.slider, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.slider, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            }
        }
    }

    private void initVarData(String canvasId, VarModel varModel, Long dataSetId, IModelCacheHelper modelCache, JSONObject dimensionViews) {
        JSONObject mainViews;
        List dimensionList = modelCache.getDimensionList(dataSetId);
        String varDim = varModel.getVarDim();
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        if (dimensionList.stream().anyMatch(dimension -> dimension.getNumber().equals(varDim))) {
            this.getModel().setValue(VAR_DIM, (Object)varDim);
            ignoreDimNumbers.add(varDim);
            Long varDimViewId = IDUtils.toLong((Object)dimensionViews.getString(varDim));
            List vars = varModel.getVars();
            ArrayList varItemList = new ArrayList(vars.size());
            this.getModel().batchCreateNewEntryRow(VAR_ENTRY, vars.size());
            AtomicInteger varRow = new AtomicInteger(0);
            vars.forEach(var -> {
                String num = var.getNum();
                Member member = AnalysisCanvasPluginHelper.getMember(modelCache, varDim, varDimViewId, num);
                if (member == null) {
                    return;
                }
                int i = varRow.getAndIncrement();
                TextEditSelectItem item = new TextEditSelectItem();
                item.setName(member.getName());
                item.setNumber(num);
                item.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                varItemList.add(item);
                this.getModel().setValue(VAR_LABEL, (Object)var.getLabel(), i);
                this.getModel().setValue(VAR_NAME, (Object)member.getName(), i);
                this.getModel().setValue(VAR_NUMBER, (Object)num, i);
                this.getModel().setValue(VAR_START, (Object)var.getS(), i);
                this.getModel().setValue(VAR_END, (Object)var.getE(), i);
            });
            if (varItemList.isEmpty()) {
                this.getModel().deleteEntryData(VAR_ENTRY);
            }
            this.getPageCache().put("vardim_select", JSON.toJSONString(varItemList));
        }
        if ((mainViews = varModel.getDimensionViews()) == null) {
            mainViews = new JSONObject();
        }
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, varModel.getDims(), mainViews, AnalysisCanvasEnum.slider, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.slider, ignoreDimNumbers);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", "btn_config", "dimmember", "dimselect"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.slider, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
                this.initVarDim();
                this.getModel().setValue(VAR_DIM, null);
                this.getModel().setValue(VAR_DIM, (Object)SysDimensionEnum.Account.getNumber());
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasRememberHelper.getDataset(this.getPageCache().get("canvasId"), modelId);
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (VAR_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            this.clearVarDim();
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.slider, Collections.singletonList(newVal));
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    private void clearVarDim() {
        this.getModel().deleteEntryData(VAR_ENTRY);
        this.getPageCache().remove("vardim_select");
    }

    private void initVarDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit comboEdit = (ComboEdit)this.getControl(VAR_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        comboEdit.setComboItems(data);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildVarModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_config".equals(ctrlKey)) {
            Object model = this.getModel().getValue("model");
            if (model == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalysisCanvasVarConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Object dataset = this.getModel().getValue("dataset");
            if (dataset == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AnalysisCanvasVarConfigPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Object varDim = this.getModel().getValue(VAR_DIM);
            if (varDim == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasVarConfigPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = varDim.toString();
            this.openDimSelect(dimNumber, "varRangeCloseCallback", false, RangeEnum.ONLY);
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "varMemberCloseCallback", !isMulti, null);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId);
        }
    }

    private void openDropdownConfig(String dimNumber, String relateId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dropdownConfigCloseCallback"));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    private VarModel buildVarModel() {
        Object varDim = this.getModel().getValue(VAR_DIM);
        if (varDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasVarConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection varEntry = this.getModel().getEntryEntity(VAR_ENTRY);
        if (CollectionUtils.isEmpty((Collection)varEntry)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u53c2\u6570\u5217\u8868\u3002", (String)"AnalysisCanvasVarConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List varRanges = varEntry.stream().map(entry -> {
            BigDecimal varEnd;
            String varLabel = entry.getString(VAR_LABEL);
            String varName = entry.getString(VAR_NAME);
            String varNumber = entry.getString(VAR_NUMBER);
            BigDecimal varStart = entry.getBigDecimal(VAR_START);
            if (varStart.compareTo(varEnd = entry.getBigDecimal(VAR_END)) == 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u53d6\u503c\u8303\u56f4[%1]\u7684\u6700\u5c0f\u503c\u4e0d\u80fd\u7b49\u4e8e\u6700\u5927\u503c\u3002", (String)"AnalysisCanvasVarConfigPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{varName}));
            }
            if (varStart.compareTo(varEnd) > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u53d6\u503c\u8303\u56f4[%1]\u7684\u6700\u5c0f\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c\u3002", (String)"AnalysisCanvasVarConfigPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{varName}));
            }
            if (StringUtils.isEmpty((CharSequence)varLabel)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u53c2\u6570\u540d\u79f0\u3002", (String)"AnalysisCanvasVarConfigPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{varName}));
            }
            AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)datasetId), varDim.toString(), IDUtils.toLong((Object)dimensionViews.getString(varDim.toString())), varNumber);
            VarRange varRange = new VarRange();
            varRange.setLabel(varLabel);
            varRange.setName(varName);
            varRange.setNum(varNumber);
            varRange.setS(Long.valueOf(varStart.setScale(0, RoundingMode.CEILING).longValue()));
            varRange.setE(Long.valueOf(varEnd.setScale(0, RoundingMode.CEILING).longValue()));
            return varRange;
        }).collect(Collectors.toList());
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.slider);
        VarModel varModel = new VarModel();
        varModel.setModel(String.valueOf(this.getModelId()));
        varModel.setDataset(datasetId);
        varModel.setVarDim(varDim.toString());
        varModel.setVars(varRanges);
        varModel.setDims(dimModels);
        varModel.setAdd(Boolean.valueOf(false));
        varModel.setEdit(Boolean.valueOf(false));
        varModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return varModel;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect, RangeEnum defaultRange) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectKey = "varRangeCloseCallback".equals(callback) ? VAR_DIM : dimNumber;
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this, defaultRange, "varRangeCloseCallback".equals(callback), true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("varRangeCloseCallback".equals(actionId) || actionId.startsWith("varMemberCloseCallback")) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.slider);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if ("varRangeCloseCallback".equals(actionId)) {
            this.initVarEntry(list);
            this.getPageCache().put("vardim_select", JSON.toJSONString(list));
        } else {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }

    private void initVarEntry(List<TextEditSelectItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        DynamicObjectCollection currEntry = this.getModel().getEntryEntity(VAR_ENTRY);
        this.getModel().deleteEntryData(VAR_ENTRY);
        this.getModel().batchCreateNewEntryRow(VAR_ENTRY, list.size());
        AtomicInteger row = new AtomicInteger(0);
        list.forEach(item -> {
            String varNumber = item.getNumber();
            DynamicObject currRowObj = null;
            Optional<DynamicObject> optional = currEntry.stream().filter(obj -> varNumber.equals(obj.getString(VAR_NUMBER))).findFirst();
            if (optional.isPresent()) {
                currRowObj = optional.get();
            }
            int i = row.getAndIncrement();
            this.getModel().setValue(VAR_NUMBER, (Object)varNumber, i);
            this.getModel().setValue(VAR_NAME, (Object)item.getName(), i);
            if (currRowObj != null) {
                this.getModel().setValue(VAR_LABEL, (Object)currRowObj.getString(VAR_LABEL), i);
                this.getModel().setValue(VAR_START, (Object)currRowObj.getLong(VAR_START), i);
                this.getModel().setValue(VAR_END, (Object)currRowObj.getLong(VAR_END), i);
            } else {
                this.getModel().setValue(VAR_LABEL, (Object)item.getName(), i);
            }
        });
    }
}

