/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.PageConfig;
import kd.epm.eb.formplugin.analysiscanvas.AnalysisCanvasDesignPlugin;
import kd.epm.eb.formplugin.analysiscanvas.AnalysisCanvasI18N;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasPluginConstants;
import kd.epm.eb.formplugin.analysiscanvas.constant.PropsDataType;
import kd.epm.eb.formplugin.analysiscanvas.model.PropsData;

public class CustomItemEvent {
    private static final Log log = LogFactory.getLog(AnalysisCanvasDesignPlugin.class);

    public static CustomItemEvent getInstance() {
        return InnerClass.instance;
    }

    private CustomItemEvent() {
    }

    public void sendDataInitEvent(IFormView formView, List<CustomItem> itemList, PageConfig pageConfig, boolean designMode, String designStatus, String boxType) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.DATA_INIT);
        data.setData(itemList);
        data.setPageConfig(pageConfig);
        data.setDesignMode(designMode);
        data.setDesignStatus(designStatus);
        data.setBoxType(boxType);
        data.setI18n(AnalysisCanvasI18N.getInstance().getI18NData());
        this.sendData(formView, data);
    }

    public void sendDataRemoveEvent(IFormView formView, List<CustomItem> itemList) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.DATA_REMOVE);
        data.setData(itemList);
        this.sendData(formView, data);
    }

    public void sendDataUpdateEvent(IFormView formView, List<CustomItem> itemList) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.DATA_UPDATE);
        data.setData(itemList);
        this.sendData(formView, data);
    }

    public void sendDataSplitEvent(IFormView formView, CustomItem item) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.DATA_SPLIT);
        data.setData(item);
        this.sendData(formView, data);
    }

    public void sendEvent(IFormView formView, AnalysisCanvasPluginConstants.Event event) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.EVENT);
        data.setEventName(event.getName());
        this.sendData(formView, data);
    }

    public void sendEventWithData(IFormView formView, AnalysisCanvasPluginConstants.Event event, Object data) {
        PropsData propsData = new PropsData();
        propsData.setDataType(PropsDataType.EVENT);
        propsData.setEventName(event.getName());
        propsData.setData(data);
        this.sendData(formView, propsData);
    }

    public void sendPageConfigEvent(IFormView formView, PageConfig pageConfig) {
        PropsData data = new PropsData();
        data.setDataType(PropsDataType.DATA_PAGECONFIG);
        data.setPageConfig(pageConfig);
        this.sendData(formView, data);
    }

    private void sendData(IFormView formView, PropsData data) {
        String compressData = AnalysisCanvasUtils.compressData((String)JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        CustomControl customcontrol = (CustomControl)formView.getControl("customcontrolap");
        customcontrol.setData((Object)compressData);
    }

    private static class InnerClass {
        private static final CustomItemEvent instance = new CustomItemEvent();

        private InnerClass() {
        }
    }
}

