/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartHelper;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasChartEnum;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasChartBarLineChildPlugin
extends AbstractBasePlugin
implements SubPage,
AnalysisCanvasChartHelper,
BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String canvasId = this.getCanvasId(this.getView());
        String datasetId = this.getDatasetId(this.getView());
        if (StringUtils.isEmpty((CharSequence)datasetId)) {
            return;
        }
        ChartModel chartModel = (ChartModel)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("chartModel")), ChartModel.class);
        if (chartModel != null) {
            this.getPageCache().put("relationId", JSON.toJSONString((Object)chartModel.getRelationId()));
            this.getModel().setValue("horizontaldim", (Object)chartModel.getHorDim());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            if (CollectionUtils.isNotEmpty((Collection)chartModel.getChartConfig())) {
                ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(1);
                Long rightDatasetId = StringUtils.isNotEmpty((CharSequence)chartConfig.getDataset()) ? IDUtils.toLong((Object)chartConfig.getDataset()) : IDUtils.toLong((Object)datasetId);
                this.getModel().setValue("dataset", (Object)rightDatasetId);
                this.getPageCache().put("dataset", String.valueOf(rightDatasetId));
            }
            this.clear();
            this.initComboBox();
            this.initDimData(canvasId, chartModel, IDUtils.toLong((Object)datasetId), modelCache);
        } else {
            this.getModel().setValue("dataset", (Object)datasetId);
            this.getPageCache().put("dataset", datasetId);
            this.initComboBox();
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"herizontaldimrange", "serialdimrange", "dimmember", "dimselect", "leftaxisdimrange", "rightaxisdimrange", "dimmember1", "dimselect1"});
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        if ("dataset".equals(propName)) {
            if (IDUtils.isNotEmptyLong((Long)this.getModelId()).booleanValue()) {
                e.addCustomQFilter(new QFilter("businessmodel", "=", (Object)this.getLeftBizModelId()));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalysisCanvasDesignPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                this.getModel().setValue("horizontaldim", null);
                this.clearHorizontalRange();
                this.clearRightSerialDim();
                this.initComboBox();
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView().getParentView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                this.getView().getParentView().getPageCache().put("analysisCanvas:userSel", this.getView().getParentView().getParentView().getPageCache().get("analysisCanvas:userSel"));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
                AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("horizontaldim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            this.clearHorizontalRange();
            if (StringUtils.isNotBlank((CharSequence)newVal)) {
                this.clearLeftSerialDim();
                this.rebuildLeftDimEntry(newVal, null);
                this.clearRightSerialDim();
                this.rebuildRightDimEntry(newVal, null);
            }
            this.initSerialDim(newVal);
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.leftChart);
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("herizontaldimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("herizontaldimrange_select");
                this.getPageCache().remove("herizontaldimrange_range");
            }
        } else if ("leftaxisdim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String horDim = this.getModel().getValue("horizontaldim") != null ? this.getModel().getValue("horizontaldim").toString() : "";
            this.clearLeftRange();
            this.rebuildLeftDimEntry(horDim, newVal);
        } else if ("leftaxisdimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("leftaxisdimrange_select");
                this.getPageCache().remove("leftaxisdimrange_range");
            }
        } else if ("rightaxisdim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String horDim = this.getModel().getValue("horizontaldim") != null ? this.getModel().getValue("horizontaldim").toString() : "";
            this.clearRightRange();
            this.rebuildRightDimEntry(horDim, newVal);
        } else if ("rightaxisdimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("rightaxisdimrange_select_1");
                this.getPageCache().remove("rightaxisdimrange_range");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.leftChart));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.leftChart);
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        } else if ("dimselect1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect1" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember1"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmember1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart);
                this.getPageCache().remove(currEntryDim + "_select_1");
            }
        } else if ("dimmemberismulti1".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect1"});
                this.getModel().setValue("dimselect1", null, rowIndex);
                this.getModel().setValue("dimmember1", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart);
                this.getPageCache().remove(currEntryDim + "_select_1");
                this.getPageCache().remove("dimselect1" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect1"});
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("herizontaldimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("horizontaldim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a2a\u8f74\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            List dimensionRange = this.getDimensionRange(dimNumber);
            if (CollectionUtils.isNotEmpty((Collection)dimensionRange) && dimensionRange.size() > 1) {
                String caption = ResManager.loadKDString((String)"\u6a2a\u8f74\u53d6\u503c\u8303\u56f4", (String)"AnalysisCanvasChartBarChildPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.openChartRangePage((IFormPlugin)this, this.getView(), this.getModelId(this.getView()), this.getDatasetId(this.getView()), dimensionRange, this.getDimMemberRange(this.getView(), ctrlKey), ctrlKey, caption, "dimension_view");
            } else {
                this.openDimSelect(this.getDimensionString(dimNumber), "chartHorRangeCloseCallback", false, "dimension_view");
            }
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.leftChart);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "chartMemberCloseCallback", !isMulti, "dimension_view_left");
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.leftChart);
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback");
        } else if ("leftaxisdimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("leftaxisdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            List dimensionRange = this.getDimensionRange(dimNumber);
            if (CollectionUtils.isNotEmpty((Collection)dimensionRange) && dimensionRange.size() > 1) {
                this.openChartRangePage((IFormPlugin)this, this.getView(), this.getModelId(this.getView()), this.getDatasetId(this.getView()), dimensionRange, this.getDimMemberRange(this.getView(), ctrlKey), ctrlKey, null, "dimension_view_left");
            } else {
                this.openDimSelect(this.getDimensionString(dimNumber), "chartLeftRangeCloseCallback", false, "dimension_view_left");
            }
        } else if ("rightaxisdimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("rightaxisdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            List dimensionRange = this.getDimensionRange(dimNumber);
            if (CollectionUtils.isNotEmpty((Collection)dimensionRange) && dimensionRange.size() > 1) {
                this.openChartRangePage((IFormPlugin)this, this.getView(), this.getModelId(this.getView()), this.getRightDataset().toString(), dimensionRange, this.getDimMemberRange(this.getView(), ctrlKey), ctrlKey, null, "dimension_view_right");
            } else {
                this.openDimSelect(this.getDimensionString(dimNumber), "chartRightRangeCloseCallback", false, "dimension_view_right");
            }
        } else if ("dimmember1".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView(), AnalysisCanvasEnum.rightChart);
            this.openDimSelect(dimNumber, "chartMemberCloseCallback1", !isMulti, "dimension_view_right");
        } else if ("dimselect1".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView(), AnalysisCanvasEnum.rightChart);
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect1" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback1");
        }
    }

    public void dealMsg(CommandParam command) {
        if ("btn_ok".equals(command.getOperation())) {
            ChartModel chartModel = this.buildChartModel();
            CommandParam cmd = new CommandParam(AnalysisCanvasChartEnum.barLine.getFormName(), "eb_analysiscanvas_parent", "btn_ok", new Object[]{chartModel});
            this.sendMsg(this.getView(), cmd);
        }
        if ("dataset".equals(command.getOperation())) {
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            String dataSetId = (String)command.getParam().get(0);
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            if (!this.isBizModelEqual()) {
                this.clearLeftSerialDim();
                this.getModel().setValue("dataset", (Object)dataSetId);
                this.getPageCache().put("dataset", dataSetId);
            } else {
                this.getModel().setValue("horizontaldim", null);
                this.clear();
                this.initComboBox();
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("chartHorRangeCloseCallback".equals(actionId) || actionId.startsWith("chartLeftRangeCloseCallback") || actionId.startsWith("chartRightRangeCloseCallback") || actionId.startsWith("chartMemberCloseCallback") || actionId.startsWith("chartMemberCloseCallback1")) {
            this.cacheSelectedDim(actionId, evt);
        } else if ("dropdownConfigCloseCallback".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.leftChart);
        } else if ("dropdownConfigCloseCallback1".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.rightChart);
        } else if ("close_callback_member_range".equals(actionId)) {
            this.closeCallbackRangeData(this.getView(), evt);
        }
    }

    protected void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String viewKey = "chartHorRangeCloseCallback".equals(actionId) ? "dimension_view" : ("chartLeftRangeCloseCallback".equals(actionId) || "chartMemberCloseCallback".equals(actionId) ? "dimension_view_left" : "dimension_view_right");
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        Pair<String, Long> dimInfo = AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, viewKey, this.getView());
        if ("chartHorRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("herizontaldimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("herizontaldimrange_select", JSON.toJSONString(list));
            String dimNumber = this.getModel().getValue("horizontaldim").toString();
            JSONObject dimensionView = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
            String viewId = dimensionView.getString(dimNumber);
            if (StringUtils.isNotBlank((CharSequence)viewId)) {
                AnalysisCanvasPluginHelper.setDimView(dimNumber, "dimension_view_left", viewId, this.getView());
                AnalysisCanvasPluginHelper.setDimView(dimNumber, "dimension_view_right", viewId, this.getView());
            }
            this.calcDimMemberRange(actionId, this.getView(), (String)dimInfo.getLeft(), (Long)dimInfo.getRight(), list);
        } else if ("chartLeftRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("leftaxisdimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("leftaxisdimrange_select", JSON.toJSONString(list));
            this.calcDimMemberRange(actionId, this.getView(), (String)dimInfo.getLeft(), (Long)dimInfo.getRight(), list);
        } else if ("chartRightRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("rightaxisdimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("rightaxisdimrange_select_1", JSON.toJSONString(list));
            this.calcDimMemberRange(actionId, this.getView(), (String)dimInfo.getLeft(), (Long)dimInfo.getRight(), list);
        } else if ("chartMemberCloseCallback".equals(actionId)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.leftChart);
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView(), AnalysisCanvasEnum.leftChart));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        } else if ("chartMemberCloseCallback1".equals(actionId)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            this.getModel().setValue("dimmember1", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView(), AnalysisCanvasEnum.rightChart));
            this.getPageCache().put(dimNumber + "_select_1", JSON.toJSONString(list));
        }
    }

    private ChartModel buildChartModel() {
        this.checkRequiredData();
        String chartType = this.getView().getParentView().getModel().getValue("charttype").toString();
        String leftDatasetId = this.getDatasetId(this.getView());
        String rightDatasetId = this.getPageCache().get("dataset");
        String canvasId = this.getCanvasId(this.getView());
        String boxId = this.getBoxId(this.getView());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        JSONObject dimensionViewsLeft = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_left", this.getView());
        JSONObject dimensionViewsRight = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_right", this.getView());
        JSONObject dimensionViewsAll = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        String leftTabName = ResManager.loadKDString((String)"\u5de6\u8f74\u7ef4\u5ea6", (String)"AnalysisCanvasChartBarLineChildPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String rightTabName = ResManager.loadKDString((String)"\u53f3\u8f74\u7ef4\u5ea6", (String)"AnalysisCanvasChartBarLineChildPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ModelHelper.checkViewIdExisted((String)leftTabName, (JSONObject)dimensionViewsLeft);
        ModelHelper.checkViewIdExisted((String)rightTabName, (JSONObject)dimensionViewsRight);
        ChartModel chartModel = new ChartModel();
        chartModel.setModel(String.valueOf(this.getModelId()));
        chartModel.setDataset(leftDatasetId);
        chartModel.setType(chartType);
        this.buildHorRangeData(this.getView(), modelCache, leftDatasetId, "horizontaldim", "herizontaldimrange", "_select", dimensionViewsAll, chartModel);
        ChartConfigModel leftConfigModel = this.buildConfigModel(this.getView(), modelCache, leftDatasetId, "leftaxisdim", "leftaxisdimrange", "_select", dimensionViewsLeft, "bar", AnalysisCanvasEnum.leftChart);
        leftConfigModel.setDataset(leftDatasetId);
        ChartConfigModel rightConfigModel = this.buildConfigModel(this.getView(), modelCache, rightDatasetId, "rightaxisdim", "rightaxisdimrange", "_select_1", dimensionViewsRight, "line", AnalysisCanvasEnum.rightChart);
        rightConfigModel.setDataset(rightDatasetId);
        leftConfigModel.getDims().stream().filter(p -> p.getS() == false).forEach(leftDim -> rightConfigModel.getDims().stream().filter(p -> p.getS() == false).forEach(rightDim -> {
            if (leftDim.getDim().equals(rightDim.getDim())) {
                if (!leftDatasetId.equals(rightDatasetId)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u4e0d\u540c\u6570\u636e\u96c6\u65f6\uff0c\u7ef4\u5ea6[%1]\u4e0d\u80fd\u540c\u65f6\u6253\u5f00\u751f\u6210\u7ef4\u5ea6\u6210\u5458\u9009\u62e9\u5668\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{leftDim.getDim()}));
                }
                if (StringUtils.isNotBlank((CharSequence)leftDim.getRelSelectId())) {
                    rightDim.setRelSelectId(leftDim.getRelSelectId());
                    dimensionViewsRight.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                    dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                } else if (StringUtils.isNotBlank((CharSequence)rightDim.getRelSelectId())) {
                    leftDim.setRelSelectId(rightDim.getRelSelectId());
                    dimensionViewsLeft.fluentPut(rightDim.getDim(), dimensionViewsRight.get((Object)rightDim.getDim()));
                    dimensionViewsAll.fluentPut(rightDim.getDim(), dimensionViewsRight.get((Object)rightDim.getDim()));
                } else {
                    dimensionViewsRight.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                    dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                }
            }
        }));
        ArrayList<ChartConfigModel> chartConfigs = new ArrayList<ChartConfigModel>(2);
        chartConfigs.add(leftConfigModel);
        chartConfigs.add(rightConfigModel);
        chartModel.setDimensionViews(dimensionViewsAll);
        chartModel.setChartConfig(chartConfigs);
        List relationId = JSONObject.parseArray((String)this.getPageCache().get("relationId"), String.class);
        chartModel.setRelationId(relationId);
        chartModel.setAdd(Boolean.valueOf(false));
        chartModel.setEdit(Boolean.valueOf(false));
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)leftDatasetId).longValue());
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)rightDatasetId).longValue());
        return chartModel;
    }

    private void checkRequiredData() {
        Object horDim = this.getModel().getValue("horizontaldim");
        if (horDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a2a\u8f74\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List horDimRange = this.getDimensionRange(horDim.toString());
        String horDimRanges = this.getPageCache().get("herizontaldimrange_select");
        String horDimRanges1 = this.getPageCache().get("herizontaldimrange_range");
        if (horDimRange.size() == 1 && StringUtils.isBlank((CharSequence)horDimRanges) || horDimRange.size() > 1 && StringUtils.isBlank((CharSequence)horDimRanges1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a2a\u8f74\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String left = ResManager.loadKDString((String)"\u5de6\u8f74\u7ef4\u5ea6", (String)"AnalysisCanvasChartBarLineChildPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Object leftSerDim = this.getModel().getValue("leftaxisdim");
        if (leftSerDim == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{left}));
        }
        List leftSerDimRange = this.getDimensionRange(leftSerDim.toString());
        String leftSerDimRanges = this.getPageCache().get("leftaxisdimrange_select");
        String leftSerDimRanges1 = this.getPageCache().get("leftaxisdimrange_range");
        if (leftSerDimRange.size() == 1 && StringUtils.isBlank((CharSequence)leftSerDimRanges) || leftSerDimRange.size() > 1 && StringUtils.isBlank((CharSequence)leftSerDimRanges1)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{left}));
        }
        String right = ResManager.loadKDString((String)"\u53f3\u8f74\u7ef4\u5ea6", (String)"AnalysisCanvasChartBarLineChildPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Object rightSerDim = this.getModel().getValue("rightaxisdim");
        if (rightSerDim == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{right}));
        }
        List rightSerDimRange = this.getDimensionRange(rightSerDim.toString());
        String rightSerDimRanges = this.getPageCache().get("rightaxisdimrange_select_1");
        String rightSerDimRanges1 = this.getPageCache().get("rightaxisdimrange_range");
        if (rightSerDimRange.size() == 1 && StringUtils.isBlank((CharSequence)rightSerDimRanges) || rightSerDimRange.size() > 1 && StringUtils.isBlank((CharSequence)rightSerDimRanges1)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u3002", (String)"AnalysisCanvasChartBarLineChildPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{right}));
        }
    }

    protected void clear() {
        this.clearHorizontalRange();
        this.clearSerialRange();
    }

    protected void clearHorizontalRange() {
        this.getModel().setValue("herizontaldimrange", null);
        this.getPageCache().remove("herizontaldimrange_select");
        this.getPageCache().remove("herizontaldimrange_range");
    }

    protected void clearSerialRange() {
        this.getModel().setValue("leftaxisdim", null);
        this.getModel().setValue("rightaxisdim", null);
        ComboEdit leftComboEdit = (ComboEdit)this.getView().getControl("leftaxisdim");
        leftComboEdit.setComboItems(null);
        ComboEdit rightComboEdit = (ComboEdit)this.getView().getControl("rightaxisdim");
        rightComboEdit.setComboItems(null);
        this.clearLeftRange();
        this.clearRightRange();
    }

    private void clearLeftSerialDim() {
        this.getModel().setValue("leftaxisdim", null);
        ComboEdit leftComboEdit = (ComboEdit)this.getView().getControl("leftaxisdim");
        leftComboEdit.setComboItems(null);
        this.clearLeftRange();
    }

    private void clearRightSerialDim() {
        this.getModel().setValue("rightaxisdim", null);
        ComboEdit rightComboEdit = (ComboEdit)this.getView().getControl("rightaxisdim");
        rightComboEdit.setComboItems(null);
        this.clearRightRange();
    }

    protected void clearLeftRange() {
        this.getModel().setValue("leftaxisdimrange", null);
        this.getPageCache().remove("leftaxisdimrange_select");
        this.getPageCache().remove("leftaxisdimrange_range");
    }

    protected void clearRightRange() {
        this.getModel().setValue("rightaxisdimrange", null);
        this.getPageCache().remove("rightaxisdimrange_select_1");
        this.getPageCache().remove("rightaxisdimrange_range");
    }

    protected void initComboBox() {
        this.initHorizontalDim();
        String horDim = this.getModel().getValue("horizontaldim") != null ? this.getModel().getValue("horizontaldim").toString() : "";
        this.initSerialDim(horDim);
    }

    public void initHorizontalDim() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        Long leftDatasetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        Long rightDataset = this.getRightDataset();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List leftDimensionList = modelCache.getDimensionList(leftDatasetId);
        List rightDimensionList = modelCache.getDimensionList(rightDataset);
        List dimensionList = leftDimensionList.stream().filter(e -> rightDimensionList.stream().anyMatch(p -> p.getNumber().equals(e.getNumber()))).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("horizontaldim");
        ArrayList data = new ArrayList();
        if (IDUtils.equals((Object)leftDatasetId, (Object)rightDataset)) {
            dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        } else {
            dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        }
        comboEdit.setComboItems(data);
    }

    protected void initSerialDim(String horDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List leftDimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getDatasetId(this.getView())));
        ComboEdit leftComboEdit = (ComboEdit)this.getView().getControl("leftaxisdim");
        List horDimList = this.getDimensionRange(horDim);
        ArrayList leftData = new ArrayList();
        leftDimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (horDimList.contains(dimNumber) || SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                return;
            }
            leftData.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        });
        leftComboEdit.setComboItems(leftData);
        this.initRightSerialDim(modelCache, horDim);
    }

    private void initRightSerialDim(IModelCacheHelper modelCache, String horDim) {
        List rightDimensionList = modelCache.getDimensionList(this.getRightDataset());
        ComboEdit rightComboEdit = (ComboEdit)this.getView().getControl("rightaxisdim");
        List horDimList = this.getDimensionRange(horDim);
        ArrayList rightData = new ArrayList();
        rightDimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (horDimList.contains(dimNumber) || SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                return;
            }
            rightData.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        });
        rightComboEdit.setComboItems(rightData);
    }

    protected void initDimData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        JSONObject dimensionViews = chartModel.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        this.getPageCache().put("dimension_view", dimensionViews.toJSONString());
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        List horDimensionRange = this.getDimensionRange(chartModel.getHorDim());
        if (horDimensionRange.size() == 1) {
            AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViews, chartModel.getHorDim(), chartModel.getHorMems(), ignoreDimNumbers, "horizontaldim", "herizontaldimrange", AnalysisCanvasEnum.chart);
        } else {
            this.initMultipleMembers(this.getView(), dimensionList, horDimensionRange, ignoreDimNumbers, "horizontaldim", "herizontaldimrange", chartModel.getHorRange());
        }
        this.initLeftData(canvasId, chartModel, dataSetId, modelCache, dimensionList, ignoreDimNumbers);
        this.initRightData(canvasId, chartModel, dataSetId, modelCache, dimensionList, ignoreDimNumbers);
    }

    protected void initLeftData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<String> ignoreDimNumbers) {
        if (CollectionUtils.isEmpty((Collection)chartModel.getChartConfig())) {
            return;
        }
        ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(0);
        JSONObject dimensionViewsLeft = chartConfig.getDimensionViews();
        if (dimensionViewsLeft == null) {
            dimensionViewsLeft = new JSONObject();
        }
        ArrayList<String> ignoreLeftDimNumbers = new ArrayList<String>(ignoreDimNumbers);
        List serDimensionRange = this.getDimensionRange(chartConfig.getSerDim());
        if (serDimensionRange.size() == 1) {
            AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViewsLeft, chartConfig.getSerDim(), chartConfig.getSerMems(), ignoreLeftDimNumbers, "leftaxisdim", "leftaxisdimrange", AnalysisCanvasEnum.leftChart);
        } else {
            this.initMultipleMembers(this.getView(), dimensionList, serDimensionRange, ignoreLeftDimNumbers, "leftaxisdim", "leftaxisdimrange", chartConfig.getSerRange());
        }
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, chartConfig.getDims(), dimensionViewsLeft, AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
    }

    protected void initRightData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<String> ignoreDimNumbers) {
        if (CollectionUtils.isEmpty((Collection)chartModel.getChartConfig())) {
            return;
        }
        ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(1);
        JSONObject dimensionViewsRight = chartConfig.getDimensionViews();
        if (dimensionViewsRight == null) {
            dimensionViewsRight = new JSONObject();
        }
        Long rightDatasetId = this.getRightDataset();
        ArrayList<String> ignoreRightDimNumbers = new ArrayList<String>(ignoreDimNumbers);
        List serDimensionRange = this.getDimensionRange(chartConfig.getSerDim());
        if (serDimensionRange.size() == 1) {
            AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViewsRight, chartConfig.getSerDim(), chartConfig.getSerMems(), ignoreRightDimNumbers, "rightaxisdim", "rightaxisdimrange", AnalysisCanvasEnum.rightChart);
        } else {
            this.initMultipleMembers(this.getView(), dimensionList, serDimensionRange, ignoreRightDimNumbers, "rightaxisdim", "rightaxisdimrange", chartConfig.getSerRange());
        }
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), rightDatasetId, chartConfig.getDims(), dimensionViewsRight, AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), rightDatasetId, AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
    }

    private void rebuildLeftDimEntry(String horDim, String leftAxisDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        ArrayList<String> ignoreLeftDimNumbers = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)horDim)) {
            ignoreLeftDimNumbers.addAll(this.getDimensionRange(horDim));
        }
        if (StringUtils.isNotBlank((CharSequence)leftAxisDim)) {
            ignoreLeftDimNumbers.addAll(this.getDimensionRange(leftAxisDim));
        }
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
    }

    private void rebuildRightDimEntry(String horDim, String rightAxisDim) {
        Long modelId = this.getModelId();
        Long rightDatasetId = this.getRightDataset();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        ArrayList<String> ignoreRightDimNumbers = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)horDim)) {
            ignoreRightDimNumbers.addAll(this.getDimensionRange(horDim));
        }
        if (StringUtils.isNotBlank((CharSequence)rightAxisDim)) {
            ignoreRightDimNumbers.addAll(this.getDimensionRange(rightAxisDim));
        }
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), rightDatasetId, AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect, String viewKey) {
        Long modelId = this.getModelId();
        Long dataSetId = "dimension_view_right".equals(viewKey) ? this.getRightDataset() : IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, viewKey, this.getView());
        String selectKey = "chartHorRangeCloseCallback".equals(callback) ? "herizontaldimrange" : ("chartLeftRangeCloseCallback".equals(callback) ? "leftaxisdimrange" : ("chartRightRangeCloseCallback".equals(callback) ? "rightaxisdimrange" : dimNumber));
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if ("chartMemberCloseCallback1".equals(callback) || "chartRightRangeCloseCallback".equals(callback)) {
            selectItemStr = this.getPageCache().get(selectKey + "_select_1");
        }
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getModelId(this.getView()));
    }

    private Long getRightDataset() {
        return IDUtils.toLong((Object)this.getPageCache().get("dataset"));
    }

    private Long getLeftBizModelId() {
        Long datasetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return modelCache.getBusModelByDataSet(datasetId);
    }

    private boolean isBizModelEqual() {
        Long datasetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long leftBizModel = modelCache.getBusModelByDataSet(datasetId);
        Long rightBizModel = modelCache.getBusModelByDataSet(this.getRightDataset());
        return IDUtils.equals((Object)leftBizModel, (Object)rightBizModel);
    }
}

