/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartHelper;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasChartEnum;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasChartGaugeChildPlugin
extends AbstractBasePlugin
implements SubPage,
AnalysisCanvasChartHelper {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String canvasId = this.getCanvasId(this.getView());
        String datasetId = this.getDatasetId(this.getView());
        if (StringUtils.isEmpty((CharSequence)datasetId)) {
            return;
        }
        ChartModel chartModel = (ChartModel)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("chartModel")), ChartModel.class);
        if (chartModel != null) {
            ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(0);
            this.getPageCache().put("relationId", JSON.toJSONString((Object)chartModel.getRelationId()));
            this.getModel().setValue("serialdim", (Object)chartConfig.getSerDim());
            JSONObject dimensionViews = chartConfig.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            this.getPageCache().put("dimension_view", dimensionViews.toJSONString());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.clear();
            this.initComboBox();
            this.initDimData(canvasId, chartModel, IDUtils.toLong((Object)datasetId), dimensionViews, modelCache);
        } else {
            this.initComboBox();
            this.getModel().setValue("serialdim", (Object)SysDimensionEnum.Account.getNumber());
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.chart, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.chart, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"serialdimrange", "dimmember", "dimselect"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("serialdim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            this.clearSerialRange();
            this.rebuildDimEntry(null, newVal);
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("serialdimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("serialdimrange_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("serialdimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("serialdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eea\u8868\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartGaugeChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            this.openDimSelect(dimNumber, "chartSerRangeCloseCallback", true, "dimension_view");
        } else if ("sourcedimmember".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("serialdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                return;
            }
            String dimNumber = dim.toString();
            this.openDimSelect(dimNumber, "chartSourceDimMemberCloseCallback", true, "dimension_view");
        } else if ("targetdimmember".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("serialdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                return;
            }
            String dimNumber = dim.toString();
            this.openDimSelect(dimNumber, "chartTargetDimMemberCloseCallback", true, "dimension_view");
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "chartMemberCloseCallback", !isMulti, "dimension_view");
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback");
        }
    }

    public void dealMsg(CommandParam command) {
        if ("btn_ok".equals(command.getOperation())) {
            ChartModel chartModel = this.buildChartModel();
            CommandParam cmd = new CommandParam(AnalysisCanvasChartEnum.map.getFormName(), "eb_analysiscanvas_parent", "btn_ok", new Object[]{chartModel});
            this.sendMsg(this.getView(), cmd);
        }
        if ("dataset".equals(command.getOperation())) {
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            String dataSetId = (String)command.getParam().get(0);
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.chart, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.chart, Collections.singletonList(SysDimensionEnum.Account.getNumber()));
            this.initComboBox();
            this.getModel().setValue("serialdim", null);
            this.clear();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("chartHorRangeCloseCallback".equals(actionId) || actionId.startsWith("chartSerRangeCloseCallback") || actionId.startsWith("chartMemberCloseCallback")) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.chart);
        }
    }

    protected void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if ("chartSerRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("serialdimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("serialdimrange_select", JSON.toJSONString(list));
        } else if ("chartMemberCloseCallback".equals(actionId)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }

    private ChartModel buildChartModel() {
        this.checkRequiredData();
        String chartType = this.getView().getParentView().getModel().getValue("charttype").toString();
        String datasetId = this.getDatasetId(this.getView());
        String canvasId = this.getCanvasId(this.getView());
        String boxId = this.getBoxId(this.getView());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        Pair serDimPair = this.buildDimMember(this.getView(), modelCache, datasetId, "serialdim", "serialdimrange", "_select", dimensionViews);
        ChartConfigModel chartConfig = this.buildConfigModel(this.getView(), modelCache, datasetId, dimensionViews, "gauge", serDimPair, AnalysisCanvasEnum.chart);
        ChartModel chartModel = new ChartModel();
        chartModel.setModel(String.valueOf(this.getModelId()));
        chartModel.setDataset(datasetId);
        chartModel.setType(chartType);
        chartModel.setChartConfig(Collections.singletonList(chartConfig));
        List relationId = JSONObject.parseArray((String)this.getPageCache().get("relationId"), String.class);
        chartModel.setRelationId(relationId);
        chartModel.setAdd(Boolean.valueOf(false));
        chartModel.setEdit(Boolean.valueOf(false));
        chartModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return chartModel;
    }

    protected void clear() {
        this.clearSerialRange();
    }

    protected void clearSerialRange() {
        this.getModel().setValue("serialdimrange", null);
        this.getPageCache().remove("serialdimrange_select");
    }

    protected void initComboBox() {
        this.initSerialDim(null);
    }

    protected void initSerialDim(String horDim) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getDatasetId(this.getView())));
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("serialdim");
        ArrayList data = new ArrayList();
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (dimNumber.equals(horDim) || SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                return;
            }
            data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        });
        comboEdit.setComboItems(data);
    }

    protected void initDimData(String canvasId, ChartModel chartModel, Long dataSetId, JSONObject dimensionViews, IModelCacheHelper modelCache) {
        if (CollectionUtils.isEmpty((Collection)chartModel.getChartConfig())) {
            return;
        }
        ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(0);
        List dimensionList = modelCache.getDimensionList(dataSetId);
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViews, chartConfig.getSerDim(), chartConfig.getSerMems(), ignoreDimNumbers, "serialdim", "serialdimrange", AnalysisCanvasEnum.chart);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, chartConfig.getDims(), dimensionViews, AnalysisCanvasEnum.chart, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.chart, ignoreDimNumbers);
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect, String viewKey) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, viewKey, this.getView());
        String selectKey = "chartSerRangeCloseCallback".equals(callback) ? "serialdimrange" : dimNumber;
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    protected void rebuildDimEntry(String horDim, String serialDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)horDim)) {
            ignoreDimNumbers.add(horDim);
        }
        if (StringUtils.isNotBlank((CharSequence)serialDim)) {
            ignoreDimNumbers.add(serialDim);
        }
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), AnalysisCanvasEnum.chart, ignoreDimNumbers);
    }

    private void checkRequiredData() {
        Object serDim = this.getModel().getValue("serialdim");
        if (serDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eea\u8868\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartGaugeChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String serDimRanges = this.getPageCache().get("serialdimrange_select");
        if (StringUtils.isBlank((CharSequence)serDimRanges)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eea\u8868\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisCanvasChartGaugeChildPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getModelId(this.getView()));
    }
}

