/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ChartValueModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasRememberHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public interface AnalysisCanvasChartHelper {
    default public String getCanvasId(IFormView formView) {
        return formView.getParentView().getPageCache().get("canvasId");
    }

    default public String getModelId(IFormView formView) {
        return formView.getParentView().getPageCache().get("model");
    }

    default public String getDatasetId(IFormView formView) {
        return formView.getParentView().getPageCache().get("dataset");
    }

    default public String getBoxId(IFormView formView) {
        return formView.getParentView().getPageCache().get("usedBoxId");
    }

    default public void buildHorRangeData(IFormView view, IModelCacheHelper modelCache, String datasetId, String dim, String dimRange, String postSelect, JSONObject dimensionViews, ChartModel chartModel) {
        String dimNumbers = view.getModel().getValue(dim).toString();
        List<String> dimensionRange = this.getDimensionRange(dimNumbers);
        if (dimensionRange.size() > 1) {
            String serDimRange = view.getPageCache().get(dimRange + "_range");
            List chartValueModels = JSONObject.parseArray((String)serDimRange, ChartValueModel.class);
            chartModel.setHorDim(this.getDimensionString(dimNumbers));
            chartModel.setHorRange(chartValueModels);
        } else {
            Pair<String, List<MemberModel>> horDimPair = this.buildDimMember(view, modelCache, datasetId, dim, dimRange, postSelect, dimensionViews);
            chartModel.setHorDim((String)horDimPair.getLeft());
            chartModel.setHorMems((List)horDimPair.getRight());
        }
    }

    default public ChartConfigModel buildConfigModel(IFormView view, IModelCacheHelper modelCache, String datasetId, String dim, String dimRange, String postSelect, JSONObject dimensionViews, String type, AnalysisCanvasEnum field) {
        String dimNumbers = view.getModel().getValue(dim).toString();
        List<String> dimensionRange = this.getDimensionRange(dimNumbers);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(view, modelCache, dimensionViews, datasetId, field);
        ChartConfigModel rightModel = new ChartConfigModel();
        rightModel.setType(type);
        if (dimensionRange.size() > 1) {
            String serDimRange = view.getPageCache().get(dimRange + "_range");
            List chartValueModels = JSONObject.parseArray((String)serDimRange, ChartValueModel.class);
            rightModel.setSerDim(this.getDimensionString(dimNumbers));
            rightModel.setSerRange(chartValueModels);
        } else {
            Pair<String, List<MemberModel>> horDimPair = this.buildDimMember(view, modelCache, datasetId, dim, dimRange, postSelect, dimensionViews);
            rightModel.setSerDim((String)horDimPair.getLeft());
            rightModel.setSerMems((List)horDimPair.getRight());
        }
        rightModel.setDims(dimModels);
        rightModel.setDimensionViews(dimensionViews);
        return rightModel;
    }

    default public Pair<String, List<MemberModel>> buildDimMember(IFormView view, IModelCacheHelper modelCache, String datasetId, String dim, String dimRange, String postSelect, JSONObject dimensionViews) {
        String serialDim = this.getDimensionString(view.getModel().getValue(dim).toString());
        String serDimRange = view.getPageCache().get(dimRange + postSelect);
        List serDimRangeList = JSON.parseArray((String)serDimRange, TextEditSelectItem.class);
        Long viewId = IDUtils.toLong((Object)dimensionViews.getString(serialDim));
        List serMembers = serDimRangeList.stream().map(s -> {
            AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)datasetId), serialDim, viewId, s.getNumber());
            MemberModel memberModel = new MemberModel();
            memberModel.setNum(s.getNumber());
            memberModel.setScope(Integer.valueOf(Integer.parseInt(s.getScope())));
            return memberModel;
        }).collect(Collectors.toList());
        return Pair.of((Object)serialDim, serMembers);
    }

    default public ChartConfigModel buildConfigModel(IFormView view, IModelCacheHelper modelCache, String datasetId, JSONObject dimensionViews, String type, Pair<String, List<MemberModel>> serialPair, AnalysisCanvasEnum field) {
        String serialDim = (String)serialPair.getLeft();
        List serMembers = (List)serialPair.getRight();
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(view, modelCache, dimensionViews, datasetId, field);
        ChartConfigModel rightModel = new ChartConfigModel();
        rightModel.setType(type);
        rightModel.setSerDim(serialDim);
        rightModel.setSerMems(serMembers);
        rightModel.setDims(dimModels);
        rightModel.setDimensionViews(dimensionViews);
        return rightModel;
    }

    default public void openDropdownConfig(IFormPlugin formPlugin, IFormView view, Long modelId, String dimNumber, String relateId, String closeBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(formPlugin, closeBack));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)view.getParentView().getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getCanvasId(view));
        fsp.setCustomParam("dataset", (Object)this.getDatasetId(view));
        fsp.setCustomParam("model", (Object)modelId);
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        view.showForm(fsp);
    }

    default public void setSelectedDim(ClosedCallBackEvent evt, IFormView formView, AnalysisCanvasEnum field) {
        if (evt.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)evt.getReturnData();
        if (!"ok".equals(returnData.get("event"))) {
            return;
        }
        String selectorId = String.valueOf(returnData.get("id"));
        String canvasId = this.getCanvasId(formView);
        String selectMemberStr = "";
        SelectModel selectModel = AnalysisCanvasPluginHelper.getSelectorDimModel(selectorId, formView.getParentView());
        if (selectModel != null) {
            selectMemberStr = AnalysisCanvasPluginHelper.getSelectMemberStr(selectModel, formView.getParentView());
        }
        String dimNum = AnalysisCanvasPluginHelper.getCurrEntryDim(null, formView, field);
        formView.getPageCache().put(field.getDimSelect() + dimNum, selectorId);
        int rowIndex = AnalysisCanvasPluginHelper.getCurrEntryRow(formView, field);
        formView.getModel().setValue(field.getDimSelect(), (Object)AnalysisCanvasRememberHelper.getSelectName(canvasId, selectorId), rowIndex);
        formView.getModel().setValue(field.getDimMember(), (Object)selectMemberStr, rowIndex);
    }

    default public void calcDimMemberRange(String type, IFormView formView, String dimNumber, Long viewId, List<TextEditSelectItem> list) {
        int horSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P007);
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        Long modelId = IDUtils.toLong((Object)formView.getParentView().getPageCache().get("model"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List members = list.stream().flatMap(e -> modelCache.getMember(dimNumber, viewId, e.getNumber(), Integer.parseInt(e.getScope())).stream()).collect(Collectors.toList());
        if ("chartHorRangeCloseCallback".equals(type) && members.size() > horSize) {
            formView.showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u56fe\u8868\u6a2a\u8f74\u6216\u8005\u7eb5\u8f74\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6700\u591a\u53ef\u9009%1\u4e2a\uff0c\u591a\u7684\u7ef4\u5ea6\u6210\u5458\u4f1a\u88ab\u622a\u53d6\u3002", (String)"AnalysisCanvasChartHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[]{horSize}));
        }
        if (("chartSerRangeCloseCallback".equals(type) || "chartLeftRangeCloseCallback".equals(type) || "chartRightRangeCloseCallback".equals(type)) && members.size() > serSize) {
            formView.showTipNotification(ResManager.loadResFormat((String)"\u6570\u636e\u56fe\u8868\u7cfb\u5217\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6700\u591a\u53ef\u9009%1\u4e2a\uff0c\u591a\u7684\u7ef4\u5ea6\u6210\u5458\u4f1a\u88ab\u622a\u53d6\u3002", (String)"AnalysisCanvasChartHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{serSize}));
        }
    }

    default public void openChartRangePage(IFormPlugin plugin, IFormView formView, String modelId, String datasetId, List<String> dimNumbers, List<ChartValueModel> memberRange, String type, String caption, String viewKey) {
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView(viewKey, formView);
        JSONObject dimView = new JSONObject();
        dimNumbers.forEach(dimNumber -> dimView.put(dimNumber, (Object)dimensionViews.getString(dimNumber)));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_analysiscanvas_range");
        showParameter.setShowTitle(true);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("dataset", (Object)datasetId);
        showParameter.setCustomParam("dimension_field", (Object)JSON.toJSONString(dimNumbers));
        showParameter.setCustomParam("member_range", (Object)JSON.toJSONString(memberRange));
        showParameter.setCustomParam("chart_range_type", (Object)type);
        showParameter.setCustomParam("dimension_view", (Object)dimView.toJSONString());
        showParameter.setCustomParam("viewArea", (Object)viewKey);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "close_callback_member_range");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartRangePlugin");
        formView.showForm(showParameter);
    }

    default public void closeCallbackRangeData(IFormView formView, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)evt.getReturnData();
        String range = (String)returnData.get("range_data");
        String type = (String)returnData.get("chart_range_type");
        String view = (String)returnData.get("dimension_view");
        String viewKey = (String)returnData.get("viewArea");
        List chartValueModels = JSONObject.parseArray((String)range, ChartValueModel.class);
        JSONObject dimensionView = JSONObject.parseObject((String)view);
        for (String key : dimensionView.keySet()) {
            AnalysisCanvasPluginHelper.setDimView(key, viewKey, dimensionView.get((Object)key), formView);
            if (!"eb_analysiscanvas_barline".equals(formView.getFormShowParameter().getFormId())) continue;
            AnalysisCanvasPluginHelper.setDimView(key, "dimension_view_left", dimensionView.get((Object)key), formView);
            AnalysisCanvasPluginHelper.setDimView(key, "dimension_view_right", dimensionView.get((Object)key), formView);
        }
        this.setRangeMemberData(formView, type, chartValueModels);
    }

    default public void setRangeMemberData(IFormView formView, String type, List<ChartValueModel> chartValueModels) {
        String name = chartValueModels.stream().map(ChartValueModel::getName).collect(Collectors.joining(","));
        formView.getModel().setValue(type, (Object)name);
        formView.getPageCache().put(type + "_range", JSONObject.toJSONString(chartValueModels));
    }

    default public List<String> getDimensionRange(String dimNumbers) {
        return StringUtils.isEmpty((CharSequence)dimNumbers) ? Collections.emptyList() : Arrays.stream(dimNumbers.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    default public String getDimensionString(String dimNumbers) {
        return String.join((CharSequence)",", this.getDimensionRange(dimNumbers));
    }

    default public List<ChartValueModel> getDimMemberRange(IFormView view, String type) {
        String range = view.getPageCache().get(type + "_range");
        return StringUtils.isNotEmpty((CharSequence)range) ? JSONObject.parseArray((String)range, ChartValueModel.class) : Collections.emptyList();
    }

    default public void initMultipleMembers(IFormView formView, List<Dimension> dimensionList, List<String> dims, List<String> ignoreDimNumbers, String dimField, String dimMemberField, List<ChartValueModel> chartValueModels) {
        if (dimensionList.stream().noneMatch(dimension -> dims.contains(dimension.getNumber()))) {
            return;
        }
        formView.getModel().setValue(dimField, (Object)String.join((CharSequence)",", dims));
        ignoreDimNumbers.addAll(dims);
        this.setRangeMemberData(formView, dimMemberField, chartValueModels);
    }
}

