/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MapModel;
import kd.epm.eb.business.analysiscanvas.model.MapValue;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartHelper;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasChartEnum;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasChartMapChildPlugin
extends AbstractBasePlugin
implements SubPage,
BeforeF7SelectListener,
AnalysisCanvasChartHelper {
    private static final Log log = LogFactory.getLog(AnalysisCanvasChartMapChildPlugin.class);
    private static final String AREA_DIM = "areadim";
    private static final String MAPPING = "mapping";
    private static final String TEMPLATE = "template";
    private static final String AREA_VIEW = "areaview";
    private static final String AREA_MAPPING = "areamapping";
    private static final String AREA = "area";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String CLOSE_CALLBACK_AREA_MAPPING = "closeCallbackAreaMapping";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String canvasId = this.getCanvasId(this.getView());
        String datasetId = this.getDatasetId(this.getView());
        if (StringUtils.isEmpty((CharSequence)datasetId)) {
            return;
        }
        ChartModel chartModel = (ChartModel)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("chartModel")), ChartModel.class);
        if (chartModel != null) {
            this.getModel().setValue(TEMPLATE, (Object)chartModel.getMap().getArea());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.initMapDim();
            this.initMapData(canvasId, chartModel, IDUtils.toLong((Object)datasetId), modelCache);
            this.initMappingData(chartModel.getMap().getMapValues(), chartModel.getMap().getMapDim());
        } else {
            this.initMapDim();
            this.getModel().setValue(AREA_DIM, (Object)SysDimensionEnum.Entity.getNumber());
            List<MapValue> mapValues = this.initMapValues(this.getModel().getValue(TEMPLATE).toString());
            this.initMappingData(mapValues, SysDimensionEnum.Entity.getNumber());
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.map, Collections.singletonList(SysDimensionEnum.Entity.getNumber()));
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.map, Collections.singletonList(SysDimensionEnum.Entity.getNumber()));
            this.setAreaDimView(SysDimensionEnum.Entity.getNumber(), null);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MAPPING, "dimmember", "dimselect", NAME});
        BasedataEdit areaView = (BasedataEdit)this.getControl(AREA_VIEW);
        areaView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
        if (AREA_VIEW.equals(e.getProperty().getName())) {
            Long modelId = this.getModelId();
            Long datasetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            String dimNumber = String.valueOf(this.getModel().getValue(AREA_DIM));
            Dimension dimension = modelCache.getDimension(dimNumber);
            e.addCustomQFilter(new QFilter("model", "=", (Object)modelId));
            e.addCustomQFilter(new QFilter("dimension", "=", (Object)dimension.getId()));
            Long viewId = AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber);
            if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue() && !SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                e.addCustomQFilter(new QFilter(ID, "=", (Object)viewId).or(new QFilter("parent", "=", (Object)viewId)));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (AREA_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (newVal == null || newVal.equals(oldValue)) {
                return;
            }
            this.setAreaDimView(newVal, null);
            if (View.NoViewDimNums.contains(newVal) || SysDimensionEnum.ChangeType.getNumber().equals(newVal)) {
                this.clearMappingData();
            }
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), AnalysisCanvasEnum.map, Collections.singletonList(newVal));
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        } else if (TEMPLATE.equals(key)) {
            List<MapValue> mapValues = this.initMapValues(this.getModel().getValue(TEMPLATE).toString());
            this.initMappingData(mapValues, this.getPageCache().get(AREA_DIM));
        } else if (AREA_VIEW.equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String dimNumber = String.valueOf(this.getModel().getValue(AREA_DIM));
            if (newVal == null) {
                Long datasetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
                long viewId = AnalysisCanvasPluginHelper.getViewId(this.getModelId(), datasetId, dimNumber, "dimension_view", this.getView());
                if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                    this.getModel().setValue(AREA_VIEW, (Object)viewId);
                }
            } else {
                AnalysisCanvasPluginHelper.setDimView(dimNumber, "dimension_view", newVal.getLong(ID), this.getView());
                this.clearMappingData();
            }
        } else if (NAME.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getModel().setValue(ID, null, rowIndex);
                this.getModel().setValue(NUMBER, null, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "varMemberCloseCallback", !isMulti);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback");
        } else if (NAME.equals(ctrlKey)) {
            Object dimNumber = this.getModel().getValue(AREA_DIM);
            this.openDimSelect(dimNumber.toString(), CLOSE_CALLBACK_AREA_MAPPING, true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CLOSE_CALLBACK_AREA_MAPPING.equals(actionId)) {
            this.setSelectedDimMember(evt);
        }
        if (actionId.startsWith("varMemberCloseCallback")) {
            this.cacheSelectedDim(evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.chart);
        }
    }

    public void dealMsg(CommandParam command) {
        if ("btn_ok".equals(command.getOperation())) {
            ChartModel chartModel = this.buildChartModel();
            CommandParam cmd = new CommandParam(AnalysisCanvasChartEnum.map.getFormName(), "eb_analysiscanvas_parent", "btn_ok", new Object[]{chartModel});
            this.sendMsg(this.getView(), cmd);
        }
        if ("dataset".equals(command.getOperation())) {
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            String dataSetId = (String)command.getParam().get(0);
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.map, Collections.singletonList(SysDimensionEnum.Entity.getNumber()));
            this.initMapDim();
            this.getModel().setValue(AREA_DIM, null);
            this.getModel().setValue(AREA_DIM, (Object)SysDimensionEnum.Entity.getNumber());
        }
    }

    private ChartModel buildChartModel() {
        Object mapDim = this.getModel().getValue(AREA_DIM);
        if (mapDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u533a\u57df\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartMapChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection sheetMapping = this.getModel().getEntryEntity(AREA_MAPPING);
        if (sheetMapping.stream().noneMatch(p -> IDUtils.isNotEmptyLong((Long)p.getLong(ID)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u533a\u57df\u6620\u5c04\u6210\u5458\u6570\u636e\u3002", (String)"AnalysisCanvasChartMapChildPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object area = this.getModel().getValue(TEMPLATE);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getDatasetId(this.getView());
        String canvasId = this.getCanvasId(this.getView());
        String boxId = this.getBoxId(this.getView());
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.map);
        List<MapValue> mapModels = this.buildMappingData();
        ChartModel chartModel = new ChartModel();
        chartModel.setModel(String.valueOf(this.getModelId()));
        chartModel.setDataset(datasetId);
        chartModel.setAdd(Boolean.valueOf(false));
        chartModel.setEdit(Boolean.valueOf(false));
        chartModel.setDimensionViews(dimensionViews);
        chartModel.setType(this.getView().getParentView().getModel().getValue("charttype").toString());
        MapModel mapModel = new MapModel();
        mapModel.setDims(dimModels);
        mapModel.setArea(area.toString());
        mapModel.setMapDim(mapDim.toString());
        mapModel.setMapValues(mapModels);
        chartModel.setMap(mapModel);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return chartModel;
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        if (CLOSE_CALLBACK_AREA_MAPPING.equals(callback)) {
            this.openMappingDimSelect(modelId, dataSetId, dimNumber, qFilters, callback);
            return;
        }
        String selectKey = dimNumber;
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void openMappingDimSelect(Long modelId, Long dataSetId, String dimNumber, List<QFilter> qFilters, String callback) {
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        f7Param.setMultiSelect(true);
        f7Param.setBusModelId(modelCache.getBusModelByDataSet(dataSetId));
        f7Param.setDatasetId(dataSetId);
        f7Param.addCustomFilter(qFilters);
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        f7Param.setViewId(Long.valueOf(viewId));
        int rowIndex = this.getModel().getEntryCurrentRowIndex(AREA_MAPPING);
        DynamicObject row = this.getModel().getEntryRowEntity(AREA_MAPPING, rowIndex);
        if (row != null && IDUtils.isNotEmptyLong((Long)row.getLong(ID)).booleanValue()) {
            HashSet<Long> ids = new HashSet<Long>(1);
            ids.add(row.getLong(ID));
            f7Param.setSelectIds(ids);
        }
        f7Param.setShowDisable(true);
        f7Param.setHideDecompose(false);
        f7Param.setEnableView(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, callback));
    }

    private List<MapValue> buildMappingData() {
        DynamicObjectCollection sheetMapping = this.getModel().getEntryEntity(AREA_MAPPING);
        return sheetMapping.stream().map(dynamicObject -> {
            MapValue mapValue = new MapValue();
            mapValue.setName(dynamicObject.getString(AREA));
            mapValue.setValue((Object)0);
            if (IDUtils.isNotEmptyLong((Long)dynamicObject.getLong(ID)).booleanValue()) {
                mapValue.setMemberName(dynamicObject.getString(NAME));
                MemberModel member = new MemberModel();
                member.setNum(dynamicObject.getString(NUMBER));
                member.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                mapValue.setMember(member);
            }
            return mapValue;
        }).collect(Collectors.toList());
    }

    private void setSelectedDimMember(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        if (evt.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection members = (ListSelectedRowCollection)evt.getReturnData();
            int size = this.getModel().getEntryEntity(AREA_MAPPING).size();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(AREA_MAPPING);
            for (int i = 0; i < members.size(); ++i) {
                int currentRow = i + rowIndex;
                if (currentRow >= size) {
                    return;
                }
                this.getModel().setValue(ID, (Object)IDUtils.toLong((Object)members.get(i).getPrimaryKeyValue()), currentRow);
                this.getModel().setValue(NAME, (Object)members.get(i).getName(), currentRow);
                this.getModel().setValue(NUMBER, (Object)members.get(i).getNumber(), currentRow);
            }
        }
    }

    private void cacheSelectedDim(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
        this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView()));
        this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
    }

    private void initMapDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getDatasetId(this.getView())));
        ComboEdit comboEdit = (ComboEdit)this.getControl(AREA_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        comboEdit.setComboItems(data);
    }

    private void initMapData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache) {
        JSONObject dimensionViews = chartModel.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        String mapDim = chartModel.getMap().getMapDim();
        this.setAreaDimView(mapDim, dimensionViews.getLong(mapDim));
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        ignoreDimNumbers.add(mapDim);
        this.getModel().setValue(AREA_DIM, (Object)mapDim);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, chartModel.getMap().getDims(), dimensionViews, AnalysisCanvasEnum.map, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.map, ignoreDimNumbers);
    }

    private void initMappingData(List<MapValue> mapValues, String dimNumber) {
        if (mapValues.size() > 0) {
            this.getModel().deleteEntryData(AREA_MAPPING);
            this.getModel().batchCreateNewEntryRow(AREA_MAPPING, mapValues.size());
        }
        int i = 0;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long dataSetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        Map viewIds = modelCache.getViewsByDataSet(dataSetId);
        for (MapValue mapValue : mapValues) {
            if (mapValue.getMember() != null) {
                Member member = modelCache.getMember(dimNumber, (Long)viewIds.get(dimNumber), mapValue.getMember().getNum());
                this.getModel().setValue(ID, (Object)member.getId(), i);
                this.getModel().setValue(NAME, (Object)member.getName(), i);
                this.getModel().setValue(NUMBER, (Object)member.getNumber(), i);
            }
            this.getModel().setValue(AREA, (Object)mapValue.getName(), i);
            ++i;
        }
    }

    private void setAreaDimView(String areaDim, Long viewId) {
        if (View.NoViewDimNums.contains(areaDim) || SysDimensionEnum.ChangeType.getNumber().equals(areaDim)) {
            this.getModel().setValue(AREA_VIEW, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{AREA_VIEW});
            return;
        }
        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
            viewId = AnalysisCanvasPluginHelper.getViewId(this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), areaDim, "dimension_view", this.getView());
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{AREA_VIEW});
        this.getModel().setValue(AREA_VIEW, (Object)viewId);
    }

    private void clearMappingData() {
        DynamicObjectCollection sheetMapping = this.getModel().getEntryEntity(AREA_MAPPING);
        for (int i = 0; i < sheetMapping.size(); ++i) {
            this.getModel().setValue(ID, null, i);
            this.getModel().setValue(NAME, null, i);
            this.getModel().setValue(NUMBER, null, i);
        }
    }

    private List<MapValue> initMapValues(String template) {
        String resources = this.getStringFromResources();
        JSONObject data = JSONObject.parseObject((String)resources);
        JSONArray array = (JSONArray)data.get((Object)template);
        return array.stream().map(p -> {
            MapValue mapValue = new MapValue();
            mapValue.setName(p.toString());
            return mapValue;
        }).collect(Collectors.toList());
    }

    private String getStringFromResources() {
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream("analysiscanvas/mapData.json");
            assert (in != null);
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException var6) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"AnalysisCanvasChartMapChildPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getModelId(this.getView()));
    }
}

