/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasChartEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasChartParentPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
MainPage {
    public static final String ANALYSIS_CANVAS_REMEMBER = "analysisCanvas:userSel";
    public static final String TARGET_KEY = "flexpanelap1";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.getView().getPageCache().put(ANALYSIS_CANVAS_REMEMBER, this.getView().getParentView().getPageCache().get(ANALYSIS_CANVAS_REMEMBER));
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        this.getPageCache().put("itemId", customItem.getId());
        JSONObject chartModelJson = customItem.getC().getJSONObject("chartModel");
        if (chartModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            ChartModel chartModel = (ChartModel)chartModelJson.toJavaObject(ChartModel.class);
            Long modelId = IDUtils.toLong((Object)chartModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)chartModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            String chartType = chartModel.getType();
            this.getModel().setValue("charttype", (Object)chartType);
            this.initChildIframe(customItem.getId(), chartType, chartModel);
            this.setDatasetName(Objects.equals(chartType, AnalysisCanvasChartEnum.barLine.getType()));
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
            }
            this.getModel().setValue("charttype", (Object)"bar");
            this.initChildIframe(customItem.getId(), "bar", null);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                this.getView().getPageCache().put(ANALYSIS_CANVAS_REMEMBER, this.getView().getParentView().getPageCache().get(ANALYSIS_CANVAS_REMEMBER));
                this.sendChildMsg("dataset", dataSetId);
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
                this.sendChildMsg("model", modelId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if ("charttype".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldVal = (String)e.getChangeSet()[0].getOldValue();
            if (StringUtils.isNotBlank((CharSequence)newVal) && StringUtils.isBlank((CharSequence)this.getPageCache().get("dataset"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AnalysisCanvasChartParentPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (newVal != null && oldVal != null) {
                AnalysisCanvasChartEnum newChart = AnalysisCanvasChartEnum.getAnalysisCanvasChartEnumByType(newVal);
                AnalysisCanvasChartEnum oldChart = AnalysisCanvasChartEnum.getAnalysisCanvasChartEnumByType(oldVal);
                if (!newChart.getFormName().equals(oldChart.getFormName())) {
                    this.initChildIframe(this.getPageCache().get("itemId"), newVal, null);
                }
                if (newChart == AnalysisCanvasChartEnum.bar || newChart == AnalysisCanvasChartEnum.sortBar || newChart == AnalysisCanvasChartEnum.line) {
                    this.sendChildMsg("charttype", new Object[0]);
                }
                this.setDatasetName(newChart == AnalysisCanvasChartEnum.barLine);
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            this.sendChildMsg("btn_ok", new Object[0]);
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    public void dealMsg(CommandParam com) {
        super.dealMsg(com);
        String operation = com.getOperation();
        if ("btn_ok".equals(operation)) {
            List param = com.getParam();
            ChartModel chartModel = (ChartModel)param.get(0);
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)chartModel);
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("model"));
    }

    private void initChildIframe(String itemId, String type, ChartModel chartModel) {
        AnalysisCanvasChartEnum child = AnalysisCanvasChartEnum.getAnalysisCanvasChartEnumByType(type);
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = this.getView().getPageId() + itemId + child.getFormName();
        this.cachePageId(this.getPageCache(), child.getFormName(), pageId);
        showParameter.setPageId(pageId);
        showParameter.setFormId(child.getFormName());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("chartModel", (Object)JSONObject.toJSONString((Object)chartModel));
        this.getView().showForm(showParameter);
    }

    private void sendChildMsg(String operation, Object ... param) {
        AnalysisCanvasChartEnum child = AnalysisCanvasChartEnum.getAnalysisCanvasChartEnumByType(this.getModel().getValue("charttype").toString());
        CommandParam cmd = new CommandParam("eb_analysiscanvas_parent", child.getFormName(), operation, param);
        this.sendMsg(this.getView(), cmd);
    }

    private void setDatasetName(boolean isBarLine) {
        BasedataEdit control = (BasedataEdit)this.getControl("dataset");
        control.setCaption(isBarLine ? new LocaleString(ResManager.loadKDString((String)"\u5de6\u8f74\u6570\u636e\u96c6", (String)"AnalysisCanvasChartParentPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])) : new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"AnalysisCanvasChartParentPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
    }
}

