/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartHelper;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasChartEnum;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasChartProgressChildPlugin
extends AbstractBasePlugin
implements SubPage,
AnalysisCanvasChartHelper {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String canvasId = this.getCanvasId(this.getView());
        String datasetId = this.getDatasetId(this.getView());
        if (StringUtils.isEmpty((CharSequence)datasetId)) {
            return;
        }
        ChartModel chartModel = (ChartModel)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("chartModel")), ChartModel.class);
        if (chartModel != null) {
            this.getPageCache().put("relationId", JSON.toJSONString((Object)chartModel.getRelationId()));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.clear();
            this.initComboBox();
            this.initDimData(canvasId, chartModel, IDUtils.toLong((Object)datasetId), modelCache);
        } else {
            this.initComboBox();
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"serialdimrange", "dimmember", "dimselect", "leftaxisdimrange", "rightaxisdimrange", "dimmember1", "dimselect1"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("leftaxisdim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            this.clearLeftRange();
            this.rebuildLeftDimEntry(null, newVal);
        } else if ("leftaxisdimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("leftaxisdimrange_select");
            }
        } else if ("rightaxisdim".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            this.clearRightRange();
            this.rebuildRightDimEntry(null, newVal);
        } else if ("rightaxisdimrange".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("rightaxisdimrange_select_1");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView()));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView());
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        } else if ("dimselect1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect1" + AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember1"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmember1".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart);
                this.getPageCache().remove(currEntryDim + "_select_1");
            }
        } else if ("dimmemberismulti1".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect1"});
                this.getModel().setValue("dimselect1", null, rowIndex);
                this.getModel().setValue("dimmember1", null, rowIndex);
                String currEntryDim = AnalysisCanvasPluginHelper.getCurrEntryDim(rowIndex, this.getView(), AnalysisCanvasEnum.rightChart);
                this.getPageCache().remove(currEntryDim + "_select_1");
                this.getPageCache().remove("dimselect1" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect1"});
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("dimmember".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            this.openDimSelect(dimNumber, "chartMemberCloseCallback", !isMulti, "dimension_view_left");
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView());
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView());
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback");
        } else if ("leftaxisdimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("leftaxisdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            this.openDimSelect(dimNumber, "chartLeftRangeCloseCallback", true, "dimension_view_left");
        } else if ("rightaxisdimrange".equals(ctrlKey)) {
            Object dim = this.getModel().getValue("rightaxisdim");
            if (dim == null || StringUtils.isBlank((CharSequence)dim.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dimNumber = dim.toString();
            this.openDimSelect(dimNumber, "chartRightRangeCloseCallback", true, "dimension_view_right");
        } else if ("dimmember1".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                return;
            }
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView(), AnalysisCanvasEnum.rightChart);
            this.openDimSelect(dimNumber, "chartMemberCloseCallback1", !isMulti, "dimension_view_right");
        } else if ("dimselect1".equals(ctrlKey)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            boolean isMulti = AnalysisCanvasPluginHelper.getCurrEntryIsMulti(this.getView(), AnalysisCanvasEnum.rightChart);
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect1" + dimNumber);
            this.openDropdownConfig((IFormPlugin)this, this.getView(), this.getModelId(), dimNumber, relateId, "dropdownConfigCloseCallback1");
        }
    }

    public void dealMsg(CommandParam command) {
        if ("btn_ok".equals(command.getOperation())) {
            ChartModel chartModel = this.buildChartModel();
            CommandParam cmd = new CommandParam(AnalysisCanvasChartEnum.progress.getFormName(), "eb_analysiscanvas_parent", "btn_ok", new Object[]{chartModel});
            this.sendMsg(this.getView(), cmd);
        }
        if ("dataset".equals(command.getOperation())) {
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            String dataSetId = (String)command.getParam().get(0);
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.leftChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
            AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.rightChart, Collections.emptyList());
            this.clear();
            this.initComboBox();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("chartHorRangeCloseCallback".equals(actionId) || actionId.startsWith("chartLeftRangeCloseCallback") || actionId.startsWith("chartRightRangeCloseCallback") || actionId.startsWith("chartMemberCloseCallback") || actionId.startsWith("chartMemberCloseCallback1")) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.leftChart);
        }
        if ("dropdownConfigCloseCallback1".equals(actionId)) {
            this.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.rightChart);
        }
    }

    protected void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String viewKey = "chartHorRangeCloseCallback".equals(actionId) ? "dimension_view" : ("chartLeftRangeCloseCallback".equals(actionId) || "chartMemberCloseCallback".equals(actionId) ? "dimension_view_left" : "dimension_view_right");
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, viewKey, this.getView());
        if ("chartLeftRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("leftaxisdimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("leftaxisdimrange_select", JSON.toJSONString(list));
        } else if ("chartRightRangeCloseCallback".equals(actionId)) {
            this.getModel().setValue("rightaxisdimrange", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getPageCache().put("rightaxisdimrange_select_1", JSON.toJSONString(list));
        } else if ("chartMemberCloseCallback".equals(actionId)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.leftChart);
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView(), AnalysisCanvasEnum.leftChart));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        } else if ("chartMemberCloseCallback1".equals(actionId)) {
            String dimNumber = AnalysisCanvasPluginHelper.getCurrEntryDim(null, this.getView(), AnalysisCanvasEnum.rightChart);
            this.getModel().setValue("dimmember1", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), AnalysisCanvasPluginHelper.getCurrEntryRow(this.getView(), AnalysisCanvasEnum.rightChart));
            this.getPageCache().put(dimNumber + "_select_1", JSON.toJSONString(list));
        }
    }

    private ChartModel buildChartModel() {
        this.checkRequiredData();
        String chartType = this.getView().getParentView().getModel().getValue("charttype").toString();
        String datasetId = this.getDatasetId(this.getView());
        String canvasId = this.getCanvasId(this.getView());
        String boxId = this.getBoxId(this.getView());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        JSONObject dimensionViewsLeft = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_left", this.getView());
        JSONObject dimensionViewsRight = AnalysisCanvasPluginHelper.getDimensionView("dimension_view_right", this.getView());
        JSONObject dimensionViewsAll = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        String leftTabName = ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6", (String)"AnalysisCanvasChartProgressChildPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String rightTabName = ResManager.loadKDString((String)"\u5bf9\u6bd4\u7ef4\u5ea6", (String)"AnalysisCanvasChartProgressChildPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ModelHelper.checkViewIdExisted((String)leftTabName, (JSONObject)dimensionViewsLeft);
        ModelHelper.checkViewIdExisted((String)rightTabName, (JSONObject)dimensionViewsRight);
        ChartModel chartModel = new ChartModel();
        chartModel.setModel(String.valueOf(this.getModelId()));
        chartModel.setDataset(datasetId);
        chartModel.setType(chartType);
        Pair leftSerDimPair = this.buildDimMember(this.getView(), modelCache, datasetId, "leftaxisdim", "leftaxisdimrange", "_select", dimensionViewsLeft);
        ChartConfigModel leftConfigModel = this.buildConfigModel(this.getView(), modelCache, datasetId, dimensionViewsLeft, "pie", leftSerDimPair, AnalysisCanvasEnum.leftChart);
        Pair rightSerDimPair = this.buildDimMember(this.getView(), modelCache, datasetId, "rightaxisdim", "rightaxisdimrange", "_select_1", dimensionViewsRight);
        ChartConfigModel rightConfigModel = this.buildConfigModel(this.getView(), modelCache, datasetId, dimensionViewsRight, "pie", rightSerDimPair, AnalysisCanvasEnum.rightChart);
        Optional<DimensionModel> leftMetricDim = leftConfigModel.getDims().stream().filter(d -> SysDimensionEnum.Metric.getNumber().equals(d.getDim())).findFirst();
        Optional<DimensionModel> rightMetricDim = rightConfigModel.getDims().stream().filter(d -> SysDimensionEnum.Metric.getNumber().equals(d.getDim())).findFirst();
        if (leftMetricDim.isPresent() && rightMetricDim.isPresent()) {
            DimensionModel leftMetricDimModel = leftMetricDim.get();
            DimensionModel rightMetricDimModel = rightMetricDim.get();
            if (leftMetricDimModel.getS().booleanValue() && !rightMetricDimModel.getS().booleanValue() || !leftMetricDimModel.getS().booleanValue() && rightMetricDimModel.getS().booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u548c\u5bf9\u6bd4\u7ef4\u5ea6\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u5ea6\u91cf\u6210\u5458\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (leftMetricDimModel.getS().booleanValue() && rightMetricDimModel.getS().booleanValue()) {
                MemberModel leftMetric = (MemberModel)leftMetricDimModel.getMems().get(0);
                MemberModel rightMetric = (MemberModel)rightMetricDimModel.getMems().get(0);
                if (!leftMetric.getNum().equals(rightMetric.getNum())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u548c\u5bf9\u6bd4\u7ef4\u5ea6\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u5ea6\u91cf\u6210\u5458\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        leftConfigModel.getDims().stream().filter(p -> p.getS() == false).forEach(leftDim -> rightConfigModel.getDims().stream().filter(p -> p.getS() == false).forEach(rightDim -> {
            if (leftDim.getDim().equals(rightDim.getDim())) {
                if (StringUtils.isNotBlank((CharSequence)leftDim.getRelSelectId())) {
                    rightDim.setRelSelectId(leftDim.getRelSelectId());
                    dimensionViewsRight.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                    dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                } else if (StringUtils.isNotBlank((CharSequence)rightDim.getRelSelectId())) {
                    leftDim.setRelSelectId(rightDim.getRelSelectId());
                    dimensionViewsLeft.fluentPut(rightDim.getDim(), dimensionViewsRight.get((Object)rightDim.getDim()));
                    dimensionViewsAll.fluentPut(rightDim.getDim(), dimensionViewsRight.get((Object)rightDim.getDim()));
                } else {
                    dimensionViewsRight.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                    dimensionViewsAll.fluentPut(leftDim.getDim(), dimensionViewsLeft.get((Object)leftDim.getDim()));
                }
            }
        }));
        ArrayList<ChartConfigModel> chartConfigs = new ArrayList<ChartConfigModel>(2);
        chartConfigs.add(leftConfigModel);
        chartConfigs.add(rightConfigModel);
        chartModel.setDimensionViews(dimensionViewsAll);
        chartModel.setChartConfig(chartConfigs);
        List relationId = JSONObject.parseArray((String)this.getPageCache().get("relationId"), String.class);
        chartModel.setRelationId(relationId);
        chartModel.setAdd(Boolean.valueOf(false));
        chartModel.setEdit(Boolean.valueOf(false));
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return chartModel;
    }

    private void checkRequiredData() {
        String left = ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6", (String)"AnalysisCanvasChartProgressChildPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (this.getModel().getValue("leftaxisdim") == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{left}));
        }
        String leftDimRanges = this.getPageCache().get("leftaxisdimrange_select");
        if (StringUtils.isBlank((CharSequence)leftDimRanges)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{left}));
        }
        String right = ResManager.loadKDString((String)"\u5bf9\u6bd4\u7ef4\u5ea6", (String)"AnalysisCanvasChartProgressChildPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (this.getModel().getValue("rightaxisdim") == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{right}));
        }
        String rightDimRanges = this.getPageCache().get("rightaxisdimrange_select_1");
        if (StringUtils.isBlank((CharSequence)rightDimRanges)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e[%1]\u9875\u7b7e\u7684\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{right}));
        }
        if (Objects.equals(leftDimRanges, rightDimRanges)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u548c\u5bf9\u6bd4\u7ef4\u5ea6\u7cfb\u5217\u53d6\u503c\u8303\u56f4\u4e0d\u80fd\u76f8\u540c\u6216\u8005\u4e3a\u7a7a\u3002", (String)"AnalysisCanvasChartProgressChildPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void clear() {
        this.clearSerialRange();
    }

    protected void clearSerialRange() {
        this.getModel().setValue("leftaxisdim", null);
        this.getModel().setValue("rightaxisdim", null);
        ComboEdit leftComboEdit = (ComboEdit)this.getView().getControl("leftaxisdim");
        leftComboEdit.setComboItems(null);
        ComboEdit rightComboEdit = (ComboEdit)this.getView().getControl("rightaxisdim");
        rightComboEdit.setComboItems(null);
        this.clearLeftRange();
        this.clearRightRange();
    }

    protected void clearLeftRange() {
        this.getModel().setValue("leftaxisdimrange", null);
        this.getPageCache().remove("leftaxisdimrange_select");
    }

    protected void clearRightRange() {
        this.getModel().setValue("rightaxisdimrange", null);
        this.getPageCache().remove("rightaxisdimrange_select_1");
    }

    protected void initComboBox() {
        this.initSerialDim(null);
    }

    protected void initSerialDim(String horDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getDatasetId(this.getView())));
        ComboEdit leftComboEdit = (ComboEdit)this.getView().getControl("leftaxisdim");
        ComboEdit rightComboEdit = (ComboEdit)this.getView().getControl("rightaxisdim");
        ArrayList data = new ArrayList();
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (dimNumber.equals(horDim) || SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                return;
            }
            data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        });
        leftComboEdit.setComboItems(data);
        rightComboEdit.setComboItems(data);
    }

    protected void initDimData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache) {
        List dimensionList = modelCache.getDimensionList(dataSetId);
        JSONObject dimensionViews = chartModel.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        this.getPageCache().put("dimension_view", dimensionViews.toJSONString());
        ArrayList<String> ignoreDimNumbers = new ArrayList<String>(4);
        this.initLeftData(canvasId, chartModel, dataSetId, modelCache, dimensionList, ignoreDimNumbers);
        this.initRightData(canvasId, chartModel, dataSetId, modelCache, dimensionList, ignoreDimNumbers);
    }

    protected void initLeftData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<String> ignoreDimNumbers) {
        if (CollectionUtils.isEmpty((Collection)chartModel.getChartConfig())) {
            return;
        }
        ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(0);
        JSONObject dimensionViewsLeft = chartConfig.getDimensionViews();
        if (dimensionViewsLeft == null) {
            dimensionViewsLeft = new JSONObject();
        }
        ArrayList<String> ignoreLeftDimNumbers = new ArrayList<String>(ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViewsLeft, chartConfig.getSerDim(), chartConfig.getSerMems(), ignoreLeftDimNumbers, "leftaxisdim", "leftaxisdimrange", AnalysisCanvasEnum.leftChart);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, chartConfig.getDims(), dimensionViewsLeft, AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
    }

    protected void initRightData(String canvasId, ChartModel chartModel, Long dataSetId, IModelCacheHelper modelCache, List<Dimension> dimensionList, List<String> ignoreDimNumbers) {
        if (CollectionUtils.isEmpty((Collection)chartModel.getChartConfig())) {
            return;
        }
        ChartConfigModel chartConfig = (ChartConfigModel)chartModel.getChartConfig().get(1);
        JSONObject dimensionViewsRight = chartConfig.getDimensionViews();
        if (dimensionViewsRight == null) {
            dimensionViewsRight = new JSONObject();
        }
        ArrayList<String> ignoreRightDimNumbers = new ArrayList<String>(ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initMultipleMembers(this.getView(), modelCache, dimensionList, dimensionViewsRight, chartConfig.getSerDim(), chartConfig.getSerMems(), ignoreRightDimNumbers, "rightaxisdim", "rightaxisdimrange", AnalysisCanvasEnum.rightChart);
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, chartConfig.getDims(), dimensionViewsRight, AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
    }

    private void rebuildLeftDimEntry(String horDim, String leftAxisDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        ArrayList<String> ignoreLeftDimNumbers = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)horDim)) {
            ignoreLeftDimNumbers.add(horDim);
        }
        if (StringUtils.isNotBlank((CharSequence)leftAxisDim)) {
            ignoreLeftDimNumbers.add(leftAxisDim);
        }
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), AnalysisCanvasEnum.leftChart, ignoreLeftDimNumbers);
    }

    private void rebuildRightDimEntry(String horDim, String rightAxisDim) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        ArrayList<String> ignoreRightDimNumbers = new ArrayList<String>(4);
        if (StringUtils.isNotBlank((CharSequence)horDim)) {
            ignoreRightDimNumbers.add(horDim);
        }
        if (StringUtils.isNotBlank((CharSequence)rightAxisDim)) {
            ignoreRightDimNumbers.add(rightAxisDim);
        }
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getCanvasId(this.getView())), this.getModelId(), IDUtils.toLong((Object)this.getDatasetId(this.getView())), AnalysisCanvasEnum.rightChart, ignoreRightDimNumbers);
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect, String viewKey) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getDatasetId(this.getView()));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, viewKey, this.getView());
        String selectKey = "chartLeftRangeCloseCallback".equals(callback) ? "leftaxisdimrange" : ("chartRightRangeCloseCallback".equals(callback) ? "rightaxisdimrange" : dimNumber);
        String selectItemStr = this.getPageCache().get(selectKey + "_select");
        if ("chartMemberCloseCallback1".equals(callback) || "chartRightRangeCloseCallback".equals(callback)) {
            selectItemStr = this.getPageCache().get(selectKey + "_select_1");
        }
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getModelId(this.getView()));
    }
}

