/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.chart;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartValueModel;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasPluginConstants;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasEntryHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPanelHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasChartRangePlugin
extends AbstractBasePlugin
implements ClickListener {
    private static final String POOL_RANGE = "rangePool";
    private boolean isCopy;
    private boolean isAdd = false;

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"configentry"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addline", "btn_copy", "btn_batch", "btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("range_data", (String)this.getView().getFormShowParameter().getCustomParam("member_range"));
        this.getPageCache().put("dimension_view", (String)this.getView().getFormShowParameter().getCustomParam("dimension_view"));
        EntryAp entryAp = this.createDynamicEntryAp();
        if (entryAp != null) {
            AnalysisCanvasPanelHelper.updateControlMetadata(this.getView(), "configentry", entryAp.createControl());
            this.initEntryValue();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("config_name".equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            List<ChartValueModel> configDataList = this.getConfigData();
            ChartValueModel configDto = configDataList.get(rowIndex);
            configDto.setName(String.valueOf(changeData.getNewValue()));
            this.updateConfigData(configDataList);
        } else if (AnalysisCanvasPluginConstants.isCustomItem(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((CharSequence)newVal)) {
                Optional<DimensionModel> optional;
                DimensionItem dimItem = this.findItemByKey(key);
                List<ChartValueModel> configDataList = this.getConfigData();
                ChartValueModel configDto = configDataList.get(rowIndex);
                if (CollectionUtils.isNotEmpty((Collection)configDto.getDims()) && dimItem != null && (optional = configDto.getDims().stream().filter(d -> d.getDim().equals(dimItem.getNumber())).findFirst()).isPresent()) {
                    DimensionModel dimDto = optional.get();
                    dimDto.setMems(null);
                }
                this.updateConfigData(configDataList);
            }
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        EntryGrid entryGrid;
        int[] selectRows;
        String key = ((Control)evt.getSource()).getKey();
        this.isCopy = "btn_copy".equals(key);
        if (this.isCopy && (selectRows = (entryGrid = (EntryGrid)this.getControl("configentry")).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u5206\u5f55\u884c\u3002", (String)"AnalysisCanvasRangePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        if ("btn_ok".equals(key)) {
            this.checkDimRange();
        } else if ("btn_batch".equals(key)) {
            this.openBatchChartRangePage();
        } else if (AnalysisCanvasPluginConstants.isCustomItem(key)) {
            this.openMemberF7(key);
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int[] rowIndexArray;
        super.afterMoveEntryUp(e);
        for (int rowIndex : rowIndexArray = e.getRowIndexs()) {
            List<ChartValueModel> dtoList = this.getConfigData();
            ChartValueModel configDto = dtoList.remove(rowIndex);
            dtoList.add(rowIndex - 1, configDto);
            this.updateConfigData(dtoList);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int[] rowIndexArray;
        super.afterMoveEntryDown(e);
        for (int rowIndex : rowIndexArray = e.getRowIndexs()) {
            List<ChartValueModel> dtoList = this.getConfigData();
            ChartValueModel configDto = dtoList.remove(rowIndex);
            dtoList.add(rowIndex + 1, configDto);
            this.updateConfigData(dtoList);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int maxRows;
        super.afterAddRow(e);
        if (this.isAdd) {
            return;
        }
        List<ChartValueModel> dtoList = this.getConfigData();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("chart_range_type");
        int n = maxRows = "herizontaldimrange".equals(type) ? 50 : 30;
        if (this.isCopy) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("configentry");
            int[] selectRows = entryGrid.getSelectRows();
            if (dtoList.size() + selectRows.length >= maxRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d85\u51fa\u6570\u91cf\u9650\u5236\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u3002", (String)"AnalysisCanvasRangePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.copyRows(dtoList);
        } else {
            if (dtoList.size() >= maxRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d85\u51fa\u6570\u91cf\u9650\u5236\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u3002", (String)"AnalysisCanvasRangePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.addDtoRow(dtoList);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.delDtoRow(e.getRowIndexs());
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("model");
        return IDUtils.toLong((Object)modelId);
    }

    public Long getDatasetId() {
        String datasetId = (String)this.getView().getFormShowParameter().getCustomParam("dataset");
        return IDUtils.toLong((Object)datasetId);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if ("config_name".equals(ctrlKey)) {
            TextEdit edit = AnalysisCanvasEntryHelper.createEntryTextCtl(ctrlKey, "configentry", this.getModel(), this.getView());
            e.setControl((Control)edit);
        } else if (AnalysisCanvasPluginConstants.isCustomItem(ctrlKey)) {
            DimensionItem dimItem2 = this.findItemByKey(ctrlKey);
            if (dimItem2 != null) {
                TextEdit edit = AnalysisCanvasEntryHelper.createEntryTextCtl(dimItem2.getFieldKey(), "configentry", this.getModel(), this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            }
        } else if ("configentry".equals(ctrlKey)) {
            EntryGrid entryGrid = (EntryGrid)e.getControl();
            if (entryGrid == null) {
                return;
            }
            entryGrid.getItems().clear();
            TextEdit nameEdit = AnalysisCanvasEntryHelper.createEntryTextCtl("config_name", "configentry", this.getModel(), this.getView());
            entryGrid.getItems().add(nameEdit);
            List<DimensionItem> allDimension = this.getAllDimension();
            if (CollectionUtils.isNotEmpty(allDimension)) {
                allDimension.forEach(dimItem -> {
                    TextEdit textCtl = AnalysisCanvasEntryHelper.createEntryTextCtl(dimItem.getFieldKey(), "configentry", this.getModel(), this.getView());
                    entryGrid.getItems().add(textCtl);
                });
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("close_callback_member_batch".equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            String range = (String)returnData.get("range_data");
            String view = (String)returnData.get("dimension_view");
            List dtoList = JSONObject.parseArray((String)range, ChartValueModel.class);
            JSONObject dimensionView = JSONObject.parseObject((String)view);
            this.getPageCache().put("dimension_view", dimensionView.toJSONString());
            this.batchFillDimRange(dtoList);
        } else if (AnalysisCanvasPluginConstants.isCustomItem(actionId)) {
            ListSelectedRowCollection members;
            DimensionItem dimItem = this.findItemByKey(actionId);
            if (dimItem == null) {
                return;
            }
            if (evt.getReturnData() instanceof ListSelectedRowCollection && CollectionUtils.isNotEmpty((Collection)(members = (ListSelectedRowCollection)evt.getReturnData()))) {
                Optional<DimensionModel> optional;
                int rowIndex = this.getCurrRowIndex();
                String dimNumber = dimItem.getNumber();
                ListSelectedRow row = members.get(0);
                String memName = row.getName();
                Object viewId = row.getDataMap().get("viewid");
                AnalysisCanvasPluginHelper.setDimView(dimNumber, "dimension_view", viewId, this.getView());
                StringBuilder sb = new StringBuilder();
                AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, memName, RangeEnum.ONLY.getIndex());
                this.getModel().setValue(actionId, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
                List<ChartValueModel> configDataList = this.getConfigData();
                ChartValueModel configDto = configDataList.get(rowIndex);
                if (CollectionUtils.isNotEmpty((Collection)configDto.getDims()) && (optional = configDto.getDims().stream().filter(d -> d.getDim().equals(dimNumber)).findFirst()).isPresent()) {
                    DimensionModel dimDto = optional.get();
                    MemberModel memDto = new MemberModel();
                    memDto.setNum(row.getNumber());
                    memDto.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                    dimDto.setMems(Collections.singletonList(memDto));
                }
                if (StringUtils.isBlank((CharSequence)configDto.getName())) {
                    this.getModel().setValue("config_name", (Object)memName, rowIndex);
                    configDto.setName(memName);
                }
                this.updateConfigData(configDataList);
            }
        }
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        List<DimensionItem> dimItems = this.getAllDimension();
        if (CollectionUtils.isEmpty(dimItems)) {
            return;
        }
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        EntryType entryType = (EntryType)mainEntityType.getAllEntities().get("configentry");
        entryType.createPropIndexs();
        entryType.setDbIgnore(true);
        AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)entryType, "config_name");
        for (DimensionItem item : dimItems) {
            AnalysisCanvasPanelHelper.registerSimplePropWithId((EntityType)entryType, item.getFieldKey());
        }
    }

    private EntryAp createDynamicEntryAp() {
        List<DimensionItem> dimItems = this.getAllDimension();
        if (CollectionUtils.isEmpty(dimItems)) {
            return null;
        }
        EntryAp entryAp = AnalysisCanvasEntryHelper.createEntry("configentry");
        String nameStr = ResManager.loadKDString((String)"\u540d\u79f0", (String)"QingAnalysisDsConfigPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        AnalysisCanvasEntryHelper.createEntryTextFieldAp(entryAp, "config_name", nameStr, false);
        dimItems.forEach(item -> AnalysisCanvasEntryHelper.createEntryTextFieldAp(entryAp, item.getFieldKey(), item.getName(), true));
        return entryAp;
    }

    private void initEntryValue() {
        IDataModel dataModel = this.getControl("configentry").getModel();
        dataModel.deleteEntryData("configentry");
        List<ChartValueModel> dtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(dtoList)) {
            dataModel.batchCreateNewEntryRow("configentry", 1);
            this.addDtoRow(dtoList);
        } else {
            dataModel.batchCreateNewEntryRow("configentry", dtoList.size());
            this.setDtoValueToModel(dtoList);
        }
        this.getControl("configentry").getModel();
    }

    private void setDtoValueToModel(List<ChartValueModel> dtoList) {
        IDataModel dataModel = this.getControl("configentry").getModel();
        List<DimensionItem> allDim = this.getAllDimension();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (int i = 0; i < dtoList.size(); ++i) {
            ChartValueModel configDto = dtoList.get(i);
            ArrayList<DimensionModel> dimDtoList = configDto.getDims();
            if (dimDtoList == null) {
                dimDtoList = new ArrayList<DimensionModel>(16);
            }
            Map<String, DimensionModel> dimDtoMap = dimDtoList.stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v));
            String name = configDto.getName();
            dataModel.setValue("config_name", (Object)name, i);
            for (DimensionItem dimItem : allDim) {
                List members;
                String fieldKey = dimItem.getFieldKey();
                String dimNumber = dimItem.getNumber();
                long viewId = AnalysisCanvasPluginHelper.getViewId(this.getModelId(), this.getDatasetId(), dimNumber, "dimension_view", this.getView());
                DimensionModel dimDto = dimDtoMap.get(dimNumber);
                if (dimDto == null) {
                    dimDto = new DimensionModel();
                    dimDto.setDim(dimNumber);
                    dimDto.setMems(new ArrayList(1));
                    dimDtoList.add(dimDto);
                }
                if (CollectionUtils.isEmpty((Collection)(members = dimDto.getMems()))) continue;
                StringBuilder sb = new StringBuilder();
                members.forEach(mem -> {
                    Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, mem.getNum());
                    AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, member == null ? "" : member.getName(), mem.getScope());
                });
                this.getModel().setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), i);
            }
        }
    }

    private void openMemberF7(String key) {
        if (AnalysisCanvasPluginConstants.isCustomItem(key)) {
            DimensionModel dimDto2;
            ChartValueModel configDto;
            Optional<DimensionModel> optional;
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null) {
                return;
            }
            String dimNumber = dimItem.getNumber();
            Long modelId = this.getModelId();
            Long dataSetId = this.getDatasetId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
            long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(bizModelId);
            f7Param.setDatasetId(dataSetId);
            f7Param.setViewId(Long.valueOf(viewId));
            f7Param.addCustomFilter(qFilters);
            f7Param.setReturnAllData(true);
            f7Param.setShowVariable(false);
            f7Param.setCanSelectBudgetPeriodRoot(false);
            int currRowIndex = this.getCurrRowIndex();
            List<ChartValueModel> configData = this.getConfigData();
            if (CollectionUtils.isNotEmpty(configData) && configData.size() > currRowIndex && (optional = (configDto = configData.get(currRowIndex)).getDims().stream().filter(dimDto -> dimNumber.equals(dimDto.getDim())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(dimDto2 = optional.get()).getMems())) {
                Set ids = dimDto2.getMems().stream().map(e -> {
                    Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, e.getNum());
                    return member == null ? null : member.getId();
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                f7Param.setSelectIds(ids);
            }
            f7Param.setEnableView(this.checkViewSelect(configData, dimNumber, currRowIndex));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
            this.getPageCache().remove(key);
        }
    }

    private boolean checkViewSelect(List<ChartValueModel> configData, String dimNumber, int currRowIndex) {
        ArrayList<ChartValueModel> newConfigData = new ArrayList<ChartValueModel>(16);
        for (int i = 0; i < configData.size(); ++i) {
            if (i == currRowIndex) continue;
            newConfigData.add(configData.get(i));
        }
        return this.checkViewSelect(newConfigData, dimNumber);
    }

    private boolean checkViewSelect(List<ChartValueModel> newConfigData, String dimNumber) {
        return CollectionUtils.isEmpty(newConfigData) || newConfigData.stream().allMatch(e -> {
            Optional<DimensionModel> optional = e.getDims().stream().filter(dimDto -> dimNumber.equals(dimDto.getDim())).findFirst();
            if (optional.isPresent()) {
                DimensionModel dimensionModel = optional.get();
                return CollectionUtils.isEmpty((Collection)dimensionModel.getMems());
            }
            return false;
        });
    }

    private int getCurrRowIndex() {
        return this.getModel().getEntryCurrentRowIndex("configentry");
    }

    private int[] getSelectRows() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("configentry");
        return cardEntry.getEntryState().getSelectedRows();
    }

    private List<ChartValueModel> getConfigData() {
        String configData = this.getPageCache().get("range_data");
        if (StringUtils.isBlank((CharSequence)configData)) {
            return new ArrayList<ChartValueModel>(16);
        }
        List dtoList = JSON.parseArray((String)configData, ChartValueModel.class);
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return new ArrayList<ChartValueModel>(16);
        }
        return dtoList;
    }

    private void updateConfigData(List<ChartValueModel> dtoList) {
        this.getPageCache().put("range_data", JSON.toJSONString(dtoList));
    }

    private List<DimensionItem> getAllDimension() {
        String DIMENSION_CACHE = "dimensionCache";
        String dimensionFields = this.getPageCache().get(DIMENSION_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)dimensionFields)) {
            return JSON.parseArray((String)dimensionFields, DimensionItem.class);
        }
        List dimensionList = this.getIModelCacheHelper().getDimensionList(IDUtils.toLong((Object)this.getDatasetId()));
        List dimNumberList = JSONObject.parseArray((String)((String)this.getView().getFormShowParameter().getCustomParam("dimension_field")), String.class);
        ArrayList<DimensionItem> dimensionItems = new ArrayList<DimensionItem>(dimNumberList.size());
        dimNumberList.forEach(dimNumber -> {
            Optional<Dimension> first = dimensionList.stream().filter(e -> dimNumber.equals(e.getNumber())).findFirst();
            if (first.isPresent()) {
                Dimension dimension = first.get();
                DimensionItem dimensionItem = new DimensionItem(dimension.getId(), dimension.getName(), dimension.getNumber(), dimension.getMemberModel(), dimension.getSeq(), POOL_RANGE);
                dimensionItems.add(dimensionItem);
            }
        });
        this.getPageCache().put(DIMENSION_CACHE, JSONObject.toJSONString(dimensionItems));
        return dimensionItems;
    }

    private DimensionItem findItemByKey(String key) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getFieldKey().equals(key)).findFirst();
        return optional.orElse(null);
    }

    private void addDtoRow(List<ChartValueModel> dtoList) {
        ChartValueModel dto = new ChartValueModel();
        dto.setDims(this.createNewDimDto());
        dtoList.add(dto);
        this.updateConfigData(dtoList);
    }

    private void copyRows(List<ChartValueModel> dtoList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("configentry");
        int[] selectRows = entryGrid.getSelectRows();
        List copyData = Arrays.stream(selectRows).mapToObj(dtoList::get).map(ChartValueModel::deepCopy).collect(Collectors.toList());
        dtoList.addAll(copyData);
        this.updateConfigData(dtoList);
        this.setDtoValueToModel(dtoList);
    }

    private void delDtoRow(int[] delRows) {
        List<ChartValueModel> dtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        AtomicInteger rowIndex = new AtomicInteger(0);
        Iterator<ChartValueModel> iterator = dtoList.iterator();
        while (iterator.hasNext()) {
            ChartValueModel next = iterator.next();
            int andIncrement = rowIndex.getAndIncrement();
            if (!Arrays.stream(delRows).anyMatch(e -> e == andIncrement)) continue;
            iterator.remove();
        }
        this.updateConfigData(dtoList);
    }

    private List<DimensionModel> createNewDimDto() {
        List<DimensionItem> allDim = this.getAllDimension();
        return allDim.stream().map(dimItem -> {
            DimensionModel dto = new DimensionModel();
            dto.setDim(dimItem.getNumber());
            return dto;
        }).collect(Collectors.toList());
    }

    private void checkDimRange() {
        int j;
        List<ChartValueModel> dtoList = this.getConfigData();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("chart_range_type");
        int horSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P007);
        int serSize = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.P008);
        if ("herizontaldimrange".equals(type)) {
            if (dtoList.size() > horSize) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u9650\u5236\u8f74\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u8d85\u8fc7%1\u4e2a\uff0c\u8bf7\u5220\u9664\u591a\u4f59\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"AnalysisCanvasRangePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{horSize}));
            }
        } else if (dtoList.size() > serSize) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u9650\u5236\u7cfb\u5217\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u8d85\u8fc7%1\u4e2a\uff0c\u8bf7\u5220\u9664\u591a\u4f59\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"AnalysisCanvasRangePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{serSize}));
        }
        for (int i = 0; i < dtoList.size(); ++i) {
            ChartValueModel dto = dtoList.get(i);
            if (StringUtils.isBlank((CharSequence)dto.getName())) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"AnalysisCanvasRangePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
            }
            if (dto.getName().length() > 20) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u540d\u79f0\u8d85\u8fc720\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"AnalysisCanvasRangePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
            }
            if (CollectionUtils.isEmpty((Collection)dto.getDims()) || dto.getDims().stream().anyMatch(e -> CollectionUtils.isEmpty((Collection)e.getMems()))) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"AnalysisCanvasRangePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
            }
            for (j = 0; j < dtoList.size(); ++j) {
                ChartValueModel jDto = dtoList.get(j);
                if (i == j || !dto.getName().equals(jDto.getName())) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u7684\u540d\u79f0\u4e0e\u7b2c%2\u884c\u6570\u636e\u7684\u540d\u79f0\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"AnalysisCanvasRangePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, j + 1}));
            }
        }
        List dimHashIds = dtoList.stream().map(e -> {
            String key = e.getDims().stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getMems())).map(p -> ((MemberModel)p.getMems().get(0)).getNum()).collect(Collectors.joining("!"));
            return Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
        }).collect(Collectors.toList());
        for (int i = 0; i < dimHashIds.size(); ++i) {
            for (j = 0; j < dimHashIds.size(); ++j) {
                if (i == j || !((Long)dimHashIds.get(i)).equals(dimHashIds.get(j))) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u7684\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u4e0e\u7b2c%2\u884c\u6570\u636e\u7684\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AnalysisCanvasRangePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, j + 1}));
            }
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("range_data", JSON.toJSONString(dtoList));
        returnData.put("chart_range_type", this.getView().getFormShowParameter().getCustomParam("chart_range_type"));
        returnData.put("viewArea", this.getView().getFormShowParameter().getCustomParam("viewArea"));
        returnData.put("dimension_view", AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView()).toJSONString());
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void openBatchChartRangePage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_analysiscanvas_range");
        showParameter.setShowTitle(true);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId().toString());
        showParameter.setCustomParam("dataset", (Object)this.getDatasetId().toString());
        showParameter.setCustomParam("dimension_field", this.getView().getFormShowParameter().getCustomParam("dimension_field"));
        showParameter.setCustomParam("dimension_view", (Object)AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView()).toJSONString());
        showParameter.setCustomParam("isChangeView", (Object)this.getChangeView());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_callback_member_batch");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e", (String)"AnalysisCanvasRangePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.addCustPlugin("kd.epm.eb.formplugin.analysiscanvas.chart.AnalysisCanvasChartBatchPlugin");
        this.getView().showForm(showParameter);
    }

    private String getChangeView() {
        List dimNumberList = JSONObject.parseArray((String)((String)this.getView().getFormShowParameter().getCustomParam("dimension_field")), String.class);
        List<ChartValueModel> configData = this.getConfigData();
        JSONObject dimView = new JSONObject();
        dimNumberList.forEach(dim -> dimView.put(dim, (Object)this.checkViewSelect(configData, (String)dim)));
        return dimView.toJSONString();
    }

    private void batchFillDimRange(List<ChartValueModel> dtoList) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        List newDtoList = dtoList.stream().flatMap(dto -> {
            Long modelId = this.getModelId();
            Long datasetId = this.getDatasetId();
            List cartesianProduct = dto.getDims().stream().map(e -> {
                String dim = e.getDim();
                long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, datasetId, dim, "dimension_view", this.getView());
                return e.getMems().stream().flatMap(mem -> {
                    List member = modelCache.getMember(dim, Long.valueOf(viewId), mem.getNum(), mem.getScope().intValue());
                    return member.stream();
                }).map(p -> {
                    DimensionModel dimensionModel = new DimensionModel();
                    dimensionModel.setDim(dim);
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(p.getNumber());
                    memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                    dimensionModel.setMems(Collections.singletonList(memberModel));
                    return dimensionModel;
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            List cartesianProductList = Lists.cartesianProduct(cartesianProduct);
            List chartValueModels = cartesianProductList.stream().map(car -> {
                ChartValueModel chartValueModel = new ChartValueModel();
                String name = car.stream().map(e -> CollectionUtils.isNotEmpty((Collection)e.getMems()) ? modelCache.getMember(e.getDim(), Long.valueOf(AnalysisCanvasPluginHelper.getViewId(modelId, datasetId, e.getDim(), "dimension_view", this.getView())), ((MemberModel)e.getMems().get(0)).getNum()).getName() : null).filter(Objects::nonNull).collect(Collectors.joining("_"));
                name = name.length() > 20 ? name.substring(0, 20) : name;
                chartValueModel.setName(name);
                chartValueModel.setDims(car);
                return chartValueModel;
            }).collect(Collectors.toList());
            return chartValueModels.stream();
        }).collect(Collectors.toList());
        List<ChartValueModel> oldDtoList = this.getConfigData();
        oldDtoList.addAll(newDtoList);
        this.updateConfigData(oldDtoList);
        this.isAdd = true;
        this.getModel().batchCreateNewEntryRow("configentry", newDtoList.size());
        this.setDtoValueToModel(oldDtoList);
    }
}

