/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasControlHelper {
    public static Boolean isEdit(CustomItem customItem) {
        BaseModel baseModel = ModelHelper.getModel((CustomItem)customItem);
        return baseModel != null && baseModel.getEdit() != false;
    }

    public static Boolean isAdd(CustomItem customItem) {
        BaseModel baseModel = ModelHelper.getModel((CustomItem)customItem);
        return baseModel != null && baseModel.getAdd() != false;
    }

    public static List<CustomItem> getNewItemSelector(BaseModel newModel, CustomItem item, List<CustomItem> selectItems) {
        Pair<List<DimensionModel>, List<DimensionModel>> pair = AnalysisCanvasControlHelper.getModelDims(item, null, newModel);
        List newDims = (List)pair.getRight();
        Map<String, DimensionModel> newDimSelectIdMap = newDims.stream().filter(dim -> dim.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
        ArrayList<CustomItem> itemSelector = new ArrayList<CustomItem>(newDimSelectIdMap.size());
        if (MapUtils.isNotEmpty(newDimSelectIdMap)) {
            Map<String, CustomItem> selectItemMap = selectItems.stream().collect(Collectors.toMap(CustomItem::getId, p -> p));
            newDimSelectIdMap.forEach((key, dimModel) -> {
                String relSelectId = dimModel.getRelSelectId();
                if (StringUtils.isEmpty((String)relSelectId)) {
                    CustomItem newSelectItem = AnalysisCanvasControlHelper.addSelectItem(newModel.getModel(), newModel.getDataset(), AnalysisCanvasControlHelper.getDimensionView(newModel), item.getId(), dimModel);
                    itemSelector.add(newSelectItem);
                    dimModel.setRelSelectId(newSelectItem.getId());
                } else {
                    CustomItem selectItem = (CustomItem)selectItemMap.get(relSelectId);
                    AnalysisCanvasControlHelper.modifySelectItem(item.getId(), selectItem);
                    itemSelector.add(selectItem);
                }
            });
        }
        return itemSelector;
    }

    private static JSONObject getDimensionView(BaseModel newModel) {
        if (newModel instanceof ChartModel && ("barLine".equals(((ChartModel)newModel).getType()) || "progress".equals(((ChartModel)newModel).getType()))) {
            JSONObject dimensionViews = new JSONObject();
            ((ChartModel)newModel).getChartConfig().forEach(e -> {
                JSONObject dimensionViews1 = e.getDimensionViews();
                e.getDims().forEach(p -> {
                    if (!p.getS().booleanValue()) {
                        dimensionViews.put(p.getDim(), dimensionViews1.get((Object)p.getDim()));
                    }
                });
            });
            return dimensionViews;
        }
        return newModel.getDimensionViews();
    }

    private static Pair<List<DimensionModel>, List<DimensionModel>> getModelDims(CustomItem item, BaseModel oldModel, BaseModel newModel) {
        List oldDims = Collections.emptyList();
        ArrayList<DimensionModel> newDims = Collections.emptyList();
        switch (item.getType()) {
            case "bizindicator": {
                if (oldModel != null) {
                    Map<String, DimensionModel> oldDimMaps = ((BizModel)oldModel).getBizConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                    oldDims = new ArrayList<DimensionModel>(oldDimMaps.values());
                }
                Map<String, DimensionModel> newBizDimMaps = ((BizModel)newModel).getBizConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                newDims = new ArrayList<DimensionModel>(newBizDimMaps.values());
                break;
            }
            case "table": {
                oldDims = oldModel == null ? Collections.emptyList() : ((TabModel)oldModel).getDims();
                newDims = ((TabModel)newModel).getDims();
                break;
            }
            case "table2": {
                oldDims = oldModel == null ? Collections.emptyList() : ((TableModel)oldModel).getDims();
                newDims = ((TableModel)newModel).getDims();
                break;
            }
            case "chart": {
                if (oldModel != null) {
                    Map<String, DimensionModel> oldDimMaps = ((ChartModel)oldModel).getType().equals("map") ? ((ChartModel)oldModel).getMap().getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1)) : ((ChartModel)oldModel).getChartConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                    oldDims = new ArrayList<DimensionModel>(oldDimMaps.values());
                }
                Map<String, DimensionModel> newDimMaps = ((ChartModel)newModel).getType().equals("map") ? ((ChartModel)newModel).getMap().getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1)) : ((ChartModel)newModel).getChartConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                newDims = new ArrayList<DimensionModel>(newDimMaps.values());
                break;
            }
            case "slider": {
                oldDims = oldModel == null ? Collections.emptyList() : ((VarModel)oldModel).getDims();
                newDims = ((VarModel)newModel).getDims();
                break;
            }
            case "report": {
                oldDims = oldModel == null ? Collections.emptyList() : ((ReportModel)oldModel).getDims();
                newDims = ((ReportModel)newModel).getDims();
                break;
            }
            case "dupontnode": {
                if (oldModel != null) {
                    Map<String, DimensionModel> oldDimMaps = ((DupontModel)oldModel).getDupontConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                    oldDims = new ArrayList<DimensionModel>(oldDimMaps.values());
                }
                Map<String, DimensionModel> newDupontDimMaps = ((DupontModel)newModel).getDupontConfig().stream().flatMap(p -> p.getDims().stream()).filter(p -> p.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, p -> p, (p1, p2) -> p1));
                newDims = new ArrayList<DimensionModel>(newDupontDimMaps.values());
            }
        }
        return Pair.of(oldDims, newDims);
    }

    public static List<CustomItem> getModifyItemSelector(BaseModel oldModel, BaseModel newModel, CustomItem item, List<CustomItem> selectItems) {
        Pair<List<DimensionModel>, List<DimensionModel>> pair = AnalysisCanvasControlHelper.getModelDims(item, oldModel, newModel);
        List oldDims = (List)pair.getLeft();
        List newDims = (List)pair.getRight();
        Map<String, CustomItem> selectItemMap = selectItems.stream().collect(Collectors.toMap(CustomItem::getId, p -> p));
        Map<String, String> oldDimSelectIdMap = oldDims.stream().filter(dim -> dim.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, v -> v.getRelSelectId() == null ? "" : v.getRelSelectId(), (o1, o2) -> o2));
        Map<String, DimensionModel> newDimSelectIdMap = newDims.stream().filter(dim -> dim.getS() == false).collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
        ArrayList<CustomItem> itemSelector = new ArrayList<CustomItem>(newDimSelectIdMap.size());
        if (MapUtils.isNotEmpty(oldDimSelectIdMap)) {
            oldDimSelectIdMap.forEach((dim, oldFilterId) -> {
                DimensionModel dimModel = (DimensionModel)newDimSelectIdMap.get(dim);
                if (dimModel == null || StringUtils.isEmpty((String)dimModel.getRelSelectId())) {
                    if (StringUtils.isNotEmpty((String)oldFilterId)) {
                        CustomItem selectItem = (CustomItem)selectItemMap.get(oldFilterId);
                        AnalysisCanvasControlHelper.removeSelectItem(item.getId(), selectItem);
                        itemSelector.add(selectItem);
                    }
                } else if (!dimModel.getRelSelectId().equals(oldFilterId)) {
                    CustomItem newSelectItem;
                    if (StringUtils.isNotEmpty((String)oldFilterId)) {
                        CustomItem selectItem = (CustomItem)selectItemMap.get(oldFilterId);
                        AnalysisCanvasControlHelper.removeSelectItem(item.getId(), selectItem);
                        itemSelector.add(selectItem);
                    }
                    if ((newSelectItem = (CustomItem)selectItemMap.get(dimModel.getRelSelectId())) != null) {
                        AnalysisCanvasControlHelper.modifySelectItem(item.getId(), newSelectItem);
                        itemSelector.add(newSelectItem);
                    }
                }
            });
        }
        if (MapUtils.isNotEmpty(newDimSelectIdMap)) {
            newDimSelectIdMap.forEach((key, dimModel) -> {
                if (StringUtils.isEmpty((String)dimModel.getRelSelectId())) {
                    CustomItem newSelectItem = AnalysisCanvasControlHelper.addSelectItem(newModel.getModel(), newModel.getDataset(), AnalysisCanvasControlHelper.getDimensionView(newModel), item.getId(), dimModel);
                    itemSelector.add(newSelectItem);
                    dimModel.setRelSelectId(newSelectItem.getId());
                } else {
                    CustomItem selectItem = (CustomItem)selectItemMap.get(dimModel.getRelSelectId());
                    AnalysisCanvasControlHelper.modifySelectItem(item.getId(), selectItem);
                    itemSelector.add(selectItem);
                }
            });
        }
        return itemSelector;
    }

    private static CustomItem addSelectItem(String modelId, String dataSetId, JSONObject dimensionViews, String itemId, DimensionModel dim) {
        CustomItem newItem = new CustomItem();
        JSONObject c = new JSONObject();
        newItem.setC(c);
        newItem.setType("select");
        SelectModel newSelectModel = new SelectModel();
        newSelectModel.setAdd(Boolean.valueOf(true));
        newSelectModel.setEdit(Boolean.valueOf(false));
        newSelectModel.setModel(modelId);
        newSelectModel.setDataset(dataSetId);
        newSelectModel.setRelationId(Collections.singletonList(itemId));
        newSelectModel.setDim(dim);
        JSONObject viewMap = new JSONObject();
        if (dimensionViews != null && StringUtils.isNotEmpty((String)dimensionViews.getString(dim.getDim()))) {
            String viewId = dimensionViews.getString(dim.getDim());
            viewMap.fluentPut(dim.getDim(), (Object)viewId);
        }
        newSelectModel.setDimensionViews(viewMap);
        ModelHelper.updateModel((CustomItem)newItem, (BaseModel)newSelectModel);
        newItem.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        return newItem;
    }

    private static CustomItem modifySelectItem(String relationId, CustomItem selectItem) {
        SelectModel selectModel = (SelectModel)ModelHelper.getModel((CustomItem)selectItem, SelectModel.class);
        if (!selectModel.getRelationId().contains(relationId)) {
            selectModel.getRelationId().add(relationId);
        }
        ModelHelper.updateModel((CustomItem)selectItem, (BaseModel)selectModel);
        return selectItem;
    }

    private static CustomItem removeSelectItem(String relationId, CustomItem selectItem) {
        SelectModel selectModel = (SelectModel)ModelHelper.getModel((CustomItem)selectItem, SelectModel.class);
        selectModel.getRelationId().remove(relationId);
        ModelHelper.updateModel((CustomItem)selectItem, (BaseModel)selectModel);
        return selectItem;
    }

    public static String getUserInfo() {
        JSONObject userInfoJson = new JSONObject(2);
        userInfoJson.put("userId", (Object)String.valueOf(UserUtils.getUserId()));
        userInfoJson.put("userName", (Object)UserUtils.getUserName());
        return userInfoJson.toJSONString();
    }
}

