/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.epm.eb.business.analysiscanvas.model.CompareHead;

public class AnalysisCanvasEntryHelper {
    private static final int CHAR_WIDTH = 15;

    public static void updateEntry(EntryAp entryAp, IFormView formView) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(entryAp.getKey(), "createGridColumns", new Object[]{entryAp.createControl()});
    }

    public static EntryAp createEntry(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        entryAp.setOrderAndFilter(1);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    public static FieldAp createEntryTextFieldAp(EntryAp entryAp, String fieldKey, String name, boolean selectEdit) {
        EntryFieldAp textFieldAp = AnalysisCanvasEntryHelper.createEntryTextFieldAp(fieldKey, name, "left", selectEdit);
        entryAp.getItems().add(textFieldAp);
        return textFieldAp;
    }

    public static FieldAp createEntryTextFieldAp(EntryAp entryAp, String fieldKey, String name, String textAlign) {
        EntryFieldAp textFieldAp = AnalysisCanvasEntryHelper.createEntryTextFieldAp(fieldKey, name, textAlign, true);
        entryAp.getItems().add(textFieldAp);
        return textFieldAp;
    }

    public static EntryFieldAp createEntryTextFieldAp(String fieldKey, String name, String textAlign, boolean selectEdit) {
        EntryFieldAp textFieldAp = new EntryFieldAp();
        textFieldAp.setId(fieldKey);
        textFieldAp.setKey(fieldKey);
        textFieldAp.setName(new LocaleString(name));
        textFieldAp.setFireUpdEvt(true);
        textFieldAp.setWidth(new LocaleString("150px"));
        textFieldAp.setTextAlign(textAlign);
        TextField textField = new TextField();
        textField.setId(fieldKey);
        textField.setKey(fieldKey);
        textField.setMustInput(false);
        textField.setMaxLength(20);
        if (selectEdit) {
            textField.setEditStyle(1);
        }
        textFieldAp.setField((Field)textField);
        return textFieldAp;
    }

    public static void registerSimpleProp(EntityType entityType, String fieldKey) {
        TextProp textProp = new TextProp();
        textProp.setName(fieldKey);
        textProp.setDbIgnore(true);
        entityType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    public static TextEdit createEntryTextCtl(String key, String entryKey, IDataModel dataModel, IFormView view) {
        TextEdit edit = new TextEdit();
        edit.setKey(key);
        edit.setView(view);
        edit.setModel(dataModel);
        edit.setEntryKey(entryKey);
        return edit;
    }

    public static void createEntryFieldGroupAp(EntryAp entryAp, String fieldKey, String name, List<CompareHead> child, String textAlign) {
        EntryFieldGroupAp entryFieldGroupAp = new EntryFieldGroupAp();
        entryFieldGroupAp.setName(new LocaleString(name));
        entryFieldGroupAp.setKey(fieldKey);
        child.forEach(c -> {
            EntryFieldAp entryTextFieldAp = AnalysisCanvasEntryHelper.createEntryTextFieldAp(c.getFieldKey(), c.getName(), textAlign, true);
            entryFieldGroupAp.getItems().add(entryTextFieldAp);
        });
        entryAp.getItems().add(entryFieldGroupAp);
    }
}

