/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AnalysisCanvasExcelHelper {
    private XSSFWorkbook wb;
    private XSSFSheet sheet;
    private int curRow = 0;
    private XSSFCellStyle titleStyle;
    private XSSFCellStyle unitStyle;
    private XSSFCellStyle rowStyle;
    private XSSFCellStyle colStyle;
    private XSSFCellStyle blackStyle;
    private XSSFCellStyle redStyle;
    private XSSFCellStyle greenStyle;
    private static final float ROW_HEIGHT = 13.5f;
    private static final Color GREY_5_PERCENT = new Color(244, 244, 244);
    private static final Color GREY_8_PERCENT = new Color(212, 212, 212);
    private final List<CellRangeAddress> cellRangeAddressList = new ArrayList<CellRangeAddress>(16);

    private AnalysisCanvasExcelHelper() {
        this.createWorkBook();
    }

    public static AnalysisCanvasExcelHelper getInstance() {
        return new AnalysisCanvasExcelHelper();
    }

    private void createWorkBook() {
        this.wb = new XSSFWorkbook();
        this.initCellStyle();
    }

    private void initCellStyle() {
        this.titleStyle = this.wb.createCellStyle();
        this.titleStyle.setAlignment(HorizontalAlignment.LEFT);
        this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.titleStyle.setFillForegroundColor(new XSSFColor(GREY_8_PERCENT, (IndexedColorMap)new DefaultIndexedColorMap()));
        this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBorder((CellStyle)this.titleStyle);
        this.unitStyle = this.wb.createCellStyle();
        this.unitStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.unitStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.unitStyle.setFillForegroundColor(new XSSFColor(GREY_8_PERCENT, (IndexedColorMap)new DefaultIndexedColorMap()));
        this.unitStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBorder((CellStyle)this.unitStyle);
        this.rowStyle = this.wb.createCellStyle();
        this.rowStyle.setAlignment(HorizontalAlignment.GENERAL);
        this.rowStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.rowStyle.setFillForegroundColor(new XSSFColor(GREY_5_PERCENT, (IndexedColorMap)new DefaultIndexedColorMap()));
        this.rowStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBorder((CellStyle)this.rowStyle);
        this.colStyle = this.wb.createCellStyle();
        this.colStyle.setAlignment(HorizontalAlignment.CENTER);
        this.colStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.colStyle.setFillForegroundColor(new XSSFColor(GREY_5_PERCENT, (IndexedColorMap)new DefaultIndexedColorMap()));
        this.colStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBorder((CellStyle)this.colStyle);
        this.blackStyle = this.wb.createCellStyle();
        this.blackStyle.setAlignment(HorizontalAlignment.CENTER);
        this.blackStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont black = this.wb.createFont();
        black.setColor(IndexedColors.BLACK.getIndex());
        this.blackStyle.setFont((Font)black);
        this.setCellBorder((CellStyle)this.blackStyle);
        this.redStyle = this.wb.createCellStyle();
        this.redStyle.setAlignment(HorizontalAlignment.CENTER);
        this.redStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont red = this.wb.createFont();
        red.setColor(IndexedColors.RED.getIndex());
        this.redStyle.setFont((Font)red);
        this.setCellBorder((CellStyle)this.redStyle);
        this.greenStyle = this.wb.createCellStyle();
        this.greenStyle.setAlignment(HorizontalAlignment.CENTER);
        this.greenStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont green = this.wb.createFont();
        green.setColor(IndexedColors.GREEN.getIndex());
        this.greenStyle.setFont((Font)green);
        this.setCellBorder((CellStyle)this.greenStyle);
    }

    private void setCellBorder(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    public void createSheet(String sheetName) {
        this.sheet = this.wb.createSheet();
        this.wb.setSheetName(0, sheetName);
    }

    public Row createRow() {
        XSSFRow row = this.sheet.getRow(this.curRow);
        if (row == null) {
            row = this.sheet.createRow(this.curRow);
            ++this.curRow;
        }
        row.setHeightInPoints(13.5f);
        return row;
    }

    public Cell creatCell(Row row, int colIndex) {
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            cell = row.createCell(colIndex);
        }
        return cell;
    }

    public void setCellValue(Row row, Integer colIndex, CellStyle cellStyle, Object value) {
        Cell cell = this.creatCell(row, colIndex);
        this.setCellValue(cell, value);
        if (cellStyle != null) {
            if (value instanceof Number) {
                cellStyle.setDataFormat(this.wb.createDataFormat().getFormat("#,##0.00_ "));
            }
            cell.setCellStyle(cellStyle);
        }
        this.sheet.autoSizeColumn(colIndex.intValue(), true);
    }

    private void setCellValue(Cell c, Object value) {
        if (value == null) {
            c.setCellValue("");
        } else if (value instanceof String) {
            c.setCellValue(value.toString());
        } else if (value instanceof Calendar) {
            c.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            c.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            c.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            c.setCellValue(((Number)value).doubleValue());
        } else {
            c.setCellValue(value.toString());
        }
    }

    public void mergeRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        if (firstRow == lastRow && firstCol == lastCol) {
            return;
        }
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.cellRangeAddressList.add(region);
    }

    public void initMergeRegion() {
        this.cellRangeAddressList.forEach(region -> {
            this.sheet.addMergedRegion(region);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)this.sheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)this.sheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)this.sheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)this.sheet);
        });
    }

    public void downloadExcel(String fileName, IFormView formView) throws IOException {
        String url = this.writeFile(fileName);
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            this.wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public int getCurRow() {
        return this.curRow;
    }

    public CellStyle getTitleStyle() {
        return this.titleStyle;
    }

    public CellStyle getUnitStyle() {
        return this.unitStyle;
    }

    public CellStyle getRowStyle() {
        return this.rowStyle;
    }

    public CellStyle getColStyle() {
        return this.colStyle;
    }

    public CellStyle getColorStyle(String color) {
        if ("red".equals(color)) {
            return this.redStyle;
        }
        if ("green".equals(color)) {
            return this.greenStyle;
        }
        return this.blackStyle;
    }
}

