/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.SplitModel;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasRememberHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasPluginHelper {
    private static final String LONG_NUMBER_SPLIT_CHAR = "!";
    private static final String CLOSE_CALLBACK_SUB_DIMMEMBER = "closeCallbacksubDimmember";
    private static final Integer SELECT_MEMBER_SIZE = 100;
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.##");

    public static void clearDimViewInPageCache(String key, IFormView formView) {
        formView.getPageCache().remove(key);
    }

    public static JSONObject getDimensionView(String key, IFormView formView) {
        String dimViewStr = formView.getPageCache().get(key);
        JSONObject dimensionViews = StringUtils.isNotEmpty((CharSequence)dimViewStr) ? JSON.parseObject((String)dimViewStr) : new JSONObject();
        return dimensionViews;
    }

    public static long getViewId(long modelId, long datasetId, String dimNumber, String viewKey, IFormView formView) {
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView(viewKey, formView);
        String viewId = dimensionViews.getString(dimNumber);
        if (StringUtils.isBlank((CharSequence)viewId)) {
            Long busModelId;
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map viewsByDataSet = modelCache.getViewsByBusModelIncludeBase(busModelId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId)));
            viewId = viewsByDataSet.get(dimNumber) == null ? "" : String.valueOf(viewsByDataSet.get(dimNumber));
        }
        return IDUtils.toLong((Object)viewId);
    }

    public static void setDimView(String dimNumber, String viewKey, Object viewId, IFormView formView) {
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView(viewKey, formView);
        if (viewId != null && StringUtils.isNotEmpty((CharSequence)viewId.toString())) {
            dimensionViews.put(dimNumber, (Object)viewId.toString());
            formView.getPageCache().put(viewKey, dimensionViews.toJSONString());
        }
    }

    public static Long getModelId(IFormView formView) {
        String modelId = formView.getPageCache().get("model");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject value = (DynamicObject)formView.getModel().getValue("model");
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            formView.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    public static void beforeF7Select(BeforeF7SelectEvent e, IFormView formView) {
        String propName = e.getProperty().getName();
        if ("model".equals(propName)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)formView.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            Set roleModels = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)formView));
            qFilterList.add(new QFilter("id", "in", (Object)roleModels));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if ("dataset".equals(propName)) {
            if (IDUtils.isNotEmptyLong((Long)AnalysisCanvasPluginHelper.getModelId(formView)).booleanValue()) {
                e.addCustomQFilter(new QFilter("model", "=", (Object)AnalysisCanvasPluginHelper.getModelId(formView)));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalysisCanvasDesignPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static SelectModel getSelectorDimModel(String selectorId, IFormView formView) {
        String canvasId = formView.getPageCache().get("canvasId");
        List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(canvasId);
        Optional<CustomItem> optional = selectItems.stream().filter(item -> item.getId().equals(selectorId)).findFirst();
        if (optional.isPresent()) {
            CustomItem selectItem = optional.get();
            return (SelectModel)ModelHelper.getModel((CustomItem)selectItem, SelectModel.class);
        }
        return null;
    }

    public static String getSelectMemberStr(SelectModel selectModel, IFormView formView) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)AnalysisCanvasPluginHelper.getModelId(formView));
        DimensionModel dim = selectModel.getDim();
        String dimNumber = dim.getDim();
        List members = dim.getMems();
        Long selectorViewId = AnalysisCanvasPluginHelper.getSelectorViewId(selectModel, dimNumber);
        StringBuilder sb = new StringBuilder();
        for (MemberModel memberModel : members) {
            String memberNumber = memberModel.getNum();
            Integer scope = memberModel.getScope();
            Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, selectorViewId, memberNumber);
            if (member == null) continue;
            AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), scope);
        }
        return sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public static Long getSelectorViewId(String selectorId, String dimNumber, IFormView formView) {
        SelectModel selectModel = AnalysisCanvasPluginHelper.getSelectorDimModel(selectorId, formView);
        if (selectModel == null) {
            return 0L;
        }
        return AnalysisCanvasPluginHelper.getSelectorViewId(selectModel, dimNumber);
    }

    private static Long getSelectorViewId(SelectModel selectModel, String dimNumber) {
        if (selectModel.getDimensionViews() == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)selectModel.getDimensionViews().getString(dimNumber));
    }

    public static void setSelectedDim(ClosedCallBackEvent evt, IFormView formView, AnalysisCanvasEnum field) {
        if (evt.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)evt.getReturnData();
        if (!"ok".equals(returnData.get("event"))) {
            return;
        }
        String selectorId = String.valueOf(returnData.get("id"));
        String canvasId = formView.getPageCache().get("canvasId");
        String selectMemberStr = "";
        SelectModel selectModel = AnalysisCanvasPluginHelper.getSelectorDimModel(selectorId, formView);
        if (selectModel != null) {
            selectMemberStr = AnalysisCanvasPluginHelper.getSelectMemberStr(selectModel, formView);
        }
        String dimNum = AnalysisCanvasPluginHelper.getCurrEntryDim(null, formView, field);
        formView.getPageCache().put(field.getDimSelect() + dimNum, selectorId);
        int rowIndex = AnalysisCanvasPluginHelper.getCurrEntryRow(formView, field);
        formView.getModel().setValue(field.getDimSelect(), (Object)AnalysisCanvasRememberHelper.getSelectName(canvasId, selectorId), rowIndex);
        formView.getModel().setValue(field.getDimMember(), (Object)selectMemberStr, rowIndex);
    }

    public static String getCurrEntryDim(Integer rowIndex, IFormView formView) {
        if (rowIndex == null) {
            rowIndex = AnalysisCanvasPluginHelper.getCurrEntryRow(formView);
        }
        DynamicObject row = formView.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
        return row.getString("dimnumber");
    }

    public static String getCurrEntryDim(Integer rowIndex, IFormView formView, AnalysisCanvasEnum field) {
        if (rowIndex == null) {
            rowIndex = AnalysisCanvasPluginHelper.getCurrEntryRow(formView, field);
        }
        DynamicObject row = formView.getModel().getEntryRowEntity(field.getEntity(), rowIndex.intValue());
        return row.getString(field.getDimNumber());
    }

    public static Boolean getCurrEntryIsMulti(IFormView formView) {
        DynamicObject row = formView.getModel().getEntryRowEntity("entryentity", AnalysisCanvasPluginHelper.getCurrEntryRow(formView));
        return row.getBoolean("dimmemberismulti");
    }

    public static Boolean getCurrEntryIsMulti(IFormView formView, AnalysisCanvasEnum field) {
        DynamicObject row = formView.getModel().getEntryRowEntity(field.getEntity(), AnalysisCanvasPluginHelper.getCurrEntryRow(formView, field));
        return row.getBoolean(field.getDimMultiple());
    }

    public static int getCurrEntryRow(IFormView formView) {
        return formView.getModel().getEntryCurrentRowIndex("entryentity");
    }

    public static int getCurrEntryRow(IFormView formView, AnalysisCanvasEnum field) {
        return formView.getModel().getEntryCurrentRowIndex(field.getEntity());
    }

    public static Pair<String, Long> buildSelectF7ReturnValue(StringBuilder sb, List<TextEditSelectItem> list, ClosedCallBackEvent evt, String viewKey, IFormView formView) {
        String dimNumber = null;
        Long viewId = null;
        if (evt.getReturnData() instanceof DynamicObjectCollection) {
            DynamicObjectCollection rows = (DynamicObjectCollection)evt.getReturnData();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u3002", (String)"AnalysisCanvasBizIndicatorConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject row : rows) {
                TextEditSelectItem item = new TextEditSelectItem();
                item.setId(row.getString("memberid"));
                item.setScope(row.getString("scope"));
                item.setNumber(row.getString("number"));
                item.setName(row.getString("name"));
                AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, row.getString("name"), row.getInt("scope"));
                list.add(item);
            }
            dimNumber = ((DynamicObject)rows.get(0)).getString("dimNum");
            viewId = ((DynamicObject)rows.get(0)).getLong("viewid");
            AnalysisCanvasPluginHelper.setDimView(dimNumber, viewKey, viewId, formView);
        } else if (evt.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection members = (ListSelectedRowCollection)evt.getReturnData();
            if (CollectionUtils.isEmpty((Collection)members)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u914d\u7f6e\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u3002", (String)"AnalysisCanvasBizIndicatorConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (ListSelectedRow member : members) {
                TextEditSelectItem item = new TextEditSelectItem();
                item.setId(member.getPrimaryKeyValue().toString());
                item.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                item.setNumber(member.getNumber());
                item.setName(member.getName());
                AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), RangeEnum.ONLY.getIndex());
                list.add(item);
                dimNumber = String.valueOf(member.getDataMap().get("dimNumber"));
                viewId = member.getDataMap().get("viewid");
                AnalysisCanvasPluginHelper.setDimView(dimNumber, viewKey, viewId, formView);
            }
        }
        return Pair.of(dimNumber, (Object)IDUtils.toLong(viewId));
    }

    public static void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"AnalysisCanvasVarConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public static void openCustomF7Range(Long modelId, Long bizModelId, Long dataSetId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin) {
        AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, formView, formPlugin, null, false, !CLOSE_CALLBACK_SUB_DIMMEMBER.equals(callback));
    }

    public static void openCustomF7Range(Long modelId, Long bizModelId, Long dataSetId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin, RangeEnum defaultRange) {
        AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, formView, formPlugin, defaultRange, false, !CLOSE_CALLBACK_SUB_DIMMEMBER.equals(callback));
    }

    public static void openCustomF7Range(Long modelId, Long bizModelId, Long dataSetId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin, RangeEnum defaultRange, boolean lockRangeSelect, boolean enableView) {
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("number", "!=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()));
        }
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(new CloseCallBack(formPlugin, callback));
        param.setqFilters(qFilters);
        param.setLockRangeSelect(lockRangeSelect);
        param.setEnableView(enableView);
        param.setNeedPermCheck(true);
        param.setSign(dimNumber);
        param.setBizModelId(bizModelId);
        param.setDatasetId(dataSetId);
        if (defaultRange != null) {
            param.setDefaultRange(defaultRange);
        }
        if (viewId != 0L && !ModelHelper.viewExisted((Long)viewId)) {
            viewId = 0L;
        }
        if (StringUtils.isNotEmpty((CharSequence)selectItemStr)) {
            List selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
            List conList = selectItemList.stream().map(s -> {
                MemberCondition memberCondition = new MemberCondition();
                memberCondition.setNumber(s.getNumber());
                memberCondition.setRange(s.getScope());
                return memberCondition;
            }).collect(Collectors.toList());
            param.setCon_list(conList);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)formView, (RangeF7Param)param);
    }

    public static void openNewF7(Long modelId, Long dataSetId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(modelCache.getBusModelByDataSet(dataSetId));
        f7Param.setDatasetId(dataSetId);
        f7Param.setViewId(Long.valueOf(viewId));
        f7Param.addCustomFilter(qFilters);
        f7Param.setEnableView(true);
        f7Param.setReturnAllData(true);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        if (StringUtils.isNotEmpty((CharSequence)selectItemStr)) {
            List selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
            Set ids = selectItemList.stream().map(p -> Long.parseLong(p.getId())).collect(Collectors.toSet());
            f7Param.setSelectIds(ids);
        }
        CloseCallBack closeCallBack = new CloseCallBack(formPlugin, callback);
        NewF7Utils.openF7((IFormView)formView, (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    public static Member getMember(IModelCacheHelper modelCache, String dimNumber, Long viewId, String memNumber) {
        if (viewId != 0L && !ModelHelper.viewExisted((Long)viewId)) {
            return null;
        }
        return modelCache.getMember(dimNumber, viewId, memNumber);
    }

    public static void checkDimension(IModelCacheHelper modelCache, long datasetId, String dimNumber, Long viewId, String memNumber) {
        Map dimensionMap = modelCache.getDimensionMap(Long.valueOf(datasetId));
        Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u91cd\u65b0\u914d\u7f6e\u7ef4\u5ea6\u201c%1\u201d\u3002", (String)"AnalysisCanvasDesignPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber}));
        }
        Member member = modelCache.getMember(dimNumber, viewId, memNumber);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u91cd\u65b0\u914d\u7f6e\u7ef4\u5ea6\u201c%1\u201d\u7684\u6210\u5458\u201c%2\u201d\u3002", (String)"AnalysisCanvasDesignPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName(), memNumber}));
        }
    }

    public static List<DimensionModel> buildDimensionModel(IFormView formView, IModelCacheHelper modelCache, JSONObject dimensionViews, String dataSetId, AnalysisCanvasEnum field) {
        DynamicObjectCollection dimEntry = formView.getModel().getEntryEntity(field.getEntity());
        return dimEntry.stream().map(entry -> {
            String dimName = entry.getString(field.getDimName());
            String dimNumber = entry.getString(field.getDimNumber());
            String dimViewId = dimensionViews.getString(dimNumber);
            boolean isMulti = !StringUtils.isEmpty((CharSequence)field.getDimMultiple()) && entry.getBoolean(field.getDimMultiple());
            String relSelectId = isMulti ? formView.getPageCache().get(field.getDimSelect() + dimNumber) : null;
            List selectItemList = Collections.emptyList();
            if (StringUtils.isBlank(relSelectId)) {
                String selectItemStr = formView.getPageCache().get(dimNumber + field.getPostfix());
                selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
                if (CollectionUtils.isEmpty((Collection)selectItemList)) {
                    throw new KDBizException(String.format(field.getBridge(), dimName));
                }
                if (isMulti) {
                    HashSet multiMembers = new HashSet(16);
                    selectItemList.forEach(s -> {
                        List members = modelCache.getMember(dimNumber, IDUtils.toLong((Object)dimViewId), s.getNumber(), Integer.parseInt(s.getScope()));
                        members.forEach(member -> multiMembers.add(member.getNumber()));
                    });
                    if (multiMembers.size() > SELECT_MEMBER_SIZE) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u591a\u9009\u4e0b\u62c9\u83dc\u5355\u6210\u5458\u4e2a\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7%2\u4e2a\u3002", (String)"AnalysisCanvasPluginHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName, SELECT_MEMBER_SIZE}));
                    }
                }
            } else {
                Long selectorViewId = AnalysisCanvasPluginHelper.getSelectorViewId(relSelectId, dimNumber, formView.getParentView());
                dimensionViews.put(dimNumber, (Object)String.valueOf(selectorViewId));
            }
            List memberModels = selectItemList.stream().map(s -> {
                AnalysisCanvasPluginHelper.checkDimension(modelCache, IDUtils.toLong((Object)dataSetId), dimNumber, IDUtils.toLong((Object)dimViewId), s.getNumber());
                MemberModel memberModel = new MemberModel();
                memberModel.setNum(s.getNumber());
                memberModel.setScope(Integer.valueOf(Integer.parseInt(s.getScope())));
                return memberModel;
            }).collect(Collectors.toList());
            DimensionModel dimModel = new DimensionModel();
            dimModel.setDim(dimNumber);
            dimModel.setS(Boolean.valueOf(!isMulti));
            dimModel.setMems(memberModels);
            dimModel.setRelSelectId(relSelectId);
            return dimModel;
        }).collect(Collectors.toList());
    }

    public static List<CustomItem> filterSameDimSelector(String canvasId, String modelId, String dataset, String dimNumber) {
        List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(canvasId);
        return AnalysisCanvasPluginHelper.filterSameDimSelector(selectItems, modelId, dataset, dimNumber);
    }

    public static List<CustomItem> filterSameDimSelector(List<CustomItem> selectItems, String modelId, String dataset, String dimNumber) {
        HashSet hasViewDims = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            return selectItems.stream().filter(item -> {
                SelectModel model = (SelectModel)ModelHelper.getModel((CustomItem)item, SelectModel.class);
                return model.getDataset().equals(dataset) && model.getDim().getDim().equals(dimNumber);
            }).collect(Collectors.toList());
        }
        if (hasViewDims.contains(dimNumber) || !SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)modelId));
            Long bizModelId = modelCache.getBusModelByDataSet(IDUtils.toLong((Object)dataset));
            return selectItems.stream().filter(item -> {
                SelectModel model = (SelectModel)ModelHelper.getModel((CustomItem)item, SelectModel.class);
                if (!model.getDim().getDim().equals(dimNumber)) {
                    return false;
                }
                String itemModelId = model.getModel();
                if (!itemModelId.equals(modelId)) {
                    return false;
                }
                IModelCacheHelper itemModelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)itemModelId));
                Long itemBizModelId = itemModelCache.getBusModelByDataSet(IDUtils.toLong((Object)model.getDataset()));
                return itemBizModelId.equals(bizModelId);
            }).collect(Collectors.toList());
        }
        return selectItems.stream().filter(item -> {
            SelectModel model = (SelectModel)ModelHelper.getModel((CustomItem)item, SelectModel.class);
            if (!model.getDim().getDim().equals(dimNumber)) {
                return false;
            }
            return model.getModel().equals(modelId);
        }).collect(Collectors.toList());
    }

    public static SplitModel convertToSplitModel(ChartModel chartModel, String canvasId) {
        SplitModel splitModel = new SplitModel();
        splitModel.setModel(chartModel.getModel());
        splitModel.setDataset(chartModel.getDataset());
        ChartConfigModel chartConfigModel = (ChartConfigModel)chartModel.getChartConfig().get(0);
        splitModel.setDimensionViews(chartConfigModel.getDimensionViews());
        if (CollectionUtils.isNotEmpty((Collection)chartConfigModel.getSerMems())) {
            splitModel.setDim(chartConfigModel.getSerDim());
            splitModel.setMember((MemberModel)chartConfigModel.getSerMems().get(0));
        }
        List<DimensionModel> dims = AnalysisCanvasPluginHelper.getDimensionModelFromSelectItem(chartConfigModel.getDims(), canvasId);
        splitModel.setDims(dims);
        return splitModel;
    }

    public static List<DimensionModel> getDimensionModelFromSelectItem(List<DimensionModel> dims, String canvasId) {
        return dims.stream().map(e -> {
            if (e.getS().booleanValue()) {
                return e;
            }
            List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(canvasId);
            Optional<CustomItem> first = selectItems.stream().filter(item -> item.getId().equals(e.getRelSelectId())).findFirst();
            if (first.isPresent()) {
                CustomItem customItem = first.get();
                SelectModel selectModel = (SelectModel)ModelHelper.getModel((CustomItem)customItem, SelectModel.class);
                DimensionModel dimensionModel = selectModel.getDim();
                MemberModel memberModel = (MemberModel)dimensionModel.getMems().get(0);
                memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                dimensionModel.setMems(Collections.singletonList(memberModel));
                dimensionModel.setS(Boolean.valueOf(true));
                dimensionModel.setRelSelectId(null);
                return dimensionModel;
            }
            DimensionModel dimensionModel = new DimensionModel();
            dimensionModel.setDim(e.getDim());
            dimensionModel.setS(Boolean.valueOf(true));
            if (CollectionUtils.isNotEmpty((Collection)e.getMems())) {
                dimensionModel.setMems(Collections.singletonList(e.getMems().get(0)));
            }
            return dimensionModel;
        }).collect(Collectors.toList());
    }

    public static Object formatData(Object val, CompareTable.AnalysisCanvasUnit unit) {
        BigDecimal bigDecimal;
        if (val == null) {
            return "";
        }
        if (val instanceof BigDecimal) {
            bigDecimal = (BigDecimal)val;
        } else {
            if (val instanceof String) {
                return val;
            }
            bigDecimal = new BigDecimal(val.toString());
        }
        return bigDecimal.divide(new BigDecimal(unit.getValue()), 2, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public static Object formatData(Object val, CompareTable.AnalysisCanvasUnit unit, Boolean isThousand) {
        Object data = AnalysisCanvasPluginHelper.formatData(val, unit);
        if (data instanceof BigDecimal) {
            if (!Boolean.TRUE.equals(isThousand)) {
                return ((BigDecimal)data).toPlainString();
            }
            return FORMATTER.format(data);
        }
        return data;
    }
}

