/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.util.UserSelectUtil;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasRememberHelper {
    public static final String ANALYSIS_CANVAS = "AnalysisCanvas:";
    public static final String MODEL = "model";
    public static final String DATASET = "dataset";
    public static final String VIEW = "view";
    public static final String SELECTOR = "selector";
    public static final int TIMEOUT = 86400;

    private static String of(String ... params) {
        return ANALYSIS_CANVAS + String.join((CharSequence)":", params);
    }

    public static void saveModel(String canvasId, String value) {
        CacheServiceHelper.put((String)AnalysisCanvasRememberHelper.of(canvasId, MODEL), (Object)value, (int)86400);
    }

    public static String getModel(IFormView view, String canvasId) {
        Set roleModels;
        String modelId = (String)CacheServiceHelper.get((String)AnalysisCanvasRememberHelper.of(canvasId, MODEL), String.class);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)view, (String)MODEL, (boolean)false);
        }
        if (CollectionUtils.isNotEmpty((Collection)(roleModels = ModelUtil.getModelIds((IFormView)view, (boolean)false))) && !roleModels.contains(IDUtils.toLong((Object)modelId))) {
            Long[] modelIds = roleModels.toArray(new Long[0]);
            modelId = String.valueOf(modelIds[0]);
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)view, (String)modelId);
        return modelId;
    }

    public static void removeModel(String canvasId) {
        CacheServiceHelper.remove((String)AnalysisCanvasRememberHelper.of(canvasId, MODEL));
    }

    public static void saveDataset(String canvasId, String modelId, String value) {
        if (!AnalysisCanvasRememberHelper.checkDatasetExisted(value)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u914d\u7f6e\u7684\u6570\u636e\u96c6\u3002", (String)"AnalysisCanvasDesignPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        CacheServiceHelper.put((String)AnalysisCanvasRememberHelper.of(canvasId, modelId, DATASET), (Object)value, (int)86400);
    }

    public static String getDataset(String canvasId, String modelId) {
        String dataSetId = (String)CacheServiceHelper.get((String)AnalysisCanvasRememberHelper.of(canvasId, modelId, DATASET), String.class);
        if (StringUtils.isEmpty((CharSequence)dataSetId) || !AnalysisCanvasRememberHelper.checkDatasetExisted(dataSetId)) {
            QFilter qFilter = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
            QFilter qFilter1 = new QFilter("number", "=", (Object)"default");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
            dataSetId = dynamicObject == null ? null : dynamicObject.getString("id");
        }
        return dataSetId;
    }

    public static boolean checkDatasetExisted(String dataSetId) {
        return QueryServiceHelper.exists((String)"eb_dataset", (Object)IDUtils.toLong((Object)dataSetId));
    }

    public static void removeDataset(String canvasId, String modelId) {
        CacheServiceHelper.remove((String)AnalysisCanvasRememberHelper.of(canvasId, modelId, DATASET));
    }

    public static void saveDimensionModel(String canvasId, String datasetId, String dimNumber, DimensionModel value) {
        CacheServiceHelper.put((String)AnalysisCanvasRememberHelper.of(canvasId, datasetId, dimNumber), (Object)value, (int)86400);
    }

    public static DimensionModel getDimensionModel(String canvasId, String datasetId, String dimNumber) {
        return (DimensionModel)CacheServiceHelper.get((String)AnalysisCanvasRememberHelper.of(canvasId, datasetId, dimNumber), DimensionModel.class);
    }

    public static void saveDimensionView(String canvasId, String datasetId, String dimNumber, String viewId) {
        if (StringUtils.isNotBlank((CharSequence)viewId)) {
            CacheServiceHelper.put((String)AnalysisCanvasRememberHelper.of(canvasId, datasetId, VIEW, dimNumber), (Object)viewId, (int)86400);
        }
    }

    public static String getDimensionView(String canvasId, String datasetId, String dimNumber) {
        return (String)CacheServiceHelper.get((String)AnalysisCanvasRememberHelper.of(canvasId, datasetId, VIEW, dimNumber), String.class);
    }

    public static void saveSelectItems(String canvasId, List<CustomItem> selectItems) {
        String s = JSON.toJSONString(selectItems);
        CacheServiceHelper.put((String)AnalysisCanvasRememberHelper.of(canvasId, SELECTOR), (Object)s, (int)86400);
    }

    public static List<CustomItem> getSelectItems(String canvasId) {
        String s = (String)CacheServiceHelper.get((String)AnalysisCanvasRememberHelper.of(canvasId, SELECTOR), String.class);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return Collections.emptyList();
        }
        return JSONObject.parseArray((String)s, CustomItem.class);
    }

    public static String getSelectName(String canvasId, String id) {
        Optional<CustomItem> optional = AnalysisCanvasRememberHelper.getSelectItems(canvasId).stream().filter(item -> item.getId().equals(id)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getName();
        }
        return "";
    }

    public static void removeSelectItems(String canvasId) {
        CacheServiceHelper.remove((String)AnalysisCanvasRememberHelper.of(canvasId, SELECTOR));
    }
}

