/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.util.UserSelectUtil;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUserSelService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasUserSel;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.ChartConfigModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.MapModel;
import kd.epm.eb.business.analysiscanvas.model.MapValue;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasRememberHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.model.utils.ModelUtil;

public class AnalysisCanvasUserSelHelper {
    public static final String ANALYSIS_CANVAS_REMEMBER = "analysisCanvas:userSel";
    public static final String MODEL = "model";
    public static final String DEFAULT = "default";

    public static String getModel(IFormView formView) {
        Set roleModels;
        IFormView parentView = formView.getParentView();
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)parentView, (String)MODEL, (boolean)false);
        AnalysisCanvasUserSel model = AnalysisCanvasUserSelHelper.getRememberModel(parentView);
        if (model != null) {
            modelId = String.valueOf(model.getModelId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(roleModels = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)parentView)))) && !roleModels.contains(IDUtils.toLong((Object)modelId))) {
            Long[] modelIds = roleModels.toArray(new Long[0]);
            modelId = String.valueOf(modelIds[0]);
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)parentView, (String)modelId);
        return modelId;
    }

    public static String getDataset(IFormView formView, Long canvasId, Long modelId) {
        Long dataSetId;
        IFormView parentView = formView.getParentView();
        AnalysisCanvasUserSel model = AnalysisCanvasUserSelHelper.getRememberModel(parentView);
        if (model != null && Objects.equals(modelId, model.getModelId()) && AnalysisCanvasUserSelHelper.checkDatasetExisted(model.getDataSetId())) {
            dataSetId = model.getDataSetId();
        } else {
            QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
            QFilter qFilter1 = new QFilter("number", "=", (Object)DEFAULT);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
            if (dynamicObject == null) {
                return null;
            }
            dataSetId = dynamicObject.getLong("id");
            model = AnalysisCanvasUserSelHelper.initUserSel(canvasId, modelId, dataSetId);
            AnalysisCanvasUserSelHelper.refreshUserSel(formView.getParentView(), model);
        }
        return String.valueOf(dataSetId);
    }

    public static AnalysisCanvasUserSel getRememberModel(IFormView formView) {
        String remember = formView.getPageCache().get(ANALYSIS_CANVAS_REMEMBER);
        if (StringUtils.isBlank((String)remember)) {
            return null;
        }
        return (AnalysisCanvasUserSel)JSONObject.parseObject((String)remember, AnalysisCanvasUserSel.class);
    }

    public static void cacheUserSel(IFormView formView, Long canvasId) {
        List analysisCanvasUsers = AnalysisCanvasUserSelService.getInstance().queryCurrentCanvas(canvasId);
        Set roleModels = ModelUtil.getModelIds((IFormView)formView, (boolean)false);
        List currentUser = analysisCanvasUsers.stream().filter(q -> RequestContext.get().getCurrUserId() == q.getModifierId().longValue()).collect(Collectors.toList());
        Optional<AnalysisCanvasUserSel> first = currentUser.stream().filter(q -> roleModels.contains(q.getModelId())).findFirst();
        if (first.isPresent()) {
            formView.getPageCache().put(ANALYSIS_CANVAS_REMEMBER, JSONObject.toJSONString((Object)first.get()));
            return;
        }
        List noCurrentUser = analysisCanvasUsers.stream().filter(q -> RequestContext.get().getCurrUserId() != q.getModifierId().longValue()).collect(Collectors.toList());
        Optional<AnalysisCanvasUserSel> noFirst = noCurrentUser.stream().filter(q -> roleModels.contains(q.getModelId())).findFirst();
        if (noFirst.isPresent()) {
            formView.getPageCache().put(ANALYSIS_CANVAS_REMEMBER, JSONObject.toJSONString((Object)noFirst.get()));
        } else {
            AnalysisCanvasUserSel model = AnalysisCanvasUserSelService.getInstance().queryOtherCanvas(canvasId);
            AnalysisCanvasUserSelHelper.refreshUserSel(formView, model);
        }
    }

    public static void refreshUserSel(IFormView formView, AnalysisCanvasUserSel model) {
        if (model == null) {
            formView.getPageCache().put(ANALYSIS_CANVAS_REMEMBER, "");
        } else {
            formView.getPageCache().put(ANALYSIS_CANVAS_REMEMBER, JSONObject.toJSONString((Object)model));
        }
    }

    public static void refreshUserSelByDataset(IFormView formView, Long canvasId, Long modelId, Long datasetId) {
        Set roleModels = ModelUtil.getModelIds((IFormView)formView.getParentView(), (boolean)false);
        if (roleModels.contains(modelId)) {
            AnalysisCanvasUserSel model = AnalysisCanvasUserSelService.getInstance().queryByDataset(canvasId, datasetId);
            if (model == null) {
                model = AnalysisCanvasUserSelHelper.initUserSel(canvasId, modelId, datasetId);
            }
            AnalysisCanvasUserSelHelper.refreshUserSel(formView.getParentView(), model);
        }
    }

    private static AnalysisCanvasUserSel initUserSel(Long canvasId, Long modelId, Long datasetId) {
        AnalysisCanvasUserSel model = new AnalysisCanvasUserSel();
        model.setCanvasId(canvasId);
        model.setModelId(modelId);
        model.setDataSetId(datasetId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        ArrayList dimensionModels = new ArrayList(dimensionList.size());
        JSONObject defaultView = new JSONObject();
        dimensionList.forEach(dimension -> {
            Long dimDefaultViewId;
            String dimNumber = dimension.getNumber();
            if (!View.NoViewDimNums.contains(dimNumber) && IDUtils.isNotEmptyLong((Long)(dimDefaultViewId = AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber))).booleanValue()) {
                defaultView.put(dimNumber, (Object)String.valueOf(dimDefaultViewId));
            }
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) || SysDimensionEnum.Account.getNumber().equals(dimNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                return;
            }
            DimensionModel dim = new DimensionModel();
            dim.setDim(dimNumber);
            dim.setS(Boolean.valueOf(true));
            MemberModel memberModel = new MemberModel();
            memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
            if (SysDimensionEnum.Currency.getNumber().equals(dimNumber)) {
                memberModel.setNum("CNY");
            } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                memberModel.setNum("EntityInput");
            } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                memberModel.setNum("CurrentPeriod");
            } else if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
                memberModel.setNum("Budget");
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                memberModel.setNum("Money");
            } else {
                memberModel.setNum(dimension.getNoneNumber());
            }
            dim.setMems(Collections.singletonList(memberModel));
            dimensionModels.add(dim);
        });
        model.setDimView(defaultView.toJSONString());
        model.setDimMember(JSONObject.toJSONString(dimensionModels));
        return model;
    }

    public static void saveUserSel(IFormView formView, BaseModel newModel, Long canvasId) {
        AnalysisCanvasUserSel model = new AnalysisCanvasUserSel();
        model.setCanvasId(canvasId);
        model.setModelId(IDUtils.toLong((Object)newModel.getModel()));
        model.setDataSetId(IDUtils.toLong((Object)newModel.getDataset()));
        AnalysisCanvasUserSelHelper.buildDimMember(model, newModel);
        AnalysisCanvasUserSelHelper.refreshUserSel(formView, model);
        if (model.getDimMember().length() > 2000) {
            return;
        }
        AnalysisCanvasUserSelService.getInstance().save(model);
    }

    private static void buildDimMember(AnalysisCanvasUserSel model, BaseModel newModel) {
        List<Object> dims = new ArrayList(16);
        JSONObject view = new JSONObject();
        if (newModel instanceof VarModel) {
            dims = AnalysisCanvasUserSelHelper.buildVarModel((VarModel)newModel);
            view = newModel.getDimensionViews();
        }
        if (newModel instanceof ChartModel) {
            dims = AnalysisCanvasUserSelHelper.buildChartModel((ChartModel)newModel);
            JSONObject jSONObject = view = "map".equals(((ChartModel)newModel).getType()) ? newModel.getDimensionViews() : ((ChartConfigModel)((ChartModel)newModel).getChartConfig().get(0)).getDimensionViews();
        }
        if (newModel instanceof BizModel) {
            dims = AnalysisCanvasUserSelHelper.buildBizModel((BizModel)newModel);
            view = ((BizValue)((BizModel)newModel).getBizConfig().get(0)).getDimensionViews();
        }
        if (newModel instanceof TabModel) {
            dims = AnalysisCanvasUserSelHelper.buildTabModel((TabModel)newModel);
            view = newModel.getDimensionViews();
        }
        if (newModel instanceof TableModel) {
            dims = AnalysisCanvasUserSelHelper.buildTableModel((TableModel)newModel);
            view = newModel.getDimensionViews();
        }
        if (newModel instanceof DupontModel) {
            dims = AnalysisCanvasUserSelHelper.buildDupontModel((DupontModel)newModel);
            view = ((BizValue)((DupontModel)newModel).getDupontConfig().get(0)).getDimensionViews();
        }
        List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(String.valueOf(model.getCanvasId()));
        for (DimensionModel dimensionModel : dims) {
            if (!StringUtils.isNotEmpty((String)dimensionModel.getRelSelectId())) continue;
            AnalysisCanvasUserSelHelper.buildSelectModel(dimensionModel, view, selectItems);
        }
        model.setDimMember(JSONObject.toJSONString(dims));
        model.setDimView(view.toJSONString());
    }

    private static List<DimensionModel> buildVarModel(VarModel newModel) {
        List dims = newModel.getDims();
        DimensionModel dimension = new DimensionModel();
        dimension.setDim(newModel.getVarDim());
        dimension.setS(Boolean.valueOf(false));
        List vars = newModel.getVars().stream().map(var -> {
            MemberModel memberModel = new MemberModel();
            memberModel.setNum(var.getNum());
            memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
            return memberModel;
        }).collect(Collectors.toList());
        dimension.setMems(vars);
        dims.add(dimension);
        return dims;
    }

    private static List<DimensionModel> buildChartModel(ChartModel newModel) {
        DimensionModel dimension;
        if ("map".equals(newModel.getType())) {
            return AnalysisCanvasUserSelHelper.buildMapModel(newModel.getMap());
        }
        ChartConfigModel config = (ChartConfigModel)newModel.getChartConfig().get(0);
        List dims = config.getDims();
        if (StringUtils.isNotEmpty((String)newModel.getHorDim()) && CollectionUtils.isNotEmpty((Collection)newModel.getHorMems())) {
            dimension = new DimensionModel();
            dimension.setDim(newModel.getHorDim());
            dimension.setS(Boolean.valueOf(false));
            dimension.setMems(newModel.getHorMems());
            dims.add(dimension);
        }
        if (StringUtils.isNotEmpty((String)config.getSerDim()) && CollectionUtils.isNotEmpty((Collection)config.getSerMems())) {
            dimension = new DimensionModel();
            dimension.setDim(config.getSerDim());
            dimension.setS(Boolean.valueOf(false));
            dimension.setMems(config.getSerMems());
            dims.add(dimension);
        }
        return dims;
    }

    private static List<DimensionModel> buildBizModel(BizModel newModel) {
        return AnalysisCanvasUserSelHelper.buildBizOrDupontModel((BizValue)newModel.getBizConfig().get(0));
    }

    private static List<DimensionModel> buildTabModel(TabModel newModel) {
        List dims = newModel.getDims();
        if (StringUtils.isNotEmpty((String)newModel.getTabDims()) && CollectionUtils.isNotEmpty((Collection)newModel.getTabs())) {
            dims.addAll(newModel.getTabs());
        }
        return dims;
    }

    private static List<DimensionModel> buildTableModel(TableModel newModel) {
        return newModel.getDims();
    }

    private static List<DimensionModel> buildDupontModel(DupontModel newModel) {
        return AnalysisCanvasUserSelHelper.buildBizOrDupontModel((BizValue)newModel.getDupontConfig().get(0));
    }

    private static List<DimensionModel> buildBizOrDupontModel(BizValue config) {
        List dims = config.getDims();
        if (StringUtils.isNotEmpty((String)config.getDim()) && StringUtils.isNotEmpty((String)config.getNum())) {
            DimensionModel dimension = new DimensionModel();
            dimension.setDim(config.getDim());
            dimension.setS(Boolean.valueOf(false));
            MemberModel memberModel = new MemberModel();
            memberModel.setNum(config.getNum());
            memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
            dimension.setMems(Collections.singletonList(memberModel));
            dims.add(dimension);
        }
        return dims;
    }

    private static List<DimensionModel> buildMapModel(MapModel newModel) {
        List dims = newModel.getDims();
        if (StringUtils.isNotEmpty((String)newModel.getMapDim()) && CollectionUtils.isNotEmpty((Collection)newModel.getMapValues())) {
            DimensionModel dimension = new DimensionModel();
            dimension.setDim(newModel.getMapDim());
            dimension.setS(Boolean.valueOf(false));
            List members = newModel.getMapValues().stream().map(MapValue::getMember).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MemberModel>(Comparator.comparing(MemberModel::getNum))), ArrayList::new));
            dimension.setMems(members);
            dims.add(dimension);
        }
        return dims;
    }

    private static void buildSelectModel(DimensionModel dim, JSONObject view, List<CustomItem> selectItems) {
        Optional<CustomItem> optional = selectItems.stream().filter(item -> item.getId().equals(dim.getRelSelectId())).findFirst();
        if (optional.isPresent()) {
            SelectModel model = (SelectModel)ModelHelper.getModel((CustomItem)optional.get(), SelectModel.class);
            dim.setMems(model.getDim().getMems());
            view.put(dim.getDim(), model.getDimensionViews().get((Object)dim.getDim()));
        }
    }

    public static boolean checkDatasetExisted(Long dataSetId) {
        return QueryServiceHelper.exists((String)"eb_dataset", (Object)dataSetId);
    }

    public static void initDimMemAndViewToPageCache(IFormView formView, Long canvasId, Long modelId, Long datasetId, AnalysisCanvasEnum field, List<String> ignoreLeftDimNumbers) {
        IFormView parentView = formView.getParentView();
        String remember = parentView.getPageCache().get(ANALYSIS_CANVAS_REMEMBER);
        AnalysisCanvasUserSel model = StringUtils.isEmpty((String)remember) ? AnalysisCanvasUserSelHelper.initUserSel(canvasId, modelId, datasetId) : (AnalysisCanvasUserSel)JSONObject.parseObject((String)remember, AnalysisCanvasUserSel.class);
        JSONObject view = JSONObject.parseObject((String)model.getDimView());
        for (Map.Entry entry : view.entrySet()) {
            if (entry.getValue() instanceof String) continue;
            entry.setValue(String.valueOf(entry.getValue()));
        }
        String dimMember = model.getDimMember();
        if (StringUtils.isBlank((String)dimMember)) {
            return;
        }
        List dims = JSONObject.parseArray((String)dimMember, DimensionModel.class);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (field == AnalysisCanvasEnum.split) {
            AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(formView, modelCache, canvasId, datasetId, AnalysisCanvasPluginHelper.getDimensionModelFromSelectItem(dims, String.valueOf(canvasId)), view, field, ignoreLeftDimNumbers);
        } else {
            AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(formView, modelCache, canvasId, datasetId, dims, view, field, ignoreLeftDimNumbers);
        }
    }

    public static void putDimMemAndViewToPageCache(IFormView formView, IModelCacheHelper modelCache, Long canvasId, Long datasetId, List<DimensionModel> dims, JSONObject view, AnalysisCanvasEnum field, List<String> ignoreLeftDimNumbers) {
        List dimensionList = modelCache.getDimensionList(datasetId);
        AnalysisCanvasUserSelHelper.removePageCache(formView, dimensionList, field);
        Map<String, DimensionModel> dimMaps = dims.stream().filter(Objects::nonNull).collect(Collectors.toMap(DimensionModel::getDim, o -> o, (o1, o2) -> o1));
        AnalysisCanvasUserSelHelper.addNoneMember(modelCache, datasetId, dimensionList, dimMaps, view, ignoreLeftDimNumbers);
        formView.getPageCache().put(field.getDimView(), view.toJSONString());
        List<CustomItem> canvasAllSelectItems = AnalysisCanvasRememberHelper.getSelectItems(String.valueOf(canvasId));
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            List<CustomItem> selectItems = AnalysisCanvasPluginHelper.filterSameDimSelector(canvasAllSelectItems, String.valueOf(modelCache.getModelobj().getId()), String.valueOf(datasetId), dimNumber);
            if (dimMaps.containsKey(dimNumber)) {
                Optional<CustomItem> first;
                DimensionModel dimensionModel = (DimensionModel)dimMaps.get(dimNumber);
                String relSelectId = dimensionModel.getRelSelectId();
                if (StringUtils.isNotEmpty((String)relSelectId) && !selectItems.isEmpty() && (first = selectItems.stream().filter(item -> relSelectId.equals(item.getId())).findFirst()).isPresent()) {
                    CustomItem selectItem = first.get();
                    SelectModel selectModel = (SelectModel)ModelHelper.getModel((CustomItem)selectItem, SelectModel.class);
                    formView.getPageCache().put(field.getDimSelect() + dimNumber, relSelectId);
                    dimensionModel = selectModel.getDim();
                }
                List<TextEditSelectItem> list = AnalysisCanvasUserSelHelper.dimensionToText(modelCache, dimensionModel, IDUtils.toLong((Object)view.get((Object)dimNumber)));
                formView.getPageCache().put(dimNumber + field.getPostfix(), JSONObject.toJSONString(list));
            }
        });
    }

    private static void removePageCache(IFormView formView, List<Dimension> dimensionList, AnalysisCanvasEnum field) {
        ArrayList removeKeys = new ArrayList(dimensionList.size() * 2);
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            removeKeys.add(dimNumber + field.getPostfix());
            removeKeys.add(field.getDimSelect() + dimNumber);
        });
        formView.getPageCache().batchRemove(removeKeys);
    }

    private static void addNoneMember(IModelCacheHelper modelCache, Long datasetId, List<Dimension> dimensionList, Map<String, DimensionModel> dimMaps, JSONObject view, List<String> ignoreLeftDimNumbers) {
        dimensionList.forEach(dimension -> {
            String dimNumber = dimension.getNumber();
            if (!dimMaps.containsKey(dimNumber) && !ignoreLeftDimNumbers.contains(dimNumber)) {
                Long dimDefaultViewId;
                DimensionModel dimensionModel = new DimensionModel();
                dimensionModel.setDim(dimNumber);
                dimensionModel.setS(Boolean.TRUE);
                MemberModel memberModel = new MemberModel();
                memberModel.setNum(dimension.getNoneNumber());
                memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
                dimensionModel.setMems(Collections.singletonList(memberModel));
                dimMaps.computeIfAbsent(dimNumber, k -> dimensionModel);
                if (!View.NoViewDimNums.contains(dimNumber) && IDUtils.isNotEmptyLong((Long)(dimDefaultViewId = AnalysisCanvasUserSelHelper.getDimDefaultView(modelCache, datasetId, dimNumber))).booleanValue()) {
                    view.put(dimNumber, (Object)String.valueOf(dimDefaultViewId));
                }
            }
        });
    }

    public static void initDimEntryEntityData(IFormView formView, Long canvasId, Long modelId, Long datasetId, AnalysisCanvasEnum field, List<String> ignoreDimNumbers) {
        List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(String.valueOf(canvasId));
        String s = formView.getPageCache().get(field.getDimView());
        JSONObject view = JSONObject.parseObject((String)s);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        HashSet<String> ignoreDimSet = new HashSet<String>(ignoreDimNumbers);
        if (CollectionUtils.isNotEmpty(ignoreDimSet)) {
            ignoreDimSet.removeIf(e -> dimensionList.stream().noneMatch(d -> e.equals(d.getNumber())));
        }
        formView.getModel().deleteEntryData(field.getEntity());
        formView.getModel().batchCreateNewEntryRow(field.getEntity(), dimensionList.size() - ignoreDimSet.size());
        AtomicInteger row = new AtomicInteger(0);
        dimensionList.forEach(dimension -> {
            List<TextEditSelectItem> list;
            String dimNumber = dimension.getNumber();
            if (ignoreDimSet.contains(dimNumber)) {
                return;
            }
            int i = row.getAndIncrement();
            formView.getModel().setValue(field.getDimName(), (Object)dimension.getName(), i);
            formView.getModel().setValue(field.getDimNumber(), (Object)dimNumber, i);
            String selectId = formView.getPageCache().get(field.getDimSelect() + dimNumber);
            String members = formView.getPageCache().get(dimNumber + field.getPostfix());
            if (StringUtils.isNotEmpty((String)selectId) && selectItems.stream().anyMatch(item -> item.getId().equals(selectId))) {
                list = AnalysisCanvasUserSelHelper.getTextFormSelectItem(modelCache, selectId, String.valueOf(canvasId));
                if (StringUtils.isNotEmpty((String)field.getDimMultiple())) {
                    formView.setEnable(Boolean.valueOf(false), i, new String[]{field.getDimMember()});
                    formView.setEnable(Boolean.valueOf(true), i, new String[]{field.getDimSelect()});
                    formView.getModel().setValue(field.getDimMultiple(), (Object)true, i);
                    formView.getPageCache().put(field.getDimSelect() + dimNumber, selectId);
                    formView.getModel().setValue(field.getDimSelect(), (Object)AnalysisCanvasRememberHelper.getSelectName(String.valueOf(canvasId), selectId), i);
                }
            } else if (StringUtils.isNotEmpty((String)members)) {
                list = JSONObject.parseArray((String)members, TextEditSelectItem.class);
                if (StringUtils.isNotEmpty((String)field.getDimMultiple())) {
                    boolean isMultiple = list.size() > 1 || list.stream().anyMatch(e -> !String.valueOf(RangeEnum.ONLY.getIndex()).equals(e.getScope()));
                    formView.setEnable(Boolean.valueOf(isMultiple), i, new String[]{field.getDimSelect()});
                    formView.getModel().setValue(field.getDimMultiple(), (Object)isMultiple, i);
                }
            } else {
                list = Collections.emptyList();
                formView.getModel().setValue(field.getDimMember(), (Object)"", i);
                formView.getPageCache().remove(field.getDimSelect() + dimNumber);
                if (StringUtils.isNotEmpty((String)field.getDimMultiple())) {
                    formView.setEnable(Boolean.valueOf(false), i, new String[]{field.getDimSelect()});
                    formView.getModel().setValue(field.getDimMultiple(), (Object)false, i);
                }
            }
            StringBuilder sb = AnalysisCanvasUserSelHelper.buildDimMembersName(list, modelCache, dimNumber, IDUtils.toLong((Object)view.get((Object)dimNumber)));
            formView.getModel().setValue(field.getDimMember(), (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), i);
        });
    }

    public static void initSingleMembers(IFormView formView, IModelCacheHelper modelCache, List<Dimension> dimensionList, JSONObject views, String dim, String dimMember, List<String> ignoreDimNumbers, String dimField, String dimMemberField, AnalysisCanvasEnum field) {
        MemberModel memberModel = new MemberModel();
        memberModel.setNum(dimMember);
        memberModel.setScope(Integer.valueOf(RangeEnum.ONLY.getIndex()));
        AnalysisCanvasUserSelHelper.initMultipleMembers(formView, modelCache, dimensionList, views, dim, Collections.singletonList(memberModel), ignoreDimNumbers, dimField, dimMemberField, field);
    }

    public static void initMultipleMembers(IFormView formView, IModelCacheHelper modelCache, List<Dimension> dimensionList, JSONObject views, String dim, List<MemberModel> memberModels, List<String> ignoreDimNumbers, String dimField, String dimMemberField, AnalysisCanvasEnum field) {
        if (dimensionList.stream().noneMatch(dimension -> dimension.getNumber().equals(dim))) {
            return;
        }
        formView.getModel().setValue(dimField, (Object)dim);
        ignoreDimNumbers.add(dim);
        StringBuilder serSb = new StringBuilder();
        ArrayList<TextEditSelectItem> serMemItemList = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasUserSelHelper.buildMemberList(serMemItemList, memberModels, modelCache, serSb, dim, views);
        if (CollectionUtils.isNotEmpty(serMemItemList)) {
            formView.getPageCache().put(dimMemberField + field.getPostfix(), JSON.toJSONString(serMemItemList));
            formView.getModel().setValue(dimMemberField, (Object)(serSb.indexOf(",") > 0 ? serSb.substring(0, serSb.length() - 1) : ""));
        }
    }

    public static void buildMemberList(List<TextEditSelectItem> memItemList, List<MemberModel> Members, IModelCacheHelper modelCache, StringBuilder sb, String dimNumber, JSONObject dimensionViews) {
        Long viewId = IDUtils.toLong((Object)dimensionViews.getString(dimNumber));
        for (MemberModel memberModel : Members) {
            String memberNumber = memberModel.getNum();
            Integer scope = memberModel.getScope();
            Member member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memberNumber);
            if (member == null) continue;
            TextEditSelectItem item = new TextEditSelectItem();
            item.setScope(String.valueOf(scope));
            item.setNumber(memberNumber);
            item.setId(member.getId().toString());
            AnalysisCanvasPluginHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), scope);
            memItemList.add(item);
        }
    }

    public static List<TextEditSelectItem> dimensionToText(IModelCacheHelper modelCache, DimensionModel dimensionModel, Long viewId) {
        return dimensionModel.getMems().stream().map(p -> {
            Member member = AnalysisCanvasUserSelHelper.getMember(modelCache, dimensionModel.getDim(), viewId, p.getNum());
            if (member != null) {
                TextEditSelectItem text = new TextEditSelectItem();
                text.setId(String.valueOf(member.getId()));
                text.setNumber(p.getNum());
                text.setScope(String.valueOf(p.getScope()));
                return text;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<TextEditSelectItem> getTextFormSelectItem(IModelCacheHelper modelCache, String selectId, String canvasId) {
        List<CustomItem> selectItems = AnalysisCanvasRememberHelper.getSelectItems(canvasId);
        Optional<CustomItem> first = selectItems.stream().filter(item -> item.getId().equals(selectId)).findFirst();
        if (first.isPresent()) {
            CustomItem customItem = first.get();
            SelectModel selectModel = (SelectModel)ModelHelper.getModel((CustomItem)customItem, SelectModel.class);
            DimensionModel dimensionModel = selectModel.getDim();
            return AnalysisCanvasUserSelHelper.dimensionToText(modelCache, dimensionModel, IDUtils.toLong((Object)selectModel.getDimensionViews().get((Object)selectModel.getDim().getDim())));
        }
        return Collections.emptyList();
    }

    public static StringBuilder buildDimMembersName(List<TextEditSelectItem> list, IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        StringBuilder sb = new StringBuilder();
        list.forEach(text -> {
            String memberNumber = text.getNumber();
            int scope = Integer.parseInt(text.getScope());
            Member member = AnalysisCanvasUserSelHelper.getMember(modelCache, dimNumber, viewId, memberNumber);
            if (member != null) {
                AnalysisCanvasUserSelHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), scope);
            }
        });
        return sb;
    }

    public static Member getMember(IModelCacheHelper modelCache, String dimNumber, Long viewId, String memNumber) {
        if (IDUtils.toLong((Object)viewId) != 0L && !ModelHelper.viewExisted((Long)viewId)) {
            return null;
        }
        return modelCache.getMember(dimNumber, viewId, memNumber);
    }

    private static void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"AnalysisCanvasVarConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public static Long getDimDefaultView(IModelCacheHelper modelCache, long datasetId, String dimNumber) {
        return IDUtils.toLong((Object)modelCache.getViewByDataSetAndDimNumber(Long.valueOf(datasetId), dimNumber));
    }
}

